/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trace {
    protected static final String PARENTHESIS_OPEN = "(";
    protected static final String PARENTHESIS_CLOSE = ")";
    protected static final String PREFIX_CHANGING = "CHANGING ";
    protected static final String PREFIX_CATCHING = "CAUGHT ";
    protected static final String PREFIX_THROWING = "THROWN ";
    protected static final String PREFIX_ENTERING = "ENTERING ";
    protected static final String PREFIX_EXITING = "EXITING ";
    protected static final String SEPARATOR_METHOD = "#";
    protected static final String SEPARATOR_PARAMETER = ", ";
    protected static final String SEPARATOR_RETURN = ":";
    protected static final String SEPARATOR_SPACE = " ";
    protected static final String LABEL_OLD_VALUE = "old=";
    protected static final String LABEL_NEW_VALUE = "new=";
    private Tracing fTracing = new Tracing();

    protected Trace() {
    }

    protected void start(Plugin plugin) {
        this.fTracing.start(plugin);
    }

    protected void stop() {
        this.fTracing.stop();
    }

    public boolean shouldTraceEntering() {
        return this.shouldTrace("org.eclipse.m2m.qvt.oml.debug.core/debug/methods/entering");
    }

    public boolean shouldTraceEntering(String option) {
        return this.shouldTraceEntering() && this.shouldTrace(option);
    }

    public boolean shouldTraceExiting() {
        return this.fTracing.shouldTrace("org.eclipse.m2m.qvt.oml.debug.core/debug/methods/exiting");
    }

    public boolean shouldTraceExiting(String option) {
        return this.shouldTraceExiting() && this.fTracing.shouldTrace(option);
    }

    public boolean shouldTraceCatching() {
        return this.fTracing.shouldTrace("org.eclipse.m2m.qvt.oml.debug.core/debug/exceptions/catching");
    }

    public boolean shouldTraceThrowing() {
        return this.fTracing.shouldTrace("org.eclipse.m2m.qvt.oml.debug.core/debug/exceptions/throwing");
    }

    public boolean shouldTrace(String option) {
        return this.fTracing.shouldTrace(option);
    }

    public void trace(String message) {
        this.fTracing.trace(message);
    }

    public void trace(String option, String message) {
        this.fTracing.trace(option, message);
    }

    public void entering(Class<?> clazz, String methodName) {
        this.fTracing.entering("org.eclipse.m2m.qvt.oml.debug.core/debug/methods/entering", clazz, methodName, new Object[0]);
    }

    public void entering(Class<?> clazz, String methodName, Object parameter) {
        this.fTracing.entering("org.eclipse.m2m.qvt.oml.debug.core/debug/methods/entering", clazz, methodName, parameter);
    }

    public void entering(Class<?> clazz, String methodName, Object[] parameters) {
        this.fTracing.entering("org.eclipse.m2m.qvt.oml.debug.core/debug/methods/entering", clazz, methodName, parameters);
    }

    public void entering(String option, Class<?> clazz, String methodName) {
        if (this.shouldTraceEntering()) {
            this.fTracing.entering(option, clazz, methodName, new Object[0]);
        }
    }

    public void entering(String option, Class<?> clazz, String methodName, Object parameter) {
        if (this.shouldTraceEntering()) {
            this.fTracing.entering(option, clazz, methodName, parameter);
        }
    }

    public void entering(String option, Class<?> clazz, String methodName, Object[] parameters) {
        if (this.shouldTraceEntering()) {
            this.fTracing.entering(option, clazz, methodName, parameters);
        }
    }

    public void exiting(Class<?> clazz, String methodName) {
        this.fTracing.exiting("org.eclipse.m2m.qvt.oml.debug.core/debug/methods/exiting", clazz, methodName);
    }

    public void exiting(Class<?> clazz, String methodName, Object returnValue) {
        this.fTracing.exiting("org.eclipse.m2m.qvt.oml.debug.core/debug/methods/exiting", clazz, methodName, returnValue);
    }

    public void exiting(String option, Class<?> clazz, String methodName) {
        if (this.shouldTraceExiting()) {
            this.fTracing.exiting(option, clazz, methodName);
        }
    }

    public void exiting(String option, Class<?> clazz, String methodName, Object returnValue) {
        if (this.shouldTraceExiting()) {
            this.fTracing.exiting(option, clazz, methodName, returnValue);
        }
    }

    public void catching(Class<?> clazz, String methodName, Throwable throwable) {
        this.fTracing.catching("org.eclipse.m2m.qvt.oml.debug.core/debug/exceptions/catching", clazz, methodName, throwable);
    }

    public void throwing(Class<?> clazz, String methodName, Throwable throwable) {
        this.fTracing.throwing("org.eclipse.m2m.qvt.oml.debug.core/debug/exceptions/throwing", clazz, methodName, throwable);
    }

    public static String toString(Object[] array) {
        StringBuffer result = new StringBuffer(64);
        result.append('[');
        int i = 0;
        while (i < array.length) {
            if (i > 0) {
                result.append(SEPARATOR_PARAMETER);
            }
            result.append(array[i]);
            ++i;
        }
        result.append(']');
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Tracing {
        private Plugin fPlugin;
        private final Map<String, Boolean> cachedOptions = new HashMap<String, Boolean>();

        Tracing() {
        }

        synchronized void start(Plugin plugin) {
            this.fPlugin = plugin;
        }

        synchronized void stop() {
            this.fPlugin = null;
        }

        protected synchronized boolean shouldTrace() {
            return this.fPlugin != null && this.fPlugin.isDebugging();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldTrace(String option) {
            if (this.shouldTrace()) {
                Boolean value = null;
                Map<String, Boolean> map = this.cachedOptions;
                synchronized (map) {
                    value = this.cachedOptions.get(option);
                    if (value == null) {
                        value = Boolean.valueOf(Platform.getDebugOption((String)option));
                        this.cachedOptions.put(option, value);
                    }
                }
                return value;
            }
            return false;
        }

        protected String getArgumentString(Object argument) {
            return String.valueOf(argument);
        }

        protected String getArgumentsString(Object[] arguments) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < arguments.length) {
                buffer.append(this.getArgumentString(arguments[i]));
                if (i < arguments.length - 1) {
                    buffer.append(Trace.SEPARATOR_PARAMETER);
                }
                ++i;
            }
            return buffer.toString();
        }

        public void trace(String message) {
            if (this.shouldTrace()) {
                System.out.println(message);
            }
        }

        public void trace(String option, String message) {
            if (this.shouldTrace(option)) {
                this.trace(message);
            }
        }

        public void catching(String option, Class<?> clazz, String methodName, Throwable throwable) {
            if (this.shouldTrace(option)) {
                this.trace(Trace.PREFIX_CATCHING + throwable.getMessage() + Trace.SEPARATOR_SPACE + Trace.PARENTHESIS_OPEN + clazz.getName() + Trace.SEPARATOR_METHOD + methodName + Trace.PARENTHESIS_CLOSE);
                throwable.printStackTrace(System.err);
            }
        }

        public void throwing(String option, Class<?> clazz, String methodName, Throwable throwable) {
            if (this.shouldTrace(option)) {
                this.trace(Trace.PREFIX_THROWING + throwable.getMessage() + Trace.SEPARATOR_SPACE + Trace.PARENTHESIS_OPEN + clazz.getName() + Trace.SEPARATOR_METHOD + methodName + Trace.PARENTHESIS_CLOSE);
                throwable.printStackTrace(System.err);
            }
        }

        public void entering(String option, Class<?> clazz, String methodName, Object ... parameters) {
            if (this.shouldTrace(option)) {
                this.trace(Trace.PREFIX_ENTERING + clazz.getName() + Trace.SEPARATOR_METHOD + methodName + Trace.PARENTHESIS_OPEN + this.getArgumentsString(parameters) + Trace.PARENTHESIS_CLOSE);
            }
        }

        public void exiting(String option, Class<?> clazz, String methodName) {
            if (this.shouldTrace(option)) {
                this.trace(Trace.PREFIX_EXITING + clazz.getName() + Trace.SEPARATOR_METHOD + methodName);
            }
        }

        public void exiting(String option, Class<?> clazz, String methodName, Object returnValue) {
            if (this.shouldTrace(option)) {
                this.trace(Trace.PREFIX_EXITING + clazz.getName() + Trace.SEPARATOR_METHOD + methodName + Trace.SEPARATOR_RETURN + this.getArgumentString(returnValue));
            }
        }
    }
}

