/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.vm;

import java.io.EOFException;
import java.io.IOException;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.m2m.qvt.oml.debug.core.vm.IQVTOVirtualMachineShell;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMRemoteClient;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMDisconnectEvent;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMEvent;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMResponse;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMTerminateEvent;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMTerminateRequest;

public class QVTOVirtualMachineProxy
implements IQVTOVirtualMachineShell {
    private final VMRemoteClient fClient;
    private final Object fRequestLock;
    private final Object fEventLock;
    private boolean fIsTerminated;
    private boolean fIsTerminating;

    public QVTOVirtualMachineProxy(String host, int requestPort, Monitor monitor) throws IOException {
        this.fClient = new VMRemoteClient(host, requestPort, monitor);
        this.fRequestLock = new Object();
        this.fEventLock = new Object();
        this.fIsTerminated = false;
    }

    @Override
    public boolean isTerminated() {
        return this.fIsTerminated;
    }

    public boolean isAvailable() {
        return !this.fIsTerminated && !this.fIsTerminating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VMResponse sendRequest(VMRequest request) throws IOException {
        Object object = this.fRequestLock;
        synchronized (object) {
            if (!this.isAvailable()) {
                return VMResponse.createERROR();
            }
            if (request instanceof VMTerminateRequest) {
                this.fIsTerminating = true;
            }
            return this.fClient.sendRequest(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VMEvent readVMEvent() throws IOException {
        try {
            VMEvent event;
            Object object = this.fEventLock;
            synchronized (object) {
                event = this.fClient.readEvent();
                if (this.isTerminatingEvent(event)) {
                    this.fIsTerminated = true;
                    this.fIsTerminating = false;
                }
            }
            return event;
        }
        catch (EOFException e) {
            if (!this.fIsTerminated) {
                this.fIsTerminated = true;
                this.fIsTerminating = false;
                return new VMDisconnectEvent();
            }
            throw e;
        }
    }

    private boolean isTerminatingEvent(VMEvent event) {
        return event instanceof VMTerminateEvent || event instanceof VMDisconnectEvent;
    }
}

