/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.io.eclipse;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFolder;
import org.eclipse.m2m.internal.qvt.oml.common.io.CResource;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.EclipseContainer;

public class EclipseResource
implements CResource {
    protected final IResource myResource;

    public EclipseResource(IResource resource) {
        this.myResource = resource;
    }

    public String getName() {
        return this.myResource.getName();
    }

    public String getFullPath() {
        IPath location = this.myResource.getLocation();
        if (location != null) {
            return location.toOSString();
        }
        String fullName = this.getParent() == null ? this.getName() : String.valueOf(this.getParent().getFullPath()) + File.separator + this.getName();
        return fullName;
    }

    public boolean exists() {
        return this.myResource.exists();
    }

    public CFolder getParent() {
        IContainer parent = this.myResource.getParent();
        if (parent == null) {
            return null;
        }
        return EclipseContainer.makeFolder(parent);
    }

    public boolean equals(Object other) {
        return other instanceof EclipseResource && ((EclipseResource)other).myResource.equals((Object)this.myResource);
    }

    public int hashCode() {
        return this.myResource.hashCode();
    }

    public String toString() {
        return String.valueOf(this.myResource);
    }

    public IResource getResource() {
        return this.myResource;
    }
}

