/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.cst.adapters.AbstractGenericAdapter;
import org.eclipse.m2m.internal.qvt.oml.evaluator.EvaluationUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.RuntimePropertyShadowHelper;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;
import org.eclipse.ocl.types.CollectionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntermediatePropertyModelAdapter
extends AbstractGenericAdapter<IntermediatePropertyModelAdapter> {
    private final Map<ContextualProperty, ShadowEntry> myProp2HolderMap = new IdentityHashMap<ContextualProperty, ShadowEntry>(2);
    private final RuntimePropertyShadowHelper myPropShadowHelper = new RuntimePropertyShadowHelper();

    private IntermediatePropertyModelAdapter() {
    }

    public boolean isAdapterForType(Object type) {
        return type == IntermediatePropertyModelAdapter.class;
    }

    public boolean equals(Object obj) {
        return obj instanceof IntermediatePropertyModelAdapter;
    }

    public int hashCode() {
        return IntermediatePropertyModelAdapter.class.hashCode();
    }

    public static ShadowEntry getPropertyHolder(EObject moduleInstance, ContextualProperty property, Object ownerInstance) {
        IntermediatePropertyModelAdapter adapter = (IntermediatePropertyModelAdapter)EcoreUtil.getAdapter((List)moduleInstance.eAdapters(), IntermediatePropertyModelAdapter.class);
        if (adapter == null) {
            adapter = new IntermediatePropertyModelAdapter();
            moduleInstance.eAdapters().add((Object)adapter);
        }
        return adapter.getPropertyHolder(property, ownerInstance);
    }

    private ShadowEntry getPropertyHolder(ContextualProperty property, Object ownerInstance) {
        ShadowEntry runtimeShadow = this.myProp2HolderMap.get(property);
        if (runtimeShadow == null) {
            runtimeShadow = new ShadowEntry(this.myPropShadowHelper.createShadowProperty(property));
            this.myProp2HolderMap.put(property, runtimeShadow);
        }
        return runtimeShadow;
    }

    private static Object getInitialValue(EStructuralFeature feature) {
        if (feature.getEType() instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)feature.getEType();
            return EvaluationUtil.createNewCollection((CollectionType<EClassifier, EOperation>)collectionType);
        }
        return null;
    }

    public static void cleanup(Module module) {
        IntermediatePropertyModelAdapter.cleanup(module, new HashSet<Module>());
    }

    private static void cleanup(Module module, Set<Module> processed) {
        Adapter adapter = EcoreUtil.getExistingAdapter((Notifier)module, IntermediatePropertyModelAdapter.class);
        if (adapter != null) {
            module.eAdapters().remove((Object)adapter);
        }
        processed.add(module);
        for (ModuleImport nextImport : module.getModuleImport()) {
            Module importedModule = nextImport.getImportedModule();
            if (processed.contains(importedModule)) continue;
            IntermediatePropertyModelAdapter.cleanup(importedModule, processed);
        }
    }

    public static class ShadowEntry {
        private EStructuralFeature myFeature;
        private Map<Object, EObject> myOwner2ShadowMap = new IdentityHashMap<Object, EObject>();

        private ShadowEntry(EStructuralFeature runtimeFeature) {
            assert (runtimeFeature != null);
            this.myFeature = runtimeFeature;
        }

        public EStructuralFeature getProperty() {
            return this.myFeature;
        }

        public EObject getPropertyRuntimeOwner(Object shadowedInstance) {
            EObject owner = this.myOwner2ShadowMap.get(shadowedInstance);
            if (owner == null) {
                EClass ownerClass = this.myFeature.getEContainingClass();
                EFactory eFactory = ownerClass.getEPackage().getEFactoryInstance();
                owner = eFactory.create(ownerClass);
                this.myOwner2ShadowMap.put(shadowedInstance, owner);
                Object initialValue = IntermediatePropertyModelAdapter.getInitialValue(this.myFeature);
                if (initialValue != null) {
                    owner.eSet(this.myFeature, initialValue);
                }
            }
            return owner;
        }
    }
}

