/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.builder.Messages;
import org.eclipse.m2m.internal.qvt.oml.common.project.NatureUtils;
import org.eclipse.m2m.internal.qvt.oml.common.project.ProjectDependencyHelper;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.osgi.util.NLS;

public class QvtBuilderConfig {
    private static final String SRC_CONTAINER = "src_container";
    private static final String PROJECT_ROOT = "/";
    private final IProject myProject;
    private ICommand myCommand;
    private static final Map<IProject, QvtBuilderConfig> ourCache = new HashMap<IProject, QvtBuilderConfig>();

    private QvtBuilderConfig(IProject project) throws CoreException {
        this.myProject = project;
        this.myCommand = NatureUtils.findCommand((IProject)this.myProject, (String)"org.eclipse.m2m.qvt.oml.QvtBuilder");
    }

    public static QvtBuilderConfig getConfig(IProject project) throws CoreException {
        QvtBuilderConfig config = ourCache.get(project);
        if (config != null) {
            return config;
        }
        config = new QvtBuilderConfig(project);
        ourCache.put(project, config);
        return config;
    }

    public boolean isInSourceContainer(IResource resource) {
        IContainer container = null;
        if (resource.exists() && this.myProject.equals((Object)resource.getProject())) {
            container = this.getSourceContainer();
        }
        if (container != null && container.exists()) {
            return container.getProjectRelativePath().isPrefixOf(resource.getProjectRelativePath());
        }
        return false;
    }

    public void save() throws CoreException {
        NatureUtils.updateCommand((IProject)this.myProject, (ICommand)this.myCommand);
    }

    public boolean getGenerateJava() {
        return false;
    }

    public IContainer getDefaultSourceContainer() {
        return this.myProject;
    }

    public IContainer getSourceContainer() {
        IContainer containerPath = this.getRawSourceContainer();
        if (containerPath == null) {
            return this.myProject;
        }
        return containerPath;
    }

    public IContainer getRawSourceContainer() {
        String containerPath = this.getArgument(SRC_CONTAINER);
        if (containerPath != null) {
            Path path = new Path(containerPath);
            if (path.isRoot()) {
                return this.myProject;
            }
            return this.myProject.getFolder((IPath)path);
        }
        return null;
    }

    public void setSourceContainer(IContainer container) {
        if (container.getProject() != this.myProject) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.QvtBuilderConfig_InvalidContainer, (Object)container.getFullPath()));
        }
        try {
            IProjectDescription pd = this.myProject.getProject().getDescription();
            NatureUtils.addBuilders((IProjectDescription)pd, (String[])new String[]{"org.eclipse.m2m.qvt.oml.QvtBuilder"}, (String[])new String[0]);
            ICommand[] buildSpec = pd.getBuildSpec();
            if (this.myCommand == null) {
                this.myCommand = NatureUtils.findCommand((ICommand[])buildSpec, (String)"org.eclipse.m2m.qvt.oml.QvtBuilder");
            }
            if (this.myCommand != null) {
                this.setBuildCommandArgument(SRC_CONTAINER, this.getPathString(container));
                int i = 0;
                while (i < buildSpec.length) {
                    if ("org.eclipse.m2m.qvt.oml.QvtBuilder".equals(buildSpec[i].getBuilderName())) {
                        buildSpec[i] = this.myCommand;
                    }
                    ++i;
                }
                pd.setBuildSpec(buildSpec);
            }
            this.myProject.getProject().setDescription(pd, null);
        }
        catch (CoreException e) {
            QvtPlugin.log(e.getStatus());
        }
    }

    public void addTransformationNature() {
        try {
            NatureUtils.addNature((IProject)this.myProject, (String)"org.eclipse.m2m.qvt.oml.project.TransformationNature");
        }
        catch (CoreException e) {
            QvtPlugin.log(e.getStatus());
        }
    }

    public IContainer[] getQvtContainers() {
        ArrayList<IContainer> containers = new ArrayList<IContainer>();
        containers.add(this.getSourceContainer());
        try {
            IProject[] referencedProjects = ProjectDependencyHelper.getQvtProjectDependencies((IProject)this.myProject, (boolean)true);
            int i = 0;
            while (i < referencedProjects.length) {
                IProject nextProject = referencedProjects[i];
                if (nextProject.isOpen() && nextProject.hasNature("org.eclipse.m2m.qvt.oml.project.TransformationNature")) {
                    containers.add(QvtBuilderConfig.getConfig(nextProject).getSourceContainer());
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Logger.getLogger().log(Logger.SEVERE, "Can't get QVT source containers", e);
        }
        return containers.toArray(new IContainer[containers.size()]);
    }

    public IProject[] getProjectDependencies(boolean recursive) {
        return ProjectDependencyHelper.getQvtProjectDependencies((IProject)this.myProject, (boolean)recursive);
    }

    private String getPathString(IContainer container) {
        String containerPath = container == this.myProject ? PROJECT_ROOT : container.getProjectRelativePath().toString();
        return containerPath;
    }

    private String getArgument(String name) {
        if (this.myCommand == null) {
            return null;
        }
        Map arguments = this.myCommand.getArguments();
        if (arguments == null) {
            return null;
        }
        return (String)this.myCommand.getArguments().get(name);
    }

    private void setBuildCommandArgument(String name, String value) {
        assert (this.myCommand != null);
        if (this.myCommand == null) {
            return;
        }
        HashMap<String, String> arguments = this.myCommand.getArguments();
        if (arguments == null) {
            arguments = new HashMap<String, String>();
        }
        arguments.put(name, value);
        this.myCommand.setArguments(arguments);
    }
}

