/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.library;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.m2m.internal.qvt.oml.library.EObjectEStructuralFeaturePair;
import org.eclipse.m2m.internal.qvt.oml.library.IConfiguration;
import org.eclipse.m2m.internal.qvt.oml.library.IContext;
import org.eclipse.m2m.internal.qvt.oml.library.IQvtLaunchConfigurationContextListener;
import org.eclipse.m2m.internal.qvt.oml.library.QvtConfiguration;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.m2m.internal.qvt.oml.trace.TraceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context
implements IContext {
    private List<Runnable> myDeferredTasks;
    private final Trace myTrace;
    private final IConfiguration myConfiguration;
    private final Map<String, Object> myData;
    private static ArrayList<IQvtLaunchConfigurationContextListener> ourListeners = new ArrayList();
    private boolean myIsDebug = false;
    private EObjectEStructuralFeaturePair myLastAssignLvalue;

    public Context() {
        this(new QvtConfiguration(Collections.<String, String>emptyMap()));
    }

    public Context(IConfiguration configuration) {
        this(new HashMap<String, Object>(), TraceFactory.eINSTANCE.createTrace(), configuration);
    }

    private Context(Map<String, Object> data, Trace trace, IConfiguration configuration) {
        this.myData = data;
        this.myTrace = trace;
        this.myConfiguration = configuration;
        this.myDeferredTasks = null;
    }

    public static final synchronized void addListener(IQvtLaunchConfigurationContextListener listener) {
        ourListeners.add(listener);
    }

    public static final synchronized boolean removeListener(IQvtLaunchConfigurationContextListener listener) {
        return ourListeners.remove(listener);
    }

    public void fireLaunchStarted() {
        for (IQvtLaunchConfigurationContextListener listener : ourListeners) {
            listener.handleConfigurationStarted(this);
        }
    }

    public void fireLaunchStopped() {
        for (IQvtLaunchConfigurationContextListener listener : ourListeners) {
            listener.handleConfigurationStopped(this);
        }
    }

    @Override
    public Trace getTrace() {
        return this.myTrace;
    }

    @Override
    public IConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    @Override
    public Object get(String name) {
        return this.myData.get(name);
    }

    @Override
    public void put(String name, Object value) {
        this.myData.put(name, value);
    }

    @Override
    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.myData);
    }

    @Override
    public void addDeferredTask(Runnable task) {
        if (this.myDeferredTasks == null) {
            this.myDeferredTasks = new ArrayList<Runnable>();
        }
        this.myDeferredTasks.add(task);
    }

    @Override
    public void processDeferredTasks() {
        if (this.myDeferredTasks != null) {
            ArrayList<Runnable> tasksCopy = new ArrayList<Runnable>(this.myDeferredTasks);
            for (Runnable task : tasksCopy) {
                task.run();
            }
        }
    }

    @Override
    public void launch() {
        this.fireLaunchStarted();
    }

    @Override
    public void release() {
        this.fireLaunchStopped();
    }

    @Override
    public boolean isDebug() {
        return this.myIsDebug;
    }

    @Override
    public void setDebug(boolean debug) {
        this.myIsDebug = debug;
    }

    @Override
    public EObjectEStructuralFeaturePair getLastAssignmentLvalueEval() {
        return this.myLastAssignLvalue;
    }

    @Override
    public void setLastAssignmentLvalueEval(EObjectEStructuralFeaturePair lvalue) {
        this.myLastAssignLvalue = lvalue;
    }
}

