/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2m.internal.qvt.oml.QvtNamesChecker;
import org.eclipse.m2m.internal.qvt.oml.ui.QVTUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.ui.QvtPluginImages;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.AbstractNewQVTElementWizard;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.Messages;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.NewQvtModuleCreationPage;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.NewQvtTransformationCreationPage;

public class NewQVTTransformationWizard
extends AbstractNewQVTElementWizard {
    private NewQvtTransformationCreationPage fNewQvtModulePage;
    private boolean fOpenInEditor = true;

    public NewQVTTransformationWizard() {
        this.setWindowTitle(Messages.NewQVTTransformationWizard_Title);
        ImageDescriptor desc = QvtPluginImages.getInstance().getImageDescriptor("new_wizard");
        this.setDefaultPageImageDescriptor(desc);
        this.setHelpAvailable(false);
    }

    protected NewQvtTransformationCreationPage createQvtTransformationCreationPage() {
        if (this.getDestinationProvider() != null) {
            return new NewQvtTransformationCreationPage(this.getDestinationProvider());
        }
        return new NewQvtTransformationCreationPage();
    }

    protected final NewQvtTransformationCreationPage getQvtTransformationCreationPage() {
        return this.fNewQvtModulePage;
    }

    public void setOpenNewTransformationInEditor(boolean openFlag) {
        this.fOpenInEditor = openFlag;
    }

    public boolean canFinish() {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            if (!pages[i].isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean doPerformFinish(IProgressMonitor monitor) {
        try {
            String moduleName = this.fNewQvtModulePage.getModuleName();
            assert (QvtNamesChecker.validateQvtModuleIdentifier((String)moduleName).isOK());
            String contents = this.createTransformationContents(moduleName);
            IFile transformationFile = this.fNewQvtModulePage.createNewFile(contents, monitor);
            if (this.fOpenInEditor) {
                NewQvtModuleCreationPage.openInEditor(this.getShell(), transformationFile);
            }
            return true;
        }
        catch (Exception exception) {
            QVTUIPlugin.log(exception);
            return false;
        }
    }

    public IFile getNewTransformationFile() {
        if (this.fNewQvtModulePage != null) {
            return this.fNewQvtModulePage.getNewCreatedModuleFile();
        }
        return null;
    }

    protected String createTransformationContents(String moduleName) {
        StringBuffer contents = new StringBuffer();
        contents.append("transformation ").append(moduleName).append("();");
        contents.append("\n\n");
        contents.append("mapping main() {\n\n}\n");
        return contents.toString();
    }

    public void addPages() {
        this.doAddPages();
    }

    protected void doAddPages() {
        this.fNewQvtModulePage = this.createQvtTransformationCreationPage();
        this.fNewQvtModulePage.setTitle(Messages.NewQVTTransformationWizard_NewModuleFilePageTitle);
        this.fNewQvtModulePage.setDescription(Messages.NewQVTTransformationWizard_NewModulePageDescription);
        this.addPage((IWizardPage)this.fNewQvtModulePage);
        this.setContentsCreated(true);
    }
}

