/*******************************************************************************
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *   
 * Contributors:
 *     Borland Software Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectors;

import lpg.lpgjavaruntime.IToken;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QvtOpLPGParsersym;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.LightweightParserUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionData;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.utilities.TypedElement;

/**
 * @author Aleksandr Igdalov
 * Created on Aug 7, 2007
 */

public abstract class AbstractCallExpSourceCollector extends AbstractCollector {
    private static final int[] MODULE_KEYWORDS = {
        QvtOpLPGParsersym.TK_transformation,
        QvtOpLPGParsersym.TK_library
    };
    
    private static final int[] UNEXPECTED_TRANSFORMATION_NAME_TOKENS = {
        QvtOpLPGParsersym.TK_SEMICOLON, 
        QvtOpLPGParsersym.TK_LBRACE
    };
    
    private static final String CALLEXP_SOURCE_FLAG = AccessorCollector.class.toString() + "CALLEXP_SOURCE_FLAG"; //$NON-NLS-1$
    
    @Override
    protected boolean isApplicableInternal(QvtCompletionData data) {
        if (data.getLeftToken() == null) {
            return false;
        }
        TypedElement<EClassifier> callExpSource = getCallExpSource(data);
        if (callExpSource != null) {
            data.getUserData().put(CALLEXP_SOURCE_FLAG, callExpSource);
        }
        return callExpSource != null;
    }
    
    protected EClassifier getCallExpSourceType(IToken accessorToken, QvtCompletionData data) {
        QvtOperationalEnv env = data.getEnvironment();
        @SuppressWarnings("unchecked")
        TypedElement<EClassifier> callExpSource = (TypedElement<EClassifier>) data.getUserData().get(CALLEXP_SOURCE_FLAG);
        EClassifier classifier = callExpSource.getType();
        if ((accessorToken.getKind() == QvtOpLPGParsersym.TK_ARROW)
                && !(classifier instanceof CollectionType)) {
            classifier = (EClassifier) env.getOCLFactory().createSetType(classifier); 
        } else if ((accessorToken.getKind() == QvtOpLPGParsersym.TK_DOT)
                && (classifier instanceof CollectionType)){
            classifier = ((CollectionType) classifier).getElementType();
        }
        return classifier;
    }
    
    protected TypedElement<EClassifier> getCallExpSource(IToken accessorToken, QvtCompletionData data) {
        if ((accessorToken.getKind() == QvtOpLPGParsersym.TK_DOT) 
                || (accessorToken.getKind() == QvtOpLPGParsersym.TK_ARROW)) {
            if (!data.isWithin(MODULE_KEYWORDS, UNEXPECTED_TRANSFORMATION_NAME_TOKENS)) {
                return LightweightParserUtil.getOclExpression(accessorToken, data, LightweightParserUtil.ParserTypeEnum.LIGHTWEIGHT_PARSER);
            }
        }
        return null;
    }

    protected abstract TypedElement<EClassifier> getCallExpSource(QvtCompletionData data);

}