/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtTemplateContext;
import org.eclipse.m2m.internal.qvt.oml.ui.QvtPluginImages;
import org.eclipse.swt.graphics.Image;

public class QvtTemplateCompletionProcessor
extends TemplateCompletionProcessor {
    private final TemplateContextType myContextType = Activator.getDefault().getContextTypeRegistry().getContextType("org.eclipse.m2m.qvt.oml.templates");

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ICompletionProposal[] allProposals = super.computeCompletionProposals(viewer, offset);
        ArrayList<ICompletionProposal> validProposals = new ArrayList<ICompletionProposal>(allProposals.length);
        ICompletionProposal[] iCompletionProposalArray = allProposals;
        int n = allProposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            if (!(proposal instanceof ICompletionProposalExtension2) || ((ICompletionProposalExtension2)proposal).validate(viewer.getDocument(), offset, null)) {
                validProposals.add(proposal);
            }
            ++n2;
        }
        Collections.sort(validProposals, new Comparator<ICompletionProposal>(){

            @Override
            public int compare(ICompletionProposal o1, ICompletionProposal o2) {
                return String.CASE_INSENSITIVE_ORDER.compare(o1.getDisplayString(), o2.getDisplayString());
            }
        });
        return validProposals.toArray(new ICompletionProposal[validProposals.size()]);
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return this.myContextType;
    }

    protected TemplateContext createContext(ITextViewer viewer, IRegion region) {
        TemplateContextType contextType = this.getContextType(viewer, region);
        if (contextType != null) {
            IDocument document = viewer.getDocument();
            return new QvtTemplateContext(contextType, document, region.getOffset(), region.getLength());
        }
        return null;
    }

    protected Image getImage(Template template) {
        return QvtPluginImages.getInstance().getImage("cat-template");
    }

    protected Template[] getTemplates(String contextTypeId) {
        return Activator.getDefault().getTemplateStore().getTemplates(contextTypeId);
    }
}

