/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.ui.pages;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugTarget;
import org.eclipse.ocl.examples.debug.vm.core.VMLineBreakpoint;
import org.eclipse.ocl.examples.debug.vm.core.VMStackFrame;
import org.eclipse.ocl.examples.debug.vm.core.VMThread;
import org.eclipse.ocl.examples.debug.vm.core.VMVariable;
import org.eclipse.ocl.examples.debug.vm.ui.actions.DebugVMImages;
import org.eclipse.ocl.examples.debug.vm.ui.pages.VMDebugModelPresentation;
import org.eclipse.qvtd.debug.ui.QVTdDebugUIPlugin;
import org.eclipse.qvtd.debug.ui.actions.QVTiDebugImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;

public class QVTiDebugModelPresentation
extends VMDebugModelPresentation {
    public Image getImage(Object element) {
        if (element instanceof VMDebugTarget) {
            return QVTiDebugImages.getImage("Transformation");
        }
        if (element instanceof VMThread) {
            return null;
        }
        if (element instanceof VMStackFrame) {
            return null;
        }
        if (element instanceof VMVariable) {
            VMVariable var = (VMVariable)element;
            if (var.isModelParameter()) {
                return DebugVMImages.getImage((String)"modelParameter");
            }
            if (var.isReference()) {
                return DebugVMImages.getImage((String)"reference");
            }
            if (var.isAttribute()) {
                return DebugVMImages.getImage((String)"attribute");
            }
            if (var.isIntermProperty()) {
                return DebugVMImages.getImage((String)"intermediateProperty");
            }
            if (var.isLocalVariable()) {
                return DebugVMImages.getImage((String)"localVariable");
            }
            if (var.isPredefinedVariable()) {
                try {
                    if ("this".equals(var.getName())) {
                        return DebugVMImages.getImage((String)"thisVariable");
                    }
                }
                catch (DebugException debugException) {
                    // empty catch block
                }
                return DebugVMImages.getImage((String)"predefinedVariable");
            }
            if (var.isCollectionElement()) {
                return DebugVMImages.getImage((String)"collectionElement");
            }
        } else if (element instanceof VMLineBreakpoint) {
            VMLineBreakpoint breakpoint = (VMLineBreakpoint)element;
            try {
                if (breakpoint.isConditionEnabled()) {
                    return breakpoint.isEnabled() ? DebugVMImages.getImage((String)"conditionalBreakpointEnabled") : DebugVMImages.getImage((String)"conditionalBreakpointDisabled");
                }
            }
            catch (CoreException ex) {
                QVTdDebugUIPlugin.log(ex);
            }
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        if (element instanceof IFile || element instanceof ILineBreakpoint) {
            return "org.eclipse.qvtd.xtext.qvtimperative.QVTimperative";
        }
        return null;
    }
}

