/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtimperative.tests;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbase;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperative;
import org.eclipse.qvtd.xtext.qvtbase.tests.AbstractTestQVT;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.TestsXMLUtil;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.XtextCompilerUtil;
import org.eclipse.xtext.resource.XtextResource;

public class QVTiSerializeTests
extends LoadTestCase {
    protected @NonNull OCLInternal createOCL() {
        return QVTimperative.newInstance((ProjectManager)this.getTestProjectManager(), null);
    }

    protected void doSerializeRoundTrip(@NonNull URI inputURI) throws Exception {
        this.doSerializeRoundTrip(inputURI, this.getURIWithExtension(inputURI, "ref.qvtias"));
    }

    protected void doSerializeRoundTrip(@NonNull URI inputURI, @NonNull URI referenceURI) throws Exception {
        URI pivotURI = this.getTestURIWithExtension(inputURI, "qvtias");
        URI serializedInputURI = this.getTestURIWithExtension(inputURI, "serialized.qvti");
        URI serializedPivotURI = this.getTestURIWithExtension(inputURI, "serialized.qvtias");
        ProjectManager projectManager = this.getTestProjectManager();
        QVTimperative ocl1 = QVTimperative.newInstance((ProjectManager)projectManager, null);
        Resource asResource1 = this.doLoad_Concrete((OCL)ocl1, inputURI, pivotURI, NO_MESSAGES);
        ocl1.deactivate();
        this.doSerialize(pivotURI, serializedInputURI, referenceURI, null, true, true);
        QVTimperative ocl2 = QVTimperative.newInstance((ProjectManager)projectManager, null);
        Resource asResource3 = this.doLoad_Concrete((OCL)ocl2, serializedInputURI, serializedPivotURI, NO_MESSAGES);
        ((Model)asResource3.getContents().get(0)).setExternalURI(((Model)asResource1.getContents().get(0)).getExternalURI());
        TestsXMLUtil.resetTransients((Resource)asResource1);
        TestsXMLUtil.resetTransients((Resource)asResource3);
        QVTiSerializeTests.assertSameModel((Resource)asResource1, (Resource)asResource3);
        ocl1.dispose();
        ocl2.dispose();
    }

    protected void doSerializeRoundTripFromAS(@NonNull URI inputURI) throws Exception {
        this.doSerializeRoundTripFromAS(inputURI, this.getURIWithExtension(inputURI, "ref.qvtias"));
    }

    protected void doSerializeRoundTripFromAS(@NonNull URI pivotURI, @NonNull URI referenceURI) throws Exception {
        URI serializedInputURI = this.getTestURIWithExtension(pivotURI, "serialized.qvti");
        URI serializedPivotURI = this.getTestURIWithExtension(pivotURI, "serialized.qvtias");
        ProjectManager projectManager = this.getTestProjectManager();
        OCL ocl1 = OCL.newInstance((ProjectManager)projectManager);
        OCL ocl2 = OCL.newInstance((ProjectManager)projectManager);
        Resource asResource1 = ocl1.getMetamodelManager().getASResourceSet().getResource(pivotURI, true);
        this.doSerialize(pivotURI, serializedInputURI, referenceURI, null, true, true);
        Resource asResource3 = this.doLoad_Concrete(ocl2, serializedInputURI, serializedPivotURI, NO_MESSAGES);
        ((Model)asResource3.getContents().get(0)).setExternalURI(((Model)asResource1.getContents().get(0)).getExternalURI());
        QVTiSerializeTests.assertSameModel((Resource)asResource1, (Resource)asResource3);
        ocl1.dispose();
        ocl2.dispose();
    }

    public XtextResource doSerialize(@NonNull URI inputURI, @NonNull URI serializedInputURI, @NonNull URI referenceURI, @Nullable Map<String, Object> options, boolean doCompare, boolean validateSaved) throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        OCL ocl = QVTbase.newInstance((ProjectManager)this.getTestProjectManager());
        try {
            ASResource asResource = AbstractTestQVT.loadQVTiAS((OCL)ocl, (URI)inputURI);
            QVTiSerializeTests.assertNoResourceErrors((String)"Normalisation failed", (Resource)asResource);
            QVTiSerializeTests.assertNoValidationErrors((String)"Normalisation invalid", (Resource)asResource);
            XtextResource xtextResource = AbstractTestQVT.as2cs((OCL)ocl, (ResourceSet)resourceSet, (ASResource)asResource, (URI)serializedInputURI, (String)"org.eclipse.qvtd.xtext.qvtimperative");
            resourceSet.getResources().clear();
            XtextResource xtextResource2 = xtextResource;
            return xtextResource2;
        }
        finally {
            ocl.dispose();
            ocl = null;
        }
    }

    public void setUp() throws Exception {
        TestUtil.doCompleteOCLSetup();
        XtextCompilerUtil.doQVTimperativeSetup();
        super.setUp();
    }

    public void testQVTiSerialize_Constructors() throws Exception {
        URI inputURI = this.getModelsURI("Constructors/Constructors.qvti");
        this.doSerializeRoundTrip(inputURI);
    }

    public void testQVTiSerialize_Dependencies() throws Exception {
        URI inputURI = this.getModelsURI("Dependencies/Dependencies.qvti");
        this.doSerializeRoundTrip(inputURI);
    }

    public void testQVTiSerialize_Expressions() throws Exception {
        URI inputURI = this.getModelsURI("Expressions/Expressions.qvti");
        this.doSerializeRoundTrip(inputURI);
    }

    public void testQVTiSerialize_Graph2GraphHierarchical() throws Exception {
        URI inputURI = this.getModelsURI("Graph2GraphHierarchical/Graph2GraphHierarchical.qvti");
        this.doSerializeRoundTrip(inputURI);
    }

    public void testQVTiSerialize_Graph2GraphMinimal() throws Exception {
        URI inputURI = this.getModelsURI("Graph2GraphMinimal/Graph2GraphMinimal.qvti");
        this.doSerializeRoundTrip(inputURI);
    }

    public void testQVTiSerialize_HSV2HSL_qvti() throws Exception {
        URI inputURI = this.getModelsURI("HSV2HSL/HSV2HSL.qvti");
        this.doSerializeRoundTrip(inputURI);
    }

    public void testQVTiSerialize_HSV2HSLas_qvtias() throws Exception {
        URI inputURI = this.getModelsURI("HSV2HSL/HSV2HSLas.qvtias");
        URI referenceURI = this.getURIWithExtension(inputURI, "ref.qvtias");
        URI serializedInputURI = this.getTestURIWithExtension(inputURI, "serialized.qvti");
        this.doSerialize(inputURI, serializedInputURI, referenceURI, null, true, true);
    }

    public void testQVTiSerialize_KiamaRewrite_qvti() throws Exception {
        URI inputURI = this.getModelsURI("KiamaRewrite/KiamaRewrite.qvti");
        this.doSerializeRoundTrip(inputURI);
    }

    public void testQVTiSerialize_ManualUML2RDBMS_qvti() throws Exception {
        URI inputURI = this.getModelsURI("ManualUML2RDBMS/ManualUML2RDBMS.qvti");
        this.doSerializeRoundTrip(inputURI);
    }

    public void testQVTiSerialize_SimpleUML2RDBMS_qvti() throws Exception {
        URI inputURI = this.getModelsURI("SimpleUML2RDBMS/SimpleUML2RDBMS.qvti");
        this.doSerializeRoundTrip(inputURI);
    }

    public void testQVTiSerialize_Tree2TallTree_qvti() throws Exception {
        URI inputURI = this.getModelsURI("Tree2TallTree/Tree2TallTree.qvti");
        this.doSerializeRoundTrip(inputURI);
    }

    public void zztestSerialize_platformResource_BaseCS2AS() throws Exception {
        URI inputURI = this.getModelsURI("platformResource/org.eclipse.ocl.xtext.base/model/BaseCS2AS.qvtias");
        this.doSerializeRoundTripFromAS(inputURI);
    }

    public void zztestSerialize_platformResource_EssentialOCLCS2AS() throws Exception {
        URI inputURI = this.getModelsURI("platformResource/org.eclipse.ocl.xtext.essentialocl/model/EssentialOCLCS2AS.qvtias");
        this.doSerializeRoundTripFromAS(inputURI);
    }
}

