/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtrelation.utilities;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtbase.utilities.TraceHelper;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomainAssignment;
import org.eclipse.qvtd.pivot.qvtrelation.RelationModel;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.SharedVariable;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationHelper;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.PropertyTemplateItem;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.utilities.QVTtemplateUtil;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeUtil;

public class QVTrelationUtil
extends QVTtemplateUtil {
    public static final @NonNull String DUMMY_VARIABLE_NAME = "_";

    public static @Nullable RelationDomain basicGetContainingRelationDomain(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof RelationDomain) {
                return (RelationDomain)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @Nullable Relation basicGetOverridden(@NonNull Relation relation) {
        return (Relation)relation.getOverridden();
    }

    public static @Nullable RelationDomain basicGetRelationDomain(@NonNull Relation qvtrRelation, @Nullable TypedModel typedModel) {
        for (RelationDomain rRelationDomain : QVTrelationUtil.getOwnedDomains(qvtrRelation)) {
            if (rRelationDomain.getTypedModel() != typedModel) continue;
            return rRelationDomain;
        }
        return null;
    }

    public static @NonNull Relation getBaseRelation(@NonNull Relation relation) {
        Rule aRule;
        Relation aRelation = relation;
        int i = 0;
        while ((aRule = aRelation.getOverridden()) instanceof Relation) {
            aRelation = (Relation)aRule;
            if (i++ <= 100) continue;
            HashSet<Relation> relations = new HashSet<Relation>();
            aRelation = relation;
            relations.add(relation);
            while ((aRule = aRelation.getOverridden()) instanceof Relation) {
                aRelation = (Relation)aRule;
                if (relations.add(aRelation)) continue;
                QVTruntimeUtil.errPrintln((String)("Cyclic override of '" + relation + "' ignored."));
                return relation;
            }
        }
        return aRelation;
    }

    public static @NonNull Variable getBindsTo(@NonNull TemplateExp rTemplateExp) {
        return (Variable)ClassUtil.nonNullState((Object)rTemplateExp.getBindsTo());
    }

    public static @NonNull Predicate getContainingPredicate(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Predicate) {
                return (Predicate)eObject;
            }
            eObject = eObject.eContainer();
        }
        throw new IllegalStateException();
    }

    public static @NonNull Relation getContainingRelation(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Relation) {
                return (Relation)eObject;
            }
            eObject = eObject.eContainer();
        }
        throw new IllegalStateException();
    }

    public static @NonNull RelationalTransformation getContainingTransformation(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof RelationalTransformation) {
                return (RelationalTransformation)eObject;
            }
            eObject = eObject.eContainer();
        }
        throw new IllegalStateException();
    }

    public static @NonNull Iterable<@NonNull RelationDomainAssignment> getDefaultAssignments(@NonNull RelationDomain rRelationDomain) {
        return ClassUtil.nullFree(rRelationDomain.getDefaultAssignment());
    }

    public static @NonNull Class getIdentifies(@NonNull Key rKey) {
        return (Class)ClassUtil.nonNullState((Object)rKey.getIdentifies());
    }

    public static @NonNull VariableDeclaration getOverriddenVariable(@NonNull Relation overriddenRelation, @NonNull VariableDeclaration overridingRootVariable) {
        RelationDomain overridingDomain = QVTrelationUtil.getRootVariableDomain(overridingRootVariable);
        List<@NonNull VariableDeclaration> rootVariables = QVTrelationUtil.getRootVariables(overridingDomain);
        int rootVariableIndex = rootVariables.indexOf(overridingRootVariable);
        assert (rootVariableIndex >= 0);
        TypedModel typedModel = overridingDomain.getTypedModel();
        RelationDomain overriddenRelationDomain = QVTrelationUtil.getRelationDomain(overriddenRelation, typedModel);
        List<@NonNull VariableDeclaration> overriddenRootVariables = QVTrelationUtil.getRootVariables(overriddenRelationDomain);
        assert (rootVariableIndex < overriddenRootVariables.size());
        return overriddenRootVariables.get(rootVariableIndex);
    }

    public static @NonNull Iterable<@NonNull Relation> getOverrides(@NonNull Relation rRelation) {
        return Iterables.filter((Iterable)ClassUtil.nullFree((EList)rRelation.getOverrides()), Relation.class);
    }

    public static @NonNull Iterable<@NonNull OCLExpression> getOwnedArguments(@NonNull RelationCallExp rInvocation) {
        return ClassUtil.nullFree(rInvocation.getArgument());
    }

    public static @NonNull Iterable<@NonNull RelationDomain> getOwnedDomains(@NonNull Relation rRelation) {
        return Iterables.filter((Iterable)ClassUtil.nullFree((EList)rRelation.getDomain()), RelationDomain.class);
    }

    public static @NonNull Iterable<@NonNull Key> getOwnedKey(@NonNull RelationalTransformation rTransformation) {
        return ClassUtil.nullFree(rTransformation.getOwnedKey());
    }

    public static @NonNull Iterable<@NonNull Property> getOwnedOppositeParts(@NonNull Key rKey) {
        return ClassUtil.nullFree(rKey.getOppositePart());
    }

    public static @NonNull Iterable<@NonNull Property> getOwnedParts(@NonNull Key rKey) {
        return ClassUtil.nullFree(rKey.getPart());
    }

    public static @NonNull Iterable<@NonNull DomainPattern> getOwnedPatterns(@NonNull RelationDomain rRelationDomain) {
        return ClassUtil.nullFree(rRelationDomain.getPattern());
    }

    public static @NonNull Iterable<@NonNull Relation> getOwnedRelations(@NonNull RelationalTransformation rTransformation) {
        return Iterables.filter((Iterable)ClassUtil.nullFree((EList)rTransformation.getRule()), Relation.class);
    }

    public static @NonNull TemplateExp getOwnedTemplateExpression(@NonNull DomainPattern rDomainPattern) {
        return (TemplateExp)ClassUtil.nonNullState((Object)rDomainPattern.getTemplateExpression());
    }

    public static @NonNull OCLExpression getOwnedValue(@NonNull PropertyTemplateItem rPropertyTemplateItem) {
        return (OCLExpression)ClassUtil.nonNullState((Object)rPropertyTemplateItem.getValue());
    }

    public static @NonNull Iterable<@NonNull Variable> getOwnedVariables(@NonNull Relation rRelation) {
        return ClassUtil.nullFree(rRelation.getVariable());
    }

    public static @NonNull ObjectTemplateExp getOwningObjectTemplateExp(@NonNull PropertyTemplateItem rPropertyTemplateItem) {
        return (ObjectTemplateExp)ClassUtil.nonNullState((Object)rPropertyTemplateItem.getObjContainer());
    }

    public static @NonNull Relation getReferredRelation(@NonNull RelationCallExp rInvocation) {
        return (Relation)ClassUtil.nonNullState((Object)rInvocation.getReferredRelation());
    }

    public static @NonNull RelationDomain getRelationCallExpArgumentDomain(@NonNull RelationCallExp rInvocation, int argumentIndex) {
        Relation rRelation = rInvocation.getReferredRelation();
        assert (rRelation != null);
        int iFirst = 0;
        for (Domain rDomain : ClassUtil.nullFree((EList)rRelation.getDomain())) {
            RelationDomain rRelationDomain = (RelationDomain)rDomain;
            int iNext = iFirst + rRelationDomain.getRootVariable().size();
            if (argumentIndex < iNext) {
                return rRelationDomain;
            }
            iFirst = iNext;
        }
        throw new IndexOutOfBoundsException(String.valueOf(argumentIndex) + " > " + iFirst + " for " + rRelation);
    }

    public static @NonNull RelationDomain getRelationDomain(@NonNull Relation qvtrRelation, @Nullable TypedModel typedModel) {
        for (RelationDomain rRelationDomain : QVTrelationUtil.getOwnedDomains(qvtrRelation)) {
            if (rRelationDomain.getTypedModel() != typedModel) continue;
            return rRelationDomain;
        }
        throw new IllegalArgumentException("No " + (typedModel != null ? typedModel.getName() : "null") + " domain in " + qvtrRelation.getName());
    }

    public static @NonNull RelationDomain getRootVariableDomain(@NonNull VariableDeclaration rootVariable) {
        Relation relation = QVTrelationUtil.getContainingRelation((EObject)rootVariable);
        for (Domain domain : ClassUtil.nullFree((EList)relation.getDomain())) {
            RelationDomain relationDomain = (RelationDomain)domain;
            for (DomainPattern domainPattern : ClassUtil.nullFree(relationDomain.getPattern())) {
                TemplateExp templateExpression = domainPattern.getTemplateExpression();
                if (rootVariable != templateExpression.getBindsTo()) continue;
                return relationDomain;
            }
        }
        throw new IllegalStateException("No RelationDomain for " + rootVariable);
    }

    public static @NonNull List<@NonNull VariableDeclaration> getRootVariables(@NonNull Relation relation) {
        ArrayList<@NonNull VariableDeclaration> rootVariables = new ArrayList<VariableDeclaration>();
        for (Domain domain : ClassUtil.nullFree((EList)relation.getDomain())) {
            for (DomainPattern domainPattern : ClassUtil.nullFree(((RelationDomain)domain).getPattern())) {
                TemplateExp templateExpression = domainPattern.getTemplateExpression();
                Variable rootVariable = templateExpression.getBindsTo();
                assert (rootVariable != null);
                rootVariables.add((VariableDeclaration)rootVariable);
            }
        }
        return rootVariables;
    }

    public static @NonNull List<@NonNull VariableDeclaration> getRootVariables(@NonNull RelationDomain relationDomain) {
        ArrayList<@NonNull VariableDeclaration> rootVariables = new ArrayList<VariableDeclaration>();
        for (DomainPattern domainPattern : ClassUtil.nullFree(relationDomain.getPattern())) {
            TemplateExp templateExpression = domainPattern.getTemplateExpression();
            Variable rootVariable = templateExpression.getBindsTo();
            assert (rootVariable != null);
            rootVariables.add((VariableDeclaration)rootVariable);
        }
        return rootVariables;
    }

    public static @NonNull Variable getTraceVariable(@NonNull Relation relation) {
        return (Variable)ClassUtil.nonNullState((Object)((Variable)NameUtil.getNameable(QVTrelationUtil.getOwnedVariables(relation), (String)"trace")));
    }

    public static @NonNull RelationalTransformation getTransformation(@NonNull Relation rRelation) {
        return (RelationalTransformation)ClassUtil.nonNullState((Object)rRelation.getTransformation());
    }

    public static @NonNull OCLExpression getValueExp(@NonNull RelationDomainAssignment relationDomainAssignment) {
        return (OCLExpression)ClassUtil.nonNullState((Object)relationDomainAssignment.getValueExp());
    }

    public static @NonNull VariableDeclaration getVariable(@NonNull RelationDomainAssignment relationDomainAssignment) {
        return (VariableDeclaration)ClassUtil.nonNullState((Object)relationDomainAssignment.getVariable());
    }

    public static boolean hasOverrides(@NonNull Relation rRelation) {
        return rRelation.getOverridden() != null || !rRelation.getOverrides().isEmpty();
    }

    public static boolean isAbstract(@NonNull Relation rRelation) {
        return rRelation.isIsAbstract() && QVTrelationUtil.hasOverrides(rRelation);
    }

    public static boolean isRequired(@NonNull VariableDeclaration variable) {
        if (variable.isIsRequired()) {
            return true;
        }
        Rule rule = QVTrelationUtil.getContainingRule((EObject)variable);
        if (!(rule instanceof Relation)) {
            return false;
        }
        for (VariableDeclaration rootVariable : QVTrelationUtil.getRootVariables((Relation)rule)) {
            if (rootVariable != variable) continue;
            return true;
        }
        return false;
    }

    public static boolean isTraceClassVariable(@NonNull VariableDeclaration variable) {
        return "trace".equals(variable.getName()) && variable instanceof SharedVariable && ((SharedVariable)variable).isIsImplicit();
    }

    public static @NonNull RelationalTransformation loadTransformation(@NonNull QVTbaseEnvironmentFactory environmentFactory, @NonNull URI transformationURI, boolean keepDebug) throws IOException {
        QVTbaseEnvironmentFactory.CreateStrategy savedStrategy = environmentFactory.setCreateStrategy(QVTrEnvironmentFactory.CREATE_STRATEGY);
        try {
            RelationalTransformation relationalTransformation = (RelationalTransformation)QVTrelationUtil.loadTransformation(RelationModel.class, (EnvironmentFactory)environmentFactory, (URI)transformationURI, (boolean)keepDebug);
            return relationalTransformation;
        }
        finally {
            environmentFactory.setCreateStrategy(savedStrategy);
        }
    }

    public static @NonNull ASResource loadTransformations(@NonNull QVTbaseEnvironmentFactory environmentFactory, @NonNull URI transformationURI, boolean keepDebug) throws IOException {
        QVTbaseEnvironmentFactory.CreateStrategy savedStrategy = environmentFactory.setCreateStrategy(QVTrEnvironmentFactory.CREATE_STRATEGY);
        try {
            ASResource aSResource = QVTrelationUtil.loadTransformations(RelationModel.class, (EnvironmentFactory)environmentFactory, (URI)transformationURI, (boolean)keepDebug);
            return aSResource;
        }
        finally {
            environmentFactory.setCreateStrategy(savedStrategy);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static boolean rewriteMissingTraceArtefacts(@NonNull EnvironmentFactory environmentFactory, @NonNull Resource asResource) {
        QVTrelationHelper helper = null;
        TraceHelper traceHelper = null;
        TreeIterator tit = asResource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (eObject instanceof RelationalTransformation) {
                TypedModel thisTypedModel;
                TypedModel primitiveTypedModel;
                RelationalTransformation asTransformation = (RelationalTransformation)eObject;
                @NonNull List modelParameters = Internal.getModelParameterList((Transformation)asTransformation);
                TypedModel typedModel = QVTbaseUtil.basicGetTraceTypedModel((Iterable)modelParameters);
                if (typedModel == null) {
                    if (helper == null) {
                        helper = new QVTrelationHelper(environmentFactory);
                    }
                    modelParameters.add(helper.createTraceTypedModel());
                }
                if ((primitiveTypedModel = QVTbaseUtil.basicGetPrimitiveTypedModel((Iterable)modelParameters)) == null) {
                    if (helper == null) {
                        helper = new QVTrelationHelper(environmentFactory);
                    }
                    modelParameters.add(0, helper.createPrimitiveTypedModel());
                }
                if ((thisTypedModel = QVTbaseUtil.basicGetThisTypedModel((Iterable)modelParameters)) == null) {
                    if (helper == null) {
                        helper = new QVTrelationHelper(environmentFactory);
                    }
                    modelParameters.add(1, helper.createThisTypedModel());
                }
            }
            if (!(eObject instanceof Relation)) continue;
            VariableDeclaration traceClassVariable = null;
            Relation asRelation = (Relation)eObject;
            for (VariableDeclaration variableDeclaration : QVTrelationUtil.getOwnedVariables(asRelation)) {
                if (!(variableDeclaration instanceof SharedVariable) || !((SharedVariable)variableDeclaration).isIsImplicit()) continue;
                traceClassVariable = variableDeclaration;
            }
            if (traceClassVariable == null) {
                traceClassVariable = (VariableDeclaration)NameUtil.getNameable(QVTrelationUtil.getOwnedVariables(asRelation), (String)"trace");
            }
            if (traceClassVariable != null) continue;
            if (helper == null) {
                helper = new QVTrelationHelper(environmentFactory);
            }
            if (traceHelper == null) {
                traceHelper = new TraceHelper(environmentFactory);
            }
            asRelation.getVariable().add((Object)helper.createTraceClassVariable(traceHelper));
        }
        return false;
    }

    public static class Internal
    extends QVTtemplateUtil.Internal {
        public static @NonNull List<@NonNull Variable> getBindsToList(@NonNull DomainPattern rDomainPattern) {
            return ClassUtil.nullFree((EList)rDomainPattern.getBindsTo());
        }

        public static @NonNull List<@NonNull OCLExpression> getOwnedArgumentsList(@NonNull RelationCallExp rInvocation) {
            return ClassUtil.nullFree(rInvocation.getArgument());
        }

        public static @NonNull List<@NonNull Domain> getOwnedDomainsList(@NonNull Relation rRelation) {
            return ClassUtil.nullFree((EList)rRelation.getDomain());
        }

        public static @NonNull List<@NonNull Key> getOwnedKeysList(@NonNull RelationalTransformation rRelationalTransformation) {
            return ClassUtil.nullFree(rRelationalTransformation.getOwnedKey());
        }

        public static @NonNull List<@NonNull Property> getOwnedPartsList(@NonNull Key rKey) {
            return ClassUtil.nullFree(rKey.getPart());
        }

        public static @NonNull List<@NonNull Rule> getOwnedRelationsList(@NonNull RelationalTransformation rRelationalTransformation) {
            return ClassUtil.nullFree((EList)rRelationalTransformation.getRule());
        }

        public static @NonNull List<@NonNull Variable> getOwnedVariablesList(@NonNull Relation rRelation) {
            return ClassUtil.nullFree(rRelation.getVariable());
        }
    }

    public static final class KeyComparator
    implements Comparator<Key> {
        public static final @NonNull KeyComparator INSTANCE = new KeyComparator();

        @Override
        public int compare(@NonNull Key o1, @NonNull Key o2) {
            String n1 = QVTrelationUtil.getName((NamedElement)QVTrelationUtil.getIdentifies(o1));
            String n2 = QVTrelationUtil.getName((NamedElement)QVTrelationUtil.getIdentifies(o2));
            return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }
    }

    public static final class RelationCallExpComparator
    implements Comparator<RelationCallExp> {
        public static final @NonNull RelationCallExpComparator INSTANCE = new RelationCallExpComparator();

        @Override
        public int compare(@NonNull RelationCallExp o1, @NonNull RelationCallExp o2) {
            String n1 = QVTrelationUtil.getName((NamedElement)QVTrelationUtil.getReferredRelation(o1));
            String n2 = QVTrelationUtil.getName((NamedElement)QVTrelationUtil.getReferredRelation(o2));
            return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }
    }
}

