/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtc2qvtu;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.LiteralExp;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.common.AbstractQVTc2QVTc;
import org.eclipse.qvtd.compiler.internal.common.TypedModelsConfiguration;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.QVTbaseFactory;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcore.Area;
import org.eclipse.qvtd.pivot.qvtcore.Assignment;
import org.eclipse.qvtd.pivot.qvtcore.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcore.BottomVariable;
import org.eclipse.qvtd.pivot.qvtcore.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcore.CoreModel;
import org.eclipse.qvtd.pivot.qvtcore.CorePattern;
import org.eclipse.qvtd.pivot.qvtcore.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcore.OppositePropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcore.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcore.QVTcoreFactory;
import org.eclipse.qvtd.pivot.qvtcore.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcore.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;

public class QVTc2QVTu
extends AbstractQVTc2QVTc {
    private static final int IS_INPUT_MASK = 1;
    private static final int IS_OUTPUT_MASK = 2;
    private final @NonNull ProblemHandler problemHandler;
    private final @NonNull TypedModelsConfiguration typedModelsConfiguration;
    private final @NonNull Map<@NonNull Area, @NonNull DomainMode> domain2mode = new HashMap<Area, DomainMode>();
    private final @NonNull Map<@NonNull Mapping, @NonNull MappingMode> mapping2mode = new HashMap<Mapping, MappingMode>();

    public QVTc2QVTu(@NonNull EnvironmentFactory environmentFactory, @NonNull ProblemHandler problemHandler, @NonNull TypedModelsConfiguration typedModelsConfiguration) {
        super(environmentFactory);
        this.problemHandler = problemHandler;
        this.typedModelsConfiguration = typedModelsConfiguration;
    }

    protected @NonNull CreateVisitor createCreateVisitor() {
        return new CreateVisitor(this);
    }

    protected @NonNull UpdateVisitor createUpdateVisitor() {
        return new UpdateVisitor(this);
    }

    private @Nullable MappingMode getComposedMappingMode(@NonNull Mapping mapping) {
        MappingMode mergedMode = MappingMode.NULL;
        for (Domain domain : ClassUtil.nullFree((EList)mapping.getDomain())) {
            TypedModel typedModel = QVTcoreUtil.getTypedModel((Domain)domain);
            if (this.typedModelsConfiguration.isInput(typedModel)) {
                mergedMode = mergedMode.asInput();
                this.domain2mode.put((Area)((CoreDomain)domain), DomainMode.INPUT);
                continue;
            }
            if (!this.typedModelsConfiguration.isIntermediate(typedModel) && !this.typedModelsConfiguration.isOutput(typedModel)) continue;
            if (domain.isNotOutput()) {
                return null;
            }
            mergedMode = mergedMode.asOutput();
            this.domain2mode.put((Area)((CoreDomain)domain), DomainMode.OUTPUT);
        }
        for (Mapping localMapping : ClassUtil.nullFree((EList)mapping.getLocal())) {
            MappingMode mappingMode = this.getMappingMode(localMapping);
            if (mappingMode == null) {
                return null;
            }
            mergedMode = mergedMode.union(mappingMode);
        }
        return mergedMode;
    }

    private @Nullable MappingMode getMappingMode(@NonNull Mapping mapping) {
        MappingMode mergedMode = this.mapping2mode.get(mapping);
        if (mergedMode == null) {
            mergedMode = this.getComposedMappingMode(mapping);
            if (mergedMode == null) {
                return null;
            }
            for (Mapping refinedMapping : ClassUtil.nullFree((EList)mapping.getSpecification())) {
                MappingMode composedMappingMode = this.getComposedMappingMode(refinedMapping);
                if (composedMappingMode == null) {
                    return null;
                }
                mergedMode = mergedMode.union(composedMappingMode);
            }
            this.mapping2mode.put(mapping, mergedMode);
            this.setMappingDomainModes(mapping, mergedMode);
        }
        return mergedMode;
    }

    private boolean isInputDomain(@Nullable Area area) {
        if (area == null) {
            return false;
        }
        DomainMode domainMode = this.domain2mode.get(area);
        assert (domainMode != null);
        return domainMode == DomainMode.INPUT;
    }

    private boolean isMiddleDomain(@Nullable Area area) {
        if (area == null) {
            return false;
        }
        DomainMode domainMode = this.domain2mode.get(area);
        assert (domainMode != null);
        return domainMode == DomainMode.MIDDLE;
    }

    private boolean isNonOutputDomain(@Nullable Area area) {
        if (area == null) {
            return false;
        }
        DomainMode domainMode = this.domain2mode.get(area);
        assert (domainMode != null);
        return domainMode != DomainMode.OUTPUT;
    }

    private boolean isOutputDomain(@Nullable Area area) {
        if (area == null) {
            return false;
        }
        DomainMode domainMode = this.domain2mode.get(area);
        assert (domainMode != null);
        return domainMode == DomainMode.OUTPUT;
    }

    private void setMappingDomainModes(@NonNull Mapping mapping, @NonNull MappingMode mode) {
        this.domain2mode.put((Area)mapping, !mode.hasInputDomain() ? DomainMode.INPUT : (!mode.hasOutputDomain() ? DomainMode.OUTPUT : DomainMode.MIDDLE));
        for (Mapping localMapping : ClassUtil.nullFree((EList)mapping.getLocal())) {
            this.setMappingDomainModes(localMapping, mode);
        }
    }

    protected class CreateVisitor
    extends AbstractQVTc2QVTc.AbstractCreateVisitor<QVTc2QVTu> {
        public CreateVisitor(QVTc2QVTu context) {
            super(context);
        }

        private boolean allReferencedVariablesInInputDomain(@NonNull Element a) {
            VariableDeclaration referredVariable = this.getReferredMappingVariable((EObject)a);
            if (referredVariable != null && !QVTc2QVTu.this.isInputDomain(this.basicGetArea(referredVariable))) {
                return false;
            }
            TreeIterator tit = a.eAllContents();
            while (tit.hasNext()) {
                referredVariable = this.getReferredMappingVariable((EObject)tit.next());
                if (referredVariable == null || QVTc2QVTu.this.isInputDomain(this.basicGetArea(referredVariable))) continue;
                return false;
            }
            return true;
        }

        private boolean allReferencedVariablesInOutputDomain(@NonNull Element a) {
            VariableDeclaration referredVariable = this.getReferredMappingVariable((EObject)a);
            if (referredVariable != null && !QVTc2QVTu.this.isOutputDomain(this.basicGetArea(referredVariable))) {
                return false;
            }
            TreeIterator tit = a.eAllContents();
            while (tit.hasNext()) {
                referredVariable = this.getReferredMappingVariable((EObject)tit.next());
                if (referredVariable == null || QVTc2QVTu.this.isOutputDomain(this.basicGetArea(referredVariable))) continue;
                return false;
            }
            return true;
        }

        private boolean anyReferencedBottomMiddleDomainVariables(@NonNull OCLExpression value) {
            VariableDeclaration referredVariable = this.getReferredMappingVariable((EObject)value);
            if (this.isMiddleDomainVariable(referredVariable)) {
                return true;
            }
            TreeIterator tit = value.eAllContents();
            while (tit.hasNext()) {
                referredVariable = this.getReferredMappingVariable((EObject)tit.next());
                if (!this.isMiddleDomainVariable(referredVariable)) continue;
                return true;
            }
            return false;
        }

        private boolean anyReferencedMiddleDomainVariables(@NonNull OCLExpression value) {
            VariableDeclaration referredVariable = this.getReferredMappingVariable((EObject)value);
            if (referredVariable != null && QVTc2QVTu.this.isMiddleDomain(this.basicGetArea(referredVariable))) {
                return true;
            }
            TreeIterator tit = value.eAllContents();
            while (tit.hasNext()) {
                referredVariable = this.getReferredMappingVariable((EObject)tit.next());
                if (referredVariable == null || !QVTc2QVTu.this.isMiddleDomain(this.basicGetArea(referredVariable))) continue;
                return true;
            }
            return false;
        }

        private boolean anyReferencedRealizedVariables(@NonNull OCLExpression value) {
            VariableDeclaration referredVariable = this.getReferredMappingVariable((EObject)value);
            if (referredVariable instanceof RealizedVariable) {
                return true;
            }
            TreeIterator tit = value.eAllContents();
            while (tit.hasNext()) {
                referredVariable = this.getReferredMappingVariable((EObject)tit.next());
                if (!(referredVariable instanceof RealizedVariable)) continue;
                return true;
            }
            return false;
        }

        private OperationCallExp assignmentToOclExp(@NonNull Assignment aIn) {
            PropertyCallExp sourceExp;
            OperationCallExp exp = PivotFactory.eINSTANCE.createOperationCallExp();
            for (Operation op : QVTc2QVTu.this.environmentFactory.getStandardLibrary().getOclAnyType().getOwnedOperations()) {
                if (!op.getName().equals("=")) continue;
                exp.setReferredOperation(op);
                exp.setName(op.getName());
                exp.setType(op.getType());
                break;
            }
            exp.getOwnedArguments().add((OCLExpression)EcoreUtil.copy((EObject)aIn.getValue()));
            if (aIn instanceof PropertyAssignment) {
                sourceExp = PivotFactory.eINSTANCE.createPropertyCallExp();
                PropertyAssignment paIn = (PropertyAssignment)aIn;
                sourceExp.setReferredProperty(paIn.getTargetProperty());
                sourceExp.setType(paIn.getTargetProperty().getType());
                sourceExp.setOwnedSource((OCLExpression)EcoreUtil.copy((EObject)paIn.getSlotExpression()));
                exp.setOwnedSource((OCLExpression)sourceExp);
            } else if (aIn instanceof OppositePropertyAssignment) {
                sourceExp = PivotFactory.eINSTANCE.createOppositePropertyCallExp();
                OppositePropertyAssignment opaIn = (OppositePropertyAssignment)aIn;
                sourceExp.setReferredProperty(opaIn.getTargetProperty());
                sourceExp.setType(opaIn.getTargetProperty().getType());
                sourceExp.setOwnedSource((OCLExpression)EcoreUtil.copy((EObject)opaIn.getSlotExpression()));
                exp.setOwnedSource((OCLExpression)sourceExp);
            } else {
                VariableExp varExp = PivotFactory.eINSTANCE.createVariableExp();
                varExp.setIsImplicit(false);
                varExp.setReferredVariable(((VariableAssignment)aIn).getTargetVariable());
                exp.setOwnedSource((OCLExpression)varExp);
            }
            return exp;
        }

        private @Nullable Area basicGetArea(@Nullable VariableDeclaration variable) {
            return QVTcoreUtil.getContainingArea((EObject)variable);
        }

        @Override
        protected void doAssignments(@NonNull BottomPattern bIn, @NonNull BottomPattern bOut) {
            GuardPattern gOut = (GuardPattern)((QVTc2QVTu)((Object)this.context)).equivalentTarget((Element)bIn.getArea().getGuardPattern());
            assert (gOut != null);
            for (Assignment aIn : ClassUtil.nullFree((EList)bIn.getAssignment())) {
                Assignment aOut = this.create(aIn);
                if (aOut instanceof Predicate) {
                    bOut.getPredicate().add((Object)((Predicate)aOut));
                    continue;
                }
                if (aOut instanceof Assignment) {
                    bOut.getAssignment().add((Object)aOut);
                    continue;
                }
                if (aOut == null) continue;
                throw new UnsupportedOperationException();
            }
        }

        public @Nullable Element doNavigationAssignment(@NonNull NavigationAssignment paIn) {
            NavigationAssignment paOut;
            OCLExpression slotExpression = paIn.getSlotExpression();
            OCLExpression value = paIn.getValue();
            assert (slotExpression != null && value != null);
            Area targetArea = this.getSourceVariableArea(slotExpression);
            if (QVTc2QVTu.this.isInputDomain(targetArea) && value instanceof VariableExp && this.anyReferencedMiddleDomainVariables(value)) {
                VariableAssignment vaOut = QVTcoreFactory.eINSTANCE.createVariableAssignment();
                ((QVTc2QVTu)((Object)this.context)).addTrace((Element)paIn, (Element)vaOut);
                return vaOut;
            }
            if (QVTc2QVTu.this.isNonOutputDomain(targetArea) && !(value instanceof VariableExp) && !(value instanceof NullLiteralExp) && this.allReferencedVariablesInOutputDomain((Element)value)) {
                return null;
            }
            if (QVTc2QVTu.this.isInputDomain(targetArea) && targetArea instanceof Mapping && this.anyReferencedBottomMiddleDomainVariables(value)) {
                return null;
            }
            if (QVTc2QVTu.this.isInputDomain(targetArea) && this.anyReferencedMiddleDomainVariables(value)) {
                return null;
            }
            if (QVTc2QVTu.this.isInputDomain(targetArea) && this.allReferencedVariablesInInputDomain((Element)paIn)) {
                Predicate pOut = QVTbaseFactory.eINSTANCE.createPredicate();
                ((QVTc2QVTu)((Object)this.context)).addTrace((Element)paIn, (Element)pOut);
                pOut.setConditionExpression((OCLExpression)this.assignmentToOclExp((Assignment)paIn));
                return pOut;
            }
            NavigationAssignment navigationAssignment = paOut = paIn instanceof OppositePropertyAssignment ? (NavigationAssignment)super.visitOppositePropertyAssignment((OppositePropertyAssignment)paIn) : (NavigationAssignment)super.visitPropertyAssignment((PropertyAssignment)paIn);
            assert (paOut != null);
            if (!QVTc2QVTu.this.typedModelsConfiguration.hasTargetTypedModel() && paIn.isIsDefault() && QVTc2QVTu.this.isOutputDomain(paIn.getBottomPattern().getArea())) {
                paOut.setIsDefault(false);
            }
            return paOut;
        }

        @Override
        protected void doRealizedVariables(@NonNull BottomPattern bIn, @NonNull BottomPattern bOut) {
            GuardPattern gOut = (GuardPattern)((QVTc2QVTu)((Object)this.context)).equivalentTarget((Element)bIn.getArea().getGuardPattern());
            assert (gOut != null);
            for (RealizedVariable rvIn : ClassUtil.nullFree((EList)bIn.getRealizedVariable())) {
                Variable vOut = (Variable)this.create(rvIn);
                if (vOut instanceof RealizedVariable) {
                    bOut.getRealizedVariable().add((Object)((RealizedVariable)vOut));
                    continue;
                }
                gOut.getOwnedVariables().add((Object)vOut);
            }
        }

        private @NonNull Area getContainingArea(@NonNull VariableDeclaration variable) {
            Area targetArea = QVTcoreUtil.getContainingArea((EObject)variable);
            assert (targetArea != null);
            return targetArea;
        }

        private @Nullable VariableDeclaration getReferredMappingVariable(@Nullable EObject value) {
            if (value instanceof VariableExp) {
                VariableDeclaration referredVariable = ((VariableExp)value).getReferredVariable();
                EObject eContainer = referredVariable.eContainer();
                if (eContainer instanceof Transformation) {
                    return null;
                }
                if (eContainer instanceof LoopExp) {
                    return null;
                }
                return referredVariable;
            }
            return null;
        }

        private @Nullable Area getSourceVariableArea(@Nullable OCLExpression exp) {
            if (exp instanceof VariableExp) {
                Variable expV = (Variable)((VariableExp)exp).getReferredVariable();
                return this.basicGetArea((VariableDeclaration)expV);
            }
            if (exp instanceof CallExp) {
                return this.getSourceVariableArea(((CallExp)exp).getOwnedSource());
            }
            if (exp instanceof IfExp) {
                return this.getSourceVariableArea(((IfExp)exp).getOwnedCondition());
            }
            if (exp instanceof LiteralExp) {
                return null;
            }
            return null;
        }

        private boolean isMiddleDomainVariable(@Nullable VariableDeclaration variable) {
            if (variable == null) {
                return false;
            }
            CorePattern pattern = QVTcoreUtil.getContainingPattern((EObject)variable);
            if (!(pattern instanceof BottomPattern)) {
                return false;
            }
            return pattern.getArea() instanceof Mapping;
        }

        @Override
        public @NonNull CoreDomain visitCoreDomain(@NonNull CoreDomain dIn) {
            CoreDomain dOut = super.visitCoreDomain(dIn);
            TypedModel typedModel = QVTcoreUtil.getTypedModel((Domain)dIn);
            String name = typedModel.getName();
            dOut.setName(name);
            if (QVTc2QVTu.this.typedModelsConfiguration.isOutput(typedModel) && dIn.isNotOutput()) {
                CompilerUtil.addRuleError(QVTc2QVTu.this.problemHandler, QVTcoreUtil.getContainingRule((EObject)dIn), "domain ''{0}'' cannot be an output", typedModel.getName());
            }
            if (QVTc2QVTu.this.typedModelsConfiguration.isInput(typedModel)) {
                dOut.setIsEnforceable(false);
                dOut.setIsCheckable(true);
            } else if (!QVTc2QVTu.this.typedModelsConfiguration.hasTargetTypedModel()) {
                dOut.setIsEnforceable(false);
            } else {
                dOut.setIsCheckable(false);
            }
            return dOut;
        }

        @Override
        public @NonNull CoreModel visitCoreModel(@NonNull CoreModel mIn) {
            CoreModel mOut = super.visitCoreModel(mIn);
            String externalURI = mIn.getExternalURI();
            if (externalURI.endsWith(".qvtcas")) {
                externalURI = externalURI.replace(".qvtcas", ".qvtu.qvtcas");
            } else if (externalURI.endsWith(".qvtc")) {
                externalURI = externalURI.replace(".qvtc", ".qvtu.qvtcas");
            }
            mOut.setExternalURI(externalURI);
            return mOut;
        }

        @Override
        public @Nullable Element visitMapping(@NonNull Mapping mIn) {
            MappingMode mappingMode = QVTc2QVTu.this.getMappingMode(mIn);
            if (mappingMode == null) {
                return null;
            }
            @NonNull Mapping mOut = QVTcoreFactory.eINSTANCE.createMapping();
            this.doMapping(mIn, mOut);
            return mOut;
        }

        @Override
        public @Nullable Element visitOppositePropertyAssignment(@NonNull OppositePropertyAssignment paIn) {
            return this.doNavigationAssignment((NavigationAssignment)paIn);
        }

        @Override
        public @Nullable Element visitPredicate(@NonNull Predicate pIn) {
            if (pIn.getPattern() instanceof BottomPattern && this.anyReferencedRealizedVariables(QVTcoreUtil.getOwnedConditionExpression((Predicate)pIn))) {
                return null;
            }
            return super.visitPredicate(pIn);
        }

        @Override
        public @Nullable Element visitPropertyAssignment(@NonNull PropertyAssignment paIn) {
            return this.doNavigationAssignment((NavigationAssignment)paIn);
        }

        @Override
        public @NonNull Variable visitRealizedVariable(@NonNull RealizedVariable rvIn) {
            Area aIn = this.getContainingArea((VariableDeclaration)rvIn);
            if (QVTc2QVTu.this.isInputDomain(aIn)) {
                BottomVariable vOut = QVTcoreFactory.eINSTANCE.createBottomVariable();
                assert (vOut != null);
                ((QVTc2QVTu)((Object)this.context)).addTrace((Element)rvIn, (Element)vOut);
                vOut.setName(rvIn.getName());
                vOut.setType(rvIn.getType());
                vOut.setIsRequired(rvIn.isIsRequired());
                return vOut;
            }
            return super.visitRealizedVariable(rvIn);
        }

        @Override
        public @Nullable Element visitVariableAssignment(@NonNull VariableAssignment vaIn) {
            VariableDeclaration targetVariable = vaIn.getTargetVariable();
            OCLExpression value = vaIn.getValue();
            assert (targetVariable != null && value != null);
            Area targetArea = this.getContainingArea(targetVariable);
            if (QVTc2QVTu.this.isInputDomain(targetArea) && !this.allReferencedVariablesInInputDomain((Element)value)) {
                return null;
            }
            return super.visitVariableAssignment(vaIn);
        }
    }

    private static enum DomainMode {
        INPUT,
        MIDDLE,
        OUTPUT;

    }

    private static enum MappingMode {
        NULL(0),
        LEFT2MIDDLE(1),
        MIDDLE2RIGHT(2),
        LEFT2RIGHT(3);

        private int flags;

        private MappingMode(int flags) {
            this.flags = flags;
        }

        private @NonNull MappingMode get(int flagsUnion) {
            switch (flagsUnion) {
                case 1: {
                    return LEFT2MIDDLE;
                }
                case 2: {
                    return MIDDLE2RIGHT;
                }
                case 3: {
                    return LEFT2RIGHT;
                }
            }
            return NULL;
        }

        public @NonNull MappingMode asInput() {
            return this.get(this.flags | 1);
        }

        public @NonNull MappingMode asOutput() {
            return this.get(this.flags | 2);
        }

        public boolean hasInputDomain() {
            return (this.flags & 1) != 0;
        }

        public boolean hasOutputDomain() {
            return (this.flags & 2) != 0;
        }

        public @NonNull MappingMode union(@NonNull MappingMode anotherMappingMode) {
            return this.get(this.flags | anotherMappingMode.flags);
        }
    }

    protected class UpdateVisitor
    extends AbstractQVTc2QVTc.AbstractUpdateVisitor<QVTc2QVTu> {
        public UpdateVisitor(QVTc2QVTu context) {
            super(context);
        }

        @Override
        public @NonNull Mapping visitMapping(@NonNull Mapping mOut) {
            return this.doMapping(mOut);
        }

        @Override
        public @Nullable Object visitVariableAssignment(@NonNull VariableAssignment vaOut) {
            Element pIn = ((QVTc2QVTu)((Object)this.context)).equivalentSource((Element)vaOut);
            if (pIn instanceof PropertyAssignment) {
                return this.convertToVariableAssignment((NavigationAssignment)((PropertyAssignment)pIn), vaOut);
            }
            return super.visitVariableAssignment(vaOut);
        }
    }
}

