/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.umlx.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2ASReferenceSwitch;
import org.eclipse.ocl.pivot.internal.utilities.PivotConstantsInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.ocl.pivot.utilities.URIUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;
import org.eclipse.qvtd.umlx.RelDiagram;
import org.eclipse.qvtd.umlx.RelDomainNode;
import org.eclipse.qvtd.umlx.RelInvocationEdge;
import org.eclipse.qvtd.umlx.RelInvocationNode;
import org.eclipse.qvtd.umlx.RelPatternEdge;
import org.eclipse.qvtd.umlx.RelPatternNode;
import org.eclipse.qvtd.umlx.TxDiagram;
import org.eclipse.qvtd.umlx.TxKeyNode;
import org.eclipse.qvtd.umlx.TxPackageNode;
import org.eclipse.qvtd.umlx.TxPartNode;
import org.eclipse.qvtd.umlx.TxTypedModelNode;
import org.eclipse.qvtd.umlx.UMLXNamedElement;
import org.eclipse.qvtd.umlx.UMLXTypedElement;
import org.eclipse.qvtd.umlx.utilities.UMLXUtil;

public class UMLXServices {
    protected void appendMultiplicity(@NonNull StringBuilder s, int lower, int upper) {
        if (upper == 1) {
            s.append(lower == 1 ? "[1]" : "[?]");
        } else if (upper < 0) {
            if (lower == 0) {
                s.append("[*]");
            } else if (lower == 1) {
                s.append("[+]");
            } else {
                s.append("[" + lower + "..*]");
            }
        } else if (lower == upper) {
            s.append("[" + lower + "]");
        } else {
            s.append("[" + lower + ".." + upper + "]");
        }
    }

    protected void appendType(StringBuilder s, @NonNull UMLXTypedElement umlxTypedElement) {
        EClassifier eClassifier;
        if (umlxTypedElement.isIsMany()) {
            if (umlxTypedElement.isIsUnique()) {
                s.append(umlxTypedElement.isIsOrdered() ? "OrderedSet" : "Set");
            } else {
                s.append(umlxTypedElement.isIsOrdered() ? "Sequence" : "Bag");
            }
            s.append("(");
        }
        if ((eClassifier = umlxTypedElement.getReferredEClassifier()) != null) {
            s.append(eClassifier.eIsProxy() ? EcoreUtil.getURI((EObject)eClassifier) : String.valueOf(eClassifier.getName()));
        }
        if (umlxTypedElement.isIsMany()) {
            s.append(")");
        } else {
            s.append(umlxTypedElement.isIsRequired() ? "[1]" : "[?]");
        }
    }

    protected void appendTypedElement(StringBuilder s, @NonNull UMLXTypedElement umlxTypedElement, @NonNull String nameTypeSeparator) {
        s.append(String.valueOf(umlxTypedElement.getName()));
        s.append(nameTypeSeparator);
        this.appendType(s, umlxTypedElement);
    }

    protected @NonNull String defaultName(@NonNull EObject context, @NonNull Class<? extends UMLXNamedElement> newClass, @NonNull String prefix) {
        HashSet<@NonNull String> allNames = new HashSet<String>();
        Resource eResource = context.eResource();
        assert (eResource != null);
        for (EObject eObject : new TreeIterable(eResource)) {
            if (!newClass.isAssignableFrom(eObject.getClass())) continue;
            allNames.add(UMLXUtil.getName((UMLXNamedElement)eObject));
        }
        int i = allNames.size();
        String newName;
        while (allNames.contains(newName = String.valueOf(prefix) + i)) {
            ++i;
        }
        return newName;
    }

    private int getEOppositeLower(@NonNull EReference eReference) {
        EReference eOpposite = eReference.getEOpposite();
        if (eOpposite != null) {
            return eOpposite.getLowerBound();
        }
        EAnnotation oppositeRole = eReference.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml");
        if (oppositeRole != null) {
            EMap details = oppositeRole.getDetails();
            String oppositeName = (String)details.get((Object)"Property.oppositeRoleName");
            if (oppositeName != null) {
                IntegerValue lower;
                String lowerValue = (String)details.get(Ecore2ASReferenceSwitch.PROPERTY_OPPOSITE_ROLE_LOWER_KEY);
                IntegerValue one = ValueUtil.ONE_VALUE;
                IntegerValue integerValue = lower = lowerValue != null ? ValueUtil.integerValueOf((String)lowerValue) : one;
                if (lower.isInvalid()) {
                    lower = one;
                }
                return lower.intValue();
            }
        } else {
            EMap details;
            String oppositeName;
            oppositeRole = eReference.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml#Property.oppositeRoleName");
            if (oppositeRole != null && (oppositeName = (String)(details = oppositeRole.getDetails()).get((Object)"body")) != null) {
                IntegerValue lower;
                String lowerValue = (String)details.get((Object)"lower");
                IntegerValue integerValue = lower = lowerValue != null ? ValueUtil.integerValueOf((String)lowerValue) : PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_LOWER_VALUE;
                if (lower.isInvalid()) {
                    lower = PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_LOWER_VALUE;
                }
                return lower.intValue();
            }
        }
        return 0;
    }

    private String getEOppositeName(@NonNull EReference eReference) {
        EReference eOpposite = eReference.getEOpposite();
        if (eOpposite != null) {
            return eOpposite.getName();
        }
        EAnnotation oppositeRole = eReference.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml");
        if (oppositeRole != null) {
            EMap details = oppositeRole.getDetails();
            String oppositeName = (String)details.get((Object)"Property.oppositeRoleName");
            if (oppositeName != null) {
                return oppositeName;
            }
        } else {
            EMap details;
            String oppositeName;
            oppositeRole = eReference.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml#Property.oppositeRoleName");
            if (oppositeRole != null && (oppositeName = (String)(details = oppositeRole.getDetails()).get((Object)"body")) != null) {
                return oppositeName;
            }
        }
        return "\u00abinferred\u00bb";
    }

    private int getEOppositeUpper(@NonNull EReference eReference) {
        EReference eOpposite = eReference.getEOpposite();
        if (eOpposite != null) {
            return eOpposite.getUpperBound();
        }
        EAnnotation oppositeRole = eReference.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml");
        if (oppositeRole != null) {
            EMap details = oppositeRole.getDetails();
            String oppositeName = (String)details.get((Object)"Property.oppositeRoleName");
            if (oppositeName != null) {
                UnlimitedNaturalValue upper;
                String upperValue = (String)details.get(Ecore2ASReferenceSwitch.PROPERTY_OPPOSITE_ROLE_UPPER_KEY);
                UnlimitedNaturalValue unlimitedOne = ValueUtil.UNLIMITED_ONE_VALUE;
                UnlimitedNaturalValue unlimitedNaturalValue = upper = upperValue != null ? ValueUtil.unlimitedNaturalValueOf((String)upperValue) : unlimitedOne;
                if (upper.isInvalid()) {
                    upper = unlimitedOne;
                }
                return upper.intValue();
            }
        } else {
            EMap details;
            String oppositeName;
            oppositeRole = eReference.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml#Property.oppositeRoleName");
            if (oppositeRole != null && (oppositeName = (String)(details = oppositeRole.getDetails()).get((Object)"body")) != null) {
                UnlimitedNaturalValue upper;
                String upperValue = (String)details.get((Object)"upper");
                UnlimitedNaturalValue unlimitedNaturalValue = upper = upperValue != null ? ValueUtil.unlimitedNaturalValueOf((String)upperValue) : PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_UPPER_VALUE;
                if (upper.isInvalid()) {
                    upper = PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_UPPER_VALUE;
                }
                return upper.intValue();
            }
        }
        return 0;
    }

    public int umlxBorderSize(EObject context) {
        return 4;
    }

    public @NonNull String umlxDefaultName(EObject context) {
        if (context instanceof RelPatternNode && !((RelPatternNode)context).isExpression().booleanValue()) {
            return this.defaultName(context, RelPatternNode.class, "NewClass");
        }
        if (context instanceof RelDiagram) {
            return this.defaultName(context, RelDiagram.class, "NewRelation");
        }
        if (context instanceof TxTypedModelNode) {
            return this.defaultName(context, TxTypedModelNode.class, "NewTypedModel");
        }
        return "\u00abumlxDefaultName\u00bb";
    }

    public EObject umlxEdgeContext(EObject context) {
        if (context instanceof RelInvocationNode) {
            return context;
        }
        if (context instanceof RelPatternNode) {
            return ((RelPatternNode)context).getOwningRelDomainNode();
        }
        return context;
    }

    public @NonNull String umlxInvocationEdgeEndLabel(EObject context) {
        RelPatternNode relPatternNode;
        if (context instanceof RelInvocationEdge && (relPatternNode = ((RelInvocationEdge)context).getReferredRelPatternNode()) != null) {
            return String.valueOf(relPatternNode.getName());
        }
        return "";
    }

    public boolean umlxInvocationIsThen(EObject context) {
        if (context instanceof RelInvocationNode) {
            return ((RelInvocationNode)context).isIsThen();
        }
        if (context instanceof RelInvocationEdge) {
            RelInvocationNode owningSource = ((RelInvocationEdge)context).getOwningRelInvocationNode();
            return owningSource != null && owningSource.isIsThen();
        }
        return false;
    }

    public @NonNull String umlxPatternEdgeBeginLabel(EObject context) {
        EStructuralFeature eStructuralFeature;
        if (context instanceof RelPatternEdge && (eStructuralFeature = ((RelPatternEdge)context).getReferredEStructuralFeature()) instanceof EReference) {
            EReference eReference = (EReference)eStructuralFeature;
            StringBuilder s = new StringBuilder();
            s.append(this.getEOppositeName(eReference));
            s.append(" ");
            this.appendMultiplicity(s, this.getEOppositeLower(eReference), this.getEOppositeUpper(eReference));
            return s.toString();
        }
        return "";
    }

    public @NonNull String umlxPatternEdgeCenterLabel(EObject context) {
        if (context instanceof RelPatternEdge) {
            int sourceIndex = ((RelPatternEdge)context).getSourceIndex();
            if (sourceIndex > 0) {
                return "\u00ab" + sourceIndex + "\u00bb";
            }
            if (sourceIndex < 0) {
                return "\u00abrest\u00bb";
            }
        }
        return "";
    }

    public @NonNull String umlxPatternEdgeEndLabel(EObject context) {
        EStructuralFeature eStructuralFeature;
        if (context instanceof RelPatternEdge && (eStructuralFeature = ((RelPatternEdge)context).getReferredEStructuralFeature()) != null) {
            StringBuilder s = new StringBuilder();
            s.append(String.valueOf(eStructuralFeature.getName()));
            s.append(" ");
            this.appendMultiplicity(s, eStructuralFeature.getLowerBound(), eStructuralFeature.getUpperBound());
            return s.toString();
        }
        return "";
    }

    public boolean umlxPatternEdgeSourceIsContainer(EObject context) {
        EStructuralFeature eStructuralFeature;
        if (context instanceof RelPatternEdge && (eStructuralFeature = ((RelPatternEdge)context).getReferredEStructuralFeature()) instanceof EReference) {
            EReference eOpposite = ((EReference)eStructuralFeature).getEOpposite();
            return eOpposite != null && eOpposite.isContainer();
        }
        return false;
    }

    public boolean umlxPatternEdgeTargetIsContainer(EObject context) {
        EStructuralFeature eStructuralFeature;
        if (context instanceof RelPatternEdge && (eStructuralFeature = ((RelPatternEdge)context).getReferredEStructuralFeature()) instanceof EReference) {
            return ((EReference)eStructuralFeature).isContainer();
        }
        return false;
    }

    public boolean umlxPatternEdgeTargetIsDataType(EObject context) {
        EStructuralFeature eStructuralFeature;
        return context instanceof RelPatternEdge && (eStructuralFeature = ((RelPatternEdge)context).getReferredEStructuralFeature()) instanceof EAttribute;
    }

    public boolean umlxPatternEdgeTargetIsMember(EObject context) {
        if (context instanceof RelPatternEdge) {
            return ((RelPatternEdge)context).getSourceIndex() > 0;
        }
        return false;
    }

    public boolean umlxPatternEdgeTargetIsRest(EObject context) {
        if (context instanceof RelPatternEdge) {
            return ((RelPatternEdge)context).getSourceIndex() < 0;
        }
        return false;
    }

    public @NonNull String umlxRelDiagramTitleExpression(EObject context) {
        if (context instanceof RelDiagram) {
            return "UMLX Relation " + ((RelDiagram)context).getName();
        }
        return "new UMLX Relation Diagram";
    }

    public @NonNull Collection<EObject> umlxRelDiagramSemanticsCandidatesExpression(EObject context) {
        ArrayList<EObject> candidates = new ArrayList<EObject>();
        if (context instanceof RelDiagram) {
            RelDiagram relDiagram = (RelDiagram)context;
            candidates.addAll((Collection<EObject>)relDiagram.getOwnedRelDomainNodes());
            candidates.addAll((Collection<EObject>)relDiagram.getOwnedRelInvocationNodes());
        } else {
            candidates.add(context);
        }
        return candidates;
    }

    public @NonNull String umlxRelLabel(EObject context) {
        if (context instanceof RelDiagram) {
            RelDiagram relDiagram = (RelDiagram)context;
            StringBuilder s = new StringBuilder();
            if (relDiagram.isIsTop()) {
                s.append("\u00abtop\u00bb ");
            }
            if (relDiagram.isIsAbstract()) {
                s.append("\u00ababstract\u00bb ");
            }
            s.append(String.valueOf(relDiagram.getName()));
            return s.toString();
        }
        if (context instanceof RelDomainNode) {
            TxTypedModelNode txTypedModelNode = ((RelDomainNode)context).getReferredTxTypedModelNode();
            if (txTypedModelNode != null) {
                if (((RelDomainNode)context).isIsEnforced()) {
                    return "\u00abenforce\u00bb " + String.valueOf(txTypedModelNode.getName());
                }
                return String.valueOf(txTypedModelNode.getName());
            }
            return "\u00abprimitive\u00bb";
        }
        if (context instanceof RelInvocationNode) {
            RelDiagram relDiagram = ((RelInvocationNode)context).getReferredRelDiagram();
            if (relDiagram != null) {
                return String.valueOf(relDiagram.getName());
            }
            return "\u00abnull-referredDiagram\u00bb";
        }
        if (context instanceof RelPatternNode && !((RelPatternNode)context).isExpression().booleanValue()) {
            StringBuilder s = new StringBuilder();
            RelPatternNode relPatternClassNode = (RelPatternNode)context;
            s.append(String.valueOf(relPatternClassNode.getName()));
            EList<String> initExpressionLines = relPatternClassNode.getInitExpressionLines();
            if (initExpressionLines.size() > 0) {
                s.append(" :=");
                for (String line : initExpressionLines) {
                    s.append("\n");
                    s.append(line);
                }
            }
            return s.toString();
        }
        if (context instanceof RelPatternNode && ((RelPatternNode)context).isExpression().booleanValue()) {
            StringBuilder s = new StringBuilder();
            boolean firstLine = true;
            for (String line : ((RelPatternNode)context).getInitExpressionLines()) {
                if (!firstLine) {
                    s.append("\n");
                }
                s.append(line);
                firstLine = false;
            }
            return s.toString();
        }
        return "\u00abumlxRelLabel - " + context.getClass().getName() + " - " + context.eClass().getName() + "\u00bb";
    }

    public boolean umlxRelPatternNodeIsExpression(EObject context) {
        return context instanceof RelPatternNode && ((RelPatternNode)context).isExpression() != false;
    }

    public boolean umlxRelPatternNodeIsOptional(EObject context) {
        if (context instanceof RelPatternNode && !((RelPatternNode)context).isExpression().booleanValue()) {
            return !((RelPatternNode)context).isIsRequired();
        }
        return false;
    }

    public boolean umlxRelPatternNodeIsRoot(EObject context) {
        if (context instanceof RelPatternNode) {
            return ((RelPatternNode)context).isIsRoot();
        }
        return false;
    }

    public EObject umlxSelfExpression(EObject context) {
        return context;
    }

    public int umlxSize(EObject context) {
        return 9;
    }

    public int umlxWidth(EObject context) {
        return 7;
    }

    public @NonNull String umlxTooltipExpression(EObject context) {
        return "Tooltip for " + context.eClass().getName();
    }

    public @NonNull String umlxTxDiagramTitleExpression(EObject context) {
        if (context instanceof TxDiagram) {
            return "UMLX Transformation " + ((TxDiagram)context).getName();
        }
        return "new UMLX Transformation Diagram";
    }

    public @NonNull String umlxTxLabel(EObject context) {
        if (context instanceof RelDiagram) {
            RelDiagram relDiagram = (RelDiagram)context;
            if (((RelDiagram)context).isIsTop()) {
                return "\u00abtop\u00bb\n" + String.valueOf(relDiagram.getName());
            }
            return String.valueOf(relDiagram.getName());
        }
        if (context instanceof TxKeyNode) {
            EClass eClassifier = ((TxKeyNode)context).getReferredEClass();
            if (eClassifier != null) {
                return String.valueOf(eClassifier.getName());
            }
            return "\u00abnull-referredClass\u00bb";
        }
        if (context instanceof TxPackageNode) {
            EPackage ePackage = ((TxPackageNode)context).getReferredEPackage();
            StringBuilder s = new StringBuilder();
            s.append(ePackage.getName());
            s.append(" : ");
            s.append(ePackage.getNsURI());
            s.append("\n");
            @NonNull URI uri = EcoreUtil.getURI((EObject)ePackage);
            uri = URIUtil.deresolve((URI)uri, (URI)context.eResource().getURI());
            s.append(uri);
            return s.toString();
        }
        if (context instanceof TxPartNode) {
            EStructuralFeature eStructuralFeature = ((TxPartNode)context).getReferredEStructuralFeature();
            if (eStructuralFeature != null) {
                return String.valueOf(eStructuralFeature.getName());
            }
            return "\u00abnull-referredProperty\u00bb";
        }
        if (context instanceof TxTypedModelNode) {
            return String.valueOf(((TxTypedModelNode)context).getName());
        }
        if (context instanceof UMLXTypedElement) {
            StringBuilder s = new StringBuilder();
            this.appendTypedElement(s, (UMLXTypedElement)context, " : ");
            return s.toString();
        }
        return "\u00abumlxTxLabel - " + context.getClass().getName() + " - " + context.eClass().getName() + "\u00bb";
    }

    public @NonNull Collection<@NonNull EObject> umlxTxTransformationNodeCandidates(EObject context) {
        ArrayList<@NonNull EObject> candidates = new ArrayList<EObject>();
        if (context instanceof TxDiagram) {
            candidates.addAll((Collection<EObject>)ClassUtil.nullFree(((TxDiagram)context).getOwnedTxKeyNodes()));
            candidates.addAll((Collection<EObject>)ClassUtil.nullFree(((TxDiagram)context).getOwnedTxTypedModelNodes()));
        }
        return candidates;
    }

    public @NonNull String umlxTypeLabel(EObject context) {
        if (context instanceof UMLXTypedElement) {
            StringBuilder s = new StringBuilder();
            this.appendType(s, (UMLXTypedElement)context);
            return s.toString();
        }
        return "\u00abumlxTypeLabel - " + context.getClass().getName() + " - " + context.eClass().getName() + "\u00bb";
    }
}

