/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.doc.minioclcs.xtext.internal.tx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.evaluation.AbstractModelManager;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.ClassId;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.evaluation.EvaluationCache;
import org.eclipse.ocl.pivot.internal.values.SetValueImpl;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.SetValue;
import org.eclipse.qvtd.doc.minioclcs.xtext.internal.tx.LazyInvocationManager;
import org.eclipse.qvtd.doc.minioclcs.xtext.internal.tx.LazyObjectManager;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.AbstractTransformer;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.AbstractTypedModelInstance;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.ExecutionVisitable;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.Invocation;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.InvocationFailedException;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.InvocationManager;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.ObjectManager;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.Transformer;

public abstract class AbstractTransformerInternal
extends AbstractModelManager
implements Transformer,
ExecutionVisitable {
    private static final @NonNull List<@NonNull Integer> EMPTY_INDEX_LIST = Collections.emptyList();
    private static final @NonNull List<@NonNull Object> EMPTY_EOBJECT_LIST = Collections.emptyList();
    protected final @NonNull Executor executor;
    @Deprecated
    protected final @NonNull Evaluator evaluator;
    protected final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IdResolver.IdResolverExtension idResolver;
    protected final @NonNull Model @NonNull [] models;
    protected final @NonNull Map<@NonNull String, @NonNull Integer> modelIndexes = new HashMap<String, Integer>();
    protected final boolean debugExceptions = AbstractTransformer.EXCEPTIONS.isActive();
    protected final boolean debugInvocations = AbstractTransformer.INVOCATIONS.isActive();
    private final @NonNull PropertyId @Nullable [] propertyIndex2propertyId;
    private final @Nullable Map<PropertyId, Integer> propertyId2propertyIndex;
    private final @Nullable EReference @Nullable [] propertyIndex2eReference;
    private final @NonNull Map<@NonNull Object, @NonNull Object> @Nullable [] object2oppositeObject;
    private final @Nullable Map<@NonNull ClassId, @NonNull Integer> classId2classIndex;
    private final @Nullable Map<@NonNull ClassId, @NonNull Set<@NonNull Integer>> classId2classIndexes;
    protected final @NonNull InvocationManager invocationManager;
    protected final @NonNull ObjectManager objectManager;
    protected final @NonNull EvaluationCache evaluationCache;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected AbstractTransformerInternal(@NonNull Executor executor, @NonNull String @NonNull [] modelNames, @NonNull PropertyId @Nullable [] propertyIndex2propertyId, @NonNull ClassId @Nullable [] classIndex2classId, int @Nullable [] @NonNull [] classIndex2allClassIndexes) {
        this.executor = executor;
        this.evaluator = executor;
        this.idResolver = (IdResolver.IdResolverExtension)executor.getIdResolver();
        this.invocationManager = this.createInvocationManager();
        this.objectManager = this.createObjectManager();
        this.evaluationCache = this.createEvaluationCache();
        this.models = new Model[modelNames.length];
        int i = 0;
        while (i < modelNames.length) {
            String modelName = modelNames[i];
            this.models[i] = new Model(modelName, propertyIndex2propertyId, classIndex2classId, classIndex2allClassIndexes);
            this.modelIndexes.put(modelName, i);
            ++i;
        }
        if (propertyIndex2propertyId != null) {
            int propertyIds = propertyIndex2propertyId.length;
            this.propertyIndex2propertyId = propertyIndex2propertyId;
            HashMap<@NonNull PropertyId, @NonNull Integer> propertyId2propertyIndex2 = new HashMap<PropertyId, Integer>(propertyIds);
            this.propertyId2propertyIndex = propertyId2propertyIndex2;
            this.propertyIndex2eReference = new EReference[propertyIds];
            int propertyIndex = 0;
            while (propertyIndex < propertyIds) {
                PropertyId propertyId = propertyIndex2propertyId[propertyIndex];
                propertyId2propertyIndex2.put(propertyId, propertyIndex);
                ++propertyIndex;
            }
            @NonNull @NonNull @NonNull Map @Nullable [] object2oppositeObject = new HashMap[propertyIds];
            this.object2oppositeObject = object2oppositeObject;
            int i2 = 0;
            while (i2 < propertyIds) {
                object2oppositeObject[i2] = new HashMap();
                ++i2;
            }
        } else {
            this.propertyIndex2propertyId = null;
            this.propertyId2propertyIndex = null;
            this.propertyIndex2eReference = null;
            this.object2oppositeObject = null;
        }
        if (classIndex2classId != null) {
            assert (classIndex2allClassIndexes != null);
            int classIds = classIndex2classId.length;
            HashMap<@NonNull ClassId, @NonNull Integer> classId2classIndex2 = new HashMap<ClassId, Integer>(classIds);
            HashMap<@NonNull ClassId, @NonNull Set<@NonNull Integer>> classId2classIndexes2 = new HashMap<ClassId, Set<Integer>>(classIds);
            this.classId2classIndex = classId2classIndex2;
            this.classId2classIndexes = classId2classIndexes2;
            int classIndex = 0;
            while (classIndex < classIds) {
                ClassId classId = classIndex2classId[classIndex];
                classId2classIndex2.put(classId, classIndex);
                HashSet<@NonNull Integer> superClassIndexes = new HashSet<Integer>();
                int[] nArray = classIndex2allClassIndexes[classIndex];
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int allClassIndex = nArray[n2];
                    superClassIndexes.add(allClassIndex);
                    ++n2;
                }
                classId2classIndexes2.put(classId, superClassIndexes);
                ++classIndex;
            }
        } else {
            this.classId2classIndex = null;
            this.classId2classIndexes = null;
        }
    }

    @Override
    public void addRootObjects(@NonNull String modelName, @NonNull Iterable<@NonNull ? extends Object> eRootObjects) {
        Integer modelIndex = this.modelIndexes.get(modelName);
        if (modelIndex == null) {
            throw new IllegalStateException("Unknown model name '" + modelName + "'");
        }
        this.models[modelIndex].addRootObjects(eRootObjects);
    }

    protected @NonNull EvaluationCache createEvaluationCache() {
        return new EvaluationCache(this.executor);
    }

    protected @NonNull InvocationManager createInvocationManager() {
        return new LazyInvocationManager();
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SetValue.Accumulator createUnenforcedSetAccumulatorValue(@NonNull CollectionTypeId typeId) {
        return new UnenforcedSetAccumulator(typeId);
    }

    protected @NonNull ObjectManager createObjectManager() {
        return new LazyObjectManager((LazyInvocationManager)this.invocationManager);
    }

    public @NonNull Set<@NonNull Object> get(@NonNull Class type) {
        return new UnmodifiableCollectionAsSet<Object>(this.models[0].getObjectsOfKind(type));
    }

    private @NonNull Set<@NonNull Integer> getClassIndexes(@NonNull EClass eClass) {
        EPackage ePackage = (EPackage)ClassUtil.nonNullEMF((Object)eClass.getEPackage());
        PackageId packageId = IdManager.getPackageId((EPackage)ePackage);
        String className = (String)ClassUtil.nonNullEMF((Object)eClass.getName());
        ClassId classId = packageId.getClassId(className, eClass.getETypeParameters().size());
        assert (this.classId2classIndexes != null);
        Set<@NonNull Integer> classIndexes = this.classId2classIndexes.get(classId);
        if (classIndexes == null) {
            classIndexes = new HashSet<Integer>();
            for (EClass eSuperClass : ClassUtil.nullFree((EList)eClass.getESuperTypes())) {
                Set<@NonNull Integer> partialResult = this.getClassIndexes(eSuperClass);
                classIndexes.addAll(partialResult);
            }
            assert (this.classId2classIndexes != null);
            this.classId2classIndexes.put(classId, classIndexes);
        }
        return classIndexes;
    }

    private @NonNull List<@NonNull Integer> getOppositePropertyIndexes(@NonNull Map<@NonNull EReference, @NonNull Integer> eReference2propertyIndex, @NonNull EClass eClass) {
        List<@NonNull Integer> propertyIndexes = null;
        for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
            if (!(eStructuralFeature instanceof EReference)) continue;
            EReference eReference = (EReference)eStructuralFeature;
            Integer propertyIndex = eReference2propertyIndex.get(eReference);
            if (propertyIndex == null) {
                if (!(eReference.getEOpposite() != null || eReference.isDerived() || eReference.isTransient() || eReference.isVolatile())) {
                    EClass eContainingClass = eReference.getEContainingClass();
                    EPackage ePackage = (EPackage)ClassUtil.nonNullEMF((Object)eContainingClass.getEPackage());
                    PackageId packageId = IdManager.getPackageId((EPackage)ePackage);
                    String className = (String)ClassUtil.nonNullEMF((Object)eContainingClass.getName());
                    ClassId classId = packageId.getClassId(className, eContainingClass.getETypeParameters().size());
                    String propertyName = (String)ClassUtil.nonNullEMF((Object)eReference.getName());
                    PropertyId propertyId = classId.getPropertyId(propertyName);
                    assert (this.propertyId2propertyIndex != null);
                    propertyIndex = this.propertyId2propertyIndex.get(propertyId);
                }
                if (propertyIndex == null) {
                    propertyIndex = -1;
                }
                eReference2propertyIndex.put(eReference, propertyIndex);
            }
            if (propertyIndex < 0) continue;
            if (propertyIndexes == null) {
                propertyIndexes = new ArrayList<Integer>();
            }
            propertyIndexes.add(propertyIndex);
        }
        return propertyIndexes != null ? propertyIndexes : EMPTY_INDEX_LIST;
    }

    public @NonNull Collection<@NonNull EObject> getRootEObjects(@NonNull String modelName) {
        Integer modelIndex = this.modelIndexes.get(modelName);
        if (modelIndex == null) {
            throw new IllegalStateException("Unknown model name '" + modelName + "'");
        }
        ArrayList<@NonNull EObject> rootEObjects = new ArrayList<EObject>();
        for (Object rootObject : this.models[modelIndex].getRootObjects()) {
            if (!(rootObject instanceof EObject)) continue;
            rootEObjects.add((EObject)rootObject);
        }
        return rootEObjects;
    }

    @Override
    public @NonNull Collection<@NonNull Object> getRootObjects(@NonNull String modelName) {
        Integer modelIndex = this.modelIndexes.get(modelName);
        if (modelIndex == null) {
            throw new IllegalStateException("Unknown model name '" + modelName + "'");
        }
        return this.models[modelIndex].getRootObjects();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handleExecutionFailure(@NonNull String mappingName, @NonNull Throwable e) throws InvocationFailedException {
        if (e instanceof InvocationFailedException) {
            throw (InvocationFailedException)((Object)e);
        }
        if (e instanceof AssertionError) {
            if (!this.debugExceptions) throw (AssertionError)((Object)e);
            AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
            return false;
        } else {
            if (e instanceof Error) {
                if (!this.debugExceptions) throw (Error)e;
                AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
                throw (Error)e;
            }
            if (e instanceof InvalidValueException) {
                if (!this.debugExceptions) return false;
                AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
                return false;
            } else if (e instanceof NullPointerException) {
                if (!this.debugExceptions) return false;
                AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
                return false;
            } else {
                if (!this.debugExceptions) return false;
                AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
            }
        }
        return false;
    }

    public <T extends Invocation> void invoke(@NonNull Invocation.Constructor constructor, Object ... boundValues) {
        @NonNull Invocation invocation = constructor.newInstance(boundValues);
        if (this.debugInvocations) {
            AbstractTransformer.INVOCATIONS.println("invoke " + invocation);
        }
        this.invocationManager.invoke(invocation, true);
    }

    public void invokeOnce(@NonNull Invocation.Constructor constructor, Object ... boundValues) {
        @Nullable Invocation invocation = constructor.getFirstInvocation(boundValues);
        if (invocation != null) {
            if (this.debugInvocations) {
                AbstractTransformer.INVOCATIONS.println("invokeOnce " + invocation);
            }
            this.invocationManager.invoke(invocation, true);
        }
    }

    protected class Model
    extends AbstractTypedModelInstance {
        protected final @NonNull String name;
        private @Nullable List<@NonNull Object> allEObjects = null;
        private @Nullable List<@NonNull Object> rootEObjects = null;
        private @Nullable Map<@NonNull EClass, @NonNull Set<@NonNull Integer>> eClass2allClassIndexes = null;
        private final @NonNull List<@NonNull Object> @Nullable [] classIndex2objects;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public Model(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NonNull @Nullable String name, @NonNull PropertyId @Nullable [] propertyIndex2propertyId, @NonNull ClassId @Nullable [] classIndex2classId, int[][] classIndex2allClassIndexes) {
            this.name = name;
            if (classIndex2classId != null) {
                assert (classIndex2allClassIndexes != null);
                int classIds = classIndex2classId.length;
                @NonNull @NonNull List @NonNull [] classIndex2objects = new ArrayList[classIds];
                this.classIndex2objects = classIndex2objects;
                int i = 0;
                while (i < classIds) {
                    classIndex2objects[i] = new ArrayList();
                    ++i;
                }
            } else {
                this.classIndex2objects = null;
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private void accumulateEObject(@Nullable Map<@NonNull EClass, @NonNull Set<@NonNull Integer>> eClass2allClassIndexes, @Nullable Map<@NonNull EClass, @NonNull List<@NonNull Integer>> eClass2allPropertyIndexes, @Nullable Map<@NonNull EReference, @NonNull Integer> eReference2propertyIndex, @NonNull Object eObject) {
            EClass eClass = AbstractTransformerInternal.this.eClass(eObject);
            if (eClass2allClassIndexes != null) {
                @NonNull Set allClassIndexes = eClass2allClassIndexes.get(eClass);
                if (allClassIndexes == null) {
                    allClassIndexes = AbstractTransformerInternal.this.getClassIndexes(eClass);
                    eClass2allClassIndexes.put(eClass, allClassIndexes);
                }
                List<@NonNull Object>[] classIndex2objects2 = this.classIndex2objects;
                assert (classIndex2objects2 != null);
                for (Integer classIndex : allClassIndexes) {
                    classIndex2objects2[classIndex].add(eObject);
                }
            }
            if (eClass2allPropertyIndexes != null) {
                assert (eReference2propertyIndex != null);
                @NonNull List allPropertyIndexes = eClass2allPropertyIndexes.get(eClass);
                if (allPropertyIndexes == null) {
                    allPropertyIndexes = AbstractTransformerInternal.this.getOppositePropertyIndexes(eReference2propertyIndex, eClass);
                    eClass2allPropertyIndexes.put(eClass, allPropertyIndexes);
                }
                @NonNull @NonNull Map[] object2oppositeObject2 = AbstractTransformerInternal.this.object2oppositeObject;
                assert (object2oppositeObject2 != null);
                for (Integer propertyIndex : allPropertyIndexes) {
                    assert (AbstractTransformerInternal.this.propertyIndex2eReference != null);
                    EReference eReference = AbstractTransformerInternal.this.propertyIndex2eReference[propertyIndex];
                    if (eReference == null) {
                        assert (AbstractTransformerInternal.this.propertyIndex2propertyId != null);
                        PropertyId propertyId = AbstractTransformerInternal.this.propertyIndex2propertyId[propertyIndex];
                        assert (propertyId != null);
                        eReference = (EReference)NameUtil.getENamedElement((Iterable)eClass.getEAllStructuralFeatures(), (String)propertyId.getName());
                        assert (eReference != null);
                    }
                    Object object = AbstractTransformerInternal.this.eGet(eObject, (EStructuralFeature)eReference);
                    assert (object != null);
                    object2oppositeObject2[propertyIndex].put(object, eObject);
                }
            }
        }

        public void add(@NonNull EObject eObject) {
            List<@NonNull Object> allEObjects2 = this.allEObjects;
            if (allEObjects2 == null) {
                this.allEObjects = allEObjects2 = new ArrayList<Object>();
            }
            this.rootEObjects = null;
            assert (!allEObjects2.contains(eObject));
            allEObjects2.add(eObject);
            if (this.eClass2allClassIndexes == null && AbstractTransformerInternal.this.classId2classIndexes != null && this.classIndex2objects != null) {
                this.eClass2allClassIndexes = new HashMap<EClass, Set<Integer>>();
            }
            this.accumulateEObject(this.eClass2allClassIndexes, null, null, eObject);
        }

        public void addRootObjects(@NonNull Iterable<@NonNull ? extends Object> eRootObjects) {
            List<@NonNull Object> rootEObjects2 = this.rootEObjects;
            if (rootEObjects2 == null) {
                this.rootEObjects = rootEObjects2 = new ArrayList<Object>();
            }
            this.allEObjects = null;
            HashMap<@NonNull EClass, @NonNull Set<@NonNull Integer>> eClass2allClassIndexes = null;
            HashMap<EClass, List<Integer>> eClass2allPropertyIndexes = null;
            HashMap<EReference, Integer> eReference2propertyIndex = null;
            if (AbstractTransformerInternal.this.classId2classIndexes != null && this.classIndex2objects != null) {
                eClass2allClassIndexes = new HashMap<EClass, Set<Integer>>();
            }
            if (AbstractTransformerInternal.this.propertyIndex2propertyId != null) {
                eClass2allPropertyIndexes = new HashMap<EClass, List<Integer>>();
                eReference2propertyIndex = new HashMap<EReference, Integer>();
            }
            for (Object object : eRootObjects) {
                rootEObjects2.add(object);
                if (eClass2allClassIndexes == null && eClass2allPropertyIndexes == null) continue;
                this.accumulateEObject(eClass2allClassIndexes, eClass2allPropertyIndexes, eReference2propertyIndex, object);
                TreeIterator tit = AbstractTransformerInternal.this.eAllContents(object);
                while (tit.hasNext()) {
                    Object eObject = tit.next();
                    if (eObject == null) continue;
                    this.accumulateEObject(eClass2allClassIndexes, eClass2allPropertyIndexes, eReference2propertyIndex, eObject);
                }
            }
        }

        public @NonNull Collection<@NonNull Object> getAllObjects() {
            List<@NonNull Object> allEObjects2 = this.allEObjects;
            if (allEObjects2 == null) {
                this.allEObjects = allEObjects2 = new ArrayList<Object>();
                if (this.rootEObjects != null) {
                    for (Object eRootObject : this.rootEObjects) {
                        assert (!allEObjects2.contains(eRootObject));
                        allEObjects2.add(eRootObject);
                        TreeIterator tit = AbstractTransformerInternal.this.eAllContents(eRootObject);
                        while (tit.hasNext()) {
                            Object eObject = tit.next();
                            if (eObject == null) continue;
                            assert (!allEObjects2.contains(eObject));
                            allEObjects2.add(eObject);
                        }
                    }
                }
            }
            return allEObjects2;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @NonNull Collection<@NonNull Object> getObjectsOfKind(@NonNull Class type) {
            List<Object> objects;
            List<Object>[] classIndex2objects2;
            TypeId classId;
            Integer classIndex;
            @NonNull @NonNull Map classId2classIndex2 = AbstractTransformerInternal.this.classId2classIndex;
            if (classId2classIndex2 != null && (classIndex = (Integer)classId2classIndex2.get(classId = type.getTypeId())) != null && (classIndex2objects2 = this.classIndex2objects) != null && (objects = classIndex2objects2[classIndex]) != null) {
                return objects;
            }
            return EMPTY_EOBJECT_LIST;
        }

        public @NonNull Collection<@NonNull Object> getObjectsOfType(@NonNull Class type) {
            throw new UnsupportedOperationException();
        }

        public @NonNull Collection<@NonNull Object> getRootObjects() {
            List<@NonNull Object> rootEObjects2 = this.rootEObjects;
            if (rootEObjects2 == null) {
                this.rootEObjects = rootEObjects2 = new ArrayList<Object>();
                if (this.allEObjects != null) {
                    for (Object eObject : this.allEObjects) {
                        if (AbstractTransformerInternal.this.eContainer(eObject) != null) continue;
                        rootEObjects2.add(eObject);
                    }
                }
            }
            return rootEObjects2;
        }

        public String toString() {
            return String.valueOf(this.name) + " " + (this.rootEObjects != null ? Integer.valueOf(this.rootEObjects.size()) : "null") + "/" + (this.allEObjects != null ? Integer.valueOf(this.allEObjects.size()) : "null");
        }

        @Override
        public @NonNull String getName() {
            return this.name;
        }
    }

    private static class UnenforcedSetAccumulator
    extends SetValueImpl
    implements SetValue.Accumulator {
        public UnenforcedSetAccumulator(@NonNull CollectionTypeId typeId) {
            super(typeId, new ArrayList());
        }

        public boolean add(@Nullable Object value) {
            assert (!this.elements.contains(value));
            return this.elements.add(value);
        }
    }

    private static class UnmodifiableCollectionAsSet<T>
    implements Set<T> {
        protected final @NonNull Collection<@NonNull T> collection;

        private UnmodifiableCollectionAsSet(@NonNull Collection<@NonNull T> collection) {
            this.collection = collection;
            assert (collection.size() == new HashSet<T>(collection).size());
        }

        @Override
        public boolean add(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(@NonNull Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return this.collection.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.collection.containsAll(c);
        }

        @Override
        public boolean equals(Object obj) {
            return this.collection.equals(obj);
        }

        @Override
        public int hashCode() {
            return this.collection.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        @Override
        public @NonNull Iterator<T> iterator() {
            return this.collection.iterator();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.collection.size();
        }

        @Override
        public Object[] toArray() {
            return this.collection.toArray();
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            return this.collection.toArray(a);
        }
    }
}

