/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.merger;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.AbstractMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.EdgeMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.NodeMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.RegionMerger;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class Correlator {
    protected final @NonNull RegionMerger regionMerger;
    protected final @NonNull MappingRegion extraRegion;
    protected final @NonNull CorrelationStrategy strategy;
    protected final @NonNull Map<@NonNull Node, @NonNull NodeMerger> extraNode2nodeMerger = new HashMap<Node, NodeMerger>();
    protected final boolean debugFailures = AbstractMerger.FAILURE.isActive();

    public static @Nullable Correlator correlate(@NonNull RegionMerger regionMerger, @NonNull MappingRegion extraRegion, @NonNull CorrelationStrategy strategy, @Nullable Correlator inverseCorrelator) {
        if (extraRegion instanceof RuleRegion && ((RuleRegion)extraRegion).getReferredRule().isIsAbstract()) {
            return null;
        }
        if (regionMerger.isAbstract()) {
            return null;
        }
        Correlator correlator = new Correlator(regionMerger, extraRegion, strategy, inverseCorrelator);
        return correlator.correlate() ? correlator : null;
    }

    protected Correlator(@NonNull RegionMerger regionMerger, @NonNull MappingRegion extraRegion, @NonNull CorrelationStrategy strategy, @Nullable Correlator inverseCorrelator) {
        this.regionMerger = regionMerger;
        this.extraRegion = extraRegion;
        this.strategy = strategy;
        if (inverseCorrelator != null) {
            Map<@NonNull Node, @NonNull NodeMerger> inverseNode2NodeMerger = inverseCorrelator.getNode2NodeMerger();
            for (Node inverseNode : inverseNode2NodeMerger.keySet()) {
                NodeMerger forwardNodeMerger = inverseNode2NodeMerger.get(inverseNode);
                assert (forwardNodeMerger != null);
                NodeMerger inverseNodeMerger = regionMerger.getNodeMerger(inverseNode);
                for (Node extraNode : forwardNodeMerger.getOriginalNodes()) {
                    this.extraNode2nodeMerger.put(extraNode, inverseNodeMerger);
                }
            }
        }
    }

    protected boolean correlate() {
        if (!this.correlateHeadNodes()) {
            return false;
        }
        if (!this.correlateNavigablePredicates()) {
            return false;
        }
        Set<@NonNull Node> navigableNodes = this.extraNode2nodeMerger.keySet();
        if (!this.correlateComputedPredicates()) {
            return false;
        }
        this.correlateResidualComputations(navigableNodes);
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected boolean correlateComputation(@NonNull Node firstNode, @NonNull NodeMerger secondNodeMerger, @NonNull Map<@NonNull Node, @NonNull NodeMerger> first2second) {
        NodeMerger nodeMerger = first2second.get(firstNode);
        if (nodeMerger != null) {
            return nodeMerger == secondNodeMerger;
        }
        if (firstNode.getNodeRole() != secondNodeMerger.getNodeRole()) {
            return false;
        }
        if (!ClassUtil.safeEquals((Object)firstNode.getName(), (Object)secondNodeMerger.getName())) {
            return false;
        }
        HashMap<@NonNull Node, @NonNull NodeMerger> nestedFirst2second = new HashMap<Node, NodeMerger>(first2second);
        nestedFirst2second.put(firstNode, secondNodeMerger);
        @NonNull ArrayList residualSecondArgumentEdges = Lists.newArrayList(secondNodeMerger.getArgumentEdges());
        for (Edge firstEdge : firstNode.getArgumentEdges()) {
            boolean gotIt = false;
            for (Edge secondEdge : residualSecondArgumentEdges) {
                if (!ClassUtil.safeEquals((Object)firstEdge.getName(), (Object)secondEdge.getName())) continue;
                if (!this.correlateComputation(firstEdge.getEdgeSource(), this.regionMerger.getNodeMerger(secondEdge.getEdgeSource()), nestedFirst2second)) {
                    return false;
                }
                gotIt = true;
                residualSecondArgumentEdges.remove(secondEdge);
                break;
            }
            if (gotIt) continue;
            return false;
        }
        first2second.putAll(nestedFirst2second);
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected boolean correlateComputedPredicates() {
        List<@NonNull Node> primaryTrueNodes = Collections.emptyList();
        List<@NonNull T> extraTrueNodes = Collections.emptyList();
        int primaryTrueSize = Iterables.size(primaryTrueNodes);
        if (primaryTrueSize != Iterables.size(extraTrueNodes)) {
            return false;
        }
        if (primaryTrueSize == 0) {
            return true;
        }
        HashMap<@NonNull Node, @NonNull NodeMerger> primary2extra = new HashMap<Node, NodeMerger>();
        if (primaryTrueSize == 1) {
            Node extraTrueNode;
            Node primaryTrueNode = (Node)primaryTrueNodes.iterator().next();
            if (!this.correlateComputation(primaryTrueNode, this.regionMerger.getNodeMerger(extraTrueNode = (Node)extraTrueNodes.iterator().next()), primary2extra)) {
                return false;
            }
        } else {
            @NonNull HashSet residualExtraTrueNodes = Sets.newHashSet(extraTrueNodes);
            for (Node primaryTrueNode : primaryTrueNodes) {
                boolean gotIt = false;
                for (Node extraTrueNode : residualExtraTrueNodes) {
                    HashMap<@NonNull Node, @NonNull NodeMerger> primary2extra2 = new HashMap<Node, NodeMerger>();
                    if (!this.correlateComputation(primaryTrueNode, this.regionMerger.getNodeMerger(extraTrueNode), primary2extra2)) continue;
                    gotIt = true;
                    primary2extra.putAll(primary2extra2);
                    residualExtraTrueNodes.remove(extraTrueNode);
                    break;
                }
                if (gotIt) continue;
                return false;
            }
        }
        for (Node primaryNode : primary2extra.keySet()) {
            NodeMerger equivalentNodeMerger = (NodeMerger)primary2extra.get(primaryNode);
            assert (equivalentNodeMerger != null);
            NodeMerger primaryNodeMerger = this.regionMerger.getNodeMerger(primaryNode);
            for (Node originalNode : equivalentNodeMerger.getOriginalNodes()) {
                this.extraNode2nodeMerger.put(originalNode, primaryNodeMerger);
            }
        }
        return true;
    }

    protected boolean correlateHeadNodes() {
        EList extraHeadNodes = this.extraRegion.getHeadNodes();
        if (extraHeadNodes.size() != 1) {
            if (this.debugFailures) {
                AbstractMerger.FAILURE.println("More than 1 extra head nodes: " + extraHeadNodes.size());
            }
            return false;
        }
        if (QVTscheduleUtil.hasPredicates((Region)this.extraRegion)) {
            return false;
        }
        Node extraHeadNode = (Node)extraHeadNodes.get(0);
        CompleteClass completeClass = extraHeadNode.getCompleteClass();
        List<@NonNull NodeMerger> nodeMergers = this.regionMerger.getNodeMergers(completeClass);
        if (nodeMergers == null || nodeMergers.size() == 0) {
            if (this.debugFailures) {
                AbstractMerger.FAILURE.println("No node mergers of type: " + completeClass);
            }
            return false;
        }
        NodeMerger headNodeMerger = this.extraNode2nodeMerger.get(extraHeadNode);
        if (headNodeMerger == null) {
            headNodeMerger = this.selectHeadNodeMerger(extraHeadNode, nodeMergers);
            if (headNodeMerger == null) {
                headNodeMerger = this.selectHeadNodeMerger(extraHeadNode, nodeMergers);
                if (this.debugFailures) {
                    AbstractMerger.FAILURE.println("No head node merger to match: " + extraHeadNode);
                }
                return false;
            }
            this.extraNode2nodeMerger.put(extraHeadNode, headNodeMerger);
        }
        if (nodeMergers.size() > 1) {
            for (NodeMerger nodeMerger : nodeMergers) {
                if (nodeMerger == headNodeMerger || nodeMerger.isLoaded()) continue;
                if (this.debugFailures) {
                    AbstractMerger.FAILURE.println("Multiple node mergers of type: " + completeClass);
                }
                return false;
            }
        }
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected boolean correlateNavigablePredicates() {
        HashSet<@NonNull Node> extraNodes = new HashSet<Node>(this.extraNode2nodeMerger.keySet());
        ArrayList<@NonNull Node> extraNodesWorkList = new ArrayList<Node>(extraNodes);
        int i = 0;
        while (i < extraNodesWorkList.size()) {
            @NonNull Node extraSourceNode = (Node)extraNodesWorkList.get(i);
            @Nullable NodeMerger sourceNodeMerger = this.extraNode2nodeMerger.get(extraSourceNode);
            if (!this.strategy.navigableNodesMatch(sourceNodeMerger, extraSourceNode)) {
                return false;
            }
            for (NavigableEdge uncastExtraEdge : extraSourceNode.getNavigableEdges()) {
                Node uncastExtraTargetNode = uncastExtraEdge.getEdgeTarget();
                @NonNull Iterable extraTargetNodes = QVTscheduleUtil.getCastTargets((Node)uncastExtraTargetNode, (boolean)true);
                if (sourceNodeMerger != null) {
                    EdgeMerger edgeMerger;
                    NavigableEdge uncastPrimaryEdge = sourceNodeMerger.getNavigableEdge(QVTscheduleUtil.getProperty((NavigableEdge)uncastExtraEdge));
                    EdgeMerger edgeMerger2 = edgeMerger = uncastPrimaryEdge != null ? this.regionMerger.getEdgeMerger((Edge)uncastPrimaryEdge) : null;
                    if (!this.strategy.navigableEdgesMatch(edgeMerger, uncastExtraEdge)) {
                        return false;
                    }
                    if (uncastPrimaryEdge != null) {
                        CompleteClass targetCompleteClass;
                        Node uncastPrimaryTargetNode = uncastPrimaryEdge.getEdgeTarget();
                        if (uncastExtraTargetNode.isNullLiteral() != uncastPrimaryTargetNode.isNullLiteral()) {
                            if (this.debugFailures) {
                                AbstractMerger.FAILURE.println("Inconsistent ExplicitNull: " + uncastExtraTargetNode);
                            }
                            return false;
                        }
                        HashMap<@NonNull CompleteClass, @NonNull NodeMerger> completeClass2targetNodeMergers = new HashMap<CompleteClass, NodeMerger>();
                        for (Node primaryTargetNode : QVTscheduleUtil.getCastTargets((Node)uncastPrimaryTargetNode, (boolean)true)) {
                            targetCompleteClass = primaryTargetNode.getCompleteClass();
                            NodeMerger oldNodeMerger = completeClass2targetNodeMergers.put(targetCompleteClass, this.regionMerger.getNodeMerger(primaryTargetNode));
                            if (oldNodeMerger == null) continue;
                            if (this.debugFailures) {
                                AbstractMerger.FAILURE.println("Inconsistent paths to: " + targetCompleteClass);
                            }
                            return false;
                        }
                        for (Node extraTargetNode : extraTargetNodes) {
                            targetCompleteClass = extraTargetNode.getCompleteClass();
                            NodeMerger targetNodeMerger = (NodeMerger)completeClass2targetNodeMergers.remove(targetCompleteClass);
                            if (targetNodeMerger == null) {
                                if (this.debugFailures) {
                                    AbstractMerger.FAILURE.println("Inconsistent types at: " + targetNodeMerger + ", " + extraTargetNode);
                                }
                                return false;
                            }
                            NodeMerger targetNodeMerger2 = this.extraNode2nodeMerger.get(extraTargetNode);
                            if (targetNodeMerger2 == null) {
                                this.extraNode2nodeMerger.put(extraTargetNode, targetNodeMerger);
                                continue;
                            }
                            if (targetNodeMerger == targetNodeMerger2) continue;
                            if (this.debugFailures) {
                                AbstractMerger.FAILURE.println("Inconsistent paths to: " + targetNodeMerger + ", " + targetNodeMerger2);
                            }
                            return false;
                        }
                    }
                }
                for (Node extraTargetNode : extraTargetNodes) {
                    if (!extraNodes.add(extraTargetNode)) continue;
                    extraNodesWorkList.add(extraTargetNode);
                }
            }
            ++i;
        }
        return true;
    }

    protected void correlateResidualComputations(@NonNull Iterable<@NonNull Node> extraNodes) {
        for (Node extraNode : extraNodes) {
            NodeMerger nodeMerger = this.extraNode2nodeMerger.get(extraNode);
            assert (nodeMerger != null);
            HashMap<@NonNull Node, @NonNull NodeMerger> extraNode2nodeMerger2 = new HashMap<Node, NodeMerger>();
            if (!this.correlateComputation(extraNode, nodeMerger, extraNode2nodeMerger2)) continue;
            for (Node extraNode2 : extraNode2nodeMerger2.keySet()) {
                NodeMerger nodeMerger2 = (NodeMerger)extraNode2nodeMerger2.get(extraNode2);
                assert (nodeMerger2 != null);
                this.extraNode2nodeMerger.put(extraNode2, nodeMerger2);
            }
        }
    }

    public @NonNull Map<@NonNull Node, @NonNull NodeMerger> getNode2NodeMerger() {
        return this.extraNode2nodeMerger;
    }

    public @NonNull RegionMerger getRegionMerger() {
        return this.regionMerger;
    }

    protected @Nullable NodeMerger selectHeadNodeMerger(@NonNull Node headNode, @NonNull List<@NonNull NodeMerger> nodeMergers) {
        if (nodeMergers.size() == 1) {
            NodeMerger nodeMerger = nodeMergers.get(0);
            return nodeMerger;
        }
        if (nodeMergers.size() == 0) {
            return null;
        }
        Iterable predicateEdges = headNode.getPredicateEdges();
        for (NodeMerger nodeMerger : nodeMergers) {
            boolean ok;
            boolean bl = ok = !nodeMerger.isIterator();
            if (ok) {
                for (NavigableEdge predicateEdge : predicateEdges) {
                    Property property = QVTscheduleUtil.getProperty((NavigableEdge)predicateEdge);
                    Node navigation = nodeMerger.getNavigableTarget(property);
                    if (navigation != null) continue;
                    ok = false;
                    break;
                }
            }
            if (!ok) continue;
            return nodeMerger;
        }
        return null;
    }

    static abstract class AbstractCorrelationStrategy
    implements CorrelationStrategy {
        protected final boolean debugFailures = AbstractMerger.FAILURE.isActive();

        AbstractCorrelationStrategy() {
        }

        @Override
        public boolean navigableEdgesMatch(@Nullable EdgeMerger edgeMerger, @NonNull NavigableEdge extraEdge) {
            return true;
        }

        @Override
        public boolean navigableNodesMatch(@Nullable NodeMerger nodeMerger, @NonNull Node extraNode) {
            if (nodeMerger == null) {
                if (extraNode.isPredicated()) {
                    if (this.debugFailures) {
                        AbstractMerger.FAILURE.println("Missing predicated match for : " + extraNode);
                    }
                    return false;
                }
                return true;
            }
            assert (extraNode.isNullLiteral() == nodeMerger.isNullLiteral());
            return true;
        }
    }

    private static interface CorrelationStrategy {
        public boolean navigableEdgesMatch(@Nullable EdgeMerger var1, @NonNull NavigableEdge var2);

        public boolean navigableNodesMatch(@Nullable NodeMerger var1, @NonNull Node var2);
    }
}

