/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.DatumCaches;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcore.Assignment;
import org.eclipse.qvtd.pivot.qvtcore.CorePattern;
import org.eclipse.qvtd.pivot.qvtcore.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcore.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcore.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class QVTcoreDatumCaches
extends DatumCaches {
    public QVTcoreDatumCaches(@NonNull ScheduleManager scheduleManager) {
        super(scheduleManager);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected @NonNull RuleRegion analyzeRule(@NonNull RuleAnalysis ruleAnalysis) {
        RuleRegion ruleRegion = (RuleRegion)ruleAnalysis.getRegion();
        Rule rule = ruleAnalysis.getRule();
        @NonNull List productions = QVTscheduleUtil.Internal.getProducedDatumsList((RuleRegion)ruleRegion);
        @NonNull List consumptions = QVTscheduleUtil.Internal.getConsumedDatumsList((RuleRegion)ruleRegion);
        for (EObject eObject : new TreeIterable((EObject)rule, true)) {
            TypedModel typedModel;
            if (eObject instanceof GuardPattern) {
                for (Variable inputVar : QVTcoreUtil.getOwnedVariables((CorePattern)((GuardPattern)eObject))) {
                    typedModel = this.getTypedModel((Element)inputVar);
                    consumptions.add(this.getClassDatum(typedModel, QVTcoreUtil.getClass((TypedElement)inputVar)));
                }
                continue;
            }
            if (eObject instanceof RealizedVariable) {
                RealizedVariable outputVar = (RealizedVariable)eObject;
                TypedModel typedModel2 = this.getTypedModel((Element)outputVar);
                productions.add(this.getClassDatum(typedModel2, QVTcoreUtil.getClass((TypedElement)outputVar)));
                continue;
            }
            if (eObject instanceof OperationCallExp) {
                OperationCallExp opCall = (OperationCallExp)eObject;
                OCLExpression ownedSource = QVTcoreUtil.getOwnedSource((CallExp)opCall);
                Type type = QVTcoreUtil.getType((TypedElement)ownedSource);
                CompleteClass context = this.completeModel.getCompleteClass(type);
                consumptions.addAll(this.getOperationPropertyDatums(opCall, context, new HashMap<CompleteClass, Set<Operation>>(), new HashMap<Variable, Set<CompleteClass>>()));
                continue;
            }
            if (eObject instanceof NavigationAssignment) {
                productions.addAll(this.getAssignedPropertyDatums((NavigationAssignment)eObject));
                continue;
            }
            if (!(eObject instanceof NavigationCallExp)) continue;
            NavigationCallExp navigationCallExp = (NavigationCallExp)eObject;
            OCLExpression source = QVTcoreUtil.getOwnedSource((CallExp)navigationCallExp);
            typedModel = this.getTypedModel((Element)source);
            Property property = QVTcoreUtil.getReferredProperty((NavigationCallExp)navigationCallExp);
            Class context = QVTcoreUtil.getClass((TypedElement)source);
            PropertyDatum propertyDatum = this.getPropertyDatum(typedModel, context, property);
            consumptions.add(propertyDatum);
        }
        return ruleRegion;
    }

    private @NonNull Set<@NonNull PropertyDatum> getAssignedPropertyDatums(@NonNull NavigationAssignment propAssign) {
        HashSet<@NonNull PropertyDatum> result = new HashSet<PropertyDatum>();
        Property targetProp = QVTcoreUtil.getTargetProperty((NavigationAssignment)propAssign);
        OCLExpression slotExpression = QVTcoreUtil.getSlotExpression((NavigationAssignment)propAssign);
        TypedModel typedModel = this.getTypedModel((Element)slotExpression);
        PropertyDatum targetDatum = this.getPropertyDatum(typedModel, QVTcoreUtil.getClass((TypedElement)slotExpression), targetProp);
        result.add(targetDatum);
        Property oppositeProp = targetProp.getOpposite();
        if (oppositeProp != null) {
            TypedModel oppositeTypedModel;
            OCLExpression value = QVTcoreUtil.getValue((Assignment)propAssign);
            DomainUsage valueUsage = this.getUsage((Element)value);
            if (valueUsage == null) {
                this.getUsage((Element)value);
                throw new IllegalStateException("No DomainUsage for " + value);
            }
            Type propertyType = targetProp.getType();
            if (propertyType != null && propertyType.getESObject() != EcorePackage.Literals.EOBJECT) {
                DomainUsage propertyUsage = this.getUsage((Element)propertyType);
                if (propertyUsage == null) {
                    this.getUsage((Element)propertyType);
                    throw new IllegalStateException("No DomainUsage for " + propertyType);
                }
                valueUsage = valueUsage != this.domainUsageAnalysis.getNoneUsage() && valueUsage != this.domainUsageAnalysis.getPrimitiveUsage() ? this.domainUsageAnalysis.intersection(propertyUsage, valueUsage) : propertyUsage;
            }
            if ((oppositeTypedModel = valueUsage.getTypedModel((Element)propAssign)) == null) {
                DomainUsage valueUsage2 = this.getUsage((Element)value);
                DomainUsage propertyUsage2 = propertyType != null ? this.getUsage((Element)propertyType) : null;
                oppositeTypedModel = valueUsage.getTypedModel((Element)propAssign);
                throw new IllegalStateException("No left/right DomainUsage commonality for \"" + propAssign + "\"");
            }
            PropertyDatum oppositeDatum = this.getPropertyDatum(oppositeTypedModel, this.getElementClass((TypedElement)targetProp), oppositeProp);
            targetDatum.setOpposite(oppositeDatum);
            result.add(oppositeDatum);
        }
        return result;
    }
}

