/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.PivotEvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironment;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEvaluationVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiLMEvaluationVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiModelManager;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTracingEvaluationVisitor;

public class QVTiPivotEvaluator {
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    protected final Transformation transformation;
    @NonNull
    protected final PivotEnvironmentFactory envFactory;
    @NonNull
    protected final PivotEnvironment env;
    @NonNull
    protected final QVTiModelManager modelManager;
    private boolean traceEvaluation = false;

    public QVTiPivotEvaluator(@NonNull MetaModelManager metaModelManager, @NonNull Transformation transformation) {
        this.metaModelManager = metaModelManager;
        this.transformation = transformation;
        this.envFactory = new PivotEnvironmentFactory(null, metaModelManager);
        this.env = this.envFactory.createEnvironment();
        this.modelManager = new QVTiModelManager(metaModelManager);
    }

    public void addModel(@NonNull TypedModel typedModel, @NonNull Resource resource) {
        this.modelManager.addModel(typedModel, resource);
    }

    public void createModel(@NonNull String name, @NonNull URI modelURI) {
        TypedModel typedModel = (TypedModel)DomainUtil.getNamedElement((Iterable)this.transformation.getModelParameter(), (String)name);
        if (typedModel == null) {
            throw new IllegalStateException("Unknown TypedModel '" + name + "'");
        }
        Resource resource = this.metaModelManager.getExternalResourceSet().createResource(modelURI);
        if (resource != null) {
            this.modelManager.addModel(typedModel, resource);
        }
    }

    public void dispose() {
        this.modelManager.dispose();
    }

    public Boolean execute() {
        PivotEvaluationEnvironment evalEnv = this.envFactory.createEvaluationEnvironment();
        QVTiEvaluationVisitor visitor = new QVTiLMEvaluationVisitor((Environment)this.env, (EvaluationEnvironment)evalEnv, this.modelManager);
        if (this.isEvaluationTracingEnabled()) {
            visitor = new QVTiTracingEvaluationVisitor(visitor);
        }
        return (Boolean)this.transformation.accept((Visitor)visitor);
    }

    @NonNull
    public final PivotEnvironment getEnvironment() {
        return this.env;
    }

    @NonNull
    public final PivotEnvironmentFactory getEnvironmentFactory() {
        return this.envFactory;
    }

    @NonNull
    public final MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    @NonNull
    public final QVTiModelManager getModelManager() {
        return this.modelManager;
    }

    @NonNull
    public final Transformation getTransformation() {
        return this.transformation;
    }

    public final boolean isEvaluationTracingEnabled() {
        return this.traceEvaluation;
    }

    public void loadModel(@NonNull String name, @NonNull URI modelURI) {
        TypedModel typedModel = (TypedModel)DomainUtil.getNamedElement((Iterable)this.transformation.getModelParameter(), (String)name);
        if (typedModel == null) {
            throw new IllegalStateException("Unknown TypedModel '" + name + "'");
        }
        Resource resource = this.metaModelManager.getExternalResourceSet().getResource(modelURI, true);
        if (resource != null) {
            this.modelManager.addModel(typedModel, resource);
        }
    }

    public void saveModels() {
        this.modelManager.saveModels();
    }

    public void saveModels(@NonNull URI traceURI) {
        this.saveModels();
        this.modelManager.saveMiddleModel(traceURI);
    }

    public void setEvaluationTracingEnabled(boolean b) {
        this.traceEvaluation = b;
    }
}

