/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.paged;

import java.util.Collection;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.qvt.declarative.editor.ui.operations.OperationHistoryListener;
import org.eclipse.qvt.declarative.editor.ui.paged.PagedEditor;

public class PagedOperationHistoryListener
extends OperationHistoryListener {
    protected final Runnable resetDirtyPageRunnable = new ResetDirtyPageRunnable();
    protected final Runnable resetDirtyRunnable = new ResetDirtyRunnable();
    protected final Runnable setDirtyPageRunnable = new SetDirtyPageRunnable();

    public PagedOperationHistoryListener(PagedEditor pagedEditor) {
        super(pagedEditor);
    }

    protected void resetDirty() {
        if (PagedEditor.traceEditorShowDirty.isActive()) {
            PagedEditor.traceEditorShowDirty.println("resetDirty " + (Object)((Object)this.pagedEditor));
        }
        this.pagedEditor.getDisplay().asyncExec(this.resetDirtyRunnable);
    }

    protected void resetDirtyPage() {
        if (PagedEditor.traceEditorShowDirty.isActive()) {
            PagedEditor.traceEditorShowDirty.println("resetDirtyPage " + (Object)((Object)this.pagedEditor));
        }
        this.pagedEditor.getDisplay().asyncExec(this.resetDirtyPageRunnable);
    }

    protected void setDirtyPage() {
        if (PagedEditor.traceEditorShowDirty.isActive()) {
            PagedEditor.traceEditorShowDirty.println("setDirtyPage " + (Object)((Object)this.pagedEditor));
        }
        this.pagedEditor.getDisplay().asyncExec(this.setDirtyPageRunnable);
    }

    protected void setDone(IUndoableOperation operation) {
        Collection affectedObjects;
        operation.removeContext(this.pagedEditor.getWorkspaceCommandStack().getDefaultUndoContext());
        operation.addContext((IUndoContext)this.undoContext);
        this.undoableOperationHelper.setAffectedContexts(operation);
        Command command = this.undoableOperationHelper.getCommand(operation);
        Collection collection = affectedObjects = command != null ? command.getAffectedObjects() : null;
        if (affectedObjects != null) {
            this.pagedEditor.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PagedOperationHistoryListener.this.pagedEditor.setSelectionToViewer(affectedObjects);
                }
            });
        }
    }

    private class ResetDirtyPageRunnable
    implements Runnable {
        private ResetDirtyPageRunnable() {
        }

        public void run() {
            PagedOperationHistoryListener.super.resetDirtyPage();
            PagedOperationHistoryListener.this.pagedEditor.firePropertyChange(257);
            PagedOperationHistoryListener.this.pagedEditor.showDirtyPage(false);
        }
    }

    private class ResetDirtyRunnable
    implements Runnable {
        private ResetDirtyRunnable() {
        }

        public void run() {
            PagedOperationHistoryListener.super.resetDirty();
            PagedOperationHistoryListener.this.pagedEditor.firePropertyChange(257);
            PagedOperationHistoryListener.this.pagedEditor.showDirtyPage(false);
        }
    }

    private class SetDirtyPageRunnable
    implements Runnable {
        private SetDirtyPageRunnable() {
        }

        public void run() {
            PagedOperationHistoryListener.super.setDirtyPage();
            PagedOperationHistoryListener.this.pagedEditor.firePropertyChange(257);
            PagedOperationHistoryListener.this.pagedEditor.showDirtyPage(true);
        }
    }
}

