/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import lpg.runtime.IToken;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.services.IAnnotationTypeInfo;
import org.eclipse.imp.services.ILanguageSyntaxProperties;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ocl.examples.modelregistry.eclipse.EclipseFileHandle;
import org.eclipse.ocl.examples.modelregistry.eclipse.EclipseProjectHandle;
import org.eclipse.ocl.examples.modelregistry.environment.FileHandle;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.qvt.declarative.ecore.utils.TracingOption;
import org.eclipse.qvt.declarative.editor.ui.ICreationFactory;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.builder.MarkerProblemHandler;
import org.eclipse.qvt.declarative.editor.ui.builder.ProblemLimit;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonAnnotationTypeInfo;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonKeyword;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonParseHelper;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonParseResult;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonProblemHandler;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonKeyword;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonParseController;
import org.eclipse.qvt.declarative.parser.environment.ICSTFileEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonParseController
implements ICommonParseController {
    public static TracingOption parserProgress = new TracingOption(QVTEditorPlugin.PLUGIN_ID, "parser/progress");
    private static int counter = 0;
    protected final ICreationFactory creationFactory;
    protected final Language fLanguage;
    protected ISourceProject fProject;
    protected IPath fFilePath;
    protected IMessageHandler handler;
    private ICSTFileEnvironment fileEnvironment;
    protected CommonParseResult fCurrentAst;
    private final CommonAnnotationTypeInfo fSimpleAnnotationTypeInfo = new CommonAnnotationTypeInfo();
    private final String id;
    private CommonParseHelper parseHelper = null;

    public CommonParseController(ICreationFactory creationFactory) {
        this.creationFactory = creationFactory;
        this.fLanguage = creationFactory.getLanguage();
        this.id = String.valueOf(this.getClass().getSimpleName()) + "-" + ++counter;
        if (parserProgress.isActive()) {
            parserProgress.println(String.valueOf(this.id) + " created");
        }
        this.getAnnotationTypeInfo().addProblemMarkerType(creationFactory.getErrorMarkerId());
    }

    protected ICSTFileEnvironment createEnvironment(FileHandle fileHandle) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI astURI = fileHandle.getURI().appendFileExtension(this.creationFactory.getXMLExtension());
        return this.creationFactory.createFileEnvironment(fileHandle, (ResourceSet)resourceSet, astURI);
    }

    protected ICommonKeyword createKeyword(String text) {
        return new CommonKeyword(text);
    }

    protected CommonParseHelper createParseHelper(AbstractParser parser) {
        return new CommonParseHelper(parser);
    }

    protected CommonParseResult createParsedResult(ICSTFileEnvironment fileEnvironment) {
        return new CommonParseResult(this, fileEnvironment);
    }

    protected ProblemHandler createProblemHandler(ICSTFileEnvironment environment) {
        if (this.handler instanceof ProblemHandler) {
            ((ProblemHandler)this.handler).setParser(environment.getParser());
            if (this.handler instanceof MarkerProblemHandler) {
                ((MarkerProblemHandler)this.handler).setProblemLimit(new ProblemLimit(50, 50, 50));
            }
            return (ProblemHandler)this.handler;
        }
        CommonProblemHandler commonProblemHandler = new CommonProblemHandler(environment.getParser(), this.handler);
        commonProblemHandler.setProblemLimit(new ProblemLimit(50, 50, 50));
        return commonProblemHandler;
    }

    public IAnnotationTypeInfo getAnnotationTypeInfo() {
        return this.fSimpleAnnotationTypeInfo;
    }

    @Override
    public ICreationFactory getCreationFactory() {
        return this.creationFactory;
    }

    public CommonParseResult getCurrentAst() {
        return this.fCurrentAst;
    }

    @Override
    public CommonParseResult getCurrentResult() {
        return this.fCurrentAst;
    }

    protected FileHandle getFileHandle() {
        IProject rawProject = this.fProject.getRawProject();
        EclipseProjectHandle projectHandle = new EclipseProjectHandle(rawProject);
        EclipseFileHandle fileHandle = projectHandle.getFileHandle(this.fFilePath.toString());
        return fileHandle;
    }

    public IMessageHandler getHandler() {
        return this.handler;
    }

    public List<ICommonKeyword> getKeywords() {
        return this.parseHelper != null ? this.parseHelper.getKeywords() : null;
    }

    @Override
    public ILabelProvider getLabelProvider() {
        return ServiceFactory.getInstance().getLabelProvider(this.fLanguage);
    }

    public Language getLanguage() {
        return this.fLanguage;
    }

    @Deprecated
    public final ISourcePositionLocator getNodeLocator() {
        return this.getSourcePositionLocator();
    }

    public IPath getPath() {
        return this.fFilePath;
    }

    public ISourceProject getProject() {
        return this.fProject;
    }

    @Deprecated
    public ISourcePositionLocator getSourcePositionLocator() {
        if (this.fCurrentAst == null) {
            return null;
        }
        return this.fCurrentAst.getSourcePositionLocator();
    }

    public ILanguageSyntaxProperties getSyntaxProperties() {
        return null;
    }

    @Deprecated
    public Iterator<IToken> getTokenIterator(IRegion region) {
        if (this.fCurrentAst != null) {
            return this.fCurrentAst.getTokenIterator(region);
        }
        return new CommonParseResult.NullTokenIterator();
    }

    public void initialize(IPath filePath, ISourceProject project, IMessageHandler handler) {
        this.fProject = project;
        this.fFilePath = filePath;
        this.handler = handler;
        if (parserProgress.isActive()) {
            parserProgress.println(String.valueOf(this.id) + " initialized for " + this.fFilePath.toString());
        }
    }

    public boolean isCompleteable(int kind) {
        switch (this.getTokenKind(kind)) {
            case IDENTIFIER: 
            case INTEGER: 
            case REAL: 
            case STRING: 
            case KEYWORD: {
                return true;
            }
        }
        return false;
    }

    public boolean isIdentifier(int kind) {
        return this.getTokenKind(kind) == ICommonParseController.TokenKind.IDENTIFIER;
    }

    public boolean isKeyword(int kind) {
        return this.parseHelper != null ? this.parseHelper.isKeyword(kind) : false;
    }

    @Override
    public CommonParseResult parse(String contents, IProgressMonitor progressMonitor) {
        this.fCurrentAst = this.parseWithoutCaching(contents, progressMonitor);
        return this.fCurrentAst;
    }

    @Override
    public CommonParseResult parseWithoutCaching(String contents, IProgressMonitor progressMonitor) {
        if (parserProgress.isActive()) {
            parserProgress.println(String.valueOf(this.id) + " Parse " + this.fFilePath.toString() + " " + this.fLanguage + " handler = " + this.handler.getClass().getName());
        }
        if (progressMonitor.isCanceled()) {
            return this.fCurrentAst;
        }
        if (this.fileEnvironment == null) {
            this.fileEnvironment = this.createEnvironment(this.getFileHandle());
        }
        this.fileEnvironment.setProblemHandler(this.createProblemHandler(this.fileEnvironment));
        CommonParseResult newResult = null;
        try {
            CommonParseResult workingResult = this.createParsedResult(this.fileEnvironment);
            workingResult.parse(new StringReader(contents), progressMonitor);
            newResult = workingResult;
            if (this.parseHelper == null) {
                this.parseHelper = this.createParseHelper(newResult.getParser());
            }
        }
        catch (IOException e) {
            ErrorHandler.reportError((String)("Failed to parse language " + this.getLanguage().getName() + " and input " + this.getPath() + ":"), (Throwable)e);
        }
        catch (CoreException e) {
            ErrorHandler.reportError((String)("Failed to parse language " + this.getLanguage().getName() + " and input " + this.getPath() + ":"), (Throwable)e);
        }
        return newResult;
    }
}

