/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import java.util.List;
import org.eclipse.imp.editor.AnnotationHoverBase;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.services.IDocumentationProvider;
import org.eclipse.imp.services.IHoverHelper;
import org.eclipse.imp.services.IReferenceResolver;
import org.eclipse.imp.services.base.HoverHelperBase;
import org.eclipse.imp.utils.HTMLPrinter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.qvt.declarative.ecore.utils.TracingOption;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonParseController;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonParseResult;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonPlugin;

public abstract class CommonHoverHelper
extends HoverHelperBase
implements IHoverHelper {
    public static TracingOption hoverDebug = new TracingOption(QVTEditorPlugin.PLUGIN_ID, "hover/debug");
    IReferenceResolver fResolver = null;

    public String getHoverHelpAt(IParseController parseController, ISourceViewer srcViewer, int offset) {
        CommonParseController commonParseController = (CommonParseController)parseController;
        try {
            String msg;
            List annotations = AnnotationHoverBase.getSourceAnnotationsForLine((ISourceViewer)srcViewer, (int)srcViewer.getDocument().getLineOfOffset(offset));
            if (annotations != null && annotations.size() > 0 && (msg = AnnotationHoverBase.formatAnnotationList((List)annotations)) != null) {
                return msg;
            }
        }
        catch (BadLocationException badLocationException) {
            return "??? (BadLocationException for annotation)";
        }
        CommonParseResult parseResult = commonParseController.getCurrentResult();
        if (parseResult == null) {
            return null;
        }
        CSTNode cst = parseResult.getCST();
        if (cst == null) {
            return null;
        }
        Object sourceNode = null;
        Object targetNode = null;
        Object helpNode = null;
        String msg = null;
        ISourcePositionLocator nodeLocator = parseResult.getSourcePositionLocator();
        sourceNode = nodeLocator.findNode((Object)cst, offset);
        if (sourceNode == null) {
            return null;
        }
        if (this.fResolver == null && this.fLanguage != null) {
            try {
                this.fResolver = ServiceFactory.getInstance().getReferenceResolver(this.fLanguage);
            }
            catch (Exception exception) {
                this.getPlugin().writeErrorMsg("Exception getting Reference Resolver service from service factory");
                this.fResolver = null;
            }
        }
        if (this.fResolver != null) {
            targetNode = this.fResolver.getLinkTarget(sourceNode, (IParseController)commonParseController);
        }
        if (hoverDebug.isActive()) {
            hoverDebug.println("Hover at " + offset + " on" + " source: " + sourceNode.getClass().getSimpleName() + " target: " + (targetNode != null ? targetNode.getClass().getSimpleName() : "null"));
        }
        helpNode = targetNode != null ? targetNode : sourceNode;
        IDocumentationProvider docProvider = null;
        if (this.fLanguage != null) {
            try {
                docProvider = ServiceFactory.getInstance().getDocumentationProvider(this.fLanguage);
            }
            catch (Exception exception) {
                this.getPlugin().writeErrorMsg("Exception getting Documentation Provider Service from service factory");
                this.fResolver = null;
            }
        }
        if (docProvider != null && (msg = docProvider.getDocumentation(helpNode, (IParseController)commonParseController)) != null) {
            return HTMLPrinter.convertToHTMLContent((String)msg);
        }
        if (helpNode instanceof CSTNode) {
            CSTNode def = (CSTNode)helpNode;
            msg = parseResult.getTextRange(def.getStartOffset(), def.getEndOffset() - def.getStartOffset() + 1);
            int maxMsgLen = 80;
            if (msg == null || msg.length() == 0) {
                return "No help available";
            }
            if (msg.length() <= maxMsgLen) {
                return msg;
            }
            return msg.subSequence(0, maxMsgLen) + "...";
        }
        return "No help available";
    }

    protected abstract ICommonPlugin getPlugin();
}

