/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.common;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.qvt.declarative.ecore.utils.EcoreUtils;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.utils.DebugString;
import org.eclipse.qvt.declarative.editor.ui.utils.TracingAdapter;

public abstract class ResourceAdapter
extends TracingAdapter {
    public static ResourceAdapter getAdapter(Resource resource, boolean isLocked) {
        if (resource == null) {
            return null;
        }
        ResourceAdapter resourceAdapter = (ResourceAdapter)EcoreUtils.getAdapter((Notifier)resource, ResourceAdapter.class);
        if (resourceAdapter == null) {
            resourceAdapter = new ResourceAdapterImpl(resource, isLocked);
        } else if (resourceAdapter.isLocked() && !isLocked) {
            resourceAdapter.setLocked(isLocked);
        }
        return resourceAdapter;
    }

    public static ResourceAdapter getAdapter(Resource resource) {
        return ResourceAdapter.getAdapter(resource, true);
    }

    public static boolean isLocked(Resource resource) {
        ResourceAdapter adapter = ResourceAdapter.getAdapter(resource);
        return adapter != null ? adapter.isLocked() : false;
    }

    public static boolean isReadOnly(Resource resource) {
        ResourceAdapter adapter = ResourceAdapter.getAdapter(resource);
        return adapter != null ? adapter.isReadOnly() : false;
    }

    public static boolean isSaveable(Resource resource) {
        ResourceAdapter adapter = ResourceAdapter.getAdapter(resource);
        return adapter != null ? adapter.isSaveable() : false;
    }

    public abstract boolean computeIsReadOnly();

    public void dispose() {
    }

    public abstract Resource getResource();

    public Resource getUnderlyingResource() {
        return this.getResource();
    }

    public boolean isAdapterForType(Object type) {
        return type == ResourceAdapter.class;
    }

    public abstract boolean isLocked();

    public abstract boolean isReadOnly();

    public abstract boolean isSaveable();

    public abstract void setLocked(boolean var1);

    public abstract void setReadOnly(boolean var1);

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "[" + DebugString.toDebug(this.getResource()) + "]" + (this.isReadOnly() ? " read-only" : " read-write") + (this.isLocked() ? " locked" : " unlocked");
    }

    public static class ResourceAdapterImpl
    extends ResourceAdapter
    implements IResourceChangeListener {
        private final Resource resource;
        private URI uri;
        private String fileName;
        private boolean isReadOnly;
        private boolean isLocked;

        protected ResourceAdapterImpl(Resource resource, boolean isLocked) {
            this.resource = resource;
            resource.eAdapters().add((Object)this);
            this.setURI(resource.getURI());
            this.isLocked = this.isReadOnly || isLocked;
        }

        public boolean computeIsReadOnly() {
            if (this.uri == null) {
                return false;
            }
            try {
                URL url = new URL(this.uri.toString());
                URL resolvedURL = FileLocator.resolve((URL)url);
                String protocol = resolvedURL.getProtocol();
                if ("file".equals(protocol)) {
                    this.fileName = resolvedURL.getFile();
                    File file = new File(this.fileName);
                    if (file.canWrite()) {
                        return false;
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException e) {
                QVTEditorPlugin.logError("Failed to access " + this.uri.toString(), e);
            }
            return true;
        }

        public void dispose() {
        }

        public Resource getResource() {
            return this.resource;
        }

        public URI getURI() {
            return this.uri;
        }

        protected void handleNotification(Notification msg) {
            super.notifyChanged(msg);
            if (EcoreUtils.getFeatureID((Notification)msg, (Object)this.resource, Resource.class) == 6) {
                Object e = msg.getNewValue();
                QVTEditorPlugin.logError("Error in '" + this.resource.getURI() + "'", e instanceof Throwable ? (Throwable)e : null);
            }
        }

        public boolean isLocked() {
            return this.isLocked;
        }

        public boolean isReadOnly() {
            return this.isReadOnly;
        }

        public boolean isSaveable() {
            return true;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta resourceDelta = event.getDelta();
            if (resourceDelta != null) {
                this.resourceChanged(resourceDelta);
            }
        }

        public void resourceChanged(IResourceDelta resourceDelta) {
            IResourceDelta[] iResourceDeltaArray = resourceDelta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta childDelta = iResourceDeltaArray[n2];
                this.resourceChanged(childDelta);
                ++n2;
            }
        }

        public void setLocked(boolean setLocked) {
            if (setLocked) {
                if (this.resource.isModified()) {
                    QVTEditorPlugin.showError("Cannot lock modified resource: " + DebugString.toDebug(this.resource), null);
                    return;
                }
            } else if (this.computeIsReadOnly()) {
                QVTEditorPlugin.showError("Cannot unlock read-only resource: " + DebugString.toDebug(this.resource), null);
                return;
            }
            boolean wasLocked = this.isLocked;
            boolean bl = this.isLocked = setLocked || this.isReadOnly;
            if (wasLocked != this.isLocked) {
                this.resource.setModified(this.resource.isModified());
            }
        }

        public void setReadOnly(boolean setReadOnly) {
            if (setReadOnly) {
                if (this.resource.isModified()) {
                    QVTEditorPlugin.showError("Cannot set modified resource read-only: " + DebugString.toDebug(this.resource), null);
                    return;
                }
            } else if (this.computeIsReadOnly()) {
                QVTEditorPlugin.showError("Cannot set read-only resource read-write: " + DebugString.toDebug(this.resource), null);
                return;
            }
            boolean wasReadOnly = this.isReadOnly;
            this.isReadOnly = setReadOnly;
            boolean bl = this.isLocked = this.isLocked || this.isReadOnly;
            if (wasReadOnly != this.isReadOnly) {
                this.resource.setModified(this.resource.isModified());
            }
        }

        public void setURI(URI uri) {
            this.uri = uri;
            this.fileName = null;
            this.isReadOnly = this.computeIsReadOnly();
            this.setLocked(this.isLocked || this.isReadOnly);
        }
    }
}

