/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.commands;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.qvt.declarative.editor.ui.ICreationFactory;
import org.eclipse.qvt.declarative.editor.ui.IMasterPageManager;
import org.eclipse.qvt.declarative.editor.ui.IPageManager;
import org.eclipse.qvt.declarative.editor.ui.IUndoContextAffecter;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.commands.PageChangeDialog;
import org.eclipse.qvt.declarative.editor.ui.paged.PagedEditor;
import org.eclipse.qvt.declarative.editor.ui.utils.EcoreUpdater;
import org.eclipse.qvt.declarative.editor.ui.utils.MissingElementException;
import org.eclipse.qvt.declarative.parser.utils.ProblemCounter;

public class PageChangeCommand
extends AbstractCommand
implements AbstractCommand.NonDirtying,
IUndoContextAffecter {
    protected final PagedEditor pagedEditor;
    private final IPageManager oldPageManager;
    private final IPageManager newPageManager;
    protected final long resourceSetTimeStamp;
    protected Map<XMLResource, XMLResource> updates = null;
    protected Map<XMLResource, XMLResource> restores = null;
    private boolean suppressDeactivation = false;

    public PageChangeCommand(PagedEditor pagedEditor, IPageManager newPageManager) {
        this.pagedEditor = pagedEditor;
        this.oldPageManager = pagedEditor.getActivePageManager();
        this.newPageManager = newPageManager;
        this.resourceSetTimeStamp = pagedEditor.getNextResourceSetTimeStamp();
        assert (newPageManager != this.oldPageManager);
        assert (newPageManager != null);
        assert (this.oldPageManager != null);
        this.setLabel("Page Change " + this.resourceSetTimeStamp);
    }

    public boolean canUndo() {
        return this.oldPageManager.hasResourceSetTimeStamp(this.resourceSetTimeStamp);
    }

    public void dispose() {
        super.dispose();
        this.restores = null;
    }

    public void execute() {
        this.redo();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean prepare() {
        IMasterPageManager oldIndirectPageManager = this.oldPageManager.getAdapter(IMasterPageManager.class);
        if (oldIndirectPageManager == null) return true;
        boolean needsDeactivation = oldIndirectPageManager.needsDeactivation();
        boolean dirtyPage = this.pagedEditor.isDirtyPage();
        if (!needsDeactivation) {
            if (!dirtyPage) return true;
        }
        boolean deactivate = false;
        this.updates = new HashMap<XMLResource, XMLResource>();
        ProblemCounter problems = oldIndirectPageManager.cannotDeactivate(this.updates, this.pagedEditor.getProgressMonitor());
        if (problems.getRelevantProblemCount(ProblemHandler.Severity.WARNING) > 0 || dirtyPage) {
            boolean canRevert = this.resourceSetTimeStamp > 0L && this.newPageManager.hasResourceSetTimeStamp(this.resourceSetTimeStamp - 1L);
            boolean canUpdate = problems.getRelevantProblemCount(ProblemHandler.Severity.ERROR) <= 0;
            String reasonNotToDeactivate = "Text has " + problems.getSummary();
            PageChangeDialog dialog = new PageChangeDialog(this.pagedEditor.getShell(), this.newPageManager.getTitle(), this.oldPageManager.getTitle(), this.pagedEditor.getTitle(), reasonNotToDeactivate, canUpdate, canRevert);
            dialog.open();
            if (dialog.isUpdate()) {
                return true;
            }
            if (!dialog.isRevert()) return false;
            this.suppressDeactivation = true;
        } else {
            deactivate = needsDeactivation;
        }
        if (deactivate) return true;
        this.updates = null;
        return true;
    }

    public void redo() {
        if (this.updates != null) {
            XMLResource source;
            if (this.restores != null) {
                this.restores.clear();
            } else {
                this.restores = new HashMap<XMLResource, XMLResource>();
            }
            ICreationFactory creationFactory = this.pagedEditor.getCreationFactory();
            for (XMLResource target : this.updates.keySet()) {
                source = this.updates.get(target);
                creationFactory.assignXmiIds(source);
                creationFactory.assignXmiIds(target);
            }
            for (XMLResource target : this.updates.keySet()) {
                try {
                    this.restores.put(target, EcoreUpdater.copy(target));
                    source = this.updates.get(target);
                    EcoreUpdater.update(target, source);
                }
                catch (MissingElementException e) {
                    QVTEditorPlugin.showError("Failed to update '" + target.getURI() + "'", e);
                }
            }
        }
        this.pagedEditor.deactivate(this.suppressDeactivation ? null : this.oldPageManager, this.resourceSetTimeStamp);
        this.pagedEditor.setActivePageManager(this.newPageManager, this.resourceSetTimeStamp);
    }

    public void setAffectedContext(IUndoableOperation operation) {
        IUndoContext context = this.oldPageManager.getUndoContext();
        if (context != null) {
            operation.addContext(context);
        }
        if ((context = this.newPageManager.getUndoContext()) != null) {
            operation.addContext(context);
        }
    }

    public void undo() {
        if (this.restores != null) {
            for (XMLResource target : this.restores.keySet()) {
                try {
                    XMLResource source = this.restores.get(target);
                    EcoreUpdater.update(target, source);
                }
                catch (MissingElementException e) {
                    QVTEditorPlugin.showError("Failed to update '" + target.getURI() + "'", e);
                }
            }
        }
        this.pagedEditor.setActivePageManager(this.oldPageManager, this.resourceSetTimeStamp);
    }
}

