/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.qvtcore.environment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.ocl.LookupException;
import org.eclipse.qvt.declarative.ecore.QVTBase.TypedModel;
import org.eclipse.qvt.declarative.ecore.QVTCore.CoreDomain;
import org.eclipse.qvt.declarative.ecore.QVTCore.Mapping;
import org.eclipse.qvt.declarative.ecore.QVTCore.QVTCoreFactory;
import org.eclipse.qvt.declarative.parser.qvt.cst.IdentifierCS;
import org.eclipse.qvt.declarative.parser.qvtcore.cst.DomainCS;
import org.eclipse.qvt.declarative.parser.qvtcore.cst.MappingCS;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.IQVTcEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.IQVTcNodeEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.QVTcAreaEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.QVTcComposedMappingEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.QVTcDomainEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.QVTcEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.QVTcGuardPatternEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.QVTcMiddleEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.QVTcPatternEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QVTcMappingEnvironment<P extends IQVTcNodeEnvironment>
extends QVTcEnvironment<IQVTcNodeEnvironment, P, Mapping, MappingCS>
implements IQVTcEnvironment {
    private Map<DomainCS, QVTcDomainEnvironment> domainCSEnvironments = new HashMap<DomainCS, QVTcDomainEnvironment>();
    private Map<String, QVTcDomainEnvironment> domainEnvironments = new HashMap<String, QVTcDomainEnvironment>();
    private Map<MappingCS, QVTcComposedMappingEnvironment> childCSEnvironments = new HashMap<MappingCS, QVTcComposedMappingEnvironment>();
    private List<EPackage> middlePackages = null;
    private Set<QVTcMappingEnvironment<?>> mappingEnvironmentClosure = null;
    private QVTcMiddleEnvironment middleEnvironment = null;

    protected QVTcMappingEnvironment(P env, MappingCS mappingCS) {
        super(env, QVTCoreFactory.eINSTANCE.createMapping(), mappingCS);
        this.setNameFromIdentifier((ENamedElement)this.ast, mappingCS.getIdentifier());
    }

    protected Set<QVTcMappingEnvironment<?>> computeMappingEnvironmentsClosure() {
        return new HashSet();
    }

    public QVTcComposedMappingEnvironment createComposedMappingEnvironment(MappingCS mappingCS) {
        assert (this.mappingEnvironmentClosure == null) : "Must not createComposedMappingEnvironment after computeMappingEnvironmentsClosure";
        QVTcComposedMappingEnvironment environment = new QVTcComposedMappingEnvironment(this, mappingCS);
        this.childCSEnvironments.put(mappingCS, environment);
        return environment;
    }

    public QVTcDomainEnvironment createDomainEnvironment(DomainCS domainCS) {
        assert (this.mappingEnvironmentClosure == null) : "Must not createDomainEnvironment after computeMappingEnvironmentsClosure";
        QVTcDomainEnvironment environment = new QVTcDomainEnvironment(this, domainCS);
        this.domainCSEnvironments.put(domainCS, environment);
        IdentifierCS identifierCS = domainCS.getIdentifier();
        if (identifierCS != null) {
            String name = identifierCS.getValue();
            this.domainEnvironments.put(name, environment);
            String middleModelName = this.middleEnvironment.getModelName();
            if (name.equals(middleModelName)) {
                this.analyzerWarning("Domain name '" + name + "' should be distinct from middle domain name '" + middleModelName + "'", "DomainCS", identifierCS);
            }
        }
        return environment;
    }

    public QVTcMiddleEnvironment createMiddleEnvironment(DomainCS domainCS) {
        assert (this.mappingEnvironmentClosure == null) : "Must not createMiddleEnvironment after computeMappingEnvironmentsClosure";
        this.middleEnvironment = new QVTcMiddleEnvironment(this, domainCS);
        return this.middleEnvironment;
    }

    public abstract QVTcMappingEnvironment<?> getContextEnvironment();

    public QVTcDomainEnvironment getDomainEnvironment(String domainName) {
        return this.domainEnvironments.get(domainName);
    }

    public Collection<QVTcDomainEnvironment> getDomainEnvironments() {
        return this.domainCSEnvironments.values();
    }

    public QVTcDomainEnvironment getEnvironment(DomainCS domainCS) {
        return this.domainCSEnvironments.get(domainCS);
    }

    public QVTcComposedMappingEnvironment getEnvironment(MappingCS mappingCS) {
        return this.childCSEnvironments.get(mappingCS);
    }

    public Mapping getMapping() {
        return (Mapping)this.ast;
    }

    public QVTcMappingEnvironment<?> getMappingEnvironment() {
        return this;
    }

    public Set<QVTcMappingEnvironment<?>> getMappingEnvironmentClosure() {
        if (this.mappingEnvironmentClosure == null) {
            this.mappingEnvironmentClosure = this.computeMappingEnvironmentsClosure();
        }
        return this.mappingEnvironmentClosure;
    }

    public QVTcMiddleEnvironment getMiddleEnvironment() {
        return this.middleEnvironment;
    }

    public QVTcPatternEnvironment<?> getPatternEnvironment(QVTcPatternEnvironment<?> patternEnv) {
        QVTcAreaEnvironment areaEnv = (QVTcAreaEnvironment)patternEnv.getParentEnvironment();
        QVTcAreaEnvironment domainEnv = null;
        if (areaEnv instanceof QVTcDomainEnvironment) {
            CoreDomain domain = (CoreDomain)((QVTcDomainEnvironment)areaEnv).getASTNode();
            if (domain == null) {
                return null;
            }
            domainEnv = this.getDomainEnvironment(domain.getName());
        } else {
            domainEnv = this.getMiddleEnvironment();
        }
        if (domainEnv == null) {
            return null;
        }
        return patternEnv instanceof QVTcGuardPatternEnvironment ? domainEnv.getGuardPatternEnvironment() : domainEnv.getBottomPatternEnvironment();
    }

    public EClassifier tryLookupClassifier(List<String> names) throws LookupException {
        if (names == null) {
            return null;
        }
        int namesSize = names.size();
        if (namesSize > 0) {
            EClassifier eClassifier;
            if (this.middlePackages == null) {
                this.middlePackages = new ArrayList<EPackage>();
                TypedModel middleTypedModel = this.getMiddleEnvironment().getTypedModel();
                this.middlePackages.addAll((Collection<EPackage>)middleTypedModel.getUsedPackage());
            }
            if ((eClassifier = this.tryLookupClassifier(this.middlePackages, names)) != null) {
                return eClassifier;
            }
        }
        return super.tryLookupClassifier(names);
    }
}

