/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import lpg.runtime.IToken;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.AbstractProblemHandler;
import org.eclipse.ocl.lpg.DerivedPrsStream;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.builder.MarkerProblemHandler;
import org.eclipse.qvt.declarative.editor.ui.builder.ProblemLimit;

public class CommonProblemHandler
extends AbstractProblemHandler {
    protected final IMessageHandler handler;
    private ProblemLimit problemLimit = null;

    public CommonProblemHandler(AbstractParser parser, IMessageHandler handler) {
        super(parser);
        this.handler = handler;
        handler.clearMessages();
    }

    public IToken getNearestTokenAtCharacter(int offset) {
        AbstractParser parser = this.getParser();
        DerivedPrsStream parseStream = parser.getIPrsStream();
        int maxIndex = parseStream.getSize();
        if (maxIndex <= 0) {
            return null;
        }
        int tokenIndex = parseStream.getTokenIndexAtCharacter(offset);
        if (tokenIndex >= 0) {
            return parseStream.getTokenAt(tokenIndex >= maxIndex ? maxIndex - 1 : tokenIndex);
        }
        IToken prevToken = parseStream.getTokenAt((tokenIndex = -tokenIndex + 1) >= maxIndex ? maxIndex - 1 : tokenIndex);
        IToken nextToken = parseStream.getTokenAt(tokenIndex + 1 >= maxIndex ? maxIndex - 1 : tokenIndex + 1);
        int prevEndOffset = prevToken.getEndOffset();
        int nextStartOffset = nextToken.getStartOffset();
        int postEnd = offset - prevEndOffset;
        int preStart = nextStartOffset - offset;
        if (postEnd >= 0) {
            if (preStart >= 0) {
                return preStart < postEnd ? prevToken : nextToken;
            }
            return prevToken;
        }
        if (preStart >= 0) {
            return nextToken;
        }
        return nextToken;
    }

    public void handleProblem(ProblemHandler.Severity problemSeverity, ProblemHandler.Phase processingPhase, String problemMessage, String processingContext, int startOffset, int endOffset) {
        try {
            Integer severity;
            if (startOffset < 0) {
                startOffset = 0;
            }
            if (endOffset < 0) {
                endOffset = 0;
            }
            IToken startToken = this.getNearestTokenAtCharacter(startOffset);
            IToken endToken = this.getNearestTokenAtCharacter(endOffset);
            int startLine = startToken != null ? startToken.getLine() : 0;
            int startCol = startToken != null ? startToken.getColumn() : 0;
            int endLine = endToken != null ? endToken.getLine() : 0;
            int endCol = endToken != null ? endToken.getColumn() : 0;
            String adjustedMessage = problemMessage;
            if (this.problemLimit != null && (adjustedMessage = this.problemLimit.check((severity = MarkerProblemHandler.severityMap.get(problemSeverity)) != null ? severity : 2, adjustedMessage)) == null) {
                return;
            }
            String prefixedMessage = problemSeverity != null ? String.valueOf(problemSeverity.name()) + ": " + problemMessage : problemMessage;
            this.handler.handleSimpleMessage(prefixedMessage, startOffset, endOffset, startCol, endCol, startLine, endLine);
            if (adjustedMessage != problemMessage) {
                throw new ProblemLimit.LimitExceededException(adjustedMessage);
            }
        }
        catch (Throwable e) {
            QVTEditorPlugin.logError("Failed to handleProblem", e);
        }
    }

    public void setProblemLimit(ProblemLimit problemLimit) {
        this.problemLimit = problemLimit;
    }
}

