/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.QVTBase.operations;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.qvt.declarative.ecore.QVTBase.Pattern;
import org.eclipse.qvt.declarative.ecore.QVTBase.Predicate;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.AbstractQVTBaseOperations;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.QVTBaseMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicateOperations
extends AbstractQVTBaseOperations {
    public static PredicateOperations INSTANCE = new PredicateOperations();

    public boolean checkConditionExpressionIsBoolean(Predicate predicate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        OCLExpression expression = predicate.getConditionExpression();
        if (expression == null) {
            return true;
        }
        EClassifier type = expression.getEType();
        if (type == null) {
            return true;
        }
        if (type != PredicateOperations.getBooleanType()) {
            Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)predicate, context)};
            this.appendError(diagnostics, predicate, QVTBaseMessages._UI_Predicate_ConditionExpressionIsNotBoolean, messageSubstitutions);
            return false;
        }
        return true;
    }

    public boolean checkExternalVariablesAreBoundByPattern(Predicate predicate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Pattern pattern = predicate.getPattern();
        if (pattern == null) {
            return true;
        }
        boolean allOk = true;
        EList<Variable> boundVariables = pattern.getBindsTo();
        TreeIterator i = predicate.eAllContents();
        while (i.hasNext()) {
            Object[] messageSubstitutions;
            EObject content = (EObject)i.next();
            Variable variable = null;
            if (content instanceof VariableExp) {
                variable = (Variable)((VariableExp)content).getReferredVariable();
            } else if (content instanceof Variable) {
                variable = (Variable)content;
            }
            if (variable == null) continue;
            if (PredicateOperations.locallyDefined(variable.eContainer(), variable)) {
                if (!boundVariables.contains(variable)) continue;
                messageSubstitutions = new Object[]{this.getObjectLabel((EObject)variable, context), this.getObjectLabel((EObject)pattern, context)};
                this.appendError(diagnostics, predicate, QVTBaseMessages._UI_Predicate_LocalVariableIsBoundByPattern, messageSubstitutions);
                allOk = false;
                continue;
            }
            if (boundVariables.contains(variable)) continue;
            messageSubstitutions = new Object[]{this.getObjectLabel((EObject)variable, context), this.getObjectLabel((EObject)pattern, context)};
            this.appendError(diagnostics, predicate, QVTBaseMessages._UI_Predicate_ExternalVariableIsNotBoundByPattern, messageSubstitutions);
            allOk = false;
        }
        return allOk;
    }
}

