/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.QVTTemplate.operations;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.qvt.declarative.ecore.QVTBase.Domain;
import org.eclipse.qvt.declarative.ecore.QVTBase.Pattern;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.DomainOperations;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.CollectionTemplateExp;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.PropertyTemplateItem;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.operations.QVTTemplateMessages;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.operations.TemplateExpOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionTemplateExpOperations
extends TemplateExpOperations {
    public static CollectionTemplateExpOperations INSTANCE = new CollectionTemplateExpOperations();

    public boolean checkEveryMemberExpressionVariableIsBoundByPattern(CollectionTemplateExp collectionTemplateExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Pattern pattern = this.getPattern(collectionTemplateExp);
        if (pattern == null) {
            return true;
        }
        EList bindsTo = pattern.getBindsTo();
        boolean allOk = true;
        for (OCLExpression member : collectionTemplateExp.getMember()) {
            TreeIterator i = member.eAllContents();
            while (i.hasNext()) {
                VariableExp variableReference;
                Variable variable;
                EObject eObject = (EObject)i.next();
                if (!(eObject instanceof VariableExp) || (variable = (Variable)(variableReference = (VariableExp)eObject).getReferredVariable()) == null || this.isSpecialVariable(variable) || this.locallyDefined(variableReference) || bindsTo.contains(variable)) continue;
                Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)variable, context), this.getObjectLabel((EObject)pattern, context)};
                this.appendError(diagnostics, variableReference, QVTTemplateMessages._UI_CollectionTemplateExp_MemberExpressionVariableIsNotBoundByPattern, messageSubstitutions);
                allOk = false;
            }
        }
        return allOk;
    }

    public boolean checkEveryMemberTypeMatchesElementType(CollectionTemplateExp collectionTemplateExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        CollectionType collectionType = collectionTemplateExp.getReferredCollectionType();
        if (collectionType == null) {
            return true;
        }
        EClassifier elementType = (EClassifier)collectionType.getElementType();
        if (elementType == null) {
            return true;
        }
        boolean allOk = true;
        for (OCLExpression member : collectionTemplateExp.getMember()) {
            EClassifier memberType;
            if (this.isSpecialVariableReference(member) || (memberType = (EClassifier)member.getType()) == null || this.assignableFrom(elementType, memberType)) continue;
            Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)elementType, context), this.getObjectLabel((EObject)memberType, context)};
            this.appendError(diagnostics, collectionTemplateExp, QVTTemplateMessages._UI_CollectionTemplateExp_MemberTypeDoesNotMatchElementType, messageSubstitutions);
            allOk = false;
        }
        return allOk;
    }

    public boolean checkMemberCountSatifiesLowerBound(CollectionTemplateExp collectionTemplateExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EObject container = collectionTemplateExp.eContainer();
        if (!(container instanceof PropertyTemplateItem)) {
            return true;
        }
        int memberCount = collectionTemplateExp.getMember().size();
        if (memberCount == 0 && collectionTemplateExp.getRest() == null) {
            return true;
        }
        EStructuralFeature feature = ((PropertyTemplateItem)container).getReferredProperty();
        if (feature == null) {
            return true;
        }
        int lowerBound = feature.getLowerBound();
        if (memberCount >= lowerBound) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{memberCount, lowerBound, this.getObjectLabel((EObject)feature, context)};
        this.appendError(diagnostics, collectionTemplateExp, QVTTemplateMessages._UI_CollectionTemplateExp_MemberCountDoesNotSatisfyLowerBound, messageSubstitutions);
        return false;
    }

    public boolean checkReferredCollectionElementTypeIsDeclaredByDomain(CollectionTemplateExp collectionTemplateExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Domain domain = this.getDomain(collectionTemplateExp);
        if (domain == null) {
            return true;
        }
        CollectionType collectionType = collectionTemplateExp.getReferredCollectionType();
        if (collectionType == null) {
            return true;
        }
        EClassifier transitiveElementType = this.getTransitiveElementType((EClassifier)collectionType);
        if (transitiveElementType == null) {
            return true;
        }
        if (DomainOperations.INSTANCE.declaresType(domain, transitiveElementType)) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)transitiveElementType, context), this.getObjectLabel((EObject)domain, context)};
        this.appendError(diagnostics, collectionTemplateExp, QVTTemplateMessages._UI_CollectionTemplateExp_TypeIsNotDeclaredByDomain, messageSubstitutions);
        return false;
    }

    public boolean checkRestTypeMatchesCollectionType(CollectionTemplateExp collectionTemplateExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Variable rest = collectionTemplateExp.getRest();
        if (rest == null) {
            return true;
        }
        if (this.isSpecialVariable(rest)) {
            return true;
        }
        EClassifier restType = (EClassifier)rest.getType();
        if (restType == null) {
            return true;
        }
        CollectionType collectionType = collectionTemplateExp.getReferredCollectionType();
        if (collectionType == null) {
            return true;
        }
        if (this.assignableFrom((EClassifier)collectionType, restType)) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)collectionType, context), this.getObjectLabel((EObject)restType, context)};
        this.appendError(diagnostics, collectionTemplateExp, QVTTemplateMessages._UI_CollectionTemplateExp_RestTypeDoesNotMatchCollectionType, messageSubstitutions);
        return false;
    }

    public boolean checkRestVariableIsBoundByPattern(CollectionTemplateExp collectionTemplateExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Variable rest = collectionTemplateExp.getRest();
        if (rest == null) {
            return true;
        }
        if (this.isSpecialVariable(rest)) {
            return true;
        }
        Pattern pattern = this.getPattern(collectionTemplateExp);
        if (pattern == null) {
            return true;
        }
        if (pattern.getBindsTo().contains((Object)rest)) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{rest.getName(), this.getObjectLabel((EObject)pattern, context)};
        this.appendError(diagnostics, collectionTemplateExp, QVTTemplateMessages._UI_CollectionTemplateExp_RestVariableIsNotBoundByPattern, messageSubstitutions);
        return false;
    }
}

