/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences.fields;

import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesTab;
import org.eclipse.imp.preferences.PreferencesUtilities;
import org.eclipse.imp.preferences.fields.StringFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class StringButtonFieldEditor
extends StringFieldEditor {
    private Button changeButton;
    private String changeButtonText;

    public StringButtonFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, int width, int strategy, Composite parent) {
        super(page, tab, service, level, name, labelText, width, strategy, parent);
    }

    public StringButtonFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, int width, Composite parent) {
        super(page, tab, service, level, name, labelText, width, 0, parent);
    }

    public StringButtonFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, Composite parent) {
        super(page, tab, service, level, name, labelText, parent);
    }

    protected boolean valueChanged() {
        return super.valueChanged();
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.getTextControl((Composite)this.parent).getLayoutData()).horizontalSpan = numColumns - 2;
    }

    protected abstract String changePressed();

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns - 1);
        this.changeButton = this.getChangeControl(parent);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels((Control)this.changeButton, 61);
        gd.widthHint = Math.max(widthHint, this.changeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.changeButton.setLayoutData((Object)gd);
    }

    public Button getChangeControl(Composite parent) {
        if (this.changeButton == null) {
            boolean enabled = false;
            Control[] children = parent.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof Text) {
                    enabled = children[i].isEnabled();
                }
                ++i;
            }
            this.changeButton = new Button(parent, 8);
            if (this.changeButtonText == null) {
                this.changeButtonText = JFaceResources.getString((String)"openChange");
            }
            this.changeButton.setText(this.changeButtonText);
            this.changeButton.setFont(parent.getFont());
            this.changeButton.setEnabled(enabled);
            this.changeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    String newValue = StringButtonFieldEditor.this.changePressed();
                    if (newValue != null) {
                        StringButtonFieldEditor.this.levelFromWhichLoaded = StringButtonFieldEditor.this.preferencesLevel;
                        StringButtonFieldEditor.this.setInherited(false);
                        StringButtonFieldEditor.this.setPresentsDefaultValue(false);
                        StringButtonFieldEditor.this.setStringValue(newValue);
                        Text text = StringButtonFieldEditor.this.getTextControl();
                        text.setBackground(PreferencesUtilities.colorWhite);
                    }
                }
            });
            this.changeButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    StringButtonFieldEditor.this.changeButton = null;
                }
            });
        } else {
            this.checkParent((Control)this.changeButton, parent);
        }
        return this.changeButton;
    }

    public int getNumberOfControls() {
        return 3;
    }

    protected Shell getShell() {
        if (this.changeButton == null) {
            return null;
        }
        return this.changeButton.getShell();
    }

    public void setChangeButtonText(String text) {
        Assert.isNotNull((Object)text);
        this.changeButtonText = text;
        if (this.changeButton != null) {
            this.changeButton.setText(text);
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        if (this.changeButton != null) {
            this.changeButton.setEnabled(enabled);
        }
    }
}

