/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class SourceProposal
implements ICompletionProposal {
    private final String fProposal;
    private final String fNewText;
    private final String fPrefix;
    private final Region fRange;
    private final int fCursorLoc;
    private final String fAdditionalInfo;

    public SourceProposal(String newText, String prefix, int offset) {
        this(newText, newText, prefix, offset);
    }

    public SourceProposal(String proposal, String newText, String prefix, int offset) {
        this(proposal, newText, prefix, offset, offset + newText.length() - prefix.length());
    }

    public SourceProposal(String proposal, String newText, String prefix, int offset, int cursorLoc) {
        this(proposal, newText, prefix, new Region(offset, 0), cursorLoc);
    }

    public SourceProposal(String proposal, String newText, String prefix, Region region, String addlInfo) {
        this(proposal, newText, prefix, region, region.getOffset() + newText.length() - prefix.length(), addlInfo);
    }

    public SourceProposal(String proposal, String newText, String prefix, Region region, int cursorLoc) {
        this(proposal, newText, prefix, region, cursorLoc, null);
    }

    public SourceProposal(String proposal, String newText, String prefix, Region region, int cursorLoc, String addlInfo) {
        this.fProposal = proposal;
        this.fNewText = newText;
        this.fPrefix = prefix;
        this.fRange = region;
        this.fCursorLoc = cursorLoc;
        this.fAdditionalInfo = addlInfo;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.fRange.getOffset(), this.fRange.getLength(), this.fNewText.substring(this.fPrefix.length()));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fCursorLoc, 0);
    }

    public String getDisplayString() {
        return this.fProposal;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalInfo;
    }

    public Image getImage() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

