/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.services.INavigationTargetFinder;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.ITextEditor;

public class SelectEnclosingAction
extends Action {
    private UniversalEditor fEditor;
    private INavigationTargetFinder fNavTargetFinder;

    public SelectEnclosingAction() {
        this(null);
    }

    public SelectEnclosingAction(UniversalEditor editor) {
        super("Select Enclosing");
        this.setActionDefinitionId("org.eclipse.imp.runtime.editor.selectEnclosing");
        this.setEditor((ITextEditor)editor);
    }

    public void setEditor(ITextEditor editor) {
        this.fNavTargetFinder = null;
        if (editor instanceof UniversalEditor) {
            this.fEditor = (UniversalEditor)editor;
            if (this.fEditor.fLanguage != null) {
                this.fNavTargetFinder = ServiceFactory.getInstance().getNavigationTargetFinder(this.fEditor.fLanguage);
            }
        } else {
            this.fEditor = null;
        }
        this.setEnabled(this.fNavTargetFinder != null);
    }

    public void run() {
        Object enclosing;
        IRegion selection = this.fEditor.getSelectedRegion();
        IParseController pc = this.fEditor.getParseController();
        ISourcePositionLocator locator = pc.getSourcePositionLocator();
        Object curNode = locator.findNode(pc.getCurrentAst(), selection.getOffset(), selection.getOffset() + selection.getLength() - 1);
        if (curNode == null || selection.getOffset() == 0) {
            curNode = pc.getCurrentAst();
        }
        if ((enclosing = this.fNavTargetFinder.getEnclosingConstruct(curNode, pc.getCurrentAst())) != null) {
            int enclOffset = locator.getStartOffset(enclosing);
            int enclEnd = locator.getEndOffset(enclosing);
            this.fEditor.selectAndReveal(enclOffset, enclEnd - enclOffset + 1);
        }
    }
}

