/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.QVTRelation.operations;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.qvt.declarative.ecore.QVTBase.Rule;
import org.eclipse.qvt.declarative.ecore.QVTRelation.Key;
import org.eclipse.qvt.declarative.ecore.QVTRelation.Relation;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationalTransformation;
import org.eclipse.qvt.declarative.ecore.QVTRelation.operations.AbstractQVTRelationOperations;
import org.eclipse.qvt.declarative.ecore.QVTRelation.operations.QVTRelationMessages;
import org.eclipse.qvt.declarative.ecore.operations.AbstractValidatorOperations;
import org.eclipse.qvt.declarative.ecore.utils.EcoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationalTransformationOperations
extends AbstractQVTRelationOperations {
    public static RelationalTransformationOperations INSTANCE = new RelationalTransformationOperations();

    public boolean checkEveryRuleIsARelation(RelationalTransformation relationalTransformation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean allOk = true;
        for (Rule rule : relationalTransformation.getRule()) {
            if (rule instanceof Relation) continue;
            Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)rule, context)};
            this.appendError(diagnostics, rule, QVTRelationMessages._UI_RelationalTransformation_RuleIsNotARelation, messageSubstitutions);
            allOk = false;
        }
        return allOk;
    }

    public boolean checkKeysAreUnique(RelationalTransformation relationalTransformation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        AbstractValidatorOperations.UniquenessChecker<EClass, Key> checker = new AbstractValidatorOperations.UniquenessChecker<EClass, Key>((AbstractValidatorOperations)this){

            protected EClass getKey(Key key) {
                return key.getIdentifies();
            }
        };
        return checker.check(relationalTransformation.getOwnedKey(), QVTRelationMessages._UI_RelationalTransformation_KeyIsNotUnique, (EObject)relationalTransformation, diagnostics, context);
    }

    public boolean checkUniqueClassifierNames(RelationalTransformation relationalTransformation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        ArrayList<String> names = new ArrayList<String>();
        EList eClassifiers = relationalTransformation.getEClassifiers();
        for (EClassifier eClassifier : eClassifiers) {
            String name = eClassifier.getName();
            if (name != null) {
                String key = name.replace("_", "").toUpperCase();
                int index = names.indexOf(key);
                if (index != -1) {
                    Object[] messageSubstitutions;
                    if (diagnostics == null) {
                        return false;
                    }
                    result = false;
                    EClassifier otherEClassifier = (EClassifier)eClassifiers.get(index);
                    String otherName = otherEClassifier.getName();
                    Object[] astNodes = new Object[]{eClassifier, otherEClassifier};
                    if (!name.equals(otherName)) {
                        messageSubstitutions = new Object[]{name, otherName};
                        this.appendWarning(diagnostics, astNodes, QVTRelationMessages._UI_RelationalTransformation_ClassifierNameIsSimilar, messageSubstitutions);
                    } else if (eClassifier instanceof CollectionType && otherEClassifier instanceof CollectionType && ((CollectionType)eClassifier).getElementType() != ((CollectionType)otherEClassifier).getElementType()) {
                        messageSubstitutions = new Object[]{((CollectionType)eClassifier).getKind(), EcoreUtils.formatQualifiedName((Object)((CollectionType)eClassifier).getElementType()), ((CollectionType)otherEClassifier).getKind(), EcoreUtils.formatQualifiedName((Object)((CollectionType)otherEClassifier).getElementType())};
                        this.appendWarning(diagnostics, astNodes, QVTRelationMessages._UI_RelationalTransformation_CollectionNameIsNotUnique, messageSubstitutions);
                    } else {
                        messageSubstitutions = new Object[]{name};
                        this.appendError(diagnostics, astNodes, QVTRelationMessages._UI_RelationalTransformation_ClassifierNameIsNotUnique, messageSubstitutions);
                    }
                }
                names.add(key);
                continue;
            }
            names.add(null);
        }
        return result;
    }
}

