/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.Splitter;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.SplitterAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.Stage;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

abstract class AbstractStage
implements Stage {
    protected final @NonNull SplitterAnalysis splitter;

    protected AbstractStage(@NonNull SplitterAnalysis splitter) {
        this.splitter = splitter;
    }

    protected abstract @NonNull String buildContents(@NonNull StringBuilder var1);

    protected void build(@NonNull StringBuilder s, @NonNull String title, @NonNull Iterable<@NonNull Node> nodes) {
        if (!Iterables.isEmpty(nodes)) {
            s.append("\n");
            CompilerUtil.indent(s, 2);
            s.append(title);
            for (Node node : nodes) {
                s.append("\n");
                CompilerUtil.indent(s, 3);
                if (node.isHead()) {
                    s.append("*");
                }
                s.append(node.getName());
                s.append(" : ");
                s.append(node);
            }
        }
    }

    protected void checkAccumulate(@NonNull Set<@NonNull Node> accumulator, @NonNull Iterable<@NonNull Node> nodes) {
        for (Node node : nodes) {
            boolean wasAdded = accumulator.add(node);
            assert (wasAdded);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void checkAccumulated(@NonNull Set<@NonNull Node> actualNodes, @NonNull Iterable<@NonNull Node> expectedNodes) {
        @NonNull HashSet expectedNodesSet = Sets.newHashSet(expectedNodes);
        if (!actualNodes.equals(expectedNodesSet)) {
            StringBuilder s = new StringBuilder();
            @NonNull HashSet extraNodesSet = Sets.newHashSet(actualNodes);
            CompilerUtil.removeAll(extraNodesSet, expectedNodes);
            for (Node node : extraNodesSet) {
                s.append("\nextra: ");
                s.append(node);
            }
            @NonNull HashSet missingNodesSet = Sets.newHashSet(expectedNodes);
            missingNodesSet.removeAll(actualNodes);
            for (Node node : missingNodesSet) {
                s.append("\nmissing: ");
                s.append(node);
            }
            assert (false) : "Bad nodes for " + this + s.toString();
        }
    }

    protected @NonNull Iterable<@NonNull Node> computeDeadNodes(@NonNull Iterable<@NonNull Node> reachableNodes) {
        HashSet<@NonNull Node> deadNodes = new HashSet<Node>();
        HashSet<@NonNull Node> tryNodes = Sets.newHashSet(reachableNodes);
        while (!tryNodes.isEmpty()) {
            HashSet<@NonNull Node> retryNodes = new HashSet<Node>();
            for (Node node : tryNodes) {
                if (this.isLive(node, deadNodes)) continue;
                deadNodes.add(node);
                for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                    Node sourceNode;
                    if (edge.isRealized() || (sourceNode = edge.getEdgeSource()).isRealized()) continue;
                    retryNodes.add(sourceNode);
                }
            }
            retryNodes.removeAll(deadNodes);
            tryNodes = retryNodes;
        }
        ArrayList<@NonNull Node> nodeList = new ArrayList<Node>(deadNodes);
        Collections.sort(nodeList, NameUtil.NAMEABLE_COMPARATOR);
        return nodeList;
    }

    @Override
    public void debug() {
        if (Splitter.STAGES.isActive()) {
            StringBuilder s = new StringBuilder();
            this.toString(s, 1);
            String name = this.buildContents(s);
            Splitter.STAGES.println(String.valueOf(this.splitter.toString()) + ":" + name + "\n" + s.toString());
        }
    }

    @Override
    public @Nullable Node getIteratedNode() {
        return null;
    }

    @Override
    public @Nullable Node getIteratorNode() {
        return null;
    }

    protected abstract boolean isLive(@NonNull Node var1, @NonNull Set<@NonNull Node> var2);

    public @NonNull String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.splitter.toString());
        s.append(" ");
        this.toString(s, 0);
        return s.toString();
    }
}

