/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.cs2as.compiler.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class OCL2QVTmUtil {
    public static Function<EObject, @NonNull Stream<@NonNull EObject>> getAllContents() {
        return eObject -> {
            Iterable it = () -> eObject.eAllContents();
            return StreamSupport.stream(it.spliterator(), false);
        };
    }

    public static Function<EObject, @NonNull Stream<@NonNull EObject>> getAllContentsIncludingSelf() {
        return eObject -> {
            ArrayList<EObject> allContents = new ArrayList<EObject>();
            TreeIterator it = eObject.eAllContents();
            while (it.hasNext()) {
                allContents.add((EObject)it.next());
            }
            allContents.add((EObject)eObject);
            return allContents.stream();
        };
    }

    public static Function<EObject, @NonNull Stream<@NonNull EObject>> getAllContainers() {
        return eObject -> {
            ArrayList<EObject> containers = new ArrayList<EObject>();
            EObject container = eObject.eContainer();
            while (container != null) {
                containers.add(container);
                container = container.eContainer();
            }
            return containers.stream();
        };
    }

    public static Function<ShadowExp, @NonNull Class> getExpressionContextType() {
        return shadowExp -> (Class)OCL2QVTmUtil.getContainingExpressionInOCL().apply((OCLExpression)shadowExp).getOwnedContext().getType();
    }

    public static Function<OCLExpression, @NonNull ExpressionInOCL> getContainingExpressionInOCL() {
        return oclExp -> {
            EObject container = oclExp.eContainer();
            while (!(container instanceof ExpressionInOCL)) {
                container = container.eContainer();
            }
            assert (container != null);
            return (ExpressionInOCL)container;
        };
    }

    public static Function<@NonNull String, @NonNull String> firstToLowerCase() {
        return input -> {
            if (input.isEmpty()) {
                return input;
            }
            char[] c = input.toCharArray();
            c[0] = Character.toLowerCase(c[0]);
            return new String(c);
        };
    }

    public static Function<@NonNull String, @NonNull String> firstToUpperCase() {
        return input -> {
            if (input.isEmpty()) {
                return input;
            }
            char[] c = input.toCharArray();
            c[0] = Character.toUpperCase(c[0]);
            return new String(c);
        };
    }

    public static Function<@NonNull ShadowExp, @NonNull String> getCreationMappingName() {
        return shadowExp -> "c" + OCL2QVTmUtil.getExpressionContextType().apply((ShadowExp)shadowExp).getName() + "_2_" + OCL2QVTmUtil.getShadowTypeName().apply((ShadowExp)shadowExp);
    }

    public static Function<@NonNull ShadowPart, @NonNull String> getUpdateMappingName() {
        return shadowPart -> {
            ShadowExp shadowExp = (ShadowExp)shadowPart.eContainer();
            Property refProp = shadowPart.getReferredProperty();
            return String.valueOf('u') + OCL2QVTmUtil.getExpressionContextType().apply(shadowExp).getName() + "_2_" + OCL2QVTmUtil.getShadowTypeName().apply(shadowExp) + '_' + refProp.getName();
        };
    }

    private static Function<@NonNull ShadowExp, @NonNull String> getShadowTypeName() {
        return shadowExp -> {
            ExpressionInOCL expInOCL = OCL2QVTmUtil.getContainingExpressionInOCL().apply((OCLExpression)shadowExp);
            List sameTypeShadowExps = OCL2QVTmUtil.getAllContents().apply((EObject)expInOCL).filter(ShadowExp.class::isInstance).map(ShadowExp.class::cast).filter(x -> x.getType() == shadowExp.getType()).collect(Collectors.toList());
            if (sameTypeShadowExps.size() > 1) {
                return String.valueOf(shadowExp.getType().getName()) + "_" + sameTypeShadowExps.indexOf(shadowExp);
            }
            return shadowExp.getType().getName();
        };
    }

    public static Function<@NonNull Class, @NonNull Package> getOwningPackage() {
        return aClass -> aClass.getOwningPackage();
    }

    public static Function<@NonNull Class, @NonNull String> getOwningPackageName() {
        return aClass -> OCL2QVTmUtil.getName().apply((NamedElement)OCL2QVTmUtil.getOwningPackage().apply((Class)aClass));
    }

    private static Function<@NonNull NamedElement, @NonNull String> getName() {
        return namedElement -> namedElement == null ? "" : namedElement.getName();
    }

    public static Function<@NonNull Class, @NonNull Set<@NonNull Class>> getSuperClasses() {
        return aClass -> {
            LinkedHashSet<Class> result = new LinkedHashSet<Class>();
            for (Class superClass : ClassUtil.nullFree((List)aClass.getSuperClasses())) {
                result.add(superClass);
                result.addAll((Collection)OCL2QVTmUtil.getSuperClasses().apply(superClass));
            }
            return result;
        };
    }
}

