/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionClassAnalysis;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.CollectionClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class OriginalContentsAnalysis {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull Property oclContainerProperty;
    private final @NonNull AbstractTransformationAnalysis transformationAnalysis;
    private final @NonNull Map<@NonNull ClassDatum, @NonNull List<@NonNull Node>> classDatum2newNodes = new HashMap<ClassDatum, List<Node>>();
    private final @NonNull Map<@NonNull ClassDatum, @NonNull List<@NonNull Node>> classDatum2oldNodes = new HashMap<ClassDatum, List<Node>>();
    private final @NonNull Map<@NonNull PropertyDatum, @NonNull List<@NonNull NavigableEdge>> basePropertyDatum2newEdges = new HashMap<PropertyDatum, List<NavigableEdge>>();
    private final @NonNull Map<@NonNull ClassDatum, @NonNull Set<@NonNull RuleRegion>> classDatum2consumingRegions = new HashMap<ClassDatum, Set<RuleRegion>>();
    private final @NonNull Map<@NonNull ClassDatum, @NonNull Set<@NonNull RuleRegion>> classDatum2consumingRegions2 = new HashMap<ClassDatum, Set<RuleRegion>>();
    private final @NonNull Map<@NonNull ClassDatum, @NonNull Set<@NonNull RuleRegion>> classDatum2producingRegions = new HashMap<ClassDatum, Set<RuleRegion>>();
    private final @NonNull Map<@NonNull ClassDatum, @NonNull Set<@NonNull RuleRegion>> classDatum2producingRegions2 = new HashMap<ClassDatum, Set<RuleRegion>>();

    public OriginalContentsAnalysis(@NonNull ScheduleManager scheduleManager) {
        this.scheduleManager = scheduleManager;
        this.oclContainerProperty = scheduleManager.getStandardLibraryHelper().getOclContainerProperty();
        this.transformationAnalysis = scheduleManager.getTransformationAnalysis();
    }

    private void addNewEdge(@NonNull RuleRegion region, @NonNull NavigableEdge newEdge) {
        if (newEdge instanceof NavigationEdge) {
            PropertyDatum propertyDatum = this.getPropertyDatum((NavigationEdge)newEdge);
            this.addNewEdge(region, newEdge, propertyDatum);
        }
    }

    private void addNewEdge(@NonNull RuleRegion region, @NonNull NavigableEdge newEdge, @NonNull PropertyDatum propertyDatum) {
        String name = propertyDatum.getName();
        PropertyDatum basePropertyDatum = this.scheduleManager.getBasePropertyDatum(propertyDatum);
        List<@NonNull NavigableEdge> edges = this.basePropertyDatum2newEdges.get(basePropertyDatum);
        if (edges == null) {
            edges = new ArrayList<NavigableEdge>();
            this.basePropertyDatum2newEdges.put(basePropertyDatum, edges);
        }
        if (!edges.contains(newEdge)) {
            edges.add(newEdge);
        }
    }

    private void addNewNode(@NonNull RuleRegion region, @NonNull Node newNode) {
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)newNode);
        ClassDatum elementalClassDatum = this.scheduleManager.getElementalClassDatum(classDatum);
        for (ClassDatum superClassDatum : this.scheduleManager.getSuperClassDatums(elementalClassDatum)) {
            List<@NonNull Node> nodes = this.classDatum2newNodes.get(superClassDatum);
            if (nodes == null) {
                nodes = new ArrayList<Node>();
                this.classDatum2newNodes.put(superClassDatum, nodes);
            }
            nodes.add(newNode);
            Set<@NonNull RuleRegion> regions = this.classDatum2producingRegions2.get(superClassDatum);
            if (regions == null) {
                regions = new HashSet<RuleRegion>();
                this.classDatum2producingRegions2.put(superClassDatum, regions);
            }
            regions.add(region);
        }
    }

    private void addOldNode(@NonNull RuleRegion region, @NonNull Node oldNode) {
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)oldNode);
        for (ClassDatum superClassDatum : this.scheduleManager.getSuperClassDatums(classDatum)) {
            Set<RuleRegion> regions;
            List<@NonNull Node> nodes = this.classDatum2oldNodes.get(superClassDatum);
            if (nodes == null) {
                nodes = new ArrayList<Node>();
                this.classDatum2oldNodes.put(superClassDatum, nodes);
            }
            if (!nodes.contains(oldNode)) {
                nodes.add(oldNode);
            }
            if ((regions = this.classDatum2consumingRegions2.get(superClassDatum)) == null) {
                regions = new HashSet<RuleRegion>();
                this.classDatum2consumingRegions2.put(superClassDatum, regions);
            }
            regions.add(region);
        }
    }

    public void addRegion(@NonNull RuleRegion region) {
        for (Node oldNode : QVTscheduleUtil.getOwnedNodes((Region)region)) {
            if (!oldNode.isOld() || oldNode.isDependency() || oldNode.isConstant()) continue;
            if (oldNode.isHead()) {
                this.addOldNode(region, oldNode);
                continue;
            }
            if (this.isOnlyCastOrRecursed(oldNode)) continue;
            this.addOldNode(region, oldNode);
        }
        for (Node newNode : QVTscheduleUtil.getOwnedNodes((Region)region)) {
            if (!newNode.isNew() || !newNode.isClass()) continue;
            this.addNewNode(region, newNode);
        }
        for (Edge newEdge : QVTscheduleUtil.getOwnedEdges((Region)region)) {
            if (!newEdge.isRealized() || !newEdge.isNavigation()) continue;
            this.addNewEdge(region, (NavigableEdge)((NavigationEdge)newEdge));
        }
    }

    public @NonNull String dumpClass2newNode() {
        StringBuilder s = new StringBuilder();
        ArrayList<@NonNull ClassDatum> classDatums = new ArrayList<ClassDatum>(this.classDatum2newNodes.keySet());
        Collections.sort(classDatums, NameUtil.NAMEABLE_COMPARATOR);
        for (ClassDatum classDatum : classDatums) {
            s.append("\n\t" + classDatum + " : ");
            ArrayList<@NonNull E> newNodes = new ArrayList(this.classDatum2newNodes.get(classDatum));
            Collections.sort(newNodes, NameUtil.NAMEABLE_COMPARATOR);
            for (Node newNode : newNodes) {
                s.append("\n\t\t" + newNode.getDisplayName());
            }
        }
        return s.toString();
    }

    public @NonNull String dumpClass2oldNode() {
        StringBuilder s = new StringBuilder();
        ArrayList<@NonNull ClassDatum> classDatums = new ArrayList<ClassDatum>(this.classDatum2oldNodes.keySet());
        Collections.sort(classDatums, NameUtil.NAMEABLE_COMPARATOR);
        for (ClassDatum classDatum : classDatums) {
            s.append("\n\t" + classDatum + " : ");
            ArrayList<@NonNull E> oldNodes = new ArrayList(this.classDatum2oldNodes.get(classDatum));
            Collections.sort(oldNodes, NameUtil.NAMEABLE_COMPARATOR);
            for (Node oldNode : oldNodes) {
                s.append("\n\t\t" + oldNode.getDisplayName());
            }
        }
        return s.toString();
    }

    private @Nullable Iterable<@NonNull NavigableEdge> getCompositeNewEdges() {
        HashSet<@NonNull E> realizedEdges = null;
        for (Map.Entry<PropertyDatum, List<NavigableEdge>> entry : this.basePropertyDatum2newEdges.entrySet()) {
            Property property = entry.getKey().getReferredProperty();
            if (property == null) continue;
            Property compositeProperty = null;
            if (property.isIsComposite()) {
                compositeProperty = property;
            } else {
                Property oppositeProperty = property.getOpposite();
                if (oppositeProperty != null && oppositeProperty.isIsComposite()) {
                    compositeProperty = oppositeProperty;
                }
            }
            if (compositeProperty == null) continue;
            if (realizedEdges == null) {
                realizedEdges = new HashSet();
            }
            realizedEdges.addAll(entry.getValue());
        }
        return realizedEdges;
    }

    public @NonNull Iterable<@NonNull RuleRegion> getDirectlyConsumingRegions(@NonNull ClassDatum classDatum) {
        Set<RuleRegion> consumingRegions2;
        assert (!classDatum.isDataType()) : "DataTypes can only be consumed by a PropertyDatum";
        Set<@NonNull RuleRegion> consumingRegions = this.classDatum2consumingRegions.get(classDatum);
        if (consumingRegions == null) {
            PartialRegionClassAnalysis<@NonNull PRA> classAnalysis = this.transformationAnalysis.basicGetClassAnalysis(classDatum);
            consumingRegions = new HashSet<RuleRegion>();
            if (classAnalysis != null) {
                for (PartialRegionClassAnalysis subClassAnalysis : classAnalysis.getSubClassAnalyses()) {
                    for (PartialRegionAnalysis regionAnalysis : subClassAnalysis.getConsumers()) {
                        consumingRegions.add((RuleRegion)regionAnalysis.getRegion());
                    }
                }
            }
            this.classDatum2consumingRegions.put(classDatum, consumingRegions);
        }
        if ((consumingRegions2 = this.classDatum2consumingRegions2.get(classDatum)) == null) {
            consumingRegions2 = new HashSet<RuleRegion>();
        }
        assert (consumingRegions.equals(consumingRegions2));
        return consumingRegions;
    }

    public @NonNull Iterable<@NonNull RuleRegion> getIndirectlyProducingRegions(@NonNull ClassDatum classDatum) {
        Set<RuleRegion> producingRegions2;
        assert (!classDatum.isDataType()) : "DataTypes can only be produced by a PropertyDatum";
        Set<@NonNull RuleRegion> producingRegions = this.classDatum2producingRegions.get(classDatum);
        if (producingRegions == null) {
            PartialRegionClassAnalysis<@NonNull PRA> classAnalysis = this.transformationAnalysis.basicGetClassAnalysis(classDatum);
            producingRegions = new HashSet<RuleRegion>();
            if (classAnalysis != null) {
                for (PartialRegionClassAnalysis subClassAnalysis : classAnalysis.getSubClassAnalyses()) {
                    for (PartialRegionAnalysis regionAnalysis : subClassAnalysis.getExactProducers()) {
                        producingRegions.add((RuleRegion)regionAnalysis.getRegion());
                    }
                }
            }
            this.classDatum2producingRegions.put(classDatum, producingRegions);
        }
        if ((producingRegions2 = this.classDatum2producingRegions2.get(classDatum)) == null) {
            producingRegions2 = new HashSet<RuleRegion>();
        }
        assert (producingRegions.equals(producingRegions2));
        return producingRegions;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable Iterable<@NonNull Node> getNewNodes(@NonNull ClassDatum classDatum) {
        @NonNull Iterable newNodes = this.classDatum2newNodes.get(classDatum);
        return newNodes;
    }

    public @Nullable Iterable<@NonNull NavigableEdge> getNewEdges(@NonNull NavigableEdge edge) {
        if (edge instanceof NavigationEdge) {
            Property property = QVTscheduleUtil.getReferredProperty((NavigationEdge)((NavigationEdge)edge));
            if (property.eContainer() == null) {
                return null;
            }
            if (property == this.oclContainerProperty) {
                return this.getCompositeNewEdges();
            }
            PropertyDatum propertyDatum = this.getPropertyDatum((NavigationEdge)edge);
            return this.getNewEdges(propertyDatum);
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable Iterable<@NonNull NavigableEdge> getNewEdges(@NonNull PropertyDatum propertyDatum) {
        ClassDatum elementalTargetClassDatum = this.scheduleManager.getElementalTargetClassDatum(propertyDatum);
        Property property = propertyDatum.getReferredProperty();
        PropertyDatum basePropertyDatum = this.scheduleManager.getBasePropertyDatum(propertyDatum);
        @NonNull Iterable realizedEdges = this.basePropertyDatum2newEdges.get(basePropertyDatum);
        if (realizedEdges == null) {
            return null;
        }
        ArrayList<NavigableEdge> conformantRealizedEdges = null;
        for (NavigableEdge realizedEdge : realizedEdges) {
            boolean matches = false;
            if (!realizedEdge.isNavigation()) continue;
            NavigationEdge realizedNavigationEdge = (NavigationEdge)realizedEdge;
            Property realizedProperty = QVTscheduleUtil.getReferredProperty((NavigationEdge)realizedNavigationEdge);
            if (realizedProperty != property) {
                assert (realizedProperty.getOpposite() == property);
                matches = true;
            } else {
                Node targetNode = realizedEdge.getEdgeTarget();
                ClassDatum realizedClassDatum = QVTscheduleUtil.getClassDatum((Node)targetNode);
                if (QVTscheduleUtil.conformsToClassOrBehavioralClass((ClassDatum)realizedClassDatum, (ClassDatum)elementalTargetClassDatum)) {
                    matches = true;
                } else if (realizedClassDatum.isCollectionType() && QVTscheduleUtil.conformsToClassOrBehavioralClass((ClassDatum)QVTscheduleUtil.getElementalClassDatum((CollectionClassDatum)((CollectionClassDatum)realizedClassDatum)), (ClassDatum)elementalTargetClassDatum)) {
                    matches = true;
                }
            }
            if (!matches) continue;
            if (conformantRealizedEdges == null) {
                conformantRealizedEdges = new ArrayList<NavigableEdge>();
            }
            conformantRealizedEdges.add(realizedEdge);
        }
        return conformantRealizedEdges;
    }

    public @Nullable Iterable<@NonNull Node> getOldNodes(@NonNull ClassDatum classDatum) {
        return this.classDatum2oldNodes.get(classDatum);
    }

    private @NonNull PropertyDatum getPropertyDatum(@NonNull NavigationEdge producedEdge) {
        assert (!producedEdge.isCast());
        Property forwardProperty = QVTscheduleUtil.getReferredProperty((NavigationEdge)producedEdge);
        ClassDatum sourceClassDatum = QVTscheduleUtil.getClassDatum((Node)producedEdge.getEdgeSource());
        ClassDatum targetClassDatum = QVTscheduleUtil.getClassDatum((Node)producedEdge.getEdgeTarget());
        ClassDatum forwardClassDatum = this.scheduleManager.getElementalClassDatum(sourceClassDatum);
        ClassDatum reverseClassDatum = this.scheduleManager.getElementalClassDatum(targetClassDatum);
        return this.scheduleManager.getPropertyDatum(forwardClassDatum, forwardProperty, reverseClassDatum);
    }

    private boolean isOnlyCastOrRecursed(@NonNull Node predicatedNode) {
        boolean isCast = false;
        for (Edge outgoingEdge : QVTscheduleUtil.getOutgoingEdges((Node)predicatedNode)) {
            assert (!outgoingEdge.isCast());
            if (!outgoingEdge.isRecursion()) {
                return false;
            }
            isCast = true;
        }
        return isCast;
    }
}

