/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.evaluation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.utilities.PivotConstantsInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.evaluation.ExecutionVisitor;
import org.eclipse.qvtd.runtime.evaluation.InvocationManager;
import org.eclipse.qvtd.runtime.evaluation.ObjectManager;
import org.eclipse.qvtd.runtime.evaluation.SlotState;
import org.eclipse.qvtd.runtime.internal.evaluation.AbstractObjectState;
import org.eclipse.qvtd.runtime.internal.evaluation.EOppositeReferenceImpl;

public abstract class AbstractObjectManager<SS extends SlotState>
implements ObjectManager {
    protected static final @NonNull List<@NonNull SlotState> EMPTY_SLOT_STATE_LIST = Collections.emptyList();
    public static @NonNull Object NOT_A_VALUE = AbstractObjectManager.class;
    protected final @NonNull InvocationManager invocationManager;
    protected final boolean debugAssignments = AbstractTransformer.ASSIGNMENTS.isActive();
    protected final boolean debugGettings = AbstractTransformer.GETTINGS.isActive();
    private @NonNull Map<@NonNull Object, AbstractObjectState<@NonNull SS>> object2objectState = new HashMap<Object, AbstractObjectState<SS>>();
    private @NonNull Map<@NonNull EReference, EOppositeReferenceImpl> eReference2eOppositeReference = new HashMap<EReference, EOppositeReferenceImpl>();

    protected AbstractObjectManager(@NonNull InvocationManager invocationManager) {
        this.invocationManager = invocationManager;
    }

    @Override
    public <R> R accept(@NonNull ExecutionVisitor<R> visitor) {
        return visitor.visitObjectManager(this);
    }

    @Override
    public synchronized void assigned(@NonNull Object eObject, EStructuralFeature eFeature, @Nullable Object ecoreValue, boolean isPartial) {
        assert (eFeature != null);
        if (this.debugAssignments) {
            boolean isOpposite = false;
            StringBuilder s = new StringBuilder();
            if (isPartial) {
                s.append("partial-");
            }
            s.append("assigned ");
            s.append(AbstractObjectManager.toDebugString(eObject));
            s.append(".");
            s.append(isOpposite ? "~" : "");
            s.append(eFeature.getName());
            s.append(" := ");
            if (ecoreValue instanceof EObject) {
                s.append(AbstractObjectManager.toDebugString(ecoreValue));
            } else {
                s.append(LabelUtil.getLabel((Object)ecoreValue));
            }
            AbstractTransformer.ASSIGNMENTS.println(s.toString());
        }
        AbstractObjectState<@NonNull SS> objectState = this.getObjectState(eObject);
        objectState.assigned(eFeature, ecoreValue, isPartial);
    }

    public @Nullable AbstractObjectState<@NonNull SS> basicGetObjectState(@NonNull Object eObject) {
        return this.object2objectState.get(eObject);
    }

    public @Nullable SS basicGetSlotState(@NonNull Object eObject, @NonNull EStructuralFeature eFeature) {
        AbstractObjectState<@NonNull SS> objectState = this.basicGetObjectState(eObject);
        return objectState != null ? (SS)objectState.basicGetSlotState(eFeature) : null;
    }

    public abstract @NonNull AbstractObjectState<@NonNull SS> createObjectState(@NonNull Object var1);

    @Override
    public void destroyed(@NonNull Object eObject) {
        PivotUtilInternal.resetContainer((EObject)((EObject)eObject));
        this.object2objectState.remove(eObject);
    }

    @Override
    public @NonNull EReference getEOppositeReference(@NonNull EReference eReference) {
        Object eOppositeReference = eReference.getEOpposite();
        if (eOppositeReference == null) {
            EOppositeReferenceImpl eOppositeReference2 = this.eReference2eOppositeReference.get(eReference);
            if (eOppositeReference2 == null) {
                EMap details;
                String oppositeName;
                eOppositeReference2 = new EOppositeReferenceImpl(eReference);
                EAnnotation oppositeRole = eReference.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml#Property.oppositeRoleName");
                if (oppositeRole != null && (oppositeName = (String)(details = oppositeRole.getDetails()).get((Object)"body")) != null) {
                    UnlimitedNaturalValue upper;
                    IntegerValue lower;
                    eOppositeReference2.setName(oppositeName);
                    String lowerValue = (String)details.get((Object)"lower");
                    IntegerValue integerValue = lower = lowerValue != null ? ValueUtil.integerValueOf((String)lowerValue) : PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_LOWER_VALUE;
                    if (lower.isInvalid()) {
                        lower = PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_LOWER_VALUE;
                    }
                    eOppositeReference2.setLowerBound(lower.intValue());
                    String upperValue = (String)details.get((Object)"upper");
                    UnlimitedNaturalValue unlimitedNaturalValue = upper = upperValue != null ? ValueUtil.unlimitedNaturalValueOf((String)upperValue) : PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_UPPER_VALUE;
                    if (upper.isInvalid()) {
                        upper = PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_UPPER_VALUE;
                    }
                    eOppositeReference2.setUpperBound(upper.isUnlimited() ? -1 : upper.intValue());
                    if (!upper.equals(ValueUtil.ONE_VALUE)) {
                        String uniqueValue = (String)details.get((Object)"unique");
                        boolean isUnique = uniqueValue != null ? Boolean.valueOf(uniqueValue) : true;
                        eOppositeReference2.setUnique(isUnique);
                        String orderedValue = (String)details.get((Object)"ordered");
                        boolean isOrdered = orderedValue != null ? Boolean.valueOf(orderedValue) : false;
                        eOppositeReference2.setOrdered(isOrdered);
                    }
                }
                this.eReference2eOppositeReference.put(eReference, eOppositeReference2);
            }
            eOppositeReference = eOppositeReference2;
        }
        return eOppositeReference;
    }

    public @NonNull AbstractObjectState<@NonNull SS> getObjectState(@NonNull Object eObject) {
        @Nullable AbstractObjectState<@NonNull SS> objectState = this.object2objectState.get(eObject);
        if (objectState == null) {
            objectState = this.createObjectState(eObject);
            this.object2objectState.put(eObject, objectState);
        }
        return objectState;
    }

    public @NonNull Iterable<@NonNull Object> getObjects() {
        return ClassUtil.nullFree(this.object2objectState.keySet());
    }

    public @NonNull Iterable<@NonNull SS> getSlotStates(@NonNull Object object) {
        AbstractObjectState<@NonNull SS> objectState = this.object2objectState.get(object);
        if (objectState != null) {
            return objectState.getFeatures();
        }
        return EMPTY_SLOT_STATE_LIST;
    }

    @Override
    public synchronized void getting(@NonNull Object eObject, EStructuralFeature eFeature, boolean isOpposite) {
        assert (eFeature != null);
        if (this.debugGettings) {
            AbstractTransformer.GETTINGS.println("getting " + AbstractObjectManager.toDebugString(eObject) + "." + (isOpposite ? "~" : "") + eFeature.getName());
        }
        if (isOpposite) {
            eFeature = this.getEOppositeReference((EReference)eFeature);
        }
        SS slotState = this.updateSlotState(eObject, eFeature, NOT_A_VALUE, false);
        slotState.getting(eObject, eFeature);
    }

    public synchronized @NonNull SS gotSlotState(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue) {
        AbstractObjectState<@NonNull SS> objectState = this.getObjectState(eObject);
        return objectState.gotSlotState(eFeature, ecoreValue);
    }

    public static @NonNull String toDebugString(@Nullable Object object) {
        if (object == null) {
            return "null";
        }
        StringBuilder s = new StringBuilder();
        if (object instanceof EObject) {
            EClass eClass = ((EObject)object).eClass();
            EPackage ePackage = eClass.getEPackage();
            s.append(ePackage.getName());
            s.append("::");
            s.append(eClass.getName());
        } else {
            String className = object.getClass().getName();
            int index = className.lastIndexOf(46);
            if (index >= 0) {
                className = className.substring(index + 1);
            }
            s.append(className);
        }
        s.append("@");
        s.append(Integer.toHexString(System.identityHashCode(object)));
        return s.toString();
    }

    public synchronized @NonNull SS updateSlotState(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue, boolean isPartial) {
        AbstractObjectState<@NonNull SS> objectState = this.getObjectState(eObject);
        return objectState.updateSlotState(eFeature, ecoreValue, isPartial);
    }
}

