/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.pivot.qvtschedule.BasicPartition;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class BasicPartitionAnalysis
extends MappingPartitionAnalysis<BasicPartition> {
    private final @NonNull ReachabilityForest reachabilityForest;
    private @Nullable Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> explicitPredecessors = null;

    public BasicPartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull BasicPartition partition, @NonNull ReachabilityForest reachabilityForest, @NonNull String namePrefix, @NonNull String symbolSuffix) {
        super(partitionedTransformationAnalysis, partition);
        this.reachabilityForest = reachabilityForest;
        partitionedTransformationAnalysis.addPartitionAnalysis(this);
    }

    public void addExplicitPredecessor(@NonNull BasicPartitionAnalysis precedingPartitionAnalysis) {
        ((BasicPartition)this.getPartition()).addExplicitPredecessor((BasicPartition)precedingPartitionAnalysis.getPartition());
    }

    @Override
    public void analyzePartition2() {
        super.analyzePartition2();
        HashSet<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> partitionAnalyses = new HashSet<PartialRegionAnalysis<PartitionsAnalysis>>();
        for (Partition partition : QVTscheduleUtil.getExplicitPredecessors((BasicPartition)((BasicPartition)this.partition))) {
            partitionAnalyses.add(this.partitionedTransformationAnalysis.getPartitionAnalysis(partition));
        }
        this.explicitPredecessors = partitionAnalyses;
    }

    @Override
    public @Nullable Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> getExplicitPredecessors() {
        return this.explicitPredecessors;
    }

    protected @NonNull Iterable<@NonNull Node> getPredecessors(@NonNull Node targetNode) {
        return this.reachabilityForest.getPredecessors(targetNode);
    }

    @Override
    public @NonNull ReachabilityForest getReachabilityForest() {
        return this.reachabilityForest;
    }

    @Override
    public boolean isChecked(@NonNull Edge edge) {
        Role role = ((BasicPartition)this.partition).getRole(edge);
        return role != null ? role.isChecked() : false;
    }
}

