/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.evaluation;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.runtime.evaluation.AbstractTypedModelInstance;
import org.eclipse.qvtd.runtime.evaluation.EClassAnalysis;
import org.eclipse.qvtd.runtime.evaluation.ModelsManager;

public class EReferenceAnalysis {
    protected final @NonNull AbstractTypedModelInstance typedModelInstance;
    protected final @NonNull ModelsManager modelsManager;
    protected final @NonNull EReference eReference;
    private final boolean isContainment;
    private final boolean isMany;
    private final boolean isResolveProxies;
    private final int oppositePropertyIndex;

    public EReferenceAnalysis(@NonNull EClassAnalysis eClassAnalysis, @NonNull EReference eReference, int oppositePropertyIndex) {
        this.typedModelInstance = eClassAnalysis.getTypedModelInstance();
        this.modelsManager = this.typedModelInstance.getModelsManager();
        this.eReference = eReference;
        this.isContainment = eReference.isContainment();
        this.isMany = eReference.isMany();
        this.isResolveProxies = eReference.isResolveProxies();
        this.oppositePropertyIndex = oppositePropertyIndex;
        assert (!this.isContainment || oppositePropertyIndex < 0);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void traverseFrom(@NonNull EObject eObject) {
        if (!this.isMany) {
            Object object = eObject.eGet((EStructuralFeature)this.eReference, true);
            if (object != null) {
                this.traverseFromTo(eObject, (EObject)object);
            }
        } else if (eObject.eIsSet((EStructuralFeature)this.eReference)) {
            @NonNull List list = (List)eObject.eGet((EStructuralFeature)this.eReference, true);
            for (EObject object : list) {
                this.traverseFromTo(eObject, object);
            }
        }
    }

    private void traverseFromTo(@NonNull EObject fromEObject, @NonNull EObject toEObject) {
        Resource eResource;
        if (this.isResolveProxies && (eResource = toEObject.eResource()) != null) {
            this.typedModelInstance.addInputResource(eResource);
        }
        if (this.isContainment) {
            this.typedModelInstance.getEClassAnalysis(toEObject).traverseChild(toEObject);
        } else if (this.oppositePropertyIndex >= 0) {
            Map<@NonNull Object, @NonNull Object>[] object2oppositeObject2 = this.modelsManager.getObject2oppositeObject();
            assert (object2oppositeObject2 != null);
            object2oppositeObject2[this.oppositePropertyIndex].put(toEObject, fromEObject);
        }
    }

    public void untraverseFrom(@NonNull EObject eObject) {
        if (this.oppositePropertyIndex >= 0) {
            @NonNull Map<@NonNull Object, @NonNull Object>[] object2oppositeObject2 = this.modelsManager.getObject2oppositeObject();
            EReference @NonNull [] propertyIndex2eReference2 = this.modelsManager.getPropertyIndex2eReference();
            EReference eReference = propertyIndex2eReference2[this.oppositePropertyIndex];
            if (eReference != null) {
                Object object = eObject.eGet((EStructuralFeature)eReference);
                assert (object != null);
                object2oppositeObject2[this.oppositePropertyIndex].remove(object);
            }
        }
    }
}

