/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTransformationAnalysis;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformationInstance;
import org.eclipse.qvtd.runtime.evaluation.AbstractTypedModelInstance;
import org.eclipse.qvtd.runtime.evaluation.TransformationInstance;
import org.eclipse.qvtd.runtime.evaluation.TypedModelInstance;

public class QVTiModelsManager {
    protected final @NonNull QVTiTransformationAnalysis transformationAnalysis;
    protected final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory;
    private @NonNull Map<@NonNull ImperativeTypedModel, @NonNull Resource> modelResourceMap = new HashMap<ImperativeTypedModel, Resource>();
    private @NonNull Map<@NonNull Resource, @NonNull ImperativeTypedModel> resource2typedModel = new HashMap<Resource, ImperativeTypedModel>();
    private @NonNull Map<@NonNull ImperativeTypedModel, @NonNull List<@NonNull EObject>> modelElementsMap = new HashMap<ImperativeTypedModel, List<EObject>>();
    private @NonNull Set<@NonNull Class> allInstancesClasses;
    private @NonNull Map<?, ?>[] unnavigableOpposites;
    private TransformationInstance transformationInstance = null;
    private Map<@NonNull ImperativeTypedModel, @NonNull TypedModelInstance> typedModel2typedModelInstance = null;

    public QVTiModelsManager(@NonNull QVTiTransformationAnalysis transformationAnalysis) {
        this.transformationAnalysis = transformationAnalysis;
        this.environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)transformationAnalysis.getEnvironmentFactory();
        this.allInstancesClasses = transformationAnalysis.getAllInstancesClasses();
        int cacheIndexes = transformationAnalysis.getCacheIndexes();
        this.unnavigableOpposites = new Map[cacheIndexes];
        int i = 0;
        while (i < cacheIndexes) {
            this.unnavigableOpposites[i] = new HashMap();
            ++i;
        }
    }

    public void addModel(@NonNull ImperativeTypedModel typedModel, @NonNull Resource model) {
        this.modelResourceMap.put(typedModel, model);
        this.resource2typedModel.put(model, typedModel);
    }

    public void addModelElement(@NonNull ImperativeTypedModel model, @NonNull Object element) {
        Resource resource;
        List<@NonNull EObject> elements = this.modelElementsMap.get(model);
        if (elements == null && (resource = this.modelResourceMap.get(model)) != null) {
            elements = new ArrayList<EObject>((Collection<EObject>)resource.getContents());
            this.modelElementsMap.put(model, elements);
        }
        if (elements != null) {
            assert (!elements.contains(element));
            elements.add((EObject)element);
        }
    }

    public void dispose() {
        this.modelElementsMap.clear();
        this.modelResourceMap.clear();
        this.allInstancesClasses.clear();
        Map<?, ?>[] mapArray = this.unnavigableOpposites;
        int n = this.unnavigableOpposites.length;
        int n2 = 0;
        while (n2 < n) {
            Map<?, ?> unnavigableOpposite = mapArray[n2];
            unnavigableOpposite.clear();
            ++n2;
        }
    }

    public @NonNull Set<@NonNull Object> get(@NonNull Class type) {
        HashSet<@NonNull Object> elements = new HashSet<Object>();
        for (ImperativeTypedModel typedModel : QVTimperativeUtil.getOwnedTypedModels(this.transformationAnalysis.getTransformation())) {
            if (!typedModel.isIsChecked()) continue;
            TypedModelInstance typedModelInstance = this.getTypedModelInstance(typedModel);
            Iterables.addAll(elements, (Iterable)typedModelInstance.getObjectsOfKind(type));
        }
        return elements;
    }

    public @NonNull Collection<@NonNull Resource> getAllModelResources() {
        return this.modelResourceMap.values();
    }

    public @NonNull List<@NonNull Object> getElementsByType(@Nullable ImperativeTypedModel model, @NonNull Type type) {
        ArrayList<Object> elements;
        block6: {
            block5: {
                elements = new ArrayList<Object>();
                if (!this.modelElementsMap.containsKey(model)) break block5;
                List<@NonNull EObject> roots = this.modelElementsMap.get(model);
                assert (roots != null);
                for (EObject root : roots) {
                    if (root.eContainer() != null) continue;
                    if (this.isInstance(type, root)) {
                        elements.add(root);
                    }
                    TreeIterator contents = root.eAllContents();
                    while (contents.hasNext()) {
                        EObject element = (EObject)contents.next();
                        if (element == null || !this.isInstance(type, element)) continue;
                        elements.add(element);
                    }
                }
                break block6;
            }
            Resource resource = this.modelResourceMap.get(model);
            if (resource == null) break block6;
            TreeIterator contents = resource.getAllContents();
            while (contents.hasNext()) {
                EObject element = (EObject)contents.next();
                if (element == null || !this.isInstance(type, element)) continue;
                elements.add(element);
            }
        }
        return elements;
    }

    public @NonNull MetamodelManager getMetamodelManager() {
        return this.environmentFactory.getMetamodelManager();
    }

    public Resource getModel(@NonNull ImperativeTypedModel typedModel) {
        return this.modelResourceMap.get(typedModel);
    }

    public @NonNull Collection<@NonNull EObject> getRootObjects(@NonNull ImperativeTypedModel typedModel) {
        return ((Resource)ClassUtil.nonNullState((Object)this.modelResourceMap.get(typedModel))).getContents();
    }

    public @NonNull QVTiTransformationAnalysis getTransformationAnalysis() {
        return this.transformationAnalysis;
    }

    public @Nullable ImperativeTypedModel getTypedModel(@NonNull Resource resource) {
        return this.resource2typedModel.get(resource);
    }

    public Object getUnnavigableOpposite(@NonNull Integer cacheIndex, @NonNull Object sourceObject) {
        return this.unnavigableOpposites[cacheIndex].get(sourceObject);
    }

    protected boolean isInstance(@NonNull Type requiredType, @NonNull EObject eObject) {
        EClass eClass = eObject.eClass();
        EPackage ePackage = eClass.getEPackage();
        Type objectType = null;
        if (ePackage == PivotPackage.eINSTANCE) {
            String name = (String)ClassUtil.nonNullEMF((Object)eClass.getName());
            objectType = this.environmentFactory.getASClass(name);
        } else {
            try {
                objectType = (Type)this.environmentFactory.getASOf(Type.class, (EObject)eClass);
            }
            catch (ParserException parserException) {
                // empty catch block
            }
        }
        return objectType != null && objectType.conformsTo((StandardLibrary)this.environmentFactory.getStandardLibrary(), requiredType);
    }

    public void saveContents() {
        for (Map.Entry<ImperativeTypedModel, Resource> entry : this.modelResourceMap.entrySet()) {
            Resource model = entry.getValue();
            ImperativeTypedModel key = entry.getKey();
            if (!this.modelElementsMap.containsKey(key)) continue;
            List<EObject> elements = this.modelElementsMap.get(key);
            assert (elements != null);
            for (EObject e : elements) {
                if (e.eContainer() != null) continue;
                model.getContents().add((Object)e);
            }
        }
    }

    public void saveModels() {
        Map saveOptions = XMIUtil.createSaveOptions();
        saveOptions.put("SCHEMA_LOCATION_IMPLEMENTATION", Boolean.TRUE);
        this.saveModels(saveOptions);
    }

    public void saveModels(@Nullable Map<?, ?> savingOptions) {
        this.saveContents();
        for (Map.Entry<ImperativeTypedModel, Resource> entry : this.modelResourceMap.entrySet()) {
            Resource model = entry.getValue();
            ImperativeTypedModel key = entry.getKey();
            if (!this.modelElementsMap.containsKey(key)) continue;
            try {
                model.save(savingOptions);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveMiddleModel(@NonNull URI uri) {
        this.saveMiddleModel(uri, null);
    }

    public void saveMiddleModel(@NonNull URI uri, Map<?, ?> savingOptions) {
    }

    public void setUnnavigableOpposite(@NonNull Integer cacheIndex, @NonNull Object targetObject, Object sourceObject) {
        this.unnavigableOpposites[cacheIndex].put(sourceObject, targetObject);
    }

    public @NonNull EClass eClass(@NonNull Object object) {
        return ((EObject)object).eClass();
    }

    public @NonNull TransformationInstance getTransformationInstance(@NonNull ImperativeTransformation transformation) {
        Object transformationInstance2 = this.transformationInstance;
        if (transformationInstance2 == null) {
            this.transformationInstance = transformationInstance2 = new QVTiTransformationInstance(this, transformation);
        }
        return transformationInstance2;
    }

    public @NonNull TypedModelInstance getTypedModelInstance(@NonNull ImperativeTypedModel typedModel) {
        Object typedModelInstance;
        if (this.typedModel2typedModelInstance == null) {
            this.typedModel2typedModelInstance = new HashMap<ImperativeTypedModel, TypedModelInstance>();
        }
        if ((typedModelInstance = this.typedModel2typedModelInstance.get(typedModel)) == null) {
            typedModelInstance = new QVTiTypedModelInstance(this, typedModel);
            this.typedModel2typedModelInstance.put(typedModel, (TypedModelInstance)typedModelInstance);
        }
        return typedModelInstance;
    }

    public static class QVTiTransformationInstance
    extends AbstractTransformationInstance {
        protected final @NonNull QVTiModelsManager modelManager;
        protected final @NonNull ImperativeTransformation transformation;

        public QVTiTransformationInstance(@NonNull QVTiModelsManager modelManager, @NonNull ImperativeTransformation transformation) {
            this.modelManager = modelManager;
            this.transformation = transformation;
        }

        public @NonNull QVTiModelsManager getModelManager() {
            return this.modelManager;
        }

        public @Nullable String getName() {
            return this.transformation.getName();
        }

        public @NonNull ImperativeTransformation getTransformation() {
            return this.transformation;
        }
    }

    public static class QVTiTypedModelInstance
    extends AbstractTypedModelInstance {
        protected final @NonNull QVTiModelsManager modelManager;
        protected final @NonNull ImperativeTypedModel typedModel;
        private Map<@NonNull Type, @NonNull List<@NonNull Object>> kind2instances = null;
        private Map<@NonNull Type, @NonNull List<@NonNull Object>> type2instances = null;

        public QVTiTypedModelInstance(@NonNull QVTiModelsManager modelManager, @NonNull ImperativeTypedModel typedModel) {
            this.modelManager = modelManager;
            this.typedModel = typedModel;
        }

        public @NonNull Iterable<@NonNull Object> getAllObjects() {
            throw new UnsupportedOperationException();
        }

        public @Nullable String getName() {
            return this.typedModel.getName();
        }

        public @NonNull Iterable<@NonNull Object> getObjectsOfKind(@NonNull Class type) {
            List<Object> elements;
            if (this.kind2instances == null) {
                this.kind2instances = new HashMap<Type, List<Object>>();
            }
            if ((elements = this.kind2instances.get(type)) == null) {
                elements = this.modelManager.getElementsByType(this.typedModel, (Type)type);
                this.kind2instances.put((Type)type, elements);
            }
            return elements;
        }

        public @NonNull List<@NonNull Object> getObjectsOfType(@NonNull Class type) {
            List<Object> elements;
            if (this.type2instances == null) {
                this.type2instances = new HashMap<Type, List<Object>>();
            }
            if ((elements = this.type2instances.get(type)) == null) {
                elements = new ArrayList<Object>();
                this.type2instances.put((Type)type, elements);
                EObject eClass = type.getESObject();
                for (Object eObject : this.getObjectsOfKind(type)) {
                    if (this.modelManager.eClass(eObject) != eClass) continue;
                    elements.add(eObject);
                }
            }
            return elements;
        }

        public @NonNull QVTiModelsManager getModelManager() {
            return this.modelManager;
        }

        public @NonNull Collection<@NonNull ? extends Object> getRootObjects() {
            Resource resource = this.modelManager.getModel(this.typedModel);
            if (resource != null) {
                return resource.getContents();
            }
            return Collections.emptyList();
        }

        public @NonNull ImperativeTypedModel getTypedModel() {
            return this.typedModel;
        }
    }
}

