/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.EnumLiteralExp;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.IterateExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.IteratorExp;
import org.eclipse.ocl.pivot.IteratorVariable;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.LetVariable;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.PrimitiveLiteralExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.ResultVariable;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.AbstractRegion2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.CheckedConditionWeightComparator;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.NavigationEdgeSorter;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTiVisitor;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CheckedConditionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.util.AbstractExtendingQVTbaseVisitor;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.CheckStatement;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionVariable;
import org.eclipse.qvtd.pivot.qvtimperative.DeclareStatement;
import org.eclipse.qvtd.pivot.qvtimperative.GuardParameter;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.LoopVariable;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameter;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.NewStatement;
import org.eclipse.qvtd.pivot.qvtimperative.ObservableStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SetStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SimpleParameter;
import org.eclipse.qvtd.pivot.qvtimperative.Statement;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeHelper;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.BooleanLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.ExpressionEdge;
import org.eclipse.qvtd.pivot.qvtschedule.IfNode;
import org.eclipse.qvtd.pivot.qvtschedule.KeyPartEdge;
import org.eclipse.qvtd.pivot.qvtschedule.KeyedValueNode;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.NullLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.NumericLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.OperationCallNode;
import org.eclipse.qvtd.pivot.qvtschedule.OperationNode;
import org.eclipse.qvtd.pivot.qvtschedule.PredicateEdge;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.StringLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessEdge;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.pivot.qvttemplate.CollectionTemplateExp;

public class BasicRegion2Mapping
extends AbstractRegion2Mapping {
    protected final @NonNull RegionAnalysis regionAnalysis;
    private @Nullable Map<@NonNull Node, @NonNull Set<@NonNull Node>> node2precedingNodeClosure = null;
    private final @NonNull Map<@NonNull OperationNode, @NonNull Subexpression> resultNode2subexpression;
    private final @NonNull Map<@NonNull Node, @NonNull Subexpression> node2subexpression = new HashMap<Node, Subexpression>();
    private final @NonNull Map<@NonNull Edge, @NonNull Subexpression> edge2subexpression = new HashMap<Edge, Subexpression>();
    private final @NonNull List<@NonNull Node> headNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull Node> guardNodes = new ArrayList<Node>();
    private final @NonNull Map<@NonNull Node, @NonNull VariableDeclaration> node2variable = new HashMap<Node, VariableDeclaration>();
    private final @NonNull ReachabilityForest reachabilityForest;
    private final @NonNull CheckedConditionAnalysis checkedConditionAnalysis;

    public BasicRegion2Mapping(@NonNull QVTs2QVTiVisitor visitor, @NonNull RegionAnalysis regionAnalysis) {
        super(visitor, (Region)regionAnalysis.getRegion());
        this.regionAnalysis = regionAnalysis;
        this.reachabilityForest = new ReachabilityForest(this.getReachabilityRootNodes(), this.getAvailableNavigableEdges());
        String name = this.region.getName();
        if (name.contains("mapHelper_Attribute_qvtr")) {
            this.getClass();
        }
        this.checkedConditionAnalysis = new CheckedConditionAnalysis(regionAnalysis, this.reachabilityForest);
        this.resultNode2subexpression = this.computeSubexpressions();
        Set<@NonNull OperationNode> subexpressionResults = this.resultNode2subexpression.keySet();
        for (Subexpression subexpression : this.resultNode2subexpression.values()) {
            subexpression.analyze(subexpressionResults);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Iterable<@NonNull Node> getReachabilityRootNodes() {
        @NonNull ArrayList zeroCostNodes = Lists.newArrayList((Iterable)QVTscheduleUtil.getHeadNodes((Region)this.region));
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.region)) {
            if (!node.isOperation() || !node.isConstant()) continue;
            boolean hasNoComputationInputs = true;
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                if (!edge.isComputation()) continue;
                hasNoComputationInputs = false;
                break;
            }
            if (!hasNoComputationInputs) continue;
            zeroCostNodes.add(node);
        }
        return zeroCostNodes;
    }

    protected @NonNull Iterable<@NonNull NavigableEdge> getAvailableNavigableEdges() {
        HashSet<@NonNull NavigableEdge> oldEdges = new HashSet<NavigableEdge>();
        for (Edge edge : QVTscheduleUtil.getOwnedEdges((Region)this.region)) {
            if (!edge.isOld() || !edge.isCast() && !edge.isNavigation()) continue;
            Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge);
            Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
            if (!sourceNode.isOld() || !targetNode.isOld()) continue;
            oldEdges.add((NavigableEdge)edge);
        }
        return oldEdges;
    }

    public void addVariable(@NonNull Node node, @NonNull VariableDeclaration variableDeclaration) {
        VariableDeclaration oldVariableDeclaration = this.node2variable.put(node, variableDeclaration);
    }

    public @Nullable VariableDeclaration basicGetVariable(@NonNull Node node) {
        return this.node2variable.get(node);
    }

    private @NonNull Map<@NonNull OperationNode, @NonNull Subexpression> computeSubexpressions() {
        HashMap<@NonNull OperationNode, @NonNull Subexpression> resultNode2subexpression = new HashMap<OperationNode, Subexpression>();
        block0: for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.region)) {
            if (!node.isOperation() || !node.isUnconditional() || node.isPrimitive()) continue;
            OperationNode resultNode = (OperationNode)node;
            Edge firstEdge = null;
            boolean isSubexpression = false;
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                Node edgeSource;
                if (!edge.isNew() || edge.isSecondary() || !(edgeSource = edge.getSourceNode()).isPattern()) continue;
                resultNode2subexpression.put(resultNode, new Subexpression(resultNode));
                isSubexpression = true;
                break;
            }
            if (isSubexpression) continue;
            for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
                Node edgeTarget = edge.getTargetNode();
                if (edgeTarget.isPattern()) {
                    resultNode2subexpression.put(resultNode, new Subexpression(resultNode));
                    continue block0;
                }
                if (firstEdge == null) {
                    firstEdge = edge;
                    continue;
                }
                resultNode2subexpression.put(resultNode, new Subexpression(resultNode));
                continue block0;
            }
        }
        return resultNode2subexpression;
    }

    private void createAddStatements() {
        if (this.connection2variable != null) {
            for (NodeConnection connection : this.connection2variable.keySet()) {
                Node sourceNode = connection.getSource(this.region);
                OCLExpression variableExpression = this.createVariableExp(sourceNode);
                ConnectionVariable connectionVariable = (ConnectionVariable)this.connection2variable.get(connection);
                assert (connectionVariable != null);
                this.createAddStatement(connectionVariable, variableExpression);
            }
        }
    }

    private void createCallStatements(@NonNull Map<@NonNull Region, @NonNull Map<@NonNull Node, @NonNull Node>> calls) {
        ArrayList<@NonNull MappingCall> mappingStatements = new ArrayList<MappingCall>();
        HashMap<@NonNull LoopVariable, @NonNull OCLExpression> loopVariables = null;
        for (Map.Entry<Region, Map<Node, Node>> entry : calls.entrySet()) {
            @NonNull Region calledRegion = entry.getKey();
            AbstractRegion2Mapping calledRegion2Mapping = this.visitor.getRegion2Mapping(calledRegion);
            ArrayList<@NonNull MappingParameterBinding> mappingParameterBindings = new ArrayList<MappingParameterBinding>();
            for (Map.Entry<Node, Node> entry2 : entry.getValue().entrySet()) {
                @NonNull Node sourceNode = entry2.getKey();
                @NonNull Node targetNode = entry2.getValue();
                OCLExpression sourceExpression = this.createVariableExp(sourceNode);
                Type type = sourceExpression.getType();
                if (type instanceof CollectionType) {
                    if (loopVariables == null) {
                        loopVariables = new HashMap<LoopVariable, OCLExpression>();
                    }
                    Type elementType = ((CollectionType)type).getElementType();
                    assert (elementType != null);
                    LoopVariable loopVariable = this.helper.createLoopVariable(this.getSafeName("loop" + loopVariables.size()), elementType);
                    loopVariables.put(loopVariable, sourceExpression);
                    MappingParameter guardVariable = calledRegion2Mapping.getGuardVariable(targetNode);
                    mappingParameterBindings.add((MappingParameterBinding)this.helper.createLoopParameterBinding((GuardParameter)guardVariable, loopVariable));
                    continue;
                }
                MappingParameter guardVariable = calledRegion2Mapping.getGuardVariable(targetNode);
                mappingParameterBindings.add((MappingParameterBinding)this.helper.createSimpleParameterBinding((SimpleParameter)guardVariable, sourceExpression));
            }
            Collections.sort(mappingParameterBindings, QVTimperativeUtil.MappingParameterBindingComparator.INSTANCE);
            MappingCall mappingCallStatement = calledRegion2Mapping.createMappingCall(mappingParameterBindings);
            if (loopVariables != null) {
                for (Map.Entry loopEntry : loopVariables.entrySet()) {
                    @NonNull LoopVariable loopVariable = (LoopVariable)loopEntry.getKey();
                    @NonNull OCLExpression loopSource = (OCLExpression)loopEntry.getValue();
                    mappingCallStatement = this.helper.createMappingLoop(loopSource, loopVariable, (MappingStatement)mappingCallStatement);
                }
            }
            mappingStatements.add(mappingCallStatement);
        }
        this.mapping.getOwnedStatements().addAll(mappingStatements);
    }

    private @NonNull CheckStatement createCheckStatement(@NonNull OCLExpression booleanExpression) {
        CheckStatement checkStatement = this.helper.createCheckStatement(booleanExpression);
        this.mapping.getOwnedStatements().add((Object)checkStatement);
        return checkStatement;
    }

    private @NonNull CheckStatement createCheckStatement(@NonNull OCLExpression firstExpression, @NonNull String operatorName, @NonNull OCLExpression secondExpression) {
        OperationCallExp booleanExpression = this.helper.createOperationCallExp(firstExpression, operatorName, new OCLExpression[]{secondExpression});
        CheckStatement checkStatement = this.createCheckStatement((OCLExpression)booleanExpression);
        return checkStatement;
    }

    private @NonNull DeclareStatement createCheckedDeclareStatement(@NonNull String name, @NonNull OCLExpression sourceExp, @NonNull Type requiredType) {
        String safeName = this.getSafeName(name);
        DeclareStatement castStatement = this.helper.createDeclareStatement(safeName, requiredType, true, sourceExp);
        this.mapping.getOwnedStatements().add((Object)castStatement);
        return castStatement;
    }

    private void createClassSetStatement(@NonNull NavigableEdge edge) {
        boolean isPartial;
        OCLExpression targetVariableExp;
        Property setProperty;
        VariableDeclaration slotVariable;
        Node sourceNode = edge.getEdgeSource();
        Node targetNode = edge.getEdgeTarget();
        Property property = QVTscheduleUtil.getProperty((NavigableEdge)edge);
        boolean isNotify = this.isHazardousWrite(edge);
        if (property.isIsImplicit()) {
            slotVariable = this.getVariable(targetNode);
            setProperty = QVTrelationUtil.getOpposite((Property)property);
            targetVariableExp = this.createVariableExp(sourceNode);
            isPartial = setProperty.isIsMany();
        } else {
            slotVariable = this.getVariable(sourceNode);
            setProperty = property;
            targetVariableExp = this.createVariableExp(targetNode);
            isPartial = edge.isPartial();
        }
        SetStatement setStatement = this.helper.createSetStatement(slotVariable, setProperty, targetVariableExp, isPartial, isNotify);
        this.mapping.getOwnedStatements().add((Object)setStatement);
    }

    private @NonNull DeclareStatement createDeclareStatement(@NonNull Node node, @NonNull OCLExpression initExpression) {
        boolean isRequired;
        Class variableType = node.getCompleteClass().getPrimaryClass();
        assert (variableType != null);
        boolean bl = isRequired = node.isMatched() && node.isRequired();
        if (initExpression.isIsRequired()) {
            isRequired = true;
        }
        String safeName = this.getSafeName(node);
        DeclareStatement newVariable = this.helper.createDeclareStatement(safeName, (Type)variableType, isRequired, initExpression);
        this.mapping.getOwnedStatements().add((Object)newVariable);
        VariableDeclaration oldVariable = this.node2variable.put(node, (VariableDeclaration)newVariable);
        assert (oldVariable == null);
        return newVariable;
    }

    private @NonNull GuardParameter createGuardParameter(@NonNull Node guardNode) {
        Node localSuccessNode;
        NavigableEdge localSuccessEdge;
        Property localSuccessProperty;
        Node globalSuccessNode;
        NavigableEdge globalSuccessEdge;
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)guardNode);
        Class variableType = guardNode.getCompleteClass().getPrimaryClass();
        ImperativeTypedModel iTypedModel = (ImperativeTypedModel)ClassUtil.nonNullState((Object)this.visitor.getQVTiTypedModel(classDatum.getReferredTypedModel()));
        GuardParameter guardParameter = this.helper.createGuardParameter(this.getSafeName(guardNode), iTypedModel, (Type)variableType, true);
        Property successProperty = null;
        Property globalSuccessProperty = this.scheduleManager.basicGetGlobalSuccessProperty(guardNode);
        if (globalSuccessProperty != null && (globalSuccessEdge = guardNode.getNavigableEdge(globalSuccessProperty)) != null && (globalSuccessNode = QVTscheduleUtil.getTargetNode((Edge)globalSuccessEdge)).isSuccess()) {
            assert (globalSuccessEdge.isRealized());
            successProperty = globalSuccessProperty;
        }
        if ((localSuccessProperty = this.scheduleManager.basicGetLocalSuccessProperty(guardNode)) != null && (localSuccessEdge = guardNode.getNavigableEdge(localSuccessProperty)) != null && (localSuccessNode = QVTscheduleUtil.getTargetNode((Edge)localSuccessEdge)).isSuccess()) {
            assert (localSuccessEdge.isRealized());
            assert (successProperty == null);
            successProperty = localSuccessProperty;
        }
        if (successProperty != null) {
            guardParameter.setSuccessProperty(successProperty);
        }
        this.mapping.getOwnedMappingParameters().add((Object)guardParameter);
        VariableDeclaration oldVariable = this.node2variable.put(guardNode, (VariableDeclaration)guardParameter);
        assert (oldVariable == null);
        return guardParameter;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void createHeadAndGuardNodeVariables() {
        HashSet<@NonNull Region> headCallingRegions = new HashSet<Region>();
        @NonNull Iterable recursionEdges = this.region.getRecursionEdges();
        if (Iterables.size((Iterable)recursionEdges) > 0) {
            headCallingRegions.add(this.region);
        }
        for (Node headNode : QVTscheduleUtil.getHeadNodes((Region)this.region)) {
            if (headNode.isDependency()) continue;
            Node bestHeadNode = null;
            @NonNull Iterable callingSources = headNode.getPassedBindingSources();
            if (!Iterables.isEmpty((Iterable)callingSources)) {
                bestHeadNode = headNode;
            }
            for (Node callingSource : callingSources) {
                headCallingRegions.add(QVTscheduleUtil.getOwningRegion((Node)callingSource));
            }
            if (bestHeadNode != null) {
                this.headNodes.add(bestHeadNode);
                continue;
            }
            this.visitor.addProblem(CompilerUtil.createRegionError(this.region, "No best head", new Object[0]));
        }
        this.guardNodes.addAll(this.headNodes);
        Collections.sort(this.guardNodes, NameUtil.NAMEABLE_COMPARATOR);
        for (Node guardNode : this.guardNodes) {
            if (guardNode.isDependency()) continue;
            this.createGuardParameter(guardNode);
        }
        this.createAppendParameters();
    }

    private void createObservedProperties() {
        Set<@NonNull Property> allCheckedProperties = this.checkedConditionAnalysis.getAllCheckedProperties();
        if (!allCheckedProperties.isEmpty()) {
            for (Statement asStatement : this.mapping.getOwnedStatements()) {
                if (!(asStatement instanceof ObservableStatement)) continue;
                EList observedProperties = ((ObservableStatement)asStatement).getObservedProperties();
                for (EObject eObject : new TreeIterable((EObject)asStatement, false)) {
                    Property property;
                    if (eObject instanceof PropertyCallExp) {
                        property = PivotUtil.getReferredProperty((NavigationCallExp)((PropertyCallExp)eObject));
                        if (!allCheckedProperties.contains(property) || observedProperties.contains(property)) continue;
                        observedProperties.add(property);
                        continue;
                    }
                    if (!(eObject instanceof OppositePropertyCallExp) || !allCheckedProperties.contains(property = PivotUtil.getReferredProperty((NavigationCallExp)((NavigationCallExp)eObject)).getOpposite()) || observedProperties.contains(property)) continue;
                    observedProperties.add(property);
                }
            }
        }
    }

    public <T extends Operation> @NonNull T createOperation(@NonNull T operation) {
        Operation newOperation = this.visitor.create(operation);
        assert (newOperation != null);
        return (T)newOperation;
    }

    private void createPatternMatch() {
        if (this.mapping.isIsAbstract()) {
            OldEdgeSchedule oldSchedule = new OldEdgeSchedule();
            Iterable<@NonNull CheckedCondition> checkedConditions = oldSchedule.analyze();
            oldSchedule.synthesize(checkedConditions);
        } else {
            OldEdgeSchedule oldSchedule = new OldEdgeSchedule();
            Iterable<@NonNull CheckedCondition> checkedConditions = oldSchedule.analyze();
            oldSchedule.synthesize(checkedConditions);
        }
    }

    private void createPropertyAssignments() {
        HashMap<@NonNull Node, @NonNull ArrayList<@NonNull NavigableEdge>> classAssignments = null;
        Iterable<@NonNull NavigableEdge> sortedEdges = NavigationEdgeSorter.getSortedAssignments(this.region.getRealizedNavigationEdges());
        for (NavigableEdge edge : sortedEdges) {
            ArrayList<NavigableEdge> edges;
            Node sourceNode = edge.getEdgeSource();
            Node targetNode = edge.getEdgeTarget();
            if (targetNode.isSuccess()) continue;
            if (targetNode.isDataType()) {
                VariableDeclaration asVariable = this.getVariable(sourceNode);
                Property property = QVTscheduleUtil.getProperty((NavigableEdge)edge);
                ExpressionCreator expressionCreator = new ExpressionCreator(this);
                OCLExpression valueExp = expressionCreator.getExpression(targetNode);
                if (valueExp == null) {
                    ExpressionCreator expressionCreator2 = new ExpressionCreator(this);
                    valueExp = expressionCreator2.getExpression(targetNode);
                }
                if (valueExp != null) {
                    boolean isNotify = this.isHazardousWrite(edge);
                    SetStatement setStatement = this.helper.createSetStatement(asVariable, property, valueExp, edge.isPartial(), isNotify);
                    this.mapping.getOwnedStatements().add((Object)setStatement);
                    continue;
                }
                System.err.println("No assignment in " + this + " to " + asVariable + "." + property);
                continue;
            }
            if (classAssignments == null) {
                classAssignments = new HashMap<Node, ArrayList<NavigableEdge>>();
            }
            if ((edges = (ArrayList<NavigableEdge>)classAssignments.get(sourceNode)) == null) {
                edges = new ArrayList<NavigableEdge>();
                classAssignments.put(sourceNode, edges);
            }
            edges.add(edge);
        }
        if (classAssignments != null) {
            this.pruneClassAssignments(classAssignments);
            HashSet<@NonNull E> classAssignmentEdges = new HashSet();
            for (List values : classAssignments.values()) {
                classAssignmentEdges.addAll(values);
            }
            for (NavigableEdge edge : sortedEdges) {
                if (!classAssignmentEdges.contains(edge)) continue;
                this.createClassSetStatement(edge);
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void createRealizedVariables() {
        @NonNull ArrayList sortedNodes = Lists.newArrayList((Iterable)this.region.getNewNodes());
        Collections.sort(sortedNodes, NameUtil.NAMEABLE_COMPARATOR);
        for (Node newNode : sortedNodes) {
            if (!newNode.isClass()) continue;
            ExpressionCreator expressionCreator = new ExpressionCreator(this);
            OCLExpression constructor = null;
            if (newNode.isOperation()) {
                if (newNode instanceof KeyedValueNode) {
                    KeyedValueNode keyedValueNode = (KeyedValueNode)newNode;
                    ClassDatum classDatum = keyedValueNode.getClassDatumValue();
                    assert (classDatum != null);
                    Function function = this.visitor.getKeyFunction(classDatum);
                    VariableExp thisExp = this.helper.createVariableExp((VariableDeclaration)QVTimperativeUtil.getContextVariable((StandardLibrary)this.scheduleManager.getStandardLibrary(), (Transformation)this.getTransformation()));
                    HashMap<@NonNull PropertyDatum, @NonNull VariableExp> propertyDatum2expression = new HashMap<PropertyDatum, VariableExp>();
                    for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)newNode)) {
                        if (!(edge instanceof KeyPartEdge)) continue;
                        KeyPartEdge keyPartEdge = (KeyPartEdge)edge;
                        PropertyDatum propertyDatum = QVTscheduleUtil.getReferredPart((KeyPartEdge)keyPartEdge);
                        VariableExp subexpressionNode = this.getSubexpressionVariableExp(QVTscheduleUtil.getSourceNode((Edge)edge));
                        propertyDatum2expression.put(propertyDatum, subexpressionNode);
                    }
                    ArrayList<@NonNull OCLExpression> asArguments = new ArrayList<OCLExpression>();
                    for (PropertyDatum propertyDatum : QVTscheduleUtil.getOwnedPropertyDatums((ClassDatum)classDatum)) {
                        if (!propertyDatum.isKey()) continue;
                        OCLExpression asArgument = (OCLExpression)propertyDatum2expression.get(propertyDatum);
                        if (asArgument == null) {
                            asArgument = this.helper.createInvalidExpression();
                        }
                        asArguments.add(asArgument);
                    }
                    constructor = this.helper.createOperationCallExp((OCLExpression)thisExp, (Operation)function, asArguments);
                }
                if (constructor == null) {
                    constructor = (OCLExpression)((OperationCallExp)newNode.getOriginatingElement()).accept((Visitor)expressionCreator);
                }
            }
            ClassDatum classDatum = newNode.getClassDatum();
            TypedModel pTypedModel = classDatum.getReferredTypedModel();
            ImperativeTypedModel iTypedModel = (ImperativeTypedModel)ClassUtil.nonNullState((Object)this.visitor.getQVTiTypedModel(pTypedModel));
            NewStatement newStatement = this.helper.createNewStatement(this.getSafeName(newNode), iTypedModel, (Type)classDatum.getCompleteClass().getPrimaryClass());
            newStatement.setOwnedExpression(constructor);
            newStatement.setIsContained(newNode.isContained());
            this.mapping.getOwnedStatements().add((Object)newStatement);
            VariableDeclaration oldVariable = this.node2variable.put(newNode, (VariableDeclaration)newStatement);
            assert (oldVariable == null);
        }
    }

    private @NonNull OCLExpression createVariableExp(@NonNull Node node) {
        if (node.isNullLiteral()) {
            return this.helper.createNullLiteralExp();
        }
        VariableDeclaration variable = this.getVariable(node);
        return PivotUtil.createVariableExp((VariableDeclaration)variable);
    }

    @Override
    public @NonNull List<@NonNull Node> getGuardNodes() {
        return this.guardNodes;
    }

    @Override
    public @NonNull MappingParameter getGuardVariable(@NonNull Node node) {
        VariableDeclaration variable = this.node2variable.get(node);
        assert (variable != null);
        return (MappingParameter)variable;
    }

    public @NonNull QVTimperativeHelper getHelper() {
        return this.helper;
    }

    public @NonNull Set<@NonNull Node> getPrecedingNodes(@NonNull Node targetNode) {
        Set<Node> precedingNodes;
        Map<@NonNull Node, @NonNull Set<@NonNull Node>> node2precedingNodeClosure2 = this.node2precedingNodeClosure;
        if (node2precedingNodeClosure2 == null) {
            this.node2precedingNodeClosure = node2precedingNodeClosure2 = new HashMap<Node, Set<Node>>();
        }
        if ((precedingNodes = node2precedingNodeClosure2.get(targetNode)) == null) {
            precedingNodes = new HashSet<Node>();
            node2precedingNodeClosure2.put(targetNode, precedingNodes);
            precedingNodes.add(targetNode);
            for (Node sourceNode : this.reachabilityForest.getPredecessors(targetNode)) {
                precedingNodes.addAll(this.getPrecedingNodes(sourceNode));
            }
        }
        assert (precedingNodes.size() > 0);
        return precedingNodes;
    }

    private @NonNull VariableDeclaration getSubexpressionDeclaration(@NonNull Node node) {
        VariableDeclaration variable = this.node2variable.get(node);
        if (variable == null) {
            ExpressionCreator expressionCreator = new ExpressionCreator(this);
            ExpressionCreator inlineExpressionCreator = expressionCreator.getInlineExpressionCreator();
            OCLExpression targetExpression = inlineExpressionCreator.getExpression(node);
            assert (targetExpression != null);
            variable = this.createDeclareStatement(node, targetExpression);
        }
        return variable;
    }

    private @NonNull VariableExp getSubexpressionVariableExp(@NonNull Node node) {
        return this.helper.createVariableExp(this.getSubexpressionDeclaration(node));
    }

    public @NonNull Transformation getTransformation() {
        return this.visitor.getTransformation();
    }

    protected @NonNull VariableDeclaration getVariable(@NonNull Node node) {
        return this.getSubexpressionDeclaration(node);
    }

    private boolean isHazardousWrite(@NonNull NavigableEdge edge) {
        Node sourceNode = edge.getEdgeSource();
        Property asProperty = QVTscheduleUtil.getProperty((NavigableEdge)edge);
        TypedModel typedModel = QVTscheduleUtil.getTypedModel((Node)sourceNode);
        Iterable<@NonNull NavigableEdge> enforcedEdges = this.regionAnalysis.getEnforcedEdges(typedModel, asProperty);
        return enforcedEdges != null;
    }

    @Override
    public boolean isInfinite() {
        return this.region.getRecursionEdges().iterator().hasNext();
    }

    private void pruneClassAssignments(@NonNull Map<@NonNull Node, @NonNull List<@NonNull NavigableEdge>> classAssignments) {
        for (Node sourceNode : new ArrayList<Node>(classAssignments.keySet())) {
            List<@NonNull NavigableEdge> forwardEdges = classAssignments.get(sourceNode);
            assert (forwardEdges != null);
            int iForward = forwardEdges.size() - 1;
            while (iForward >= 0) {
                NavigableEdge forwardEdge = forwardEdges.get(iForward);
                Node targetNode = forwardEdge.getEdgeTarget();
                List<@NonNull NavigableEdge> reverseEdges = classAssignments.get(targetNode);
                if (reverseEdges != null) {
                    int iReverse = reverseEdges.size() - 1;
                    while (iReverse >= 0) {
                        NavigableEdge reverseEdge = reverseEdges.get(iReverse);
                        if (sourceNode == reverseEdge.getEdgeTarget()) {
                            Property forwardProperty = forwardEdge.getProperty();
                            Property reverseProperty = reverseEdge.getProperty();
                            if (forwardProperty.getOpposite() == reverseProperty) {
                                if (forwardProperty.isIsImplicit()) {
                                    forwardEdges.remove(forwardEdge);
                                } else if (reverseProperty.isIsImplicit()) {
                                    reverseEdges.remove(reverseEdge);
                                } else if (sourceNode.isDependency()) {
                                    forwardEdges.remove(forwardEdge);
                                } else if (targetNode.isDependency()) {
                                    reverseEdges.remove(reverseEdge);
                                } else {
                                    reverseEdges.remove(reverseEdge);
                                }
                            }
                        }
                        --iReverse;
                    }
                }
                --iForward;
            }
        }
    }

    @Override
    public void synthesizeCallStatements() {
        HashMap<@NonNull Region, @NonNull HashMap<@NonNull K, @NonNull V>> calls = null;
        for (Region calledRegion : this.region.getCallableChildren()) {
            HashMap<Node, Node> source2target;
            if (calls == null) {
                calls = new HashMap();
            }
            if ((source2target = (HashMap<Node, Node>)calls.get(calledRegion)) == null) {
                source2target = new HashMap<Node, Node>();
                calls.put(calledRegion, source2target);
            }
            AbstractRegion2Mapping calledRegion2Mapping = this.visitor.getRegion2Mapping(calledRegion);
            for (Node calledGuardNode : calledRegion2Mapping.getGuardNodes()) {
                Node oldNode;
                for (Node callingNode : calledGuardNode.getPassedBindingSources()) {
                    if (callingNode.getOwningRegion() != this.region) continue;
                    oldNode = source2target.put(callingNode, calledGuardNode);
                    assert (oldNode == null);
                }
                for (Node callingNode : calledGuardNode.getUsedBindingSources()) {
                    if (callingNode.getOwningRegion() != this.region) continue;
                    oldNode = source2target.put(callingNode, calledGuardNode);
                    assert (oldNode == null);
                }
            }
        }
        if (calls != null) {
            this.createCallStatements(calls);
        }
    }

    @Override
    public void synthesizeLocalStatements() {
        String name = this.region.getName();
        if (name.contains("mapHelper_Attribute_qvtr")) {
            this.getClass();
        }
        this.createHeadAndGuardNodeVariables();
        this.createPatternMatch();
        this.createRealizedVariables();
        this.createPropertyAssignments();
        this.createAddStatements();
        this.createObservedProperties();
    }

    @Override
    public @NonNull String toString() {
        return String.valueOf(this.region);
    }

    private static class ExpressionCreator
    extends AbstractExtendingQVTbaseVisitor<OCLExpression, BasicRegion2Mapping> {
        protected final @NonNull QVTimperativeHelper helper;
        protected final @NonNull Set<@NonNull Node> multiAccessedNodes = new HashSet<Node>();
        protected final @NonNull Set<@NonNull Node> conditionalNodes = new HashSet<Node>();
        private ExpressionCreator inlineExpressionCreator = null;

        public ExpressionCreator(@NonNull BasicRegion2Mapping context) {
            super((Object)context);
            this.helper = context.getHelper();
            this.analyzeExpressions(this.multiAccessedNodes, this.conditionalNodes);
        }

        private void analyzeExpressions(@NonNull Set<Node> multiAccessedNodes, @NonNull Set<Node> conditionalNodes) {
            HashSet<@NonNull Node> unconditionalNodes = new HashSet<Node>();
            for (Edge edge : ((BasicRegion2Mapping)this.context).getRegion().getRealizedEdges()) {
                this.analyzeIncomingPath(edge.getEdgeTarget(), unconditionalNodes, conditionalNodes, false);
            }
            conditionalNodes.removeAll(unconditionalNodes);
            for (Node node : unconditionalNodes) {
                int accesses = 0;
                for (Edge outgoingEdge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
                    if (!outgoingEdge.isCast() && !outgoingEdge.isNavigation() && !outgoingEdge.isComputation()) continue;
                    ++accesses;
                }
                if (accesses <= true) continue;
                multiAccessedNodes.add(node);
            }
        }

        private void analyzeIncomingPath(@NonNull Node node, @NonNull Set<Node> unconditionalNodes, @NonNull Set<Node> conditionalNodes, boolean isConditional) {
            if ((isConditional ? conditionalNodes : unconditionalNodes).add(node)) {
                boolean isIf = node instanceof IfNode;
                for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                    if (edge.isComputation()) {
                        boolean isIfThenOrElse = isIf && ("then".equals(edge.getName()) || "else".equals(edge.getName()));
                        this.analyzeIncomingPath(edge.getEdgeSource(), unconditionalNodes, conditionalNodes, isConditional || isIfThenOrElse);
                        continue;
                    }
                    if (!edge.isCast() && !edge.isNavigation()) continue;
                    this.analyzeIncomingPath(edge.getEdgeSource(), unconditionalNodes, conditionalNodes, isConditional);
                }
                return;
            }
        }

        protected @NonNull OCLExpression create(Node node) {
            if (node.isNullLiteral()) {
                return this.helper.createNullLiteralExp();
            }
            VariableDeclaration theVariable = ((BasicRegion2Mapping)this.context).basicGetVariable(node);
            if (theVariable == null) {
                Element originatingElement = node.getOriginatingElement();
                assert (originatingElement != null);
                OCLExpression initExpression = (OCLExpression)originatingElement.accept((Visitor)this);
                assert (initExpression != null);
                if (initExpression instanceof PrimitiveLiteralExp || this.hasRealizedVariableReference(initExpression) || this.conditionalNodes.contains(node)) {
                    return initExpression;
                }
                theVariable = ((BasicRegion2Mapping)this.context).createDeclareStatement(node, initExpression);
            }
            return PivotUtil.createVariableExp((VariableDeclaration)theVariable);
        }

        private @Nullable OCLExpression create(@Nullable OCLExpression oldTypedElement) {
            if (oldTypedElement == null) {
                return null;
            }
            Node node = ((BasicRegion2Mapping)this.context).getNode((Element)oldTypedElement);
            if (node == null) {
                node = ((BasicRegion2Mapping)this.context).getNode((Element)oldTypedElement);
            }
            if (node != null) {
                return this.create(node);
            }
            return (OCLExpression)oldTypedElement.accept((Visitor)this);
        }

        private @NonNull List<@NonNull OCLExpression> createAll(@NonNull List<@NonNull OCLExpression> oldTypedElements) {
            ArrayList<@NonNull OCLExpression> newTypedElements = new ArrayList<OCLExpression>(oldTypedElements.size());
            for (OCLExpression oldTypedElement : oldTypedElements) {
                OCLExpression newTypedElement = this.create(oldTypedElement);
                assert (newTypedElement != null);
                newTypedElements.add(newTypedElement);
            }
            return newTypedElements;
        }

        private @NonNull Variable createIteratorVariable(@NonNull Variable oldVariable) {
            String name = oldVariable.getName();
            assert (name != null);
            Type type = oldVariable.getType();
            assert (type != null);
            assert (oldVariable.getOwnedInit() == null);
            IteratorVariable newVariable = this.helper.createIteratorVariable(name, type, oldVariable.isIsRequired());
            Node variableNode = ((BasicRegion2Mapping)this.context).getNode((Element)oldVariable);
            if (variableNode != null) {
                ((BasicRegion2Mapping)this.context).addVariable(variableNode, (VariableDeclaration)newVariable);
            }
            return newVariable;
        }

        private @NonNull List<@NonNull Variable> createIteratorVariables(@NonNull List<@NonNull Variable> oldVariables) {
            ArrayList<@NonNull Variable> newVariables = new ArrayList<Variable>(oldVariables.size());
            for (Variable oldVariable : oldVariables) {
                Variable newVariable = this.createIteratorVariable(oldVariable);
                newVariables.add(newVariable);
            }
            return newVariables;
        }

        private @NonNull Variable createLetVariable(@NonNull Variable oldVariable) {
            String name = oldVariable.getName();
            assert (name != null);
            Type type = oldVariable.getType();
            assert (type != null);
            OCLExpression newInit = (OCLExpression)ClassUtil.nonNullState((Object)this.create(oldVariable.getOwnedInit()));
            LetVariable newVariable = this.helper.createLetVariable(name, type, oldVariable.isIsRequired(), newInit);
            Node variableNode = ((BasicRegion2Mapping)this.context).getNode((Element)oldVariable);
            if (variableNode != null) {
                ((BasicRegion2Mapping)this.context).addVariable(variableNode, (VariableDeclaration)newVariable);
            }
            return newVariable;
        }

        private @NonNull OCLExpression createNonNull(@Nullable OCLExpression oldTypedElement) {
            assert (oldTypedElement != null);
            Node node = ((BasicRegion2Mapping)this.context).getNode((Element)oldTypedElement);
            if (node == null) {
                node = ((BasicRegion2Mapping)this.context).getNode((Element)oldTypedElement);
            }
            return this.create(node);
        }

        private @Nullable OCLExpression createOperationCallExp(@NonNull OperationId operationId, @NonNull OperationNode operationNode) {
            OCLExpression asSourceExpression = null;
            ArrayList<@NonNull OCLExpression> asArgumentExpressions = new ArrayList<OCLExpression>();
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)operationNode)) {
                if (!(edge instanceof ExpressionEdge)) continue;
                Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge);
                OCLExpression asExpression = this.getExpression(sourceNode);
                assert (asExpression != null);
                if (asSourceExpression == null) {
                    asSourceExpression = asExpression;
                    continue;
                }
                asArgumentExpressions.add(asExpression);
            }
            assert (asSourceExpression != null);
            @NonNull OCLExpression[] asArguments = asArgumentExpressions.toArray(new OCLExpression[asArgumentExpressions.size()]);
            return this.helper.createOperationCallExp(asSourceExpression, operationId.getName(), asArguments);
        }

        private @NonNull Variable createResultVariable(@NonNull Variable oldVariable) {
            String name = oldVariable.getName();
            assert (name != null);
            Type type = oldVariable.getType();
            assert (type != null);
            OCLExpression newInit = (OCLExpression)ClassUtil.nonNullState((Object)this.create(oldVariable.getOwnedInit()));
            ResultVariable newVariable = this.helper.createResultVariable(name, type, oldVariable.isIsRequired(), newInit);
            Node variableNode = ((BasicRegion2Mapping)this.context).getNode((Element)oldVariable);
            if (variableNode != null) {
                ((BasicRegion2Mapping)this.context).addVariable(variableNode, (VariableDeclaration)newVariable);
            }
            return newVariable;
        }

        public @Nullable OCLExpression getExpression(@NonNull Node node) {
            VariableDeclaration variable = ((BasicRegion2Mapping)this.context).basicGetVariable(node);
            if (variable != null) {
                assert (!node.isNullLiteral());
                return PivotUtil.createVariableExp((VariableDeclaration)variable);
            }
            if (node.isOperation()) {
                Element originatingElement = node.basicGetOriginatingElement();
                if (originatingElement instanceof CollectionTemplateExp) {
                    OperationCallNode operationCallNode = (OperationCallNode)node;
                    Operation operation = operationCallNode.getReferredOperation();
                    return this.createOperationCallExp(operation.getOperationId(), (OperationNode)operationCallNode);
                }
                if (originatingElement != null) {
                    return (OCLExpression)originatingElement.accept((Visitor)this.getInlineExpressionCreator());
                }
                if (node instanceof BooleanLiteralNode) {
                    return this.helper.createBooleanLiteralExp(((BooleanLiteralNode)node).isBooleanValue());
                }
                if (node instanceof NullLiteralNode) {
                    return this.helper.createNullLiteralExp();
                }
                if (node instanceof NumericLiteralNode) {
                    Number numericValue = (Number)ClassUtil.nonNullState((Object)((NumericLiteralNode)node).getNumericValue());
                    if (numericValue instanceof Byte || numericValue instanceof Integer || numericValue instanceof Long || numericValue instanceof Short) {
                        return this.helper.createIntegerLiteralExp(numericValue);
                    }
                    return this.helper.createRealLiteralExp(numericValue);
                }
                if (node instanceof StringLiteralNode) {
                    return this.helper.createStringLiteralExp((String)ClassUtil.nonNullState((Object)((StringLiteralNode)node).getStringValue()));
                }
                throw new UnsupportedOperationException();
            }
            Iterator iterator = node.getArgumentEdges().iterator();
            if (iterator.hasNext()) {
                VariableDeclaration referredVariable;
                @NonNull Edge edge = (Edge)iterator.next();
                Node expNode = edge.getEdgeSource();
                OCLExpression clonedElement = this.create(expNode);
                if (clonedElement instanceof VariableExp && (referredVariable = ((VariableExp)clonedElement).getReferredVariable()) instanceof Variable) {
                    ((BasicRegion2Mapping)this.context).addVariable(node, referredVariable);
                }
                return clonedElement;
            }
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                OCLExpression source;
                if (!edge.isCast() && !edge.isNavigation()) continue;
                Role edgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
                if (edgeRole == Role.LOADED) {
                    source = this.getExpression(edge.getEdgeSource());
                    if (source == null) continue;
                    return this.helper.createNavigationCallExp(source, QVTscheduleUtil.getProperty((NavigableEdge)((NavigableEdge)edge)));
                }
                if (edgeRole != Role.PREDICATED) continue;
                source = this.create(edge.getEdgeSource());
                return this.helper.createNavigationCallExp(source, QVTscheduleUtil.getProperty((NavigableEdge)((NavigableEdge)edge)));
            }
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                if (!edge.isExpression()) continue;
                OCLExpression source = this.create(edge.getEdgeSource());
                return source;
            }
            return null;
        }

        public @NonNull ExpressionCreator getInlineExpressionCreator() {
            ExpressionCreator inlineExpressionCreator2 = this.inlineExpressionCreator;
            if (inlineExpressionCreator2 == null) {
                this.inlineExpressionCreator = inlineExpressionCreator2 = new InlineExpressionCreator((BasicRegion2Mapping)this.context);
            }
            return inlineExpressionCreator2;
        }

        private boolean hasRealizedVariableReference(@NonNull OCLExpression oclExpression) {
            TreeIterator tit = oclExpression.eAllContents();
            while (tit.hasNext()) {
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof VariableExp) || !(((VariableExp)eObject).getReferredVariable() instanceof NewStatement)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " " + ((BasicRegion2Mapping)this.context).getRegion();
        }

        public @NonNull OCLExpression visiting(@NonNull Visitable visitable) {
            throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
        }

        public @NonNull OCLExpression visitCollectionLiteralExp(@NonNull CollectionLiteralExp pCollectionLiteralExp) {
            ArrayList<@NonNull Object> clonedParts = new ArrayList<Object>();
            for (CollectionLiteralPart pPart : ClassUtil.nullFree((List)pCollectionLiteralExp.getOwnedParts())) {
                if (pPart instanceof CollectionItem) {
                    OCLExpression item = this.createNonNull(((CollectionItem)pPart).getOwnedItem());
                    clonedParts.add(this.helper.createCollectionItem(item));
                    continue;
                }
                CollectionRange pCollectionRange = (CollectionRange)pPart;
                OCLExpression first = this.createNonNull(pCollectionRange.getOwnedFirst());
                OCLExpression last = this.createNonNull(pCollectionRange.getOwnedLast());
                clonedParts.add(this.helper.createCollectionRange(first, last));
            }
            CollectionType collectionType = (CollectionType)pCollectionLiteralExp.getType();
            assert (collectionType != null);
            return this.helper.createCollectionLiteralExp(collectionType, clonedParts);
        }

        public @NonNull OCLExpression visitEnumLiteralExp(@NonNull EnumLiteralExp pEnumLiteralExp) {
            return (OCLExpression)EcoreUtil.copy((EObject)pEnumLiteralExp);
        }

        public @NonNull OCLExpression visitIfExp(@NonNull IfExp pIfExp) {
            MetamodelManager metamodelManager = this.helper.getEnvironmentFactory().getMetamodelManager();
            ExpressionCreator inlineExpressionCreator = this.getInlineExpressionCreator();
            return ((PivotMetamodelManager)metamodelManager).createIfExp(this.createNonNull(pIfExp.getOwnedCondition()), inlineExpressionCreator.createNonNull(pIfExp.getOwnedThen()), inlineExpressionCreator.createNonNull(pIfExp.getOwnedElse()));
        }

        public @NonNull OCLExpression visitIterateExp(@NonNull IterateExp pIterateExp) {
            OCLExpression iSource = this.create(pIterateExp.getOwnedSource());
            assert (iSource != null);
            List<@NonNull Variable> iIterators = this.createIteratorVariables(ClassUtil.nullFree((List)pIterateExp.getOwnedIterators()));
            Variable result = this.createResultVariable((Variable)ClassUtil.nonNull((Object)pIterateExp.getOwnedResult()));
            Iteration referredIteration = ((BasicRegion2Mapping)this.context).createOperation(QVTrelationUtil.getReferredIteration((LoopExp)pIterateExp));
            assert (referredIteration != null);
            OCLExpression iBody = this.getInlineExpressionCreator().create(pIterateExp.getOwnedBody());
            assert (iBody != null);
            return this.helper.createIterateExp(iSource, referredIteration, iIterators, result, iBody);
        }

        public @NonNull OCLExpression visitIteratorExp(@NonNull IteratorExp pIteratorExp) {
            OCLExpression iSource = this.create(pIteratorExp.getOwnedSource());
            assert (iSource != null);
            List<@NonNull Variable> iIterators = this.createIteratorVariables(ClassUtil.nullFree((List)pIteratorExp.getOwnedIterators()));
            Iteration referredIteration = ((BasicRegion2Mapping)this.context).createOperation(QVTrelationUtil.getReferredIteration((LoopExp)pIteratorExp));
            assert (referredIteration != null);
            OCLExpression iBody = this.getInlineExpressionCreator().create(pIteratorExp.getOwnedBody());
            assert (iBody != null);
            return this.helper.createIteratorExp(iSource, referredIteration, iIterators, iBody);
        }

        public @NonNull OCLExpression visitLetExp(@NonNull LetExp pLetExp) {
            Variable asVariable = this.createLetVariable((Variable)ClassUtil.nonNull((Object)pLetExp.getOwnedVariable()));
            OCLExpression asInExpression = this.create(pLetExp.getOwnedIn());
            assert (asInExpression != null);
            return this.helper.createLetExp(asVariable, asInExpression);
        }

        public @NonNull OCLExpression visitMapLiteralExp(@NonNull MapLiteralExp pMapLiteralExp) {
            ArrayList<@NonNull MapLiteralPart> clonedParts = new ArrayList<MapLiteralPart>();
            for (MapLiteralPart pPart : ClassUtil.nullFree((List)pMapLiteralExp.getOwnedParts())) {
                OCLExpression key = this.createNonNull(pPart.getOwnedKey());
                OCLExpression value = this.createNonNull(pPart.getOwnedValue());
                clonedParts.add(this.helper.createMapLiteralPart(key, value));
            }
            MapType mapType = (MapType)pMapLiteralExp.getType();
            assert (mapType != null);
            return this.helper.createMapLiteralExp(mapType, clonedParts);
        }

        public @NonNull OCLExpression visitOperationCallExp(@NonNull OperationCallExp pOperationCallExp) {
            OCLExpression iSource = this.create(pOperationCallExp.getOwnedSource());
            List<@NonNull OCLExpression> iArguments = this.createAll(ClassUtil.nullFree((List)pOperationCallExp.getOwnedArguments()));
            Operation referredOperation = ((BasicRegion2Mapping)this.context).createOperation(QVTrelationUtil.getReferredOperation((CallExp)pOperationCallExp));
            assert (referredOperation != null);
            if (iSource == null && referredOperation instanceof Function) {
                StandardLibrary standardLibrary = this.helper.getEnvironmentFactory().getStandardLibrary();
                Variable thisVariable = QVTbaseUtil.getContextVariable((StandardLibrary)standardLibrary, (Transformation)((BasicRegion2Mapping)this.context).getTransformation());
                iSource = PivotUtil.createVariableExp((VariableDeclaration)thisVariable);
            }
            return this.helper.createOperationCallExp(iSource, referredOperation, iArguments);
        }

        public @NonNull OCLExpression visitNavigationCallExp(@NonNull NavigationCallExp pNavigationCallExp) {
            OCLExpression iSource = this.createNonNull(pNavigationCallExp.getOwnedSource());
            Property referredProperty = PivotUtil.getReferredProperty((NavigationCallExp)pNavigationCallExp);
            return this.helper.createNavigationCallExp(iSource, referredProperty);
        }

        public @NonNull OCLExpression visitPrimitiveLiteralExp(@NonNull PrimitiveLiteralExp pPrimitiveLiteralExp) {
            return (OCLExpression)EcoreUtil.copy((EObject)pPrimitiveLiteralExp);
        }

        public @NonNull OCLExpression visitShadowExp(@NonNull ShadowExp pShadowExp) {
            ArrayList<@NonNull ShadowPart> clonedParts = new ArrayList<ShadowPart>();
            for (ShadowPart pPart : ClassUtil.nullFree((List)pShadowExp.getOwnedParts())) {
                OCLExpression init = this.createNonNull(pPart.getOwnedInit());
                String name = pPart.getName();
                Type type = pPart.getType();
                assert (name != null && type != null);
                Property referredProperty = pPart.getReferredProperty();
                assert (referredProperty != null);
                clonedParts.add(this.helper.createShadowPart(referredProperty, init));
            }
            Class shadowType = pShadowExp.getType();
            assert (shadowType != null);
            return this.helper.createShadowExp(shadowType, clonedParts);
        }

        public @NonNull OCLExpression visitTupleLiteralExp(@NonNull TupleLiteralExp pTupleLiteralExp) {
            ArrayList<@NonNull TupleLiteralPart> clonedParts = new ArrayList<TupleLiteralPart>();
            for (TupleLiteralPart pPart : ClassUtil.nullFree((List)pTupleLiteralExp.getOwnedParts())) {
                OCLExpression init = this.createNonNull(pPart.getOwnedInit());
                String name = pPart.getName();
                Type type = pPart.getType();
                assert (name != null && type != null);
                clonedParts.add(this.helper.createTupleLiteralPart(name, type, pPart.isIsRequired(), init));
            }
            TupleType tupleType = (TupleType)pTupleLiteralExp.getType();
            assert (tupleType != null);
            return this.helper.createTupleLiteralExp(tupleType, clonedParts);
        }

        public @NonNull OCLExpression visitTypeExp(@NonNull TypeExp pTypeExp) {
            Type referredType = pTypeExp.getReferredType();
            assert (referredType != null);
            return this.helper.createTypeExp(referredType);
        }

        public @NonNull OCLExpression visitVariableExp(@NonNull VariableExp pVariableExp) {
            VariableDeclaration pVariable = pVariableExp.getReferredVariable();
            Node node = ((BasicRegion2Mapping)this.context).getNode((Element)pVariable);
            if (node == null) {
                StandardLibrary standardLibrary = this.helper.getEnvironmentFactory().getStandardLibrary();
                Transformation pTransformation = QVTbaseUtil.getContainingTransformation((EObject)pVariableExp);
                Variable pThisVariable = QVTbaseUtil.getContextVariable((StandardLibrary)standardLibrary, (Transformation)pTransformation);
                if (pVariableExp.getReferredVariable() == pThisVariable) {
                    Variable iThisVariable = QVTbaseUtil.getContextVariable((StandardLibrary)standardLibrary, (Transformation)((BasicRegion2Mapping)this.context).getTransformation());
                    return PivotUtil.createVariableExp((VariableDeclaration)iThisVariable);
                }
            }
            if (node != null) {
                VariableDeclaration iVariable = ((BasicRegion2Mapping)this.context).basicGetVariable(node);
                assert (iVariable != null);
                return PivotUtil.createVariableExp((VariableDeclaration)iVariable);
            }
            System.err.println("Creating unexpected variable for " + pVariable + " in " + ((BasicRegion2Mapping)this.context).getRegion());
            Type variableType = pVariable.getType();
            assert (variableType != null);
            String safeName = ((BasicRegion2Mapping)this.context).getSafeName((String)ClassUtil.nonNullState((Object)pVariable.getName()));
            DeclareStatement iVariable = this.helper.createDeclareStatement(safeName, variableType, pVariable.isIsRequired(), (OCLExpression)this.helper.createNullLiteralExp());
            ((BasicRegion2Mapping)this.context).getMapping().getOwnedStatements().add((Object)iVariable);
            return PivotUtil.createVariableExp((VariableDeclaration)iVariable);
        }
    }

    private static class InlineExpressionCreator
    extends ExpressionCreator {
        private int debugDepth = 0;

        private InlineExpressionCreator(@NonNull BasicRegion2Mapping context) {
            super(context);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public @NonNull OCLExpression create(Node node) {
            try {
                if (++this.debugDepth > 100) {
                    throw new UnsupportedOperationException();
                }
                if (node.isNullLiteral()) {
                    var11_2 = this.helper.createNullLiteralExp();
                    return var11_2;
                }
                theVariable = ((BasicRegion2Mapping)this.context).basicGetVariable(node);
                if (theVariable != null) {
                    var11_3 = PivotUtil.createVariableExp((VariableDeclaration)theVariable);
                    return var11_3;
                }
                variable = node.basicGetOriginatingVariable();
                if (!(variable instanceof Variable)) ** GOTO lbl31
                ownedInit = ((Variable)variable).getOwnedInit();
                if (ownedInit == null) {
                    for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                        if (edge.isExpression() && "\u00abequals\u00bb".equals(edge.getName())) {
                            sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge);
                            var11_4 = this.create(sourceNode);
                            return var11_4;
                        }
                        if (edge.isCast()) {
                            throw new UnsupportedOperationException();
                        }
                        if (!edge.isNavigation()) continue;
                        sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge);
                        sourceExpression = this.create(sourceNode);
                        referredProperty = QVTscheduleUtil.getProperty((NavigableEdge)((NavigableEdge)edge));
                        var11_5 = this.helper.createNavigationCallExp(sourceExpression, referredProperty);
                        return var11_5;
                    }
                } else {
                    var11_6 = (OCLExpression)ownedInit.accept((Visitor)this);
                    return var11_6;
lbl31:
                    // 1 sources

                    originatingElement = node.getOriginatingElement();
                    var11_7 = (OCLExpression)originatingElement.accept((Visitor)this);
                    return var11_7;
                }
                throw new UnsupportedOperationException();
            }
            finally {
                --this.debugDepth;
            }
        }
    }

    private class OldEdgeSchedule {
        private @NonNull List<@NonNull Edge> edgeSchedule = new ArrayList<Edge>();
        private final @NonNull Set<@NonNull Edge> scheduledEdges = new HashSet<Edge>();
        private final @NonNull Set<@NonNull Node> scheduledNodes;

        public OldEdgeSchedule() {
            this.scheduledNodes = Sets.newHashSet((Iterable)QVTscheduleUtil.getHeadNodes((Region)BasicRegion2Mapping.this.region));
        }

        private void addEdge(@NonNull Edge edge) {
            if (this.scheduledEdges.add(edge)) {
                NavigableEdge oppositeEdge = null;
                if (edge instanceof NavigableEdge && (oppositeEdge = ((NavigableEdge)edge).getOppositeEdge()) != null) {
                    boolean wasAdded = this.scheduledEdges.add((Edge)oppositeEdge);
                    assert (wasAdded);
                }
                Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge);
                Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
                if (!sourceNode.isDependency() && !targetNode.isDependency()) {
                    Integer sourceCost = BasicRegion2Mapping.this.reachabilityForest.getCost(sourceNode);
                    Integer targetCost = BasicRegion2Mapping.this.reachabilityForest.getCost(targetNode);
                    assert (sourceCost != null && targetCost != null);
                    this.addNode(sourceNode);
                    this.addNode(targetNode);
                    this.edgeSchedule.add(edge);
                }
            }
        }

        private void addNode(@NonNull Node targetNode) {
            if (this.scheduledNodes.add(targetNode)) {
                Subexpression subexpression = (Subexpression)BasicRegion2Mapping.this.node2subexpression.get(targetNode);
                if (subexpression != null) {
                    for (Node inputNode : subexpression.unconditionalInputNodes) {
                        this.addNode(inputNode);
                    }
                    targetNode = subexpression.resultNode;
                    this.addNode(targetNode);
                }
                Integer targetCost = BasicRegion2Mapping.this.reachabilityForest.getCost(targetNode);
                assert (targetCost != null);
                for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)targetNode)) {
                    if (!edge.isOld() || !edge.isUnconditional()) continue;
                    Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge);
                    Integer sourceCost = BasicRegion2Mapping.this.reachabilityForest.getCost(sourceNode);
                    assert (sourceCost != null);
                    if (sourceCost >= targetCost) continue;
                    this.addEdge(edge);
                }
            }
        }

        public @NonNull Iterable<@NonNull CheckedCondition> analyze() {
            Node dispatchNode;
            String name = BasicRegion2Mapping.this.region.getName();
            if (name.contains("mapHelper_Operation")) {
                this.getClass();
            }
            if ((dispatchNode = BasicRegion2Mapping.this.regionAnalysis.basicGetDispatchNode()) != null) {
                for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)dispatchNode)) {
                    if (!edge.isPredicated()) continue;
                    this.addEdge(edge);
                }
            }
            for (Node headNode : BasicRegion2Mapping.this.headNodes) {
                SuccessEdge globalSuccessEdge;
                SuccessEdge localSuccessEdge = BasicRegion2Mapping.this.regionAnalysis.basicGetLocalSuccessEdge(headNode);
                if (localSuccessEdge != null && localSuccessEdge.isPredicated()) {
                    this.addEdge((Edge)localSuccessEdge);
                }
                if ((globalSuccessEdge = BasicRegion2Mapping.this.regionAnalysis.basicGetGlobalSuccessEdge(headNode)) == null || !globalSuccessEdge.isPredicated()) continue;
                this.addEdge((Edge)globalSuccessEdge);
            }
            Set<@NonNull CheckedCondition> checkedConditions = BasicRegion2Mapping.this.checkedConditionAnalysis.computeCheckedConditions();
            int checkableSize = checkedConditions.size();
            ArrayList<@NonNull CheckedCondition> sortedCheckedConditions = new ArrayList<CheckedCondition>(checkedConditions);
            if (checkableSize > 1) {
                Collections.sort(sortedCheckedConditions, new CheckedConditionWeightComparator(BasicRegion2Mapping.this));
            }
            for (CheckedCondition checkedCondition : sortedCheckedConditions) {
                Node node;
                Iterable<@NonNull Edge> edges = checkedCondition.getEdges();
                if (edges != null) {
                    for (Edge edge : edges) {
                        this.addEdge(edge);
                    }
                }
                if ((node = checkedCondition.getNode()) == null) continue;
                this.addNode(node);
            }
            ArrayList<Edge> residualEdges = null;
            for (Edge edge : BasicRegion2Mapping.this.checkedConditionAnalysis.getOldUnconditionalEdges()) {
                if (BasicRegion2Mapping.this.edge2subexpression.containsKey(edge)) continue;
                if (residualEdges == null) {
                    residualEdges = new ArrayList<Edge>();
                }
                residualEdges.add(edge);
            }
            if (residualEdges != null) {
                Collections.sort(residualEdges, BasicRegion2Mapping.this.reachabilityForest.getEdgeCostComparator());
                for (Edge edge : residualEdges) {
                    this.addEdge(edge);
                }
            }
            return sortedCheckedConditions;
        }

        private void createCastPredicates(@NonNull Node sourceNode, @NonNull VariableDeclaration sourceVariable) {
            for (NavigableEdge edge : sourceNode.getNavigableEdges()) {
                if (!edge.isCast() || !edge.isUnconditional()) continue;
                Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
                Property castProperty = QVTscheduleUtil.getProperty((NavigableEdge)edge);
                Type targetType = PivotUtil.getType((TypedElement)castProperty);
                VariableExp sourceExpression = BasicRegion2Mapping.this.helper.createVariableExp(sourceVariable);
                VariableDeclaration targetVariable = (VariableDeclaration)BasicRegion2Mapping.this.node2variable.get(targetNode);
                if (targetVariable == null) {
                    boolean isRequired = sourceVariable.isIsRequired();
                    String safeName = BasicRegion2Mapping.this.getSafeName(PivotUtil.getName((NamedElement)sourceVariable));
                    DeclareStatement declareStatement = BasicRegion2Mapping.this.helper.createDeclareStatement(safeName, targetType, isRequired, (OCLExpression)sourceExpression);
                    declareStatement.setIsCheck(true);
                    BasicRegion2Mapping.this.mapping.getOwnedStatements().add((Object)declareStatement);
                    targetVariable = declareStatement;
                    BasicRegion2Mapping.this.node2variable.put(targetNode, targetVariable);
                    this.createCastPredicates(targetNode, targetVariable);
                    continue;
                }
                BasicRegion2Mapping.this.createCheckStatement((OCLExpression)sourceExpression, "oclIsKindOf", (OCLExpression)BasicRegion2Mapping.this.helper.createTypeExp(targetType));
            }
        }

        protected void createConstantCheck(@NonNull Edge edge, @NonNull OCLExpression checkExpression) {
            if (edge.isSpeculated()) {
                assert (edge.isSuccess());
                System.err.println("Speculation code omitted for " + BasicRegion2Mapping.this.region);
            } else {
                BasicRegion2Mapping.this.createCheckStatement(checkExpression);
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public void synthesize(@NonNull Iterable<@NonNull CheckedCondition> checkedConditions) {
            for (Edge edge : this.edgeSchedule) {
                assert (edge.isUnconditional());
                Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge);
                Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
                assert (sourceNode.isUnconditional());
                assert (targetNode.isUnconditional());
                if (edge instanceof NavigableEdge) {
                    VariableExp targetVariableExp;
                    VariableDeclaration nodeVariable;
                    NavigableEdge navigableEdge = (NavigableEdge)edge;
                    Property property = QVTscheduleUtil.getProperty((NavigableEdge)navigableEdge);
                    OCLExpression sourceExp = BasicRegion2Mapping.this.createVariableExp(sourceNode);
                    Type sourceType = sourceExp.getType();
                    Class requiredType = property.getOwningClass();
                    if (requiredType != null && !sourceType.conformsTo(BasicRegion2Mapping.this.getMetamodelManager().getStandardLibrary(), (Type)requiredType)) {
                        String castName = "cast_" + sourceNode.getName();
                        DeclareStatement castStatement = BasicRegion2Mapping.this.createCheckedDeclareStatement(castName, sourceExp, (Type)requiredType);
                        sourceExp = BasicRegion2Mapping.this.helper.createVariableExp((VariableDeclaration)castStatement);
                    }
                    CallExp source2targetExp = BasicRegion2Mapping.this.createCallExp(sourceExp, property);
                    if (targetNode.isNullLiteral()) {
                        BasicRegion2Mapping.this.createCheckStatement((OCLExpression)source2targetExp, "=", (OCLExpression)BasicRegion2Mapping.this.helper.createNullLiteralExp());
                        continue;
                    }
                    if (targetNode.isConstant() && !sourceNode.isNew()) {
                        nodeVariable = (VariableDeclaration)BasicRegion2Mapping.this.node2variable.get(targetNode);
                        if (navigableEdge.isPartial()) {
                            targetVariableExp = BasicRegion2Mapping.this.getSubexpressionVariableExp(targetNode);
                            BasicRegion2Mapping.this.createCheckStatement((OCLExpression)source2targetExp, "includes", (OCLExpression)targetVariableExp);
                            continue;
                        }
                        if (targetNode instanceof BooleanLiteralNode && ((BooleanLiteralNode)targetNode).isBooleanValue()) {
                            this.createConstantCheck(edge, (OCLExpression)source2targetExp);
                            continue;
                        }
                        if (nodeVariable == null) {
                            ExpressionCreator expressionCreator = new ExpressionCreator(BasicRegion2Mapping.this);
                            ExpressionCreator inlineExpressionCreator = expressionCreator.getInlineExpressionCreator();
                            OCLExpression targetExpression = inlineExpressionCreator.getExpression(targetNode);
                            assert (targetExpression != null);
                            BasicRegion2Mapping.this.createCheckStatement((OCLExpression)source2targetExp, "=", targetExpression);
                            continue;
                        }
                        targetVariableExp = BasicRegion2Mapping.this.getSubexpressionVariableExp(targetNode);
                        BasicRegion2Mapping.this.createCheckStatement((OCLExpression)source2targetExp, "=", (OCLExpression)targetVariableExp);
                        continue;
                    }
                    nodeVariable = (VariableDeclaration)BasicRegion2Mapping.this.node2variable.get(targetNode);
                    if (nodeVariable == null) {
                        DeclareStatement declareStatement = BasicRegion2Mapping.this.createDeclareStatement(targetNode, (OCLExpression)source2targetExp);
                        this.createCastPredicates(targetNode, (VariableDeclaration)declareStatement);
                        continue;
                    }
                    if (navigableEdge.isPartial()) {
                        targetVariableExp = BasicRegion2Mapping.this.getSubexpressionVariableExp(targetNode);
                        BasicRegion2Mapping.this.createCheckStatement((OCLExpression)source2targetExp, "includes", (OCLExpression)targetVariableExp);
                        continue;
                    }
                    targetVariableExp = BasicRegion2Mapping.this.getSubexpressionVariableExp(targetNode);
                    BasicRegion2Mapping.this.createCheckStatement((OCLExpression)targetVariableExp, "=", (OCLExpression)source2targetExp);
                    continue;
                }
                if (edge instanceof PredicateEdge) {
                    VariableExp sourceVariableExp = BasicRegion2Mapping.this.getSubexpressionVariableExp(sourceNode);
                    if (!(targetNode instanceof BooleanLiteralNode)) {
                        String edgeName = ((String)ClassUtil.nonNullState((Object)edge.getName())).trim();
                        if (edgeName.length() >= 2) {
                            edgeName = edgeName.substring(1, edgeName.length() - 1);
                        }
                        VariableExp targetVariableExp = BasicRegion2Mapping.this.getSubexpressionVariableExp(targetNode);
                        BasicRegion2Mapping.this.createCheckStatement((OCLExpression)sourceVariableExp, edgeName, (OCLExpression)targetVariableExp);
                        continue;
                    }
                    if (((BooleanLiteralNode)targetNode).isBooleanValue()) {
                        this.createConstantCheck(edge, (OCLExpression)sourceVariableExp);
                        continue;
                    }
                    BasicRegion2Mapping.this.createCheckStatement((OCLExpression)sourceVariableExp, "=", (OCLExpression)BasicRegion2Mapping.this.helper.createBooleanLiteralExp(false));
                    continue;
                }
                if (!(edge instanceof ExpressionEdge)) continue;
                BasicRegion2Mapping.this.getSubexpressionDeclaration(targetNode);
            }
            ArrayList<@NonNull V> subexpressions = new ArrayList(BasicRegion2Mapping.this.resultNode2subexpression.values());
            Collections.sort(subexpressions);
            for (Subexpression subexpression : subexpressions) {
                if (subexpression.resultNode.isNew() || !subexpression.resultNode.isUnconditional()) continue;
                BasicRegion2Mapping.this.getSubexpressionDeclaration((Node)subexpression.resultNode);
            }
        }

        public @NonNull String toString() {
            StringBuilder s = new StringBuilder();
            boolean isFirst = true;
            for (Edge edge : this.edgeSchedule) {
                if (!isFirst) {
                    s.append("\n");
                }
                s.append(edge);
                isFirst = false;
            }
            return s.toString();
        }
    }

    private class Subexpression
    implements Comparable<Subexpression> {
        private final @NonNull OperationNode resultNode;
        private final @NonNull Set<@NonNull Node> inputNodes = new HashSet<Node>();
        private final @NonNull Set<@NonNull Node> unconditionalInputNodes = new HashSet<Node>();
        private final @NonNull Set<@NonNull Node> contentNodes = new HashSet<Node>();
        private @Nullable Integer cost = null;

        public Subexpression(OperationNode resultNode) {
            this.resultNode = resultNode;
            assert (resultNode.isUnconditional());
        }

        public void analyze(@NonNull Set<@NonNull OperationNode> subexpressionResults) {
            this.computeSubexpressionContent((Node)this.resultNode, subexpressionResults);
        }

        @Override
        public int compareTo(@NonNull Subexpression e2) {
            int d2;
            Subexpression e1 = this;
            int d1 = e1.getCost();
            if (d1 != (d2 = e2.getCost())) {
                return d1 - d2;
            }
            return ClassUtil.safeCompareTo((Comparable)((Object)e1.resultNode.getDisplayName()), (Comparable)((Object)e2.resultNode.getDisplayName()));
        }

        private void computeSubexpressionContent(@NonNull Node node, @NonNull Set<@NonNull OperationNode> subexpressionResults) {
            if (this.contentNodes.add(node)) {
                BasicRegion2Mapping.this.node2subexpression.put(node, this);
                for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                    Node sourceNode = edge.getEdgeSource();
                    if (subexpressionResults.contains(sourceNode)) {
                        if (!sourceNode.isOld() && (edge.isSecondary() || !this.resultNode.isNew())) continue;
                        this.inputNodes.add(sourceNode);
                        if (!edge.isUnconditional() || !sourceNode.isUnconditional()) continue;
                        this.unconditionalInputNodes.add(sourceNode);
                        continue;
                    }
                    if (sourceNode.isExpression()) {
                        BasicRegion2Mapping.this.node2subexpression.put(sourceNode, this);
                        BasicRegion2Mapping.this.edge2subexpression.put(edge, this);
                        this.computeSubexpressionContent(sourceNode, subexpressionResults);
                        continue;
                    }
                    if (!sourceNode.isUnconditional()) {
                        BasicRegion2Mapping.this.node2subexpression.put(sourceNode, this);
                        BasicRegion2Mapping.this.edge2subexpression.put(edge, this);
                        this.computeSubexpressionContent(sourceNode, subexpressionResults);
                        continue;
                    }
                    if (!sourceNode.isOld() && !this.resultNode.isNew()) continue;
                    this.inputNodes.add(sourceNode);
                    if (!edge.isUnconditional() || !sourceNode.isUnconditional()) continue;
                    this.unconditionalInputNodes.add(sourceNode);
                }
            }
        }

        public int getCost() {
            Integer cost2 = this.cost;
            if (cost2 == null) {
                cost2 = BasicRegion2Mapping.this.reachabilityForest.getCost((Node)this.resultNode);
                if (cost2 == null) {
                    int inputCost = 0;
                    for (Node inputNode : this.inputNodes) {
                        Subexpression inputSubexpression = (Subexpression)BasicRegion2Mapping.this.resultNode2subexpression.get(inputNode);
                        if (inputSubexpression == null) continue;
                        inputCost = Math.max(inputCost, inputSubexpression.getCost() + 1);
                    }
                    cost2 = inputCost;
                }
                this.cost = cost2;
            }
            return cost2;
        }

        public @NonNull String toString() {
            return String.valueOf(this.resultNode);
        }
    }
}

