/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.AnyType;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.InvalidType;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.SetType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.AbstractRegion2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.AbstractScheduledRegion2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTiVisitor;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.AppendParameter;
import org.eclipse.qvtd.pivot.qvtimperative.BufferStatement;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionVariable;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameter;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.DatumConnection;
import org.eclipse.qvtd.pivot.qvtschedule.LoadingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleConstants;

public class RootRegion2Mapping
extends AbstractScheduledRegion2Mapping {
    private final @NonNull Map<@NonNull ClassDatumAnalysis, @NonNull AppendParameter> classDatumAnalysis2variable = new HashMap<ClassDatumAnalysis, AppendParameter>();
    private final @NonNull Map<@NonNull Node, @NonNull Variable> node2variable = new HashMap<Node, Variable>();

    public RootRegion2Mapping(@NonNull QVTs2QVTiVisitor visitor, @NonNull LoadingRegion region) {
        super(visitor, (Region)region);
        HashSet<@NonNull ImperativeTypedModel> checkableTypedModels = new HashSet<ImperativeTypedModel>();
        for (Node node : RegionUtil.getOwnedNodes((Region)region)) {
            TypedModel qvtmTypedModel;
            ImperativeTypedModel qvtiTypedModel;
            ClassDatum classDatum = node.getClassDatum();
            Class type = classDatum.getCompleteClass().getPrimaryClass();
            if (type instanceof DataType || type instanceof AnyType || type instanceof VoidType || type instanceof InvalidType || (qvtiTypedModel = visitor.getQVTiTypedModel(qvtmTypedModel = classDatum.getReferredTypedModel())) == null) continue;
            checkableTypedModels.add(qvtiTypedModel);
        }
    }

    private @NonNull ConnectionVariable createRootConnectionVariable(@NonNull String name, boolean isStrict, @NonNull Type type, @Nullable OCLExpression initExpression) {
        BufferStatement variable = this.helper.createBufferStatement(this.getSafeName(name), isStrict, type, true, initExpression);
        this.mapping.getOwnedStatements().add((Object)variable);
        return variable;
    }

    private void createRootConnectionVariables() {
        ArrayList<@NonNull E> rootConnections = new ArrayList(this.region.getRootConnections());
        Collections.sort(rootConnections, NameUtil.NAMEABLE_COMPARATOR);
        for (NodeConnection rootConnection : rootConnections) {
            Type commonType = this.getConnectionSourcesType(rootConnection);
            Node regionNode = rootConnection.basicGetSource(this.region);
            String name = rootConnection.getName();
            assert (name != null);
            if (regionNode != null) {
                ClassDatumAnalysis classDatumAnalysis = RegionUtil.getClassDatumAnalysis(regionNode);
                AppendParameter allInstancesVariable = this.classDatumAnalysis2variable.get(classDatumAnalysis);
                if (allInstancesVariable == null) {
                    Class collectionType = classDatumAnalysis.getClassDatum().getCompleteClass().getPrimaryClass();
                    Type elementType = ((CollectionType)collectionType).getElementType();
                    assert (elementType != null);
                    assert (!(elementType instanceof CollectionType));
                    String safeName = this.getSafeName(name);
                    allInstancesVariable = this.helper.createAppendParameter(safeName, elementType, true);
                    this.mapping.getOwnedMappingParameters().add((Object)allInstancesVariable);
                    this.classDatumAnalysis2variable.put(classDatumAnalysis, allInstancesVariable);
                }
                this.connection2variable.put(rootConnection, allInstancesVariable);
                continue;
            }
            this.connection2variable.put(rootConnection, this.createRootConnectionVariable(name, false, commonType, null));
        }
    }

    @Override
    public void createSchedulingStatements() {
        this.createRootConnectionVariables();
        EList ownedStatements = this.mapping.getOwnedStatements();
        for (Region callableRegion : this.region.getCallableChildren()) {
            if (this.isInstall(callableRegion)) {
                ownedStatements.add(this.createInstall(callableRegion));
                continue;
            }
            ownedStatements.add(this.createCall(callableRegion, null));
        }
    }

    @Override
    protected @NonNull OCLExpression createSelectByKind(@NonNull Node resultNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull List<@NonNull Node> getGuardNodes() {
        return QVTscheduleConstants.EMPTY_NODE_LIST;
    }

    @Override
    public @NonNull MappingParameter getGuardVariable(@NonNull Node node) {
        Variable variable = this.node2variable.get(node);
        assert (variable != null);
        return (MappingParameter)variable;
    }

    protected @NonNull Iteration getSelectIteration() {
        SetType collectionType = ((StandardLibraryInternal)this.visitor.getStandardLibrary()).getSetType();
        Operation selectIteration = (Operation)NameUtil.getNameable((Iterable)collectionType.getOwnedOperations(), (String)"select");
        assert (selectIteration != null);
        return (Iteration)selectIteration;
    }

    protected Type getType(@NonNull IdResolver idResolver, @NonNull NodeConnection rootConnection) {
        Object commonType = null;
        for (Node node : RegionUtil.getSourceEnds((DatumConnection)rootConnection)) {
            Class nodeType = node.getCompleteClass().getPrimaryClass();
            commonType = commonType == null ? nodeType : commonType.getCommonType(idResolver, (Type)nodeType);
        }
        return commonType;
    }

    protected boolean isInstall(@NonNull Region calledRegion) {
        AbstractRegion2Mapping calledRegion2Mapping = this.visitor.getRegion2Mapping(calledRegion);
        for (Node calledGuardNode : calledRegion2Mapping.getGuardNodes()) {
            NodeConnection callingConnection = calledGuardNode.getIncomingPassedConnection();
            if (callingConnection != null) continue;
            return false;
        }
        return true;
    }
}

