/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.IteratorVariable;
import org.eclipse.ocl.pivot.LetVariable;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.CoreVariableAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.IteratorVariableAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.LetVariableAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTc;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.RelationVariableAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.ThisVariableAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.VariableAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.Assignment;
import org.eclipse.qvtd.pivot.qvtcore.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcore.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcore.CorePattern;
import org.eclipse.qvtd.pivot.qvtcore.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcore.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreHelper;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvttemplate.CollectionTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.PropertyTemplateItem;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

class VariablesAnalysis
extends QVTcoreHelper {
    protected final @NonNull QVTr2QVTc qvtr2qvtc;
    protected final @NonNull CoreDomain cEnforcedDomain;
    protected final @NonNull Mapping cMapping;
    protected final @NonNull Transformation cTransformation;
    protected final @NonNull BottomPattern cMiddleBottomPattern;
    protected final @NonNull GuardPattern cMiddleGuardPattern;
    protected final @NonNull RealizedVariable cMiddleRealizedVariable;
    protected final @NonNull Variable rThisVariable;
    protected final @NonNull Variable cThisVariable;
    private @NonNull Map<@NonNull String, @NonNull VariableAnalysis> name2originator = new HashMap<String, VariableAnalysis>();
    private final @NonNull Map<@NonNull Variable, @NonNull VariableAnalysis> rVariable2analysis = new HashMap<Variable, VariableAnalysis>();
    private final @NonNull Map<@NonNull Variable, @NonNull VariableAnalysis> cVariable2analysis = new HashMap<Variable, VariableAnalysis>();

    public static @NonNull Map<@NonNull Variable, @NonNull TemplateExp> gatherBoundVariables(@NonNull Element asRoot) {
        HashMap<@NonNull Variable, @NonNull TemplateExp> boundVariables = new HashMap<Variable, TemplateExp>();
        for (EObject eObject : new TreeIterable((EObject)asRoot, true)) {
            if (!(eObject instanceof TemplateExp)) continue;
            Variable bindsTo = QVTrelationUtil.getBindsTo((TemplateExp)((TemplateExp)eObject));
            TemplateExp oldTemplateExp = boundVariables.put(bindsTo, (TemplateExp)eObject);
            assert (oldTemplateExp == null);
        }
        return boundVariables;
    }

    public static @Nullable Map<@NonNull Variable, @NonNull List<@NonNull CollectionTemplateExp>> gatherMemberVariables(@NonNull Element asRoot) {
        HashMap<@NonNull Variable, @NonNull ArrayList<@NonNull E>> memberVariable2collectionTemplateExps = null;
        for (EObject eObject : new TreeIterable((EObject)asRoot, true)) {
            if (!(eObject instanceof CollectionTemplateExp)) continue;
            CollectionTemplateExp collectionTemplateExp = (CollectionTemplateExp)eObject;
            for (OCLExpression member : QVTrelationUtil.getOwnedMembers((CollectionTemplateExp)collectionTemplateExp)) {
                ArrayList<CollectionTemplateExp> collectionTemplateExps;
                if (!(member instanceof VariableExp)) continue;
                Variable memberVariable = QVTrelationUtil.getReferredVariable((VariableExp)((VariableExp)member));
                if (memberVariable2collectionTemplateExps == null) {
                    memberVariable2collectionTemplateExps = new HashMap();
                }
                if ((collectionTemplateExps = (ArrayList<CollectionTemplateExp>)memberVariable2collectionTemplateExps.get(memberVariable)) == null) {
                    collectionTemplateExps = new ArrayList<CollectionTemplateExp>();
                    memberVariable2collectionTemplateExps.put(memberVariable, collectionTemplateExps);
                }
                if (collectionTemplateExps.contains(collectionTemplateExp)) continue;
                collectionTemplateExps.add(collectionTemplateExp);
            }
        }
        return memberVariable2collectionTemplateExps;
    }

    public static void gatherReferredVariables(@NonNull Set<@NonNull Variable> referredVariables, @NonNull Iterable<@NonNull ? extends Element> asRoots) {
        for (Element element : asRoots) {
            VariablesAnalysis.gatherReferredVariables(referredVariables, element);
        }
    }

    public static void gatherReferredVariables(@NonNull Set<@NonNull Variable> referredVariables, @NonNull Element asRoot) {
        for (EObject eObject : new TreeIterable((EObject)asRoot, true)) {
            Variable rest;
            if (eObject instanceof VariableExp) {
                VariableDeclaration referredVariable = ((VariableExp)eObject).getReferredVariable();
                if (!(referredVariable instanceof Variable)) continue;
                referredVariables.add((Variable)referredVariable);
                continue;
            }
            if (eObject instanceof Variable) {
                referredVariables.add((Variable)eObject);
                continue;
            }
            if (!(eObject instanceof TemplateExp)) continue;
            Variable bindsTo = ((TemplateExp)eObject).getBindsTo();
            if (bindsTo != null) {
                referredVariables.add(bindsTo);
            }
            if (!(eObject instanceof CollectionTemplateExp) || (rest = ((CollectionTemplateExp)eObject).getRest()) == null || rest.isIsImplicit()) continue;
            referredVariables.add(rest);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void gatherReferredVariablesWithTypedModels(@NonNull Map<@NonNull Variable, @Nullable TypedModel> referredVariable2typedModel, @NonNull Element asRoot) {
        for (EObject eObject : new TreeIterable((EObject)asRoot, true)) {
            Variable rest;
            if (eObject instanceof VariableExp) {
                VariableDeclaration referredVariable = ((VariableExp)eObject).getReferredVariable();
                if (!(referredVariable instanceof Variable)) continue;
                EObject eContainer = eObject.eContainer();
                if (eContainer instanceof RelationCallExp) {
                    RelationCallExp relationCallExp = (RelationCallExp)eContainer;
                    int argument = relationCallExp.getArgument().indexOf((Object)eObject);
                    assert (argument >= 0);
                    Relation referredRelation = (Relation)ClassUtil.nonNullState((Object)relationCallExp.getReferredRelation());
                    @NonNull List rootVariables = QVTrelationUtil.getRootVariables((Relation)referredRelation);
                    assert (argument < rootVariables.size());
                    Variable rootVariable = (Variable)rootVariables.get(argument);
                    RelationDomain relationDomain = QVTrelationUtil.getRootVariableDomain((Variable)rootVariable);
                    VariablesAnalysis.gatherReferredVariablesWithTypedModelsAdd(referredVariable2typedModel, (Variable)referredVariable, relationDomain.getTypedModel());
                    continue;
                }
                VariablesAnalysis.gatherReferredVariablesWithTypedModelsAdd(referredVariable2typedModel, (Variable)referredVariable, null);
                continue;
            }
            if (eObject instanceof Variable) {
                VariablesAnalysis.gatherReferredVariablesWithTypedModelsAdd(referredVariable2typedModel, (Variable)eObject, null);
                continue;
            }
            if (!(eObject instanceof TemplateExp)) continue;
            Variable bindsTo = ((TemplateExp)eObject).getBindsTo();
            if (bindsTo != null) {
                VariablesAnalysis.gatherReferredVariablesWithTypedModelsAdd(referredVariable2typedModel, bindsTo, null);
            }
            if (!(eObject instanceof CollectionTemplateExp) || (rest = ((CollectionTemplateExp)eObject).getRest()) == null || rest.isIsImplicit()) continue;
            VariablesAnalysis.gatherReferredVariablesWithTypedModelsAdd(referredVariable2typedModel, rest, null);
        }
    }

    private static void gatherReferredVariablesWithTypedModelsAdd(@NonNull Map<@NonNull Variable, @Nullable TypedModel> referredVariable2typedModel, @NonNull Variable variable, @Nullable TypedModel rTypedModel) {
        if (rTypedModel != null) {
            TypedModel oldTypedModel = referredVariable2typedModel.put(variable, rTypedModel);
            assert (oldTypedModel == rTypedModel || oldTypedModel == null);
        } else if (!referredVariable2typedModel.containsKey(variable)) {
            referredVariable2typedModel.put(variable, null);
        }
    }

    public static @Nullable Map<@NonNull Variable, @NonNull CollectionTemplateExp> gatherRestVariables(@NonNull Element asRoot) {
        HashMap<@NonNull Variable, @NonNull CollectionTemplateExp> restVariable2collectionTemplateExp = null;
        for (EObject eObject : new TreeIterable((EObject)asRoot, true)) {
            CollectionTemplateExp collectionTemplateExp;
            Variable rest;
            if (!(eObject instanceof CollectionTemplateExp) || (rest = (collectionTemplateExp = (CollectionTemplateExp)eObject).getRest()) == null) continue;
            if (restVariable2collectionTemplateExp == null) {
                restVariable2collectionTemplateExp = new HashMap<Variable, CollectionTemplateExp>();
            }
            CollectionTemplateExp oldCollectionTemplateExp = restVariable2collectionTemplateExp.put(rest, collectionTemplateExp);
            assert (oldCollectionTemplateExp == null);
        }
        return restVariable2collectionTemplateExp;
    }

    public static @NonNull Set<@NonNull Variable> getMiddleDomainVariables(@NonNull Relation rRelation) {
        HashSet<@NonNull Variable> rSomeDomainVariables = new HashSet<Variable>();
        HashSet<@NonNull Variable> rMiddleDomainVariables = new HashSet<Variable>();
        for (RelationDomain rDomain : QVTrelationUtil.getOwnedDomains((Relation)rRelation)) {
            HashSet<@NonNull Variable> rThisDomainVariables = new HashSet<Variable>();
            VariablesAnalysis.gatherReferredVariables(rThisDomainVariables, (Element)rDomain);
            for (Variable rVariable : rThisDomainVariables) {
                if (rSomeDomainVariables.add(rVariable)) continue;
                rMiddleDomainVariables.add(rVariable);
            }
        }
        return rMiddleDomainVariables;
    }

    public VariablesAnalysis(@NonNull QVTr2QVTc qvtr2qvtc, @NonNull RelationDomain rEnforcedDomain, @NonNull CoreDomain cEnforcedDomain, @NonNull Type traceClass) throws CompilerChainException {
        super(qvtr2qvtc.getEnvironmentFactory());
        this.qvtr2qvtc = qvtr2qvtc;
        this.cEnforcedDomain = cEnforcedDomain;
        this.cMapping = (Mapping)ClassUtil.nonNullState((Object)QVTcoreUtil.getContainingMapping((EObject)cEnforcedDomain));
        this.cTransformation = (Transformation)ClassUtil.nonNullState((Object)this.cMapping.getTransformation());
        this.cMiddleBottomPattern = (BottomPattern)ClassUtil.nonNullState((Object)this.cMapping.getBottomPattern());
        this.cMiddleGuardPattern = (GuardPattern)ClassUtil.nonNullState((Object)this.cMapping.getGuardPattern());
        this.cMiddleRealizedVariable = this.addCoreRealizedVariable("trace", traceClass);
        this.rThisVariable = QVTbaseUtil.getContextVariable((StandardLibrary)this.environmentFactory.getStandardLibrary(), (Transformation)QVTbaseUtil.getContainingTransformation((EObject)rEnforcedDomain));
        this.cThisVariable = QVTbaseUtil.getContextVariable((StandardLibrary)this.environmentFactory.getStandardLibrary(), (Transformation)this.cTransformation);
        ThisVariableAnalysis thisVariableAnalysis = new ThisVariableAnalysis(this, this.rThisVariable, this.cThisVariable);
        this.addVariableAnalysis(thisVariableAnalysis);
    }

    protected void addConditionPredicate(@NonNull CorePattern cCorePattern, @NonNull OCLExpression cLeftExpression, @NonNull OCLExpression cRightExpression) throws CompilerChainException {
        OperationCallExp eTerm = this.createOperationCallExp(cLeftExpression, "=", new OCLExpression[]{cRightExpression});
        this.addPredicate(cCorePattern, (OCLExpression)eTerm);
    }

    public @NonNull Variable addCoreGuardVariable(@NonNull String name, @NonNull Type type) throws CompilerChainException {
        CoreVariableAnalysis analysis = new CoreVariableAnalysis(this, name, type, null);
        Variable cVariable = analysis.getCoreVariable();
        this.addVariableAnalysis(analysis);
        this.cMiddleGuardPattern.getVariable().add((Object)cVariable);
        return cVariable;
    }

    public @NonNull RealizedVariable addCoreRealizedVariable(@NonNull String name, @NonNull Type type) throws CompilerChainException {
        CoreVariableAnalysis analysis = new CoreVariableAnalysis(this, name, type);
        RealizedVariable cVariable = analysis.getCoreRealizedVariable();
        this.addVariableAnalysis(analysis);
        this.cMiddleBottomPattern.getRealizedVariable().add((Object)cVariable);
        return cVariable;
    }

    public @NonNull Variable addCoreVariable(@NonNull String name, @NonNull OCLExpression mMember) throws CompilerChainException {
        CoreVariableAnalysis analysis = new CoreVariableAnalysis(this, name, (Type)ClassUtil.nonNullState((Object)mMember.getType()), mMember);
        Variable cVariable = analysis.getCoreVariable();
        this.addVariableAnalysis(analysis);
        this.cMiddleGuardPattern.getVariable().add((Object)cVariable);
        return cVariable;
    }

    public void addNavigationAssignment(@NonNull Variable rTargetVariable, @NonNull Property targetProperty, @NonNull OCLExpression cExpression, @Nullable Boolean isPartial) throws CompilerChainException {
        this.getVariableAnalysis(rTargetVariable).addNavigationAssignment(targetProperty, cExpression, isPartial);
    }

    public void addNavigationPredicate(@NonNull CorePattern cCorePattern, @NonNull Variable rTargetVariable, @NonNull Property targetProperty, @NonNull OCLExpression cExpression) throws CompilerChainException {
        Variable cTargetVariable = this.getCoreVariable(rTargetVariable);
        NavigationCallExp cNavigationExp = this.createNavigationCallExp((OCLExpression)this.createVariableExp((VariableDeclaration)cTargetVariable), targetProperty);
        if (cExpression instanceof VariableExp) {
            this.addConditionPredicate(cCorePattern, cExpression, (OCLExpression)cNavigationExp);
        } else {
            this.addConditionPredicate(cCorePattern, (OCLExpression)cNavigationExp, cExpression);
        }
    }

    protected void addPredicate(@NonNull CorePattern cExpectedCorePattern, @NonNull OCLExpression cExpression) throws CompilerChainException {
        assert (this.cMapping == QVTcoreUtil.getContainingMapping((EObject)cExpectedCorePattern));
        QVTr2QVTc.SYNTHESIS.println("  addPredicate " + cExpression);
        HashSet<@NonNull Variable> cReferredVariables = new HashSet<Variable>();
        VariablesAnalysis.gatherReferredVariables(cReferredVariables, (Element)cExpression);
        boolean isGuard = true;
        boolean isMiddle = false;
        GuardPattern cReferredPattern = null;
        for (Variable cReferredVariable : cReferredVariables) {
            VariableAnalysis analysis = this.cVariable2analysis.get(cReferredVariable);
            if (analysis == null) {
                isGuard = false;
                isMiddle = true;
                break;
            }
            CorePattern corePattern = analysis.getCorePattern();
            if (corePattern != null && !(corePattern instanceof GuardPattern)) {
                isGuard = false;
            }
            if (cReferredPattern == null) {
                cReferredPattern = corePattern;
                continue;
            }
            if (cReferredPattern == corePattern) continue;
            isMiddle = true;
        }
        if (isMiddle) {
            cReferredPattern = isGuard ? this.cMiddleGuardPattern : this.cMiddleBottomPattern;
        } else if (cReferredPattern != null) {
            Object object = cReferredPattern = isGuard ? cReferredPattern.getArea().getGuardPattern() : cReferredPattern.getArea().getBottomPattern();
        }
        if (cReferredPattern != null) {
            Predicate cPredicate = this.createPredicate(cExpression);
            cReferredPattern.getPredicate().add((Object)cPredicate);
        }
    }

    public @NonNull Variable addTraceNavigationAssignment(@NonNull Variable rVariable, boolean isOptional) throws CompilerChainException {
        Variable cVariable = this.getCoreVariable(rVariable);
        Property cTargetProperty = this.qvtr2qvtc.basicGetTraceProperty(QVTrelationUtil.getType((TypedElement)this.cMiddleRealizedVariable), (VariableDeclaration)rVariable);
        assert (isOptional || cTargetProperty != null);
        if (cTargetProperty != null) {
            assert (!cTargetProperty.isIsMany() || cVariable.getType() instanceof CollectionType);
            VariableExp cSlotVariableExp = this.createVariableExp((VariableDeclaration)this.cMiddleRealizedVariable);
            VariableExp cExpression = this.createVariableExp((VariableDeclaration)cVariable);
            NavigationAssignment cAssignment = this.createNavigationAssignment((OCLExpression)cSlotVariableExp, cTargetProperty, (OCLExpression)cExpression, false);
            QVTr2QVTc.SYNTHESIS.println("  addPropertyAssignment " + cAssignment);
            this.assertNewAssignment(QVTcoreUtil.getOwnedAssignments((BottomPattern)this.cMiddleBottomPattern), cAssignment);
            this.cMiddleBottomPattern.getAssignment().add((Object)cAssignment);
        }
        return cVariable;
    }

    public @NonNull Variable addTraceNavigationAssignment(@NonNull Property cTargetProperty, @NonNull Variable cVariable) throws CompilerChainException {
        assert (!cTargetProperty.isIsMany() || cVariable.getType() instanceof CollectionType);
        VariableExp cSlotVariableExp = this.createVariableExp((VariableDeclaration)this.cMiddleRealizedVariable);
        VariableExp cExpression = this.createVariableExp((VariableDeclaration)cVariable);
        NavigationAssignment cAssignment = this.createNavigationAssignment((OCLExpression)cSlotVariableExp, cTargetProperty, (OCLExpression)cExpression, false);
        QVTr2QVTc.SYNTHESIS.println("  addPropertyAssignment " + cAssignment);
        this.assertNewAssignment(QVTcoreUtil.getOwnedAssignments((BottomPattern)this.cMiddleBottomPattern), cAssignment);
        this.cMiddleBottomPattern.getAssignment().add((Object)cAssignment);
        return cVariable;
    }

    public void addVariableAnalysis(@NonNull VariableAnalysis analysis) throws CompilerChainException {
        Variable cVariable = analysis.getCoreVariable();
        this.cVariable2analysis.put(cVariable, analysis);
        Variable rVariable = analysis.getRelationVariable();
        if (rVariable != null) {
            this.rVariable2analysis.put(rVariable, analysis);
        }
    }

    public void assertNewAssignment(@NonNull Iterable<@NonNull Assignment> oldAssignments, @NonNull NavigationAssignment newAssignment) {
        OCLExpression newSlotExpression = newAssignment.getSlotExpression();
        if (newSlotExpression instanceof VariableExp) {
            VariableDeclaration newVariable = ((VariableExp)newSlotExpression).getReferredVariable();
            Property targetProperty = QVTcoreUtil.getTargetProperty((NavigationAssignment)newAssignment);
            for (Assignment oldAssignment : oldAssignments) {
                OCLExpression oldSlotExpression;
                if (!(oldAssignment instanceof NavigationAssignment) || QVTcoreUtil.getTargetProperty((NavigationAssignment)((NavigationAssignment)oldAssignment)) != targetProperty || !((oldSlotExpression = ((NavigationAssignment)oldAssignment).getSlotExpression()) instanceof VariableExp)) continue;
                VariableDeclaration oldVariable = ((VariableExp)oldSlotExpression).getReferredVariable();
                assert (oldVariable != newVariable) : "Repeated assignment: \"" + oldAssignment + "\", \"" + newAssignment + "\"";
            }
        }
    }

    protected @Nullable VariableAnalysis basicGetVariableAnalysis(@NonNull Variable relationVariable) {
        return this.rVariable2analysis.get(relationVariable);
    }

    public void check() {
        for (VariableAnalysis analysis : this.rVariable2analysis.values()) {
            analysis.check();
        }
    }

    public @NonNull Iterable<@NonNull VariableAnalysis> getAnalyses() {
        return this.rVariable2analysis.values();
    }

    public @NonNull Variable getCoreThisVariable() {
        return this.cThisVariable;
    }

    public @NonNull Variable getCoreVariable(@NonNull Variable rVariable) throws CompilerChainException {
        return this.getVariableAnalysis(rVariable).getCoreVariable();
    }

    protected @NonNull VariableAnalysis getCoreVariableAnalysis(@NonNull Variable coreVariable) {
        return (VariableAnalysis)ClassUtil.nonNullState((Object)this.cVariable2analysis.get(coreVariable));
    }

    public @NonNull BottomPattern getMiddleBottomPattern() {
        return this.cMiddleBottomPattern;
    }

    public @NonNull GuardPattern getMiddleGuardPattern() {
        return this.cMiddleGuardPattern;
    }

    public @NonNull RealizedVariable getMiddleRealizedVariable() {
        return this.cMiddleRealizedVariable;
    }

    @Nullable OCLExpression getTemplateExp(@NonNull ObjectTemplateExp objectTemplateExp, @NonNull Parameter keyParameter) {
        Property property;
        String keyParameterName = keyParameter.getName();
        for (PropertyTemplateItem propertyTemplateItem : ClassUtil.nullFree((EList)objectTemplateExp.getPart())) {
            property = propertyTemplateItem.getReferredProperty();
            if (!ClassUtil.safeEquals((Object)property.getName(), (Object)keyParameterName)) continue;
            return propertyTemplateItem.getValue();
        }
        EObject eContainer = objectTemplateExp.eContainer();
        if (eContainer instanceof PropertyTemplateItem) {
            Property oppositeProperty;
            PropertyTemplateItem containingPropertyTemplateItem = (PropertyTemplateItem)eContainer;
            property = containingPropertyTemplateItem.getReferredProperty();
            Property property2 = oppositeProperty = property != null ? property.getOpposite() : null;
            if (oppositeProperty != null && ClassUtil.safeEquals((Object)oppositeProperty.getName(), (Object)keyParameterName)) {
                return containingPropertyTemplateItem.getObjContainer();
            }
        }
        return null;
    }

    public @NonNull String getUniqueVariableName(@NonNull String name, @NonNull VariableAnalysis originator) {
        VariableAnalysis oldOriginator = this.name2originator.get(name);
        if (oldOriginator != null) {
            assert (oldOriginator != originator);
            int i = 0;
            while (true) {
                String newName;
                if (!this.name2originator.containsKey(newName = String.valueOf(name) + "_" + i)) {
                    name = newName;
                    break;
                }
                ++i;
            }
        }
        this.name2originator.put(name, originator);
        return name;
    }

    protected @NonNull VariableAnalysis getVariableAnalysis(@NonNull Variable relationVariable) {
        VariableAnalysis analysis = this.rVariable2analysis.get(relationVariable);
        if (analysis == null) {
            assert (QVTbaseUtil.basicGetContainingTransformation((EObject)relationVariable) instanceof RelationalTransformation);
            analysis = relationVariable instanceof IteratorVariable ? new IteratorVariableAnalysis(this, (IteratorVariable)relationVariable) : (relationVariable instanceof LetVariable ? new LetVariableAnalysis(this, (LetVariable)relationVariable) : new RelationVariableAnalysis(this, relationVariable));
            this.rVariable2analysis.put(relationVariable, analysis);
        }
        return analysis;
    }

    public boolean isInvoked() {
        return this.isWhened() || this.isWhered();
    }

    public boolean isWhened() {
        return false;
    }

    public boolean isWhered() {
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ArrayList<@NonNull String> names = new ArrayList<String>(this.name2originator.keySet());
        Collections.sort(names);
        for (String name : names) {
            if (s.length() > 0) {
                s.append("\n");
            }
            s.append(String.valueOf(name) + " => ");
            VariableAnalysis originator = this.name2originator.get(name);
            if (originator == this) continue;
            s.append(originator);
        }
        return s.toString();
    }

    public static class WhenedVariablesAnalysis
    extends VariablesAnalysis {
        public WhenedVariablesAnalysis(@NonNull QVTr2QVTc qvtr2qvtc, @NonNull RelationDomain rEnforcedDomain, @NonNull CoreDomain cEnforcedDomain, @NonNull Type traceClass) throws CompilerChainException {
            super(qvtr2qvtc, rEnforcedDomain, cEnforcedDomain, traceClass);
        }

        @Override
        public boolean isWhened() {
            return true;
        }
    }

    public static class WheredVariablesAnalysis
    extends VariablesAnalysis {
        public WheredVariablesAnalysis(@NonNull QVTr2QVTc qvtr2qvtc, @NonNull RelationDomain rEnforcedDomain, @NonNull CoreDomain cEnforcedDomain, @NonNull Type traceClass) throws CompilerChainException {
            super(qvtr2qvtc, rEnforcedDomain, cEnforcedDomain, traceClass);
        }

        @Override
        public boolean isWhered() {
            return true;
        }
    }
}

