/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtschedule.LoadingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;

public class RootMappingAnalysis {
    protected final @NonNull LoadingRegion loadingRegion;
    private Node nullNode = null;
    private final @NonNull Map<@NonNull ClassDatumAnalysis, @NonNull Map<@Nullable Property, @NonNull Node>> classDatumAnalysis2property2node = new HashMap<ClassDatumAnalysis, Map<Property, Node>>();
    private final @NonNull Map<@NonNull ClassDatumAnalysis, @NonNull Map<@Nullable ClassDatumAnalysis, @NonNull Node>> classDatumAnalysis2type2node = new HashMap<ClassDatumAnalysis, Map<ClassDatumAnalysis, Node>>();

    public RootMappingAnalysis(@NonNull LoadingRegion loadingRegion) {
        this.loadingRegion = loadingRegion;
    }

    public @NonNull Node getIntroducerNode(@NonNull Node consumerNode) {
        Node introducedNode;
        ScheduleManager scheduleManager = RegionUtil.getScheduleManager((Region)this.loadingRegion);
        NavigableEdge containerEdge = null;
        Property parent2childProperty = null;
        ClassDatumAnalysis containingClassDatumAnalysis = null;
        for (NavigableEdge edge : consumerNode.getNavigationEdges()) {
            Property property = edge.getProperty().getOpposite();
            if (property == null || !property.isIsComposite() || property.isIsRequired()) continue;
            containerEdge = edge;
            parent2childProperty = property;
            if (property != scheduleManager.getStandardLibraryHelper().getOclContainerProperty()) break;
            containingClassDatumAnalysis = RegionUtil.getClassDatumAnalysis(edge.getEdgeSource());
            break;
        }
        CompleteEnvironment completeEnvironment = scheduleManager.getEnvironmentFactory().getCompleteEnvironment();
        ClassDatumAnalysis consumedClassDatumAnalysis = RegionUtil.getClassDatumAnalysis(consumerNode);
        Class elementType = consumedClassDatumAnalysis.getClassDatum().getCompleteClass().getPrimaryClass();
        TypedModel typedModel = RegionUtil.getTypedModel(consumedClassDatumAnalysis);
        CollectionType childCollectionType = completeEnvironment.getSetType((Type)elementType, true, null, null);
        ClassDatumAnalysis childrenClassDatumAnalysis = scheduleManager.getClassDatumAnalysis((Class)childCollectionType, typedModel);
        if (parent2childProperty == null) {
            Map<@Nullable ClassDatumAnalysis, @NonNull Node> type2node = this.classDatumAnalysis2type2node.get(consumedClassDatumAnalysis);
            if (type2node == null) {
                type2node = new HashMap<ClassDatumAnalysis, Node>();
                this.classDatumAnalysis2type2node.put(consumedClassDatumAnalysis, type2node);
            }
            if ((introducedNode = type2node.get(null)) == null) {
                introducedNode = RegionUtil.createComposingNode((Region)this.loadingRegion, "\u00ab" + elementType.getName() + "\u00bb", childrenClassDatumAnalysis);
                type2node.put(null, introducedNode);
            }
        } else if (containerEdge != null && containerEdge.getEdgeTarget().isExplicitNull()) {
            Map<@Nullable Property, @NonNull Node> property2node = this.classDatumAnalysis2property2node.get(consumedClassDatumAnalysis);
            if (property2node == null) {
                property2node = new HashMap<Property, Node>();
                this.classDatumAnalysis2property2node.put(consumedClassDatumAnalysis, property2node);
            }
            if ((introducedNode = property2node.get(null)) == null) {
                introducedNode = RegionUtil.createComposingNode((Region)this.loadingRegion, "\u00ab" + elementType.getName() + "-null\u00bb", childrenClassDatumAnalysis);
                property2node.put(null, introducedNode);
                RegionUtil.createNavigationEdge(this.getNullNode(), parent2childProperty, introducedNode, false);
            }
        } else if (containingClassDatumAnalysis != null) {
            Map<@Nullable ClassDatumAnalysis, @NonNull Node> type2node = this.classDatumAnalysis2type2node.get(consumedClassDatumAnalysis);
            if (type2node == null) {
                type2node = new HashMap<ClassDatumAnalysis, Node>();
                this.classDatumAnalysis2type2node.put(consumedClassDatumAnalysis, type2node);
            }
            if ((introducedNode = type2node.get(containingClassDatumAnalysis)) == null) {
                introducedNode = RegionUtil.createComposingNode((Region)this.loadingRegion, "\u00ab" + elementType.getName() + "-oclContents\u00bb", childrenClassDatumAnalysis);
                type2node.put(containingClassDatumAnalysis, introducedNode);
                Node containerNode = RegionUtil.createComposingNode((Region)this.loadingRegion, "\u00ab" + containingClassDatumAnalysis.getClassDatum().getCompleteClass().getName() + "-oclContainer\u00bb", containingClassDatumAnalysis);
                RegionUtil.createNavigationEdge(containerNode, parent2childProperty, introducedNode, false);
            }
        } else {
            Map<@Nullable Property, @NonNull Node> property2node = this.classDatumAnalysis2property2node.get(consumedClassDatumAnalysis);
            if (property2node == null) {
                property2node = new HashMap<Property, Node>();
                this.classDatumAnalysis2property2node.put(consumedClassDatumAnalysis, property2node);
            }
            if ((introducedNode = property2node.get(parent2childProperty)) == null) {
                introducedNode = RegionUtil.createComposingNode((Region)this.loadingRegion, "\u00ab" + elementType.getName() + "-" + parent2childProperty.getName() + "\u00bb", childrenClassDatumAnalysis);
                property2node.put(parent2childProperty, introducedNode);
                Class owningClass = parent2childProperty.getOwningClass();
                assert (owningClass != null);
                containingClassDatumAnalysis = scheduleManager.getClassDatumAnalysis(owningClass, typedModel);
                Node containerNode = RegionUtil.createComposingNode((Region)this.loadingRegion, "\u00ab" + owningClass.getName() + "-" + parent2childProperty.getName() + "\u00bb", containingClassDatumAnalysis);
                RegionUtil.createNavigationEdge(containerNode, parent2childProperty, introducedNode, false);
            }
        }
        return introducedNode;
    }

    protected @NonNull Node getNullNode() {
        Node nullNode2 = this.nullNode;
        if (nullNode2 == null) {
            this.nullNode = nullNode2 = RegionUtil.createNullNode((Region)this.loadingRegion, true, null);
        }
        return nullNode2;
    }
}

