/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.codegen.qvti.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.AS2CGVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGAccumulator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCastExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstant;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstantExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorType;
import org.eclipse.ocl.examples.codegen.cgmodel.CGFinalVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIfExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsEqualExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsKindOfExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLetExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNamedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariableExp;
import org.eclipse.ocl.examples.codegen.generator.GenModelException;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.PrimitiveTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.library.LibraryProperty;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiAnalyzer;
import org.eclipse.qvtd.codegen.qvti.java.QVTiGlobalContext;
import org.eclipse.qvtd.codegen.qvticgmodel.CGConnectionAssignment;
import org.eclipse.qvtd.codegen.qvticgmodel.CGConnectionVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGEcoreContainerAssignment;
import org.eclipse.qvtd.codegen.qvticgmodel.CGEcorePropertyAssignment;
import org.eclipse.qvtd.codegen.qvticgmodel.CGEcoreRealizedVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGFunction;
import org.eclipse.qvtd.codegen.qvticgmodel.CGFunctionCallExp;
import org.eclipse.qvtd.codegen.qvticgmodel.CGFunctionParameter;
import org.eclipse.qvtd.codegen.qvticgmodel.CGGuardVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMapping;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMappingCall;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMappingCallBinding;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMappingExp;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMappingLoop;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMiddlePropertyAssignment;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMiddlePropertyCallExp;
import org.eclipse.qvtd.codegen.qvticgmodel.CGPropertyAssignment;
import org.eclipse.qvtd.codegen.qvticgmodel.CGRealizedVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGSequence;
import org.eclipse.qvtd.codegen.qvticgmodel.CGTransformation;
import org.eclipse.qvtd.codegen.qvticgmodel.CGTypedModel;
import org.eclipse.qvtd.codegen.qvticgmodel.QVTiCGModelFactory;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.FunctionParameter;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.AddStatement;
import org.eclipse.qvtd.pivot.qvtimperative.AppendParameter;
import org.eclipse.qvtd.pivot.qvtimperative.AppendParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.BufferStatement;
import org.eclipse.qvtd.pivot.qvtimperative.CheckStatement;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionVariable;
import org.eclipse.qvtd.pivot.qvtimperative.DeclareStatement;
import org.eclipse.qvtd.pivot.qvtimperative.GuardParameter;
import org.eclipse.qvtd.pivot.qvtimperative.GuardParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.LoopParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.LoopVariable;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingLoop;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameter;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.NewStatement;
import org.eclipse.qvtd.pivot.qvtimperative.ObservableStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SetStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SimpleParameter;
import org.eclipse.qvtd.pivot.qvtimperative.SimpleParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.Statement;
import org.eclipse.qvtd.pivot.qvtimperative.VariableStatement;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTransformationAnalysis;
import org.eclipse.qvtd.pivot.qvtimperative.util.QVTimperativeVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;

public class QVTiAS2CGVisitor
extends AS2CGVisitor
implements QVTimperativeVisitor<CGNamedElement> {
    protected final @NonNull QVTiAnalyzer analyzer;
    protected final @NonNull QVTiGlobalContext globalContext;
    protected final @NonNull StandardLibraryInternal standardLibrary;
    private @Nullable PredicateTreeBuilder bodyBuilder;

    public QVTiAS2CGVisitor(@NonNull QVTiAnalyzer analyzer, @NonNull QVTiGlobalContext globalContext) {
        super((CodeGenAnalyzer)analyzer);
        this.analyzer = analyzer;
        this.globalContext = globalContext;
        this.standardLibrary = this.environmentFactory.getStandardLibrary();
    }

    private @NonNull Set<@NonNull Mapping> computeUseClases(@NonNull ImperativeTransformation asTransformation) {
        HashMap<@NonNull Mapping, @NonNull Integer> mapping2intervalIndex = new HashMap<Mapping, Integer>();
        int intervalIndex = 0;
        for (Mapping asMapping : QVTimperativeUtil.getOwnedMappings((ImperativeTransformation)asTransformation)) {
            mapping2intervalIndex.put(asMapping, intervalIndex++);
        }
        HashMap<@NonNull ConnectionVariable, @NonNull Integer> connectionValue2latestIntervalIndex = new HashMap<ConnectionVariable, Integer>();
        for (Mapping asMapping : QVTimperativeUtil.getOwnedMappings((ImperativeTransformation)asTransformation)) {
            for (EObject eObject : new TreeIterable((EObject)asMapping, false)) {
                if (!(eObject instanceof AppendParameterBinding)) continue;
                AppendParameterBinding appendParameterBinding = (AppendParameterBinding)eObject;
                MappingCall mappingCall = QVTimperativeUtil.getOwningMappingCall((MappingParameterBinding)appendParameterBinding);
                Mapping referredMapping = mappingCall.getReferredMapping();
                Integer appendingIntervalIndex = (Integer)mapping2intervalIndex.get(referredMapping);
                assert (appendingIntervalIndex != null);
                ConnectionVariable connectionValue = appendParameterBinding.getValue();
                assert (connectionValue != null);
                Integer latestIntervalIndex = (Integer)connectionValue2latestIntervalIndex.get(connectionValue);
                if (latestIntervalIndex != null && latestIntervalIndex >= appendingIntervalIndex) continue;
                connectionValue2latestIntervalIndex.put(connectionValue, appendingIntervalIndex);
            }
        }
        HashSet<@NonNull Mapping> useClassMappings = new HashSet<Mapping>();
        for (Mapping asMapping : QVTimperativeUtil.getOwnedMappings((ImperativeTransformation)asTransformation)) {
            for (EObject eObject : new TreeIterable((EObject)asMapping, false)) {
                if (!(eObject instanceof GuardParameterBinding)) continue;
                GuardParameterBinding guardParameterBinding = (GuardParameterBinding)eObject;
                MappingCall mappingCall = QVTimperativeUtil.getOwningMappingCall((MappingParameterBinding)guardParameterBinding);
                Mapping referredMapping = mappingCall.getReferredMapping();
                assert (referredMapping != null);
                Integer consumingIntervalIndex = (Integer)mapping2intervalIndex.get(referredMapping);
                assert (consumingIntervalIndex != null);
                ConnectionVariable connectionValue = guardParameterBinding.getValue();
                assert (connectionValue != null);
                Integer latestIntervalIndex = (Integer)connectionValue2latestIntervalIndex.get(connectionValue);
                if (latestIntervalIndex == null) {
                    latestIntervalIndex = 0;
                }
                if (latestIntervalIndex < consumingIntervalIndex) continue;
                useClassMappings.add(referredMapping);
            }
        }
        for (Mapping asMapping : QVTimperativeUtil.getOwnedMappings((ImperativeTransformation)asTransformation)) {
            if (asMapping.isIsStrict()) {
                useClassMappings.add(asMapping);
                continue;
            }
            if (!QVTimperativeUtil.isObserver((Mapping)asMapping)) continue;
            useClassMappings.add(asMapping);
        }
        if (useClassMappings.size() > 0) {
            useClassMappings.add(QVTimperativeUtil.getRootMapping((ImperativeTransformation)asTransformation));
        }
        return useClassMappings;
    }

    protected <T extends EObject> @NonNull T createCopy(@NonNull T aPrototype) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        EObject aCopy = copier.copy(aPrototype);
        assert (aCopy != null);
        copier.copyReferences();
        EObject castCopy = aCopy;
        return (T)castCopy;
    }

    protected @NonNull CGValuedElement generateOperationCallExp(@Nullable CGValuedElement cgSource, @NonNull OperationCallExp asOperationCallExp) {
        Operation pOperation = asOperationCallExp.getReferredOperation();
        if (pOperation instanceof Function) {
            if (cgSource == null) {
                Transformation asTransformation = QVTbaseUtil.getContainingTransformation((EObject)asOperationCallExp);
                Variable asThis = QVTbaseUtil.getContextVariable((StandardLibrary)this.standardLibrary, (Transformation)asTransformation);
                VariableExp asThisExp = PivotUtil.createVariableExp((VariableDeclaration)asThis);
                cgSource = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asThisExp);
            }
            CGFunctionCallExp cgFunctionCallExp = QVTiCGModelFactory.eINSTANCE.createCGFunctionCallExp();
            cgFunctionCallExp.setReferredOperation(pOperation);
            this.setAst((CGTypedElement)cgFunctionCallExp, (TypedElement)asOperationCallExp);
            cgFunctionCallExp.setRequired(pOperation.isIsRequired());
            cgFunctionCallExp.setSource(cgSource);
            for (OCLExpression pArgument : asOperationCallExp.getOwnedArguments()) {
                CGValuedElement cgArgument = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)pArgument);
                cgFunctionCallExp.getArguments().add(cgArgument);
            }
            return cgFunctionCallExp;
        }
        return super.generateOperationCallExp(cgSource, asOperationCallExp);
    }

    protected @NonNull CGValuedElement generateOppositePropertyCallExp(@NonNull CGValuedElement cgSource, @NonNull OppositePropertyCallExp asOppositePropertyCallExp) {
        Property asOppositeProperty = (Property)ClassUtil.nonNullModel((Object)asOppositePropertyCallExp.getReferredProperty());
        Property asProperty = (Property)ClassUtil.nonNullModel((Object)asOppositeProperty.getOpposite());
        if (asOppositeProperty.isIsComposite()) {
            return super.generateOppositePropertyCallExp(cgSource, asOppositePropertyCallExp);
        }
        this.globalContext.addOppositeProperty(asOppositeProperty);
        CGMiddlePropertyCallExp cgPropertyCallExp = QVTiCGModelFactory.eINSTANCE.createCGMiddlePropertyCallExp();
        cgPropertyCallExp.setAst((Element)asOppositePropertyCallExp);
        cgPropertyCallExp.setReferredProperty(asProperty);
        this.setAst((CGTypedElement)cgPropertyCallExp, (TypedElement)asOppositePropertyCallExp);
        cgPropertyCallExp.setRequired(asProperty.isIsRequired());
        cgPropertyCallExp.setSource(cgSource);
        return cgPropertyCallExp;
    }

    private @NonNull PredicateTreeBuilder getBodyBuilder() {
        assert (this.bodyBuilder != null);
        return this.bodyBuilder;
    }

    protected @Nullable EClassifier getEClassifier(@Nullable Type type) {
        if (type == null) {
            return null;
        }
        CompleteClassInternal completeClass = this.environmentFactory.getCompleteModel().getCompleteClass(type);
        for (Type partialClass : completeClass.getPartialClasses()) {
            EObject esObject = partialClass.getESObject();
            if (!(esObject instanceof EClassifier)) continue;
            return (EClassifier)esObject;
        }
        return null;
    }

    public @NonNull CGFunctionParameter getFunctionParameter(@NonNull FunctionParameter asFunctionParameter) {
        CGFunctionParameter cgFunctionParameter = (CGFunctionParameter)this.getVariablesStack().getParameter((VariableDeclaration)asFunctionParameter);
        if (cgFunctionParameter == null) {
            cgFunctionParameter = QVTiCGModelFactory.eINSTANCE.createCGFunctionParameter();
            this.analyzer.setNames((CGValuedElement)cgFunctionParameter, asFunctionParameter);
            this.setAst((CGTypedElement)cgFunctionParameter, (TypedElement)asFunctionParameter);
            cgFunctionParameter.setTypeId(this.analyzer.getTypeId(asFunctionParameter.getTypeId()));
            if (asFunctionParameter.isIsRequired()) {
                cgFunctionParameter.setNonNull();
            }
            this.addParameter((VariableDeclaration)asFunctionParameter, cgFunctionParameter);
        }
        return cgFunctionParameter;
    }

    public @NonNull CGGuardVariable getGuardVariable(@NonNull VariableDeclaration asVariable) {
        CGGuardVariable cgGuardVariable = (CGGuardVariable)this.getVariablesStack().getParameter(asVariable);
        assert (cgGuardVariable == null);
        boolean isConnectionVariable = asVariable instanceof ConnectionVariable;
        boolean isPrimitiveVariable = QVTimperativeUtil.isPrimitiveVariable((VariableDeclaration)asVariable);
        cgGuardVariable = isConnectionVariable ? QVTiCGModelFactory.eINSTANCE.createCGConnectionVariable() : QVTiCGModelFactory.eINSTANCE.createCGGuardVariable();
        this.analyzer.setNames((CGValuedElement)cgGuardVariable, asVariable);
        this.setAst((CGTypedElement)cgGuardVariable, (TypedElement)asVariable);
        cgGuardVariable.setTypeId(this.analyzer.getTypeId(asVariable.getTypeId()));
        if (!isConnectionVariable && !isPrimitiveVariable) {
            cgGuardVariable.setTypedModel(this.getTypedModel(asVariable));
        }
        this.addParameter(asVariable, cgGuardVariable);
        return cgGuardVariable;
    }

    public @NonNull CGRealizedVariable getRealizedVariable(@NonNull NewStatement pNewStatement) {
        AS2CGVisitor.Variables variablesStack = this.getVariablesStack();
        CGVariable cgVariable2 = variablesStack.getVariable((VariableDeclaration)pNewStatement);
        CGRealizedVariable cgVariable = (CGRealizedVariable)cgVariable2;
        if (cgVariable == null) {
            EClassifier eClassifier = this.getEClassifier(pNewStatement.getType());
            if (eClassifier != null) {
                CGEcoreRealizedVariable cgEcoreRealizedVariable = QVTiCGModelFactory.eINSTANCE.createCGEcoreRealizedVariable();
                cgEcoreRealizedVariable.setEClassifier(eClassifier);
                cgVariable = cgEcoreRealizedVariable;
            }
            if (cgVariable == null) {
                cgVariable = QVTiCGModelFactory.eINSTANCE.createCGRealizedVariable();
            }
            this.setAst((CGTypedElement)cgVariable, (TypedElement)pNewStatement);
            ImperativeTypedModel asTypedModel = (ImperativeTypedModel)ClassUtil.nonNullState((Object)pNewStatement.getReferredTypedModel());
            CGTypedModel cgTypedModel = (CGTypedModel)ClassUtil.nonNullState((Object)this.analyzer.getTypedModel(asTypedModel));
            cgVariable.setTypedModel(cgTypedModel);
            variablesStack.putVariable((VariableDeclaration)pNewStatement, (CGVariable)cgVariable);
        }
        return cgVariable;
    }

    protected @NonNull CGTypedModel getTypedModel(@NonNull VariableDeclaration pVariable) {
        if (pVariable instanceof GuardParameter) {
            ImperativeTypedModel referredTypedModel = (ImperativeTypedModel)ClassUtil.nonNullState((Object)((GuardParameter)pVariable).getReferredTypedModel());
            return (CGTypedModel)ClassUtil.nonNullState((Object)this.analyzer.getTypedModel(referredTypedModel));
        }
        ImperativeTransformation pTransformation = QVTimperativeUtil.getContainingTransformation((EObject)pVariable);
        ImperativeTypedModel asTypedModel = (ImperativeTypedModel)ClassUtil.nonNullState((Object)pTransformation.getModelParameter(null));
        return (CGTypedModel)ClassUtil.nonNullState((Object)this.analyzer.getTypedModel(asTypedModel));
    }

    protected @Nullable CGValuedElement inlineOperationCall(@NonNull OperationCallExp callExp, @NonNull LanguageExpression specification) {
        CGValuedElement cgInlineOperationCall = super.inlineOperationCall(callExp, specification);
        if (cgInlineOperationCall != null) {
            Element asInlineOperationCall = cgInlineOperationCall.getAst();
            asInlineOperationCall.eAdapters().add((Object)new InlinedBodyAdapter(callExp));
        }
        return cgInlineOperationCall;
    }

    public @Nullable CGNamedElement visitAddStatement(@NonNull AddStatement asAddStatement) {
        ConnectionVariable asVariable = asAddStatement.getTargetVariable();
        if (asVariable == null) {
            return null;
        }
        CGVariable cgVariable = this.getVariable((VariableDeclaration)asVariable);
        OCLExpression asInitValue = asAddStatement.getOwnedExpression();
        assert (cgVariable instanceof CGConnectionVariable);
        CGValuedElement initValue = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asInitValue);
        CGConnectionAssignment cgConnectionAssignment = QVTiCGModelFactory.eINSTANCE.createCGConnectionAssignment();
        cgConnectionAssignment.setConnectionVariable(cgVariable);
        cgConnectionAssignment.setOwnedInitValue(initValue);
        cgConnectionAssignment.setTypeId(initValue.getTypeId());
        cgConnectionAssignment.setRequired(initValue.isRequired());
        return cgConnectionAssignment;
    }

    public @Nullable CGNamedElement visitAppendParameter(@NonNull AppendParameter object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitAppendParameterBinding(@NonNull AppendParameterBinding asAppendParameterBinding) {
        MappingParameter asBoundVariable = asAppendParameterBinding.getBoundVariable();
        CGMappingCallBinding cgMappingCallBinding = QVTiCGModelFactory.eINSTANCE.createCGMappingCallBinding();
        cgMappingCallBinding.setName(asBoundVariable.getName());
        cgMappingCallBinding.setAst((Element)asAppendParameterBinding);
        cgMappingCallBinding.setRequired(asBoundVariable.isIsRequired());
        ConnectionVariable asVariable = asAppendParameterBinding.getValue();
        assert (asVariable != null);
        CGVariable cgVariable = this.getVariable((VariableDeclaration)asVariable);
        CGVariableExp cgVariableExp = CGModelFactory.eINSTANCE.createCGVariableExp();
        this.setAst((CGTypedElement)cgVariableExp, (TypedElement)ClassUtil.nonNullModel((Object)asVariable));
        cgVariableExp.setReferredVariable(cgVariable);
        cgMappingCallBinding.setOwnedValue((CGValuedElement)cgVariableExp);
        cgMappingCallBinding.setTypeId(this.analyzer.getTypeId(asBoundVariable.getTypeId()));
        return cgMappingCallBinding;
    }

    public @Nullable CGNamedElement visitBaseModel(@NonNull BaseModel object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitBufferStatement(@NonNull BufferStatement asVariable) {
        OCLExpression asInit = asVariable.getOwnedExpression();
        CGAccumulator cgAccumulator = CGModelFactory.eINSTANCE.createCGAccumulator();
        cgAccumulator.setAst((Element)asVariable);
        cgAccumulator.setName(asVariable.getName());
        if (asInit != null) {
            CGValuedElement cgInit = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asInit);
            TypeId typeId = asInit.getTypeId();
            if (typeId instanceof CollectionTypeId) {
                typeId = ((CollectionTypeId)typeId).getElementTypeId();
            }
            cgAccumulator.setTypeId(this.analyzer.getTypeId(typeId));
            cgAccumulator.setInit(cgInit);
        } else {
            cgAccumulator.setTypeId(this.analyzer.getTypeId(asVariable.getTypeId()));
        }
        cgAccumulator.setNonNull();
        this.getBodyBuilder().addAccumulator(cgAccumulator);
        this.getVariablesStack().putVariable((VariableDeclaration)asVariable, (CGVariable)cgAccumulator);
        return null;
    }

    public @Nullable CGNamedElement visitCheckStatement(@NonNull CheckStatement asPredicate) {
        CGIfExp cgPredicate = CGModelFactory.eINSTANCE.createCGIfExp();
        cgPredicate.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
        cgPredicate.setRequired(true);
        OCLExpression asConditionExpression = asPredicate.getOwnedExpression();
        assert (asConditionExpression != null);
        cgPredicate.setCondition((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asConditionExpression));
        CGConstantExp cgElse = this.analyzer.createCGConstantExp(asConditionExpression, (CGConstant)this.analyzer.getBoolean(false));
        this.setAst((CGTypedElement)cgElse, (TypedElement)asConditionExpression);
        cgElse.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
        cgElse.setRequired(true);
        cgPredicate.setElseExpression((CGValuedElement)cgElse);
        this.getBodyBuilder().appendSubTree((CGValuedElement)cgPredicate);
        return null;
    }

    public @Nullable CGNamedElement visitConnectionVariable(@NonNull ConnectionVariable object) {
        return this.visiting((Visitable)object);
    }

    public CGNamedElement visitDeclareStatement(@NonNull DeclareStatement asVariable) {
        OCLExpression asInit = asVariable.getOwnedExpression();
        assert (asInit != null);
        if (!asVariable.isIsCheck()) {
            this.getBodyBuilder().appendCheckedLetVariable((VariableDeclaration)asVariable, asInit);
        } else {
            CGValuedElement cgExpression = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asInit);
            cgExpression.setName("temp1_" + asVariable.getName());
            CGFinalVariable cgUncastVariable = CGModelFactory.eINSTANCE.createCGFinalVariable();
            cgUncastVariable.setName("temp2_" + asVariable.getName());
            cgUncastVariable.setInit(cgExpression);
            cgUncastVariable.setTypeId(cgExpression.getTypeId());
            cgUncastVariable.setRequired(cgExpression.isRequired());
            CGLetExp cgOuterLetExp = CGModelFactory.eINSTANCE.createCGLetExp();
            this.setAst((CGTypedElement)cgOuterLetExp, (TypedElement)asVariable);
            cgOuterLetExp.setInit((CGVariable)cgUncastVariable);
            cgOuterLetExp.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
            cgOuterLetExp.setRequired(true);
            CGIfExp cgPredicate = CGModelFactory.eINSTANCE.createCGIfExp();
            cgPredicate.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
            cgPredicate.setRequired(true);
            CGConstantExp cgElse = this.analyzer.createCGConstantExp(asInit, (CGConstant)this.analyzer.getBoolean(false));
            this.setAst((CGTypedElement)cgElse, (TypedElement)asVariable);
            cgElse.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
            cgElse.setRequired(true);
            cgPredicate.setElseExpression((CGValuedElement)cgElse);
            CGIsKindOfExp cgIsKindOfExp = CGModelFactory.eINSTANCE.createCGIsKindOfExp();
            cgIsKindOfExp.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
            cgIsKindOfExp.setRequired(true);
            CGVariableExp cgUncastVariableExp1 = CGModelFactory.eINSTANCE.createCGVariableExp();
            this.setAst((CGTypedElement)cgUncastVariableExp1, (TypedElement)asVariable);
            cgUncastVariableExp1.setReferredVariable((CGVariable)cgUncastVariable);
            cgUncastVariableExp1.setTypeId(cgUncastVariable.getTypeId());
            cgUncastVariableExp1.setRequired(cgUncastVariable.isRequired());
            cgIsKindOfExp.setSource((CGValuedElement)cgUncastVariableExp1);
            CGExecutorType cgExecutorType = this.analyzer.createExecutorType((Type)ClassUtil.nonNullState((Object)asVariable.getType()));
            cgIsKindOfExp.setExecutorType(cgExecutorType);
            cgPredicate.setCondition((CGValuedElement)cgIsKindOfExp);
            cgOuterLetExp.setIn((CGValuedElement)cgPredicate);
            CGVariableExp cgUncastVariableExp2 = CGModelFactory.eINSTANCE.createCGVariableExp();
            this.setAst((CGTypedElement)cgUncastVariableExp2, (TypedElement)asVariable);
            cgUncastVariableExp2.setReferredVariable((CGVariable)cgUncastVariable);
            cgUncastVariableExp2.setTypeId(cgUncastVariable.getTypeId());
            cgUncastVariableExp2.setRequired(cgUncastVariable.isRequired());
            CGCastExp cgCastExp = CGModelFactory.eINSTANCE.createCGCastExp();
            cgCastExp.setSource((CGValuedElement)cgUncastVariableExp2);
            cgCastExp.setExecutorType(cgExecutorType);
            TypeId asTypeId = cgExecutorType.getASTypeId();
            assert (asTypeId != null);
            cgCastExp.setTypeId(this.analyzer.getTypeId(asTypeId));
            CGFinalVariable cgCastVariable = (CGFinalVariable)this.createCGVariable((VariableDeclaration)asVariable);
            cgCastVariable.setInit((CGValuedElement)cgCastExp);
            CGLetExp cgCastLetExp = CGModelFactory.eINSTANCE.createCGLetExp();
            this.setAst((CGTypedElement)cgCastLetExp, (TypedElement)asVariable);
            cgCastLetExp.setInit((CGVariable)cgCastVariable);
            cgCastLetExp.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
            cgCastLetExp.setRequired(true);
            cgPredicate.setThenExpression((CGValuedElement)cgCastLetExp);
            this.getBodyBuilder().appendSubTree((CGValuedElement)cgCastLetExp);
        }
        return null;
    }

    public @Nullable CGNamedElement visitDomain(@NonNull Domain object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitFunction(@NonNull Function asFunction) {
        CGFunction cgFunction = QVTiCGModelFactory.eINSTANCE.createCGFunction();
        this.setAst((CGTypedElement)cgFunction, (TypedElement)asFunction);
        cgFunction.setRequired(asFunction.isIsRequired());
        for (Parameter pParameter : asFunction.getOwnedParameters()) {
            cgFunction.getParameters().add((CGParameter)this.doVisit(CGParameter.class, (Element)pParameter));
        }
        OCLExpression query = asFunction.getQueryExpression();
        if (query != null) {
            cgFunction.setBody((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)query));
        }
        this.analyzer.addFunction(asFunction, cgFunction);
        return cgFunction;
    }

    public @Nullable CGNamedElement visitFunctionParameter(@NonNull FunctionParameter asFunctionParameter) {
        return this.getFunctionParameter(asFunctionParameter);
    }

    public @Nullable CGNamedElement visitGuardParameter(@NonNull GuardParameter object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitGuardParameterBinding(@NonNull GuardParameterBinding asGuardParameterBinding) {
        MappingParameter asBoundVariable = asGuardParameterBinding.getBoundVariable();
        CGMappingCallBinding cgMappingCallBinding = QVTiCGModelFactory.eINSTANCE.createCGMappingCallBinding();
        cgMappingCallBinding.setName(asBoundVariable.getName());
        cgMappingCallBinding.setAst((Element)asGuardParameterBinding);
        cgMappingCallBinding.setRequired(asBoundVariable.isIsRequired());
        ConnectionVariable asVariable = asGuardParameterBinding.getValue();
        assert (asVariable != null);
        CGVariable cgVariable = this.getVariable((VariableDeclaration)asVariable);
        CGVariableExp cgVariableExp = CGModelFactory.eINSTANCE.createCGVariableExp();
        this.setAst((CGTypedElement)cgVariableExp, (TypedElement)ClassUtil.nonNullModel((Object)asVariable));
        cgVariableExp.setReferredVariable(cgVariable);
        cgMappingCallBinding.setOwnedValue((CGValuedElement)cgVariableExp);
        cgMappingCallBinding.setTypeId(this.analyzer.getTypeId(asBoundVariable.getTypeId()));
        return cgMappingCallBinding;
    }

    public @Nullable CGNamedElement visitImperativeModel(@NonNull ImperativeModel object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitImperativeTransformation(@NonNull ImperativeTransformation asTransformation) {
        this.analyzer.getCodeGenerator().getTransformationAnalysis(asTransformation);
        CGTransformation cgTransformation = QVTiCGModelFactory.eINSTANCE.createCGTransformation();
        this.setAst((CGNamedElement)cgTransformation, (NamedElement)asTransformation);
        this.pushCurrentClass(cgTransformation);
        List<CGTypedModel> cgTypedModels = cgTransformation.getOwnedTypedModels();
        for (ImperativeTypedModel asTypedModel : QVTimperativeUtil.getOwnedTypedModels((ImperativeTransformation)asTransformation)) {
            CGTypedModel cgTypedModel = (CGTypedModel)this.doVisit(CGTypedModel.class, (Element)asTypedModel);
            cgTypedModel.setModelIndex(cgTypedModels.size());
            cgTypedModels.add(cgTypedModel);
        }
        Set<@NonNull Mapping> useClasses = this.computeUseClases(asTransformation);
        for (Mapping asMapping : QVTimperativeUtil.getOwnedMappings((ImperativeTransformation)asTransformation)) {
            CGMapping cgMapping = (CGMapping)this.doVisit(CGMapping.class, (Element)asMapping);
            cgTransformation.getOwnedMappings().add(cgMapping);
            if (!useClasses.contains(asMapping)) continue;
            cgMapping.setUseClass(true);
        }
        for (Operation asOperation : asTransformation.getOwnedOperations()) {
            CGOperation cgOperation = (CGOperation)this.doVisit(CGOperation.class, (Element)asOperation);
            cgTransformation.getOperations().add(cgOperation);
        }
        this.popCurrentClass(cgTransformation);
        return cgTransformation;
    }

    public @Nullable CGNamedElement visitImperativeTypedModel(@NonNull ImperativeTypedModel asTypedModel) {
        CGTypedModel cgTypedModel = QVTiCGModelFactory.eINSTANCE.createCGTypedModel();
        this.setAst(cgTypedModel, (NamedElement)asTypedModel);
        this.analyzer.addTypedModel(asTypedModel, cgTypedModel);
        return cgTypedModel;
    }

    public @Nullable CGNamedElement visitLoopParameterBinding(@NonNull LoopParameterBinding asLoopParameterBinding) {
        MappingParameter asBoundVariable = asLoopParameterBinding.getBoundVariable();
        CGMappingCallBinding cgMappingCallBinding = QVTiCGModelFactory.eINSTANCE.createCGMappingCallBinding();
        cgMappingCallBinding.setName(asBoundVariable.getName());
        cgMappingCallBinding.setAst((Element)asLoopParameterBinding);
        cgMappingCallBinding.setRequired(asBoundVariable.isIsRequired());
        LoopVariable asVariable = asLoopParameterBinding.getValue();
        assert (asVariable != null);
        CGVariable cgVariable = this.getVariable((VariableDeclaration)asVariable);
        CGVariableExp cgVariableExp = CGModelFactory.eINSTANCE.createCGVariableExp();
        this.setAst((CGTypedElement)cgVariableExp, (TypedElement)ClassUtil.nonNullModel((Object)asVariable));
        cgVariableExp.setReferredVariable(cgVariable);
        cgMappingCallBinding.setOwnedValue((CGValuedElement)cgVariableExp);
        cgMappingCallBinding.setTypeId(this.analyzer.getTypeId(asBoundVariable.getTypeId()));
        return cgMappingCallBinding;
    }

    public @Nullable CGNamedElement visitLoopVariable(@NonNull LoopVariable asVariable) {
        return this.visiting((Visitable)asVariable);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable CGNamedElement visitMapping(@NonNull Mapping pMapping) {
        String name = pMapping.getName();
        CGMapping cgMapping = QVTiCGModelFactory.eINSTANCE.createCGMapping();
        this.setAst(cgMapping, (NamedElement)pMapping);
        this.analyzer.addMapping(pMapping, cgMapping);
        PredicateTreeBuilder bodyBuilder2 = this.bodyBuilder = new PredicateTreeBuilder(pMapping, cgMapping);
        bodyBuilder2.doBottoms();
        @NonNull List cgFreeVariables = ClassUtil.nullFree(cgMapping.getOwnedGuardVariables());
        ArrayList<@NonNull E> sortedVariables = new ArrayList(cgFreeVariables);
        Collections.sort(sortedVariables, CGVariableComparator.INSTANCE);
        cgFreeVariables.clear();
        cgFreeVariables.addAll(sortedVariables);
        this.bodyBuilder = null;
        return cgMapping;
    }

    public CGNamedElement visitMappingCall(@NonNull MappingCall asMappingCall) {
        CGMappingCall cgMappingCall = QVTiCGModelFactory.eINSTANCE.createCGMappingCall();
        this.setAst((CGNamedElement)cgMappingCall, (NamedElement)asMappingCall);
        ArrayList<@NonNull CGMappingCallBinding> cgMappingCallBindings = new ArrayList<CGMappingCallBinding>();
        for (MappingParameterBinding asMappingCallBinding : QVTimperativeUtil.getOwnedMappingParameterBindings((MappingCall)asMappingCall)) {
            CGMappingCallBinding cgMappingCallBinding = (CGMappingCallBinding)this.doVisit(CGMappingCallBinding.class, (Element)asMappingCallBinding);
            cgMappingCallBindings.add(cgMappingCallBinding);
        }
        Collections.sort(cgMappingCallBindings, CGMappingCallBindingComparator.INSTANCE);
        cgMappingCall.getOwnedMappingCallBindings().addAll(cgMappingCallBindings);
        return cgMappingCall;
    }

    public CGNamedElement visitMappingLoop(@NonNull MappingLoop asMappingLoop) {
        LoopVariable asIterator;
        CGMappingLoop cgMappingLoop = QVTiCGModelFactory.eINSTANCE.createCGMappingLoop();
        EList asIterators = asMappingLoop.getOwnedIterators();
        if (asIterators.size() > 0 && (asIterator = (LoopVariable)asIterators.get(0)) != null) {
            CGIterator cgIterator = this.getIterator((VariableDeclaration)asIterator);
            cgIterator.setTypeId(this.analyzer.getTypeId(asIterator.getTypeId()));
            cgIterator.setRequired(asIterator.isIsRequired());
            if (asIterator.isIsRequired()) {
                cgIterator.setNonNull();
            }
            cgMappingLoop.getIterators().add(cgIterator);
        }
        cgMappingLoop.setSource((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asMappingLoop.getOwnedExpression()));
        cgMappingLoop.setAst((Element)asMappingLoop);
        CollectionType collectionType = this.standardLibrary.getCollectionType();
        Operation forAllIteration = (Operation)NameUtil.getNameable((Iterable)collectionType.getOwnedOperations(), (String)"forAll");
        cgMappingLoop.setReferredIteration((Iteration)forAllIteration);
        CGSequence cgSequence = QVTiCGModelFactory.eINSTANCE.createCGSequence();
        List<CGValuedElement> cgMappingStatements = cgSequence.getOwnedStatements();
        for (MappingStatement asMappingStatement : asMappingLoop.getOwnedMappingStatements()) {
            CGValuedElement cgMappingStatement = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asMappingStatement);
            cgMappingStatements.add(cgMappingStatement);
        }
        cgMappingLoop.setBody(cgSequence);
        return cgMappingLoop;
    }

    public CGNamedElement visitMappingParameter(@NonNull MappingParameter object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitMappingParameterBinding(@NonNull MappingParameterBinding object) {
        return this.visiting((Visitable)object);
    }

    public CGNamedElement visitMappingStatement(@NonNull MappingStatement object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitNewStatement(@NonNull NewStatement asNewStatement) {
        OCLExpression asInit = asNewStatement.getOwnedExpression();
        if (asInit == null) {
            this.getBodyBuilder().addRealizedVariable(asNewStatement);
        } else {
            this.getBodyBuilder().appendCheckedLetVariable((VariableDeclaration)asNewStatement, asInit);
        }
        return null;
    }

    public CGNamedElement visitObservableStatement(@NonNull ObservableStatement object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitPattern(@NonNull Pattern object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitPredicate(@NonNull Predicate object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitRule(@NonNull Rule object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitSetStatement(@NonNull SetStatement asSetStatement) {
        ImperativeTransformation asTransformation = QVTimperativeUtil.getContainingTransformation((EObject)asSetStatement);
        QVTiTransformationAnalysis transformationAnalysis = this.analyzer.getCodeGenerator().getTransformationAnalysis(asTransformation);
        Integer cacheIndex = transformationAnalysis.getCacheIndex(asSetStatement);
        if (cacheIndex != null) {
            CGMiddlePropertyAssignment cgPropertyAssignment = QVTiCGModelFactory.eINSTANCE.createCGMiddlePropertyAssignment();
            this.setAst((CGNamedElement)cgPropertyAssignment, (NamedElement)asSetStatement);
            VariableDeclaration asVariable = asSetStatement.getTargetVariable();
            assert (asVariable != null);
            CGVariable cgVariable = this.getVariable(asVariable);
            cgPropertyAssignment.setOwnedSlotValue((CGValuedElement)this.analyzer.createCGVariableExp(cgVariable));
            Property asProperty = QVTimperativeUtil.getTargetProperty((SetStatement)asSetStatement);
            cgPropertyAssignment.setReferredProperty(asProperty);
            cgPropertyAssignment.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.OCL_VOID));
            cgPropertyAssignment.setOwnedInitValue((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asSetStatement.getOwnedExpression()));
            EStructuralFeature eStructuralFeature = (EStructuralFeature)asProperty.getESObject();
            if (eStructuralFeature != null) {
                try {
                    this.genModelHelper.getGetAccessor(eStructuralFeature);
                    cgPropertyAssignment.setEStructuralFeature(eStructuralFeature);
                }
                catch (GenModelException e) {
                    this.codeGenerator.addProblem((Exception)((Object)e));
                }
            }
            return cgPropertyAssignment;
        }
        Property asTargetProperty = QVTimperativeUtil.getTargetProperty((SetStatement)asSetStatement);
        LibraryProperty libraryProperty = this.metamodelManager.getImplementation((Element)asSetStatement, null, asTargetProperty);
        CGPropertyAssignment cgPropertyAssignment = null;
        if (this.isEcoreProperty(libraryProperty)) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)asTargetProperty.getESObject();
            if (eStructuralFeature != null) {
                try {
                    this.genModelHelper.getGetAccessor(eStructuralFeature);
                    CGEcorePropertyAssignment cgEcorePropertyAssignment = QVTiCGModelFactory.eINSTANCE.createCGEcorePropertyAssignment();
                    cgEcorePropertyAssignment.setEStructuralFeature(eStructuralFeature);
                    cgPropertyAssignment = cgEcorePropertyAssignment;
                }
                catch (GenModelException e) {
                    this.codeGenerator.addProblem((Exception)((Object)e));
                }
            } else {
                Property asOppositeProperty = asTargetProperty.getOpposite();
                eStructuralFeature = (EStructuralFeature)(asOppositeProperty != null ? asOppositeProperty.getESObject() : null);
                if (eStructuralFeature != null) {
                    assert (((EReference)eStructuralFeature).isContainment());
                    try {
                        this.genModelHelper.getGetAccessor(eStructuralFeature);
                        CGEcoreContainerAssignment cgEcoreContainerAssignment = QVTiCGModelFactory.eINSTANCE.createCGEcoreContainerAssignment();
                        cgEcoreContainerAssignment.setEStructuralFeature(eStructuralFeature);
                        cgPropertyAssignment = cgEcoreContainerAssignment;
                    }
                    catch (GenModelException e) {
                        this.codeGenerator.addProblem((Exception)((Object)e));
                    }
                }
            }
        }
        if (cgPropertyAssignment == null) {
            cgPropertyAssignment = QVTiCGModelFactory.eINSTANCE.createCGPropertyAssignment();
        }
        this.setAst((CGNamedElement)cgPropertyAssignment, (NamedElement)asSetStatement);
        VariableDeclaration asVariable = asSetStatement.getTargetVariable();
        assert (asVariable != null);
        CGVariable cgVariable = this.getVariable(asVariable);
        cgPropertyAssignment.setOwnedSlotValue((CGValuedElement)this.analyzer.createCGVariableExp(cgVariable));
        cgPropertyAssignment.setReferredProperty(asTargetProperty);
        cgPropertyAssignment.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.OCL_VOID));
        cgPropertyAssignment.setOwnedInitValue((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asSetStatement.getOwnedExpression()));
        CGExecutorProperty cgExecutorProperty = this.analyzer.createExecutorProperty(asTargetProperty);
        cgPropertyAssignment.setExecutorProperty(cgExecutorProperty);
        return cgPropertyAssignment;
    }

    public @Nullable CGNamedElement visitSimpleParameter(@NonNull SimpleParameter object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitSimpleParameterBinding(@NonNull SimpleParameterBinding asSimpleParameterBinding) {
        MappingParameter asBoundVariable = asSimpleParameterBinding.getBoundVariable();
        CGMappingCallBinding cgMappingCallBinding = QVTiCGModelFactory.eINSTANCE.createCGMappingCallBinding();
        cgMappingCallBinding.setName(asBoundVariable.getName());
        cgMappingCallBinding.setAst((Element)asSimpleParameterBinding);
        cgMappingCallBinding.setRequired(asBoundVariable.isIsRequired());
        cgMappingCallBinding.setOwnedValue((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asSimpleParameterBinding.getValue()));
        cgMappingCallBinding.setTypeId(this.analyzer.getTypeId(asBoundVariable.getTypeId()));
        return cgMappingCallBinding;
    }

    public CGNamedElement visitStatement(@NonNull Statement object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitTransformation(@NonNull Transformation object) {
        return this.visiting((Visitable)object);
    }

    public CGNamedElement visitTypedModel(@NonNull TypedModel object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitVariable(@NonNull Variable object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitVariableDeclaration(@NonNull VariableDeclaration object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable CGNamedElement visitVariableStatement(@NonNull VariableStatement object) {
        return this.visiting((Visitable)object);
    }

    public static class CGMappingCallBindingComparator
    implements Comparator<CGMappingCallBinding> {
        public static final @NonNull CGMappingCallBindingComparator INSTANCE = new CGMappingCallBindingComparator();

        @Override
        public int compare(@NonNull CGMappingCallBinding o1, @NonNull CGMappingCallBinding o2) {
            String n2;
            MappingParameterBinding b1 = (MappingParameterBinding)o1.getAst();
            MappingParameterBinding b2 = (MappingParameterBinding)o2.getAst();
            MappingParameter v1 = b1 != null ? b1.getBoundVariable() : null;
            MappingParameter v2 = b2 != null ? b2.getBoundVariable() : null;
            String n1 = v1 != null ? v1.getName() : null;
            String string = n2 = v2 != null ? v2.getName() : null;
            if (n1 == null) {
                n1 = "";
            }
            if (n2 == null) {
                n2 = "";
            }
            return n1.compareTo(n2);
        }
    }

    public static class CGVariableComparator
    implements Comparator<CGVariable> {
        public static final @NonNull CGVariableComparator INSTANCE = new CGVariableComparator();

        @Override
        public int compare(@NonNull CGVariable o1, @NonNull CGVariable o2) {
            String n2;
            VariableDeclaration v1 = (VariableDeclaration)o1.getAst();
            VariableDeclaration v2 = (VariableDeclaration)o2.getAst();
            String n1 = v1 != null ? v1.getName() : null;
            String string = n2 = v2 != null ? v2.getName() : null;
            if (n1 == null) {
                n1 = "";
            }
            if (n2 == null) {
                n2 = "";
            }
            return n1.compareTo(n2);
        }
    }

    public static class InlinedBodyAdapter
    extends AdapterImpl {
        protected final @NonNull OperationCallExp operationCallExp;

        public InlinedBodyAdapter(@NonNull OperationCallExp operationCallExp) {
            this.operationCallExp = operationCallExp;
        }

        public @NonNull OperationCallExp getOperationCallExp() {
            return this.operationCallExp;
        }
    }

    protected class PredicateTreeBuilder {
        protected final @NonNull Mapping asMapping;
        protected final @NonNull CGMapping cgMapping;
        protected final @NonNull CGMappingExp cgMappingExp;
        private @Nullable CGValuedElement cgLeafExp = null;

        public PredicateTreeBuilder(@NonNull Mapping asMapping, CGMapping cgMapping) {
            this.asMapping = asMapping;
            this.cgMapping = cgMapping;
            this.cgMappingExp = QVTiCGModelFactory.eINSTANCE.createCGMappingExp();
            QVTiAS2CGVisitor.this.setAst((CGNamedElement)this.cgMappingExp, (NamedElement)asMapping);
            PrimitiveTypeId pivotTypeId = TypeId.BOOLEAN;
            this.cgMappingExp.setTypeId(QVTiAS2CGVisitor.this.analyzer.getTypeId((TypeId)pivotTypeId));
        }

        public void addAccumulator(@NonNull CGAccumulator cgAccumulator) {
            this.cgMappingExp.getOwnedAccumulators().add(cgAccumulator);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public void addRealizedVariable(@NonNull NewStatement asNewStatement) {
            @NonNull List cgRealizedVariables = ClassUtil.nullFree(this.cgMapping.getOwnedRealizedVariables());
            CGRealizedVariable cgVariable = QVTiAS2CGVisitor.this.getRealizedVariable(asNewStatement);
            cgRealizedVariables.add(cgVariable);
        }

        private void appendCheckedLetVariable(@NonNull VariableDeclaration asVariable, @NonNull OCLExpression asInit) {
            Type sourceType = (Type)ClassUtil.nonNullState((Object)asInit.getType());
            Type targetType = (Type)ClassUtil.nonNullState((Object)asVariable.getType());
            boolean needsNullTest = !asInit.isIsRequired() && asVariable.isIsRequired();
            boolean needsTypeCheck = !sourceType.conformsTo((StandardLibrary)QVTiAS2CGVisitor.this.standardLibrary, targetType);
            CGValuedElement cgInit = (CGValuedElement)QVTiAS2CGVisitor.this.doVisit(CGValuedElement.class, (Element)asInit);
            if (needsTypeCheck || needsNullTest) {
                CGFinalVariable cgRawVariable = CGModelFactory.eINSTANCE.createCGFinalVariable();
                QVTiAS2CGVisitor.this.setAst((CGTypedElement)cgRawVariable, (TypedElement)asInit);
                cgRawVariable.setInit(cgInit);
                cgRawVariable.setName("raw_" + asVariable.getName());
                CGLetExp cgRawLetExp = CGModelFactory.eINSTANCE.createCGLetExp();
                QVTiAS2CGVisitor.this.setAst((CGTypedElement)cgRawLetExp, (TypedElement)asInit);
                cgRawLetExp.setInit((CGVariable)cgRawVariable);
                cgRawLetExp.setTypeId(QVTiAS2CGVisitor.this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
                this.appendSubTree((CGValuedElement)cgRawLetExp);
                if (needsNullTest) {
                    this.appendNonNullPredicate(cgRawVariable);
                }
                if (needsTypeCheck) {
                    CGExecutorType cgType = QVTiAS2CGVisitor.this.analyzer.createExecutorType(targetType);
                    this.appendIsKindOfPredicate(cgRawVariable, cgType);
                    CGCastExp cgCastExp = CGModelFactory.eINSTANCE.createCGCastExp();
                    cgCastExp.setSource((CGValuedElement)QVTiAS2CGVisitor.this.analyzer.createCGVariableExp((CGVariable)cgRawVariable));
                    cgCastExp.setExecutorType(cgType);
                    cgCastExp.setTypeId(QVTiAS2CGVisitor.this.codeGenerator.getAnalyzer().getTypeId(asVariable.getTypeId()));
                    cgInit = cgCastExp;
                } else {
                    cgInit = QVTiAS2CGVisitor.this.analyzer.createCGVariableExp((CGVariable)cgRawVariable);
                }
            }
            CGFinalVariable cgVariable = (CGFinalVariable)QVTiAS2CGVisitor.this.createCGVariable(asVariable);
            cgVariable.setInit(cgInit);
            CGLetExp cgLetExp = CGModelFactory.eINSTANCE.createCGLetExp();
            QVTiAS2CGVisitor.this.setAst((CGTypedElement)cgLetExp, (TypedElement)asVariable);
            cgLetExp.setInit((CGVariable)cgVariable);
            cgLetExp.setTypeId(QVTiAS2CGVisitor.this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
            this.appendSubTree((CGValuedElement)cgLetExp);
        }

        private void appendIsKindOfPredicate(@NonNull CGFinalVariable cgVariable, @NonNull CGExecutorType cgExecutorType) {
            @NonNull CGIsKindOfExp cgCondition = CGModelFactory.eINSTANCE.createCGIsKindOfExp();
            cgCondition.setSource((CGValuedElement)QVTiAS2CGVisitor.this.analyzer.createCGVariableExp((CGVariable)cgVariable));
            cgCondition.setExecutorType(cgExecutorType);
            cgCondition.setTypeId(QVTiAS2CGVisitor.this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
            CGIfExp cgIfExp = CGModelFactory.eINSTANCE.createCGIfExp();
            cgIfExp.setTypeId(QVTiAS2CGVisitor.this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
            cgIfExp.setCondition((CGValuedElement)cgCondition);
            cgIfExp.setElseExpression(QVTiAS2CGVisitor.this.analyzer.createCGConstantExp((CGConstant)QVTiAS2CGVisitor.this.analyzer.getBoolean(false)));
            this.appendSubTree((CGValuedElement)cgIfExp);
        }

        private void appendNonNullPredicate(@NonNull CGFinalVariable cgVariable) {
            CGIsEqualExp cgCondition = CGModelFactory.eINSTANCE.createCGIsEqualExp();
            cgCondition.setNotEquals(true);
            cgCondition.setSource((CGValuedElement)QVTiAS2CGVisitor.this.analyzer.createCGVariableExp((CGVariable)cgVariable));
            cgCondition.setArgument(QVTiAS2CGVisitor.this.analyzer.createCGConstantExp((CGConstant)QVTiAS2CGVisitor.this.analyzer.getNull()));
            cgCondition.setTypeId(QVTiAS2CGVisitor.this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
            cgCondition.setInvalidating(false);
            cgCondition.setValidating(true);
            CGIfExp cgIfExp = CGModelFactory.eINSTANCE.createCGIfExp();
            cgIfExp.setTypeId(QVTiAS2CGVisitor.this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
            cgIfExp.setName(cgVariable.getName());
            cgIfExp.setCondition((CGValuedElement)cgCondition);
            cgIfExp.setElseExpression(QVTiAS2CGVisitor.this.analyzer.createCGConstantExp((CGConstant)QVTiAS2CGVisitor.this.analyzer.getBoolean(false)));
            this.appendSubTree((CGValuedElement)cgIfExp);
        }

        private void appendSubTree(@NonNull CGValuedElement cgElement) {
            CGValuedElement cgElementRoot = cgElement;
            while (cgElementRoot.eContainer() != null) {
                cgElementRoot = (CGValuedElement)cgElementRoot.eContainer();
            }
            if (this.cgMapping.getOwnedBody() == null) {
                this.cgMapping.setOwnedBody(cgElementRoot);
            }
            if (this.cgLeafExp instanceof CGLetExp) {
                ((CGLetExp)this.cgLeafExp).setIn(cgElementRoot);
            } else if (this.cgLeafExp instanceof CGIfExp) {
                ((CGIfExp)this.cgLeafExp).setThenExpression(cgElementRoot);
            } else assert (this.cgLeafExp == null);
            this.cgLeafExp = cgElement;
        }

        public void doBottoms() {
            ArrayList<@NonNull CGGuardVariable> cgFreeVariables = new ArrayList<CGGuardVariable>();
            for (MappingParameter pMappingParameter : QVTimperativeUtil.getOwnedMappingParameters((Mapping)this.asMapping)) {
                cgFreeVariables.add(QVTiAS2CGVisitor.this.getGuardVariable((VariableDeclaration)pMappingParameter));
            }
            Collections.sort(cgFreeVariables, NameUtil.NAMEABLE_COMPARATOR);
            this.cgMapping.getOwnedGuardVariables().addAll(cgFreeVariables);
            CGSequence cgSequence = QVTiCGModelFactory.eINSTANCE.createCGSequence();
            List<CGValuedElement> cgMappingStatements = cgSequence.getOwnedStatements();
            for (Statement asStatement : ClassUtil.nullFree((EList)this.asMapping.getOwnedStatements())) {
                CGNamedElement cgElement = (CGNamedElement)asStatement.accept((Visitor)QVTiAS2CGVisitor.this);
                if (cgElement == null) continue;
                cgMappingStatements.add((CGValuedElement)cgElement);
            }
            this.appendSubTree(this.cgMappingExp);
            this.cgMappingExp.setOwnedBody(cgSequence);
        }

        public String toString() {
            return String.valueOf(this.cgMapping.getOwnedBody());
        }
    }
}

