/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.AnyType;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionKind;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.InvalidType;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.SetType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TypeUtil;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NodeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.RootCompositionRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SchedulerConstants;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.AbstractScheduledRegion2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTiVisitor;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CorePattern;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionVariable;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeDomain;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;

public class RootRegion2Mapping
extends AbstractScheduledRegion2Mapping {
    private final @NonNull Map<@NonNull ClassDatumAnalysis, @NonNull Variable> classDatumAnalysis2variable = new HashMap<ClassDatumAnalysis, Variable>();
    private final @NonNull Map<@NonNull Node, @NonNull Variable> node2variable = new HashMap<Node, Variable>();

    public RootRegion2Mapping(@NonNull QVTs2QVTiVisitor visitor, @NonNull RootCompositionRegion region) {
        super(visitor, region);
        HashSet<@NonNull TypedModel> checkableTypedModels = new HashSet<TypedModel>();
        for (Node node : region.getNodes()) {
            TypedModel qvtpTypedModel;
            TypedModel qvtiTypedModel;
            ClassDatumAnalysis classDatumAnalysis = node.getClassDatumAnalysis();
            Class type = classDatumAnalysis.getClassDatum().getType();
            if (type instanceof DataType || type instanceof AnyType || type instanceof VoidType || type instanceof InvalidType || (qvtiTypedModel = visitor.getQVTiTypedModel(qvtpTypedModel = classDatumAnalysis.getTypedModel())) == null) continue;
            checkableTypedModels.add(qvtiTypedModel);
        }
        for (TypedModel qvtiTypedModel : checkableTypedModels) {
            ImperativeDomain domain = QVTimperativeUtil.createImperativeDomain((TypedModel)qvtiTypedModel);
            domain.setIsCheckable(true);
            this.mapping.getDomain().add((Object)domain);
        }
    }

    private @NonNull OCLExpression createObjectsOfKindExpression(@NonNull Node resultNode) {
        ClassDatumAnalysis classDatumAnalysis = resultNode.getClassDatumAnalysis();
        Variable allInstancesVariable = this.classDatumAnalysis2variable.get(classDatumAnalysis);
        if (allInstancesVariable == null) {
            Class collectionType = classDatumAnalysis.getCompleteClass().getPrimaryClass();
            Type elementType = ((CollectionType)collectionType).getElementType();
            assert (elementType != null);
            assert (!(elementType instanceof CollectionType));
            StandardLibraryInternal standardLibrary = (StandardLibraryInternal)this.visitor.getStandardLibrary();
            TypedModel typedModel = this.visitor.getQVTiTypedModel(classDatumAnalysis.getTypedModel());
            assert (typedModel != null);
            Variable contextVariable = QVTbaseUtil.getContextVariable((StandardLibraryInternal)standardLibrary, (TypedModel)typedModel);
            VariableExp modelExp = this.helper.createVariableExp(contextVariable);
            TypeExp typeExp = this.helper.createTypeExp(elementType);
            OperationCallExp asSource = this.helper.createOperationCallExp((OCLExpression)modelExp, "objectsOfKind", new OCLExpression[]{typeExp});
            allInstancesVariable = PivotUtil.createVariable((String)resultNode.getName(), (OCLExpression)asSource);
            this.mapping.getBottomPattern().getVariable().add((Object)allInstancesVariable);
            this.classDatumAnalysis2variable.put(classDatumAnalysis, allInstancesVariable);
        }
        return this.helper.createVariableExp(allInstancesVariable);
    }

    private @NonNull ConnectionVariable createRootConnectionVariable(@NonNull CorePattern pattern, @NonNull String name, @NonNull Type type, @Nullable OCLExpression initExpression) {
        ConnectionVariable variable = this.helper.createConnectionVariable(this.getSafeName(name), type, initExpression);
        pattern.getVariable().add((Object)variable);
        return variable;
    }

    private void createRootConnectionVariables() {
        BottomPattern bottomPattern = this.mapping.getBottomPattern();
        assert (bottomPattern != null);
        ArrayList<@NonNull NodeConnection> rootConnections = new ArrayList<NodeConnection>(this.region.getRootConnections());
        Collections.sort(rootConnections, NameUtil.NAMEABLE_COMPARATOR);
        for (NodeConnection rootConnection : rootConnections) {
            OCLExpression initExpression;
            Type commonType = this.getConnectionSourcesType(rootConnection);
            Node regionNode = rootConnection.basicGetSource(this.region);
            String name = rootConnection.getName();
            assert (name != null);
            if (regionNode != null) {
                initExpression = this.createObjectsOfKindExpression(regionNode);
                List<@NonNull Edge> incomingEdges = regionNode.getIncomingEdges();
                switch (incomingEdges.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        initExpression = this.getFilteredExpression(initExpression, (NavigationEdge)incomingEdges.get(0));
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                this.connection2variable.put(rootConnection, this.createRootConnectionVariable((CorePattern)bottomPattern, name, commonType, initExpression));
                continue;
            }
            if (commonType instanceof CollectionType) {
                initExpression = PivotFactory.eINSTANCE.createCollectionLiteralExp();
                initExpression.setType(commonType);
                initExpression.setKind(TypeUtil.getCollectionKind((CollectionType)((CollectionType)commonType)));
                initExpression.setIsRequired(true);
                this.connection2variable.put(rootConnection, this.createRootConnectionVariable((CorePattern)bottomPattern, name, commonType, initExpression));
                continue;
            }
            initExpression = PivotFactory.eINSTANCE.createCollectionLiteralExp();
            CollectionType setType = this.visitor.getEnvironmentFactory().getCompleteEnvironment().getSetType(commonType, true, null, null);
            initExpression.setType((Type)setType);
            initExpression.setKind(CollectionKind.SET);
            initExpression.setIsRequired(true);
            this.connection2variable.put(rootConnection, this.createRootConnectionVariable((CorePattern)bottomPattern, name, (Type)setType, initExpression));
        }
    }

    @Override
    protected @NonNull OCLExpression createSelectByKind(@NonNull Node resultNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createStatements() {
        this.createRootConnectionVariables();
        MappingStatement mappingStatement = null;
        for (Region callableRegion : this.region.getCallableChildren()) {
            mappingStatement = this.createCall(mappingStatement, callableRegion, null);
        }
        this.mapping.setMappingStatement(mappingStatement);
    }

    private @NonNull OCLExpression getFilteredExpression(@NonNull OCLExpression initExpression, @NonNull NavigationEdge edge) {
        Type collectionType = initExpression.getType();
        assert (collectionType != null);
        Type elementType = ((CollectionType)collectionType).getElementType();
        assert (elementType != null);
        @NonNull Variable asIterator = PivotUtil.createVariable((String)"i", (Type)elementType, (boolean)true, null);
        Property child2parentProperty = edge.getProperty().getOpposite();
        assert (child2parentProperty != null);
        NavigationCallExp propertyCallExp = this.helper.createNavigationCallExp((OCLExpression)this.helper.createVariableExp(asIterator), child2parentProperty);
        if (edge.getSource().isNull()) {
            OperationCallExp equalsExp = this.helper.createOperationCallExp((OCLExpression)propertyCallExp, "=", new OCLExpression[]{this.helper.createNullLiteralExp()});
            initExpression = this.helper.createIteratorExp(initExpression, this.getSelectIteration(), Collections.singletonList(asIterator), (OCLExpression)equalsExp);
        } else {
            OperationCallExp notEqualsExp = this.helper.createOperationCallExp((OCLExpression)propertyCallExp, "<>", new OCLExpression[]{this.helper.createNullLiteralExp()});
            initExpression = this.helper.createIteratorExp(initExpression, this.getSelectIteration(), Collections.singletonList(asIterator), (OCLExpression)notEqualsExp);
        }
        return initExpression;
    }

    @Override
    public @NonNull List<@NonNull Node> getGuardNodes() {
        return SchedulerConstants.EMPTY_NODE_LIST;
    }

    @Override
    public @NonNull Variable getGuardVariable(@NonNull Node node) {
        Variable variable = this.node2variable.get(node);
        assert (variable != null);
        return variable;
    }

    protected @NonNull Iteration getSelectIteration() {
        SetType collectionType = ((StandardLibraryInternal)this.visitor.getStandardLibrary()).getSetType();
        Operation selectIteration = (Operation)NameUtil.getNameable((Iterable)collectionType.getOwnedOperations(), (String)"select");
        assert (selectIteration != null);
        return (Iteration)selectIteration;
    }

    protected Type getType(@NonNull IdResolver idResolver, @NonNull NodeConnection rootConnection) {
        Object commonType = null;
        for (Node node : rootConnection.getSources()) {
            Class nodeType = node.getCompleteClass().getPrimaryClass();
            commonType = commonType == null ? nodeType : commonType.getCommonType(idResolver, (Type)nodeType);
        }
        return commonType;
    }
}

