/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ConnectionRole;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.CyclicScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NodeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.RegionCycle;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Scheduler;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Symbolable;

public class CyclesAnalyzer {
    protected final @NonNull ScheduledRegion scheduledRegion;
    private final @NonNull Map<@NonNull Region, @NonNull RegionStatus> region2status = new HashMap<Region, RegionStatus>();
    private final @NonNull List<@NonNull RegionCycle> orderedCycles = new ArrayList<RegionCycle>();
    private final @NonNull Set<@NonNull RegionStatus> blockedRegions;

    /*
     * Unable to fully structure code
     */
    public CyclesAnalyzer(@NonNull ScheduledRegion scheduledRegion, @NonNull Iterable<@NonNull Region> regions) {
        super();
        this.scheduledRegion = scheduledRegion;
        for (Region region : regions) {
            if (!CyclesAnalyzer.$assertionsDisabled && region.isOperationRegion()) {
                throw new AssertionError();
            }
            this.region2status.put(region, new RegionStatus(region));
        }
        this.blockedRegions = new HashSet<RegionStatus>(this.region2status.values());
        unblockedRegionStatuses = new ArrayList<RegionStatus>();
        for (RegionStatus regionStatus : this.region2status.values()) {
            if (!regionStatus.initializeSources()) continue;
            unblockedRegionStatuses.add(regionStatus);
        }
        i = 0;
        ** GOTO lbl97
        {
            this.checkAll(unblockedRegionStatuses, i);
            unblockedRegionStatus = (RegionStatus)unblockedRegionStatuses.get(i++);
            wasRemoved = this.blockedRegions.remove(unblockedRegionStatus);
            if (!CyclesAnalyzer.$assertionsDisabled && !wasRemoved) {
                throw new AssertionError();
            }
            unblockedRegionStatus.propagate(unblockedRegionStatuses);
            do {
                if (i < unblockedRegionStatuses.size()) continue block2;
                this.checkAll(unblockedRegionStatuses, i);
                if (this.blockedRegions.size() <= 0) continue;
                cycle = this.removeCycle();
                if (cycle == null) break block2;
                this.orderedCycles.add(cycle);
                oldRegions = cycle.getRegions();
                this.showOld(oldRegions);
                debugOldPreviousRegions = new HashSet<Region>();
                debugOldNextRegions = new HashSet<Region>();
                for (Region debugOldRegion : oldRegions) {
                    debugOldPreviousRegions.addAll(this.getPreviousRegions(debugOldRegion));
                    debugOldNextRegions.addAll(this.getNextRegions(debugOldRegion));
                }
                cyclicRegion = scheduledRegion.createCyclicScheduledRegion(oldRegions);
                this.showNew(cyclicRegion);
                debugOldRegions2 = Sets.newHashSet(oldRegions);
                cyclicRegionStatus = new RegionStatus(cyclicRegion);
                debugNewPreviousRegions = this.getPreviousRegions(cyclicRegion);
                debugNewNextRegions = this.getNextRegions(cyclicRegion);
                debugNewOldPreviousRegions = Sets.newHashSet(debugOldPreviousRegions);
                debugNewOldPreviousRegions.removeAll(debugOldRegions2);
                debugNewOldNextRegions = Sets.newHashSet(debugOldNextRegions);
                debugNewOldNextRegions.removeAll(debugOldRegions2);
                if (!CyclesAnalyzer.$assertionsDisabled && !debugNewPreviousRegions.equals(debugNewOldPreviousRegions)) {
                    throw new AssertionError();
                }
                intersection = Sets.intersection(debugNewNextRegions, (Set)debugNewOldNextRegions);
                for (Region region : Sets.difference(debugNewNextRegions, (Set)debugNewOldNextRegions)) {
                    Scheduler.REGION_CYCLES.println("Missing New Next Region: " + region);
                }
                for (Region region : Sets.difference((Set)debugNewOldNextRegions, debugNewNextRegions)) {
                    Scheduler.REGION_CYCLES.println("Missing New Old Next Region: " + region);
                }
                for (Region region : debugNewNextRegions) {
                    Scheduler.REGION_CYCLES.println("New Next Region: " + region + " " + intersection.contains(region));
                }
                for (Region region : debugNewOldNextRegions) {
                    Scheduler.REGION_CYCLES.println("New Old Next Region: " + region + " " + intersection.contains(region));
                }
                if (!CyclesAnalyzer.$assertionsDisabled && !debugNewNextRegions.equals(debugNewOldNextRegions)) {
                    throw new AssertionError();
                }
                oldRegionStatuses = new HashSet<RegionStatus>();
                for (Region oldRegion : oldRegions) {
                    oldRegionStatus = this.region2status.put(oldRegion, cyclicRegionStatus);
                    if (!CyclesAnalyzer.$assertionsDisabled && oldRegionStatus == null) {
                        throw new AssertionError();
                    }
                    oldRegionStatuses.add(oldRegionStatus);
                    wasRemoved = this.blockedRegions.remove(oldRegionStatus);
                    if (!CyclesAnalyzer.$assertionsDisabled && !wasRemoved) {
                        throw new AssertionError();
                    }
                }
                if (cyclicRegionStatus.initializeSources()) {
                    unblockedRegionStatuses.add(cyclicRegionStatus);
                }
                for (RegionStatus regionStatus : this.blockedRegions) {
                    regionStatus.replaceCycle(oldRegionStatuses, cyclicRegionStatus);
                }
                for (RegionStatus regionStatus : unblockedRegionStatuses) {
                    regionStatus.replaceCycle(oldRegionStatuses, cyclicRegionStatus);
                }
                this.region2status.put(cyclicRegion, cyclicRegionStatus);
                this.blockedRegions.add(cyclicRegionStatus);
lbl97:
                // 3 sources

            } while (this.blockedRegions.size() > 0);
        }
    }

    /*
     * Exception decompiling
     */
    private void checkAll(@NonNull List<@NonNull RegionStatus> unblockedRegionStatuses, int orderedThreshold) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance$Annotated.pathIterator()" because the return value of "org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance$Annotated.access$300(org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance$Annotated)" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance$Annotated$Iterator.moveNested(JavaRefTypeInstance.java:200)
         *     at org.benf.cfr.reader.entities.attributes.TypePathPartNested.apply(TypePathPartNested.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.types.TypeAnnotationHelper.apply(TypeAnnotationHelper.java:54)
         *     at org.benf.cfr.reader.bytecode.analysis.types.TypeAnnotationHelper.apply(TypeAnnotationHelper.java:45)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.handleStatement(TypeAnnotationTransformer.java:141)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:144)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.transform(TypeAnnotationTransformer.java:61)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.transform(TypeAnnotationTransformer.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.transform(TypeAnnotationTransformer.java:55)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.applyTypeAnnotations(Op04StructuredStatement.java:733)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:957)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private @NonNull Set<@NonNull Region> getNextRegions(@NonNull Region region) {
        HashSet<@NonNull Region> nextRegions = new HashSet<Region>();
        for (NodeConnection outgoingConnection : region.getOutgoingPassedConnections()) {
            for (Map.Entry<Node, ConnectionRole> targetEntry : outgoingConnection.getTargets().entrySet()) {
                if (!targetEntry.getValue().isPassed()) continue;
                nextRegions.add(targetEntry.getKey().getRegion());
            }
        }
        return nextRegions;
    }

    public @Nullable List<@NonNull RegionCycle> getOrderedCycles() {
        return this.orderedCycles;
    }

    private @NonNull Set<@NonNull Region> getPreviousRegions(@NonNull Region region) {
        HashSet<@NonNull Region> previousRegions = new HashSet<Region>();
        for (NodeConnection incomingConnection : region.getIncomingPassedConnections()) {
            for (Region sourceRegion : incomingConnection.getSourceRegions()) {
                ScheduledRegion parentRegion;
                while ((parentRegion = sourceRegion.getInvokingRegion()) instanceof CyclicScheduledRegion) {
                    sourceRegion = parentRegion;
                }
                previousRegions.add(sourceRegion);
            }
        }
        return previousRegions;
    }

    private void putAll(@NonNull Map<@NonNull Region, @NonNull List<@NonNull NodeConnection>> region2connections, @NonNull Set<@NonNull Region> regions, @NonNull NodeConnection connection) {
        for (Region region : regions) {
            List<@NonNull NodeConnection> connections = region2connections.get(region);
            if (connections == null) {
                connections = new ArrayList<NodeConnection>();
                region2connections.put(region, connections);
            }
            connections.add(connection);
        }
    }

    private @Nullable RegionCycle removeCycle() {
        HashSet<@NonNull RegionCycle> cyclesSet = null;
        for (RegionStatus regionStatus : Sets.newHashSet(this.region2status.values())) {
            RegionCycle depthlessSourceClosure = regionStatus.getDepthlessSourceClosure();
            if (depthlessSourceClosure == null) continue;
            if (cyclesSet == null) {
                cyclesSet = new HashSet<RegionCycle>();
            }
            cyclesSet.add(depthlessSourceClosure);
        }
        if (cyclesSet == null) {
            Scheduler.REGION_CYCLES.println("No cycles found");
            return null;
        }
        ArrayList<@NonNull E> cyclesList = new ArrayList(cyclesSet);
        Collections.sort(cyclesList, RegionCycle.COMPARATOR);
        if (Scheduler.REGION_CYCLES.isActive()) {
            Scheduler.REGION_CYCLES.println("cycles ");
            for (RegionCycle cycle : cyclesList) {
                Scheduler.REGION_CYCLES.println("    " + cycle.toString());
            }
        }
        RegionCycle smallestCycle = (RegionCycle)cyclesList.get(0);
        assert (smallestCycle != null);
        return smallestCycle;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void showAll(@NonNull String prefix, @NonNull Set<@NonNull Region> regions) {
        @NonNull ArrayList sortedRegions = Lists.newArrayList(regions);
        Collections.sort(sortedRegions, SymbolableComparator.INSTANCE);
        StringBuilder s = new StringBuilder();
        s.append(prefix);
        boolean first = true;
        for (Region region : sortedRegions) {
            s.append(first ? " " : ",");
            s.append(region);
            first = false;
        }
        Scheduler.REGION_CYCLES.println(s.toString());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void showAll(@NonNull String prefix, @NonNull Map<@NonNull Region, @NonNull List<@NonNull NodeConnection>> region2connections) {
        @NonNull ArrayList sortedRegions = Lists.newArrayList(region2connections.keySet());
        Collections.sort(sortedRegions, SymbolableComparator.INSTANCE);
        for (Region region : sortedRegions) {
            StringBuilder s = new StringBuilder();
            s.append(prefix);
            s.append(region);
            List<@NonNull NodeConnection> connections = region2connections.get(region);
            assert (connections != null);
            Collections.sort(connections, NameUtil.NAMEABLE_COMPARATOR);
            boolean first = true;
            for (NodeConnection connection : connections) {
                s.append(first ? " " : ",");
                s.append(connection);
                first = false;
            }
            Scheduler.REGION_CYCLES.println(s.toString());
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void showNew(@NonNull CyclicScheduledRegion cyclicRegion) {
        HashSet<@NonNull E> externalConnections = new HashSet();
        Scheduler.REGION_CYCLES.println("New Region: " + cyclicRegion);
        @NonNull @NonNull ArrayList sortedHeadNodes = Lists.newArrayList(cyclicRegion.getHeadNodes());
        Collections.sort(sortedHeadNodes, NameUtil.NAMEABLE_COMPARATOR);
        for (Node headNode : sortedHeadNodes) {
            StringBuilder s = new StringBuilder();
            s.append("  head: ");
            s.append(headNode);
            s.append("  ");
            s.append(headNode.getIncomingConnection());
            Scheduler.REGION_CYCLES.println(s.toString());
        }
        Iterables.addAll(externalConnections, cyclicRegion.getIncomingPassedConnections());
        Iterables.addAll(externalConnections, cyclicRegion.getOutgoingPassedConnections());
        @NonNull ArrayList sortedExternalConnections = Lists.newArrayList(externalConnections);
        Collections.sort(sortedExternalConnections, NameUtil.NAMEABLE_COMPARATOR);
        for (NodeConnection externalConnection : sortedExternalConnections) {
            Scheduler.REGION_CYCLES.println("New Connection: " + externalConnection);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void showOld(@NonNull Iterable<@NonNull Region> oldRegions) {
        @NonNull HashSet debugOldRegions = Sets.newHashSet(oldRegions);
        @NonNull ArrayList sortedOldRegions = Lists.newArrayList(oldRegions);
        Collections.sort(sortedOldRegions, SymbolableComparator.INSTANCE);
        HashSet<@NonNull E> debugOldConnections = new HashSet();
        for (Region debugOldRegion : sortedOldRegions) {
            Scheduler.REGION_CYCLES.println("Old Region: " + debugOldRegion);
            Iterables.addAll(debugOldConnections, debugOldRegion.getIncomingPassedConnections());
            Iterables.addAll(debugOldConnections, debugOldRegion.getOutgoingPassedConnections());
        }
        @NonNull ArrayList sortedOldConnections = Lists.newArrayList(debugOldConnections);
        Collections.sort(sortedOldConnections, NameUtil.NAMEABLE_COMPARATOR);
        HashMap<@NonNull Region, @NonNull List<@NonNull NodeConnection>> allInternalSourceRegions = new HashMap<Region, List<NodeConnection>>();
        HashMap<@NonNull Region, @NonNull List<@NonNull NodeConnection>> allExternalSourceRegions = new HashMap<Region, List<NodeConnection>>();
        HashMap<@NonNull Region, @NonNull List<@NonNull NodeConnection>> allInternalTargetRegions = new HashMap<Region, List<NodeConnection>>();
        HashMap<@NonNull Region, @NonNull List<@NonNull NodeConnection>> allExternalTargetRegions = new HashMap<Region, List<NodeConnection>>();
        for (NodeConnection debugOldConnection : sortedOldConnections) {
            Scheduler.REGION_CYCLES.println("Old Connection: " + debugOldConnection);
            @NonNull HashSet internalSourceRegions = Sets.newHashSet(debugOldConnection.getSourceRegions());
            internalSourceRegions.retainAll(debugOldRegions);
            this.putAll(allInternalSourceRegions, internalSourceRegions, debugOldConnection);
            this.showAll("    internal sources: ", internalSourceRegions);
            @NonNull HashSet externalSourceRegions = Sets.newHashSet(debugOldConnection.getSourceRegions());
            externalSourceRegions.removeAll(debugOldRegions);
            this.putAll(allExternalSourceRegions, externalSourceRegions, debugOldConnection);
            this.showAll("    external sources: ", externalSourceRegions);
            @NonNull HashSet internalTargetRegions = Sets.newHashSet(debugOldConnection.getTargetRegions());
            internalTargetRegions.retainAll(debugOldRegions);
            this.putAll(allInternalTargetRegions, internalTargetRegions, debugOldConnection);
            this.showAll("    internal targets: ", internalTargetRegions);
            @NonNull HashSet externalTargetRegions = Sets.newHashSet(debugOldConnection.getTargetRegions());
            externalTargetRegions.removeAll(debugOldRegions);
            this.putAll(allExternalTargetRegions, externalTargetRegions, debugOldConnection);
            this.showAll("    external targets: ", externalTargetRegions);
        }
        this.showAll("internal source: ", allInternalSourceRegions);
        this.showAll("external source: ", allExternalSourceRegions);
        this.showAll("internal target: ", allInternalTargetRegions);
        this.showAll("external target: ", allExternalTargetRegions);
    }

    private class RegionStatus {
        protected final @NonNull Region region;
        private final @NonNull Set<@NonNull RegionStatus> depthlessSourceRegions = new HashSet<RegionStatus>();
        private @Nullable Integer partialSourceDepth = null;
        private @Nullable Integer depth = null;
        private @NonNull Set<@NonNull Region> debugSourceRegions = new HashSet<Region>();
        private @NonNull Set<@NonNull Region> debugTargetRegions = new HashSet<Region>();

        public RegionStatus(Region region) {
            this.region = region;
            this.debugSourceRegions.addAll(CyclesAnalyzer.this.getPreviousRegions(region));
            this.debugTargetRegions.addAll(CyclesAnalyzer.this.getNextRegions(region));
        }

        private void check(@NonNull List<@NonNull RegionStatus> unblockedRegionStatuses, int orderedThreshold) {
            RegionStatus regionStatus;
            if (this.region instanceof CyclicScheduledRegion) {
                this.computeDepth();
            }
            Integer checkDepth = this.computeDepth();
            int index = unblockedRegionStatuses.indexOf(this);
            if (index < 0) {
                assert (!this.depthlessSourceRegions.isEmpty());
                assert (this.depth == null);
            } else if (index < orderedThreshold) {
                assert (this.depthlessSourceRegions.isEmpty());
                assert (this.partialSourceDepth == checkDepth);
                if (index == 0) {
                    assert (this.partialSourceDepth == null);
                    assert (this.depth == 0);
                } else if (checkDepth != null) {
                    assert (this.partialSourceDepth != null);
                    assert (this.depth == checkDepth + 1);
                }
            } else {
                assert (this.depthlessSourceRegions.isEmpty());
                assert (this.partialSourceDepth == checkDepth);
                assert (this.depth == null);
            }
            for (Region debugSourceRegion : this.debugSourceRegions) {
                regionStatus = (RegionStatus)CyclesAnalyzer.this.region2status.get(debugSourceRegion);
                assert (regionStatus != null);
                assert (regionStatus.debugTargetRegions.contains(this.region));
            }
            for (Region debugTargetRegion : this.debugTargetRegions) {
                regionStatus = (RegionStatus)CyclesAnalyzer.this.region2status.get(debugTargetRegion);
                assert (regionStatus != null);
                assert (regionStatus.debugSourceRegions.contains(this.region));
            }
            assert (Sets.intersection(this.depthlessSourceRegions, (Set)Sets.newHashSet(unblockedRegionStatuses.subList(0, orderedThreshold))).isEmpty());
            for (RegionStatus sourceRegion : this.depthlessSourceRegions) {
                assert (this.debugSourceRegions.contains(sourceRegion.region));
            }
        }

        private @Nullable Integer computeDepth() {
            HashSet<@NonNull E> sourceRegions = new HashSet();
            sourceRegions.addAll(CyclesAnalyzer.this.getPreviousRegions(this.region));
            Integer checkDepth = null;
            for (Region sourceRegion : sourceRegions) {
                RegionStatus sourceRegionStatus = (RegionStatus)CyclesAnalyzer.this.region2status.get(sourceRegion);
                assert (sourceRegionStatus != null);
                Integer sourceDepth = sourceRegionStatus.getDepth();
                if (sourceDepth == null) continue;
                checkDepth = checkDepth != null ? Math.max(checkDepth, sourceDepth) : sourceDepth;
            }
            return checkDepth;
        }

        private @Nullable Integer getDepth() {
            return this.depth;
        }

        @NonNull Region getRegion() {
            return this.region;
        }

        public @Nullable RegionCycle getDepthlessSourceClosure() {
            if (this.depthlessSourceRegions.isEmpty()) {
                return null;
            }
            HashSet<@NonNull Region> depthlessClosure = new HashSet<Region>();
            this.getDepthlessSourceClosure(depthlessClosure);
            return new RegionCycle(depthlessClosure);
        }

        private void getDepthlessSourceClosure(@NonNull Set<@NonNull Region> depthlessClosure) {
            for (RegionStatus sourceRegionStatus : this.depthlessSourceRegions) {
                if (!depthlessClosure.add(sourceRegionStatus.getRegion())) continue;
                sourceRegionStatus.getDepthlessSourceClosure(depthlessClosure);
            }
        }

        public boolean initializeSources() {
            for (Region sourceRegion : CyclesAnalyzer.this.getPreviousRegions(this.region)) {
                RegionStatus sourceRegionStatus = (RegionStatus)CyclesAnalyzer.this.region2status.get(sourceRegion);
                assert (sourceRegionStatus != null);
                Integer sourceDepth = sourceRegionStatus.getDepth();
                if (sourceDepth == null) {
                    this.depthlessSourceRegions.add(sourceRegionStatus);
                    continue;
                }
                Integer partialSourceDepth2 = this.partialSourceDepth;
                this.partialSourceDepth = partialSourceDepth2 == null ? (partialSourceDepth2 = sourceDepth) : (partialSourceDepth2 = Integer.valueOf(Math.max(partialSourceDepth2, sourceDepth)));
            }
            if (Scheduler.REGION_CYCLES.isActive()) {
                Scheduler.REGION_CYCLES.println(this.region.getName());
                ArrayList<@NonNull String> names = new ArrayList<String>();
                for (RegionStatus regionStatus : this.depthlessSourceRegions) {
                    names.add(regionStatus.getRegion().getName());
                }
                Collections.sort(names);
                for (String name : names) {
                    Scheduler.REGION_CYCLES.println("  <= " + this.depthlessSourceRegions.size() + " " + name);
                }
            }
            return this.depthlessSourceRegions.isEmpty();
        }

        public void propagate(@NonNull List<@NonNull RegionStatus> unblockedRegionStatuses) {
            int newDepth;
            assert (this.depthlessSourceRegions.isEmpty());
            Integer checkDepth = this.computeDepth();
            int n = newDepth = checkDepth != null ? checkDepth + 1 : 0;
            if (this.depth != null) {
                assert (this.depth == newDepth);
            } else {
                this.depth = newDepth;
            }
            Scheduler.REGION_CYCLES.println(this.depth + " : " + this.region.getName());
            Integer depth2 = this.depth;
            assert (depth2 != null);
            for (Region targetRegion : CyclesAnalyzer.this.getNextRegions(this.region)) {
                RegionStatus targetRegionStatus = (RegionStatus)CyclesAnalyzer.this.region2status.get(targetRegion);
                assert (targetRegionStatus != null);
                if (targetRegionStatus.getDepth() != null) continue;
                targetRegionStatus.propagateFrom(this, depth2, unblockedRegionStatuses);
            }
        }

        private void propagateFrom(@NonNull RegionStatus sourceRegion, int sourceDepth, @NonNull List<@NonNull RegionStatus> unblockedRegionStatuses) {
            if (this.depthlessSourceRegions.remove(sourceRegion)) {
                Scheduler.REGION_CYCLES.println("    => " + this.depthlessSourceRegions.size() + " " + this);
                Integer partialSourceDepth2 = this.partialSourceDepth;
                this.partialSourceDepth = partialSourceDepth2 == null ? (partialSourceDepth2 = Integer.valueOf(sourceDepth)) : (partialSourceDepth2 = Integer.valueOf(Math.max(partialSourceDepth2, sourceDepth)));
                if (this.depthlessSourceRegions.isEmpty()) {
                    unblockedRegionStatuses.add(this);
                }
            }
        }

        public void replaceCycle(@NonNull Set<@NonNull RegionStatus> oldRegionStatuses, @NonNull RegionStatus cyclicRegionStatus) {
            boolean gotOne;
            boolean debugGotSource = false;
            boolean debugGotTarget = false;
            for (RegionStatus oldRegionStatus : oldRegionStatuses) {
                Region oldRegion = oldRegionStatus.getRegion();
                if (this.debugSourceRegions.remove(oldRegion)) {
                    debugGotSource = true;
                }
                if (!this.debugTargetRegions.remove(oldRegion)) continue;
                debugGotTarget = true;
            }
            if (debugGotSource) {
                this.debugSourceRegions.add(cyclicRegionStatus.getRegion());
            }
            if (debugGotTarget) {
                this.debugTargetRegions.add(cyclicRegionStatus.getRegion());
            }
            boolean bl = gotOne = !Sets.intersection(this.depthlessSourceRegions, oldRegionStatuses).isEmpty();
            if (gotOne) {
                Scheduler.REGION_CYCLES.println(this.region.getName());
                for (RegionStatus oldRegionStatus : oldRegionStatuses) {
                    if (!this.depthlessSourceRegions.remove(oldRegionStatus)) continue;
                    gotOne = true;
                    Scheduler.REGION_CYCLES.println("    <> " + this.depthlessSourceRegions.size() + " " + oldRegionStatus);
                }
                this.depthlessSourceRegions.add(cyclicRegionStatus);
                Scheduler.REGION_CYCLES.println("    <= " + this.depthlessSourceRegions.size() + " " + cyclicRegionStatus);
            }
        }

        public String toString() {
            return this.region.getName();
        }

        static /* synthetic */ void access$0(RegionStatus regionStatus, List list, int n) {
            regionStatus.check(list, n);
        }
    }

    public static final class SymbolableComparator
    implements Comparator<Symbolable> {
        public static final @NonNull SymbolableComparator INSTANCE = new SymbolableComparator();

        @Override
        public int compare(@NonNull Symbolable o1, @NonNull Symbolable o2) {
            String n1 = o1.getSymbolName();
            String n2 = o2.getSymbolName();
            return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }
    }
}

