/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtcorebase.analysis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.IterateExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.IteratorExp;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.LiteralExp;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.SelfType;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.internal.manager.TemplateParameterSubstitutionVisitor;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcorebase.AbstractMapping;
import org.eclipse.qvtd.pivot.qvtcorebase.Assignment;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcorebase.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.DomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtcorebase.util.AbstractExtendingQVTcoreBaseVisitor;
import org.eclipse.qvtd.pivot.qvtcorebase.utilities.QVTcoreBaseUtil;

public abstract class AbstractDomainUsageAnalysis
extends AbstractExtendingQVTcoreBaseVisitor<DomainUsage, EnvironmentFactoryInternal>
implements DomainUsageAnalysis.Internal {
    private DomainUsage selfUsage = null;
    @NonNull
    protected final Map<Element, DomainUsage> element2usage = new HashMap<Element, DomainUsage>();

    protected AbstractDomainUsageAnalysis(@NonNull EnvironmentFactoryInternal environmentFactory) {
        super(environmentFactory);
    }

    @NonNull
    protected DomainUsage doPropertyAssignment(Property property, @NonNull PropertyAssignment object) {
        DomainUsage valueUsage = this.visit((Element)object.getValue());
        DomainUsage slotUsage = this.visit((Element)object.getSlotExpression());
        DomainUsage knownSourceUsage = this.getRootAnalysis().property2containingClassUsage.get(property);
        if (knownSourceUsage != null) {
            DomainUsage knownTargetUsage = this.getRootAnalysis().property2referredTypeUsage.get(property);
            this.intersection(knownSourceUsage, slotUsage);
            return this.intersection(knownTargetUsage, valueUsage);
        }
        return this.intersection(slotUsage, valueUsage);
    }

    @NonNull
    protected DomainUsage doPropertyCallExp(Property property, @NonNull NavigationCallExp object) {
        DomainUsage actualSourceUsage = this.visit((Element)object.getOwnedSource());
        DomainUsage knownSourceUsage = this.getRootAnalysis().property2containingClassUsage.get(property);
        if (knownSourceUsage != null) {
            DomainUsage knownTargetUsage = this.getRootAnalysis().property2referredTypeUsage.get(property);
            return knownTargetUsage;
        }
        return actualSourceUsage;
    }

    @NonNull
    protected DomainUsage getDomainUsage(@Nullable EObject object) {
        Domain domain = QVTcoreBaseUtil.getContainingDomain((EObject)object);
        if (domain != null) {
            return this.visit((Element)domain.getTypedModel());
        }
        return this.getRootAnalysis().getMiddleUsage();
    }

    @NonNull
    public Map<Element, DomainUsage> getElements2Usage() {
        return this.element2usage;
    }

    @NonNull
    public EnvironmentFactoryInternal getEnvironmentFactory() {
        return (EnvironmentFactoryInternal)this.context;
    }

    @NonNull
    protected abstract RootDomainUsageAnalysis getRootAnalysis();

    @Override
    @Nullable
    public DomainUsage getUsage(@Nullable EObject element) {
        return this.element2usage.get(element);
    }

    @NonNull
    protected DomainUsage intersection(@NonNull DomainUsage firstUsage, @NonNull DomainUsage secondUsage) {
        int secondMask;
        int firstMask = ((DomainUsage.Internal)firstUsage).getMask();
        if (firstMask == (secondMask = ((DomainUsage.Internal)secondUsage).getMask())) {
            if (firstUsage != secondUsage) {
                if (!firstUsage.isConstant()) {
                    this.replace((DomainUsage.Internal)firstUsage, secondUsage);
                    return secondUsage;
                }
                if (!secondUsage.isConstant()) {
                    this.replace((DomainUsage.Internal)secondUsage, firstUsage);
                    return firstUsage;
                }
            }
            return firstUsage;
        }
        int intersectionMask = firstMask & secondMask;
        DomainUsage usage = this.getRootAnalysis().getValidUsage(intersectionMask);
        if (usage != null) {
            if (usage != firstUsage && !firstUsage.isConstant()) {
                this.replace((DomainUsage.Internal)firstUsage, usage);
            }
            if (usage != secondUsage && !secondUsage.isConstant()) {
                this.replace((DomainUsage.Internal)secondUsage, usage);
            }
            return usage;
        }
        usage = this.getRootAnalysis().createVariableUsage(intersectionMask);
        if (!firstUsage.isConstant()) {
            this.replace((DomainUsage.Internal)firstUsage, usage);
        }
        if (!secondUsage.isConstant()) {
            this.replace((DomainUsage.Internal)secondUsage, usage);
        }
        return usage;
    }

    protected void popSelfUsage(DomainUsage savedUsage) {
        this.selfUsage = savedUsage;
    }

    protected DomainUsage pushSelfUsage(@NonNull DomainUsage usage) {
        DomainUsage oldUsage = this.selfUsage;
        int usageMask = ((DomainUsage.Internal)usage).getMask();
        RootDomainUsageAnalysis.DomainUsageConstant constantUsage = this.getRootAnalysis().getValidUsage(usageMask);
        if (constantUsage == null) {
            usage = this.getRootAnalysis().createVariableUsage(usageMask);
        }
        this.selfUsage = usage;
        return oldUsage;
    }

    protected void replace(@NonNull DomainUsage.Internal oldUsage, @NonNull DomainUsage newUsage) {
        Iterable<Element> elements = oldUsage.getElements();
        if (elements != null) {
            for (Element element : elements) {
                this.setUsage(element, newUsage);
            }
        }
    }

    protected void setBoundVariablesUsages(@NonNull Rule rule) {
        DomainUsage primitiveUsage = this.getRootAnalysis().getPrimitiveUsage();
        for (Domain domain : rule.getDomain()) {
            if (!(domain instanceof CoreDomain)) continue;
            DomainUsage usage = this.visit((Element)domain.getTypedModel());
            for (Variable variable : ((CoreDomain)domain).getGuardPattern().getVariable()) {
                if (variable == null) continue;
                DomainUsage variableUsage = this.visit((Element)variable.getType());
                if (variableUsage != primitiveUsage) {
                    variableUsage = usage;
                }
                assert (variableUsage != null);
                this.setUsage((Element)variable, variableUsage);
            }
        }
        if (rule instanceof AbstractMapping) {
            DomainUsage middleUsage = this.getRootAnalysis().getMiddleUsage();
            for (Variable variable : ((AbstractMapping)rule).getGuardPattern().getVariable()) {
                if (variable == null) continue;
                DomainUsage variableUsage = this.visit((Element)variable.getType());
                if (variableUsage != primitiveUsage) {
                    variableUsage = middleUsage;
                }
                assert (variableUsage != null);
                this.setUsage((Element)variable, variableUsage);
            }
        }
    }

    protected void setUsage(@NonNull Element element, @NonNull DomainUsage newUsage) {
        this.element2usage.put(element, newUsage);
        ((DomainUsage.Internal)newUsage).addUsedBy(element);
    }

    @Override
    @NonNull
    public DomainUsage visit(@Nullable Element element) {
        if (element == null) {
            return this.getRootAnalysis().getAnyUsage();
        }
        DomainUsage usage = this.element2usage.get(element);
        if (usage == null) {
            usage = (DomainUsage)element.accept((Visitor)this);
            assert (usage != null) : "null usage for " + element.eClass().getName() + " " + element;
            this.setUsage(element, usage);
        }
        return usage;
    }

    @Nullable
    public DomainUsage visiting(@NonNull Visitable visitable) {
        throw new UnsupportedOperationException("Unsupported " + visitable.eClass().getName() + " for " + this.getClass().getSimpleName());
    }

    @Override
    @Nullable
    public DomainUsage visitBottomPattern(@NonNull BottomPattern object) {
        for (Variable variable : object.getVariable()) {
            this.visit((Element)variable);
        }
        for (Variable variable : object.getRealizedVariable()) {
            this.visit((Element)variable);
        }
        for (Assignment assignment : object.getAssignment()) {
            this.visit(assignment);
        }
        for (Predicate predicate : object.getPredicate()) {
            this.visit((Element)predicate);
        }
        return this.getDomainUsage((EObject)object);
    }

    @Nullable
    public DomainUsage visitClass(@NonNull Class object) {
        DomainUsage usage = this.getRootAnalysis().class2usage.get(object);
        if (usage != null) {
            return usage;
        }
        return this.getRootAnalysis().getPrimitiveUsage();
    }

    @Nullable
    public DomainUsage visitCollectionItem(@NonNull CollectionItem object) {
        return this.visit((Element)object.getOwnedItem());
    }

    @Nullable
    public DomainUsage visitCollectionLiteralExp(@NonNull CollectionLiteralExp object) {
        DomainUsage usage = this.getRootAnalysis().getAnyUsage();
        for (CollectionLiteralPart part : object.getOwnedParts()) {
            usage = this.intersection(usage, this.visit((Element)part));
        }
        return usage;
    }

    @Nullable
    public DomainUsage visitCollectionRange(@NonNull CollectionRange object) {
        DomainUsage firstUsage = this.visit((Element)object.getOwnedFirst());
        DomainUsage lastUsage = this.visit((Element)object.getOwnedLast());
        return this.intersection(firstUsage, lastUsage);
    }

    @Nullable
    public DomainUsage visitCollectionType(@NonNull CollectionType object) {
        return this.visit((Element)object.getElementType());
    }

    @Override
    @Nullable
    public DomainUsage visitCoreDomain(@NonNull CoreDomain object) {
        this.visit((Element)object.getGuardPattern());
        this.visit((Element)object.getBottomPattern());
        return this.visit((Element)object.getTypedModel());
    }

    @Nullable
    public DomainUsage visitExpressionInOCL(@NonNull ExpressionInOCL object) {
        this.visit((Element)object.getOwnedContext());
        for (Variable parameter : object.getOwnedParameters()) {
            this.visit((Element)parameter);
        }
        this.visit((Element)object.getOwnedResult());
        return this.visit((Element)object.getOwnedBody());
    }

    @Nullable
    public DomainUsage visitFunction(@NonNull Function object) {
        for (Parameter parameter : object.getOwnedParameters()) {
            this.visit((Element)parameter);
        }
        OCLExpression queryExpression = object.getQueryExpression();
        if (queryExpression != null) {
            return this.visit((Element)queryExpression);
        }
        return this.visit((Element)object.getType());
    }

    @Nullable
    public DomainUsage visitIfExp(@NonNull IfExp object) {
        DomainUsage conditionUsage = this.visit((Element)object.getOwnedCondition());
        DomainUsage thenUsage = this.visit((Element)object.getOwnedThen());
        DomainUsage elseUsage = this.visit((Element)object.getOwnedElse());
        return this.intersection(thenUsage, elseUsage);
    }

    @Override
    @Nullable
    public DomainUsage visitGuardPattern(@NonNull GuardPattern object) {
        DomainUsage domainUsage = this.getDomainUsage((EObject)object);
        for (Predicate predicate : object.getPredicate()) {
            this.visit((Element)predicate);
        }
        return domainUsage;
    }

    @Nullable
    public DomainUsage visitIterateExp(@NonNull IterateExp object) {
        Iteration iteration;
        DomainUsage sourceUsage = this.visit((Element)object.getOwnedSource());
        for (Variable iterator : object.getOwnedIterators()) {
            if (iterator == null) continue;
            this.setUsage((Element)iterator, sourceUsage);
        }
        this.visit((Element)object.getOwnedResult());
        DomainUsage bodyUsage = this.visit((Element)object.getOwnedBody());
        TemplateParameterSubstitutionVisitor visitor = new TemplateParameterSubstitutionVisitor((EnvironmentFactoryInternal)this.context, object.getOwnedSource().getType(), null);
        object.accept((Visitor)visitor);
        Iteration eObject = iteration = object.getReferredIteration();
        while (eObject != null) {
            TemplateSignature ownedSignature;
            if (eObject instanceof TemplateableElement && (ownedSignature = ((TemplateableElement)eObject).getOwnedSignature()) != null) {
                for (TemplateParameter templateParameter : ownedSignature.getOwnedParameters()) {
                    if (templateParameter == null) continue;
                    Type templateParameterType = visitor.get(templateParameter);
                    DomainUsage templateParameterUsage = this.visit((Element)templateParameterType);
                    this.setUsage((Element)templateParameter, templateParameterUsage);
                }
            }
            eObject = eObject.eContainer();
        }
        return this.visit((Element)iteration.getType());
    }

    @Nullable
    public DomainUsage visitIteratorExp(@NonNull IteratorExp object) {
        Iteration iteration;
        DomainUsage sourceUsage = this.visit((Element)object.getOwnedSource());
        for (Variable iterator : object.getOwnedIterators()) {
            if (iterator == null) continue;
            this.setUsage((Element)iterator, sourceUsage);
        }
        DomainUsage bodyUsage = this.visit((Element)object.getOwnedBody());
        TemplateParameterSubstitutionVisitor visitor = new TemplateParameterSubstitutionVisitor((EnvironmentFactoryInternal)this.context, object.getOwnedSource().getType(), null);
        object.accept((Visitor)visitor);
        Iteration eObject = iteration = object.getReferredIteration();
        while (eObject != null) {
            TemplateSignature ownedSignature;
            if (eObject instanceof TemplateableElement && (ownedSignature = ((TemplateableElement)eObject).getOwnedSignature()) != null) {
                for (TemplateParameter templateParameter : ownedSignature.getOwnedParameters()) {
                    if (templateParameter == null) continue;
                    Type templateParameterType = visitor.get(templateParameter);
                    DomainUsage templateParameterUsage = this.visit((Element)templateParameterType);
                    this.setUsage((Element)templateParameter, templateParameterUsage);
                }
            }
            eObject = eObject.eContainer();
        }
        return this.visit((Element)iteration.getType());
    }

    @Nullable
    public DomainUsage visitLetExp(@NonNull LetExp object) {
        this.visit((Element)object.getOwnedVariable());
        return this.visit((Element)object.getOwnedIn());
    }

    @Nullable
    public DomainUsage visitLiteralExp(@NonNull LiteralExp object) {
        return this.getRootAnalysis().getPrimitiveUsage();
    }

    @Nullable
    public DomainUsage visitMapLiteralExp(@NonNull MapLiteralExp object) {
        DomainUsage usage = this.getRootAnalysis().getAnyUsage();
        for (MapLiteralPart part : object.getOwnedParts()) {
            usage = this.intersection(usage, this.visit((Element)part));
        }
        return usage;
    }

    @Nullable
    public DomainUsage visitMapLiteralPart(@NonNull MapLiteralPart object) {
        DomainUsage keyUsage = this.visit((Element)object.getOwnedKey());
        DomainUsage valueUsage = this.visit((Element)object.getOwnedValue());
        return this.intersection(keyUsage, valueUsage);
    }

    @Nullable
    public DomainUsage visitNullLiteralExp(@NonNull NullLiteralExp object) {
        return this.getRootAnalysis().getAnyUsage();
    }

    @Nullable
    public DomainUsage visitOperation(@NonNull Operation object) {
        DomainUsage savedUsage = this.pushSelfUsage(this.visit((Element)object.getOwningClass()));
        try {
            for (Parameter parameter : object.getOwnedParameters()) {
                this.visit((Element)parameter);
            }
            LanguageExpression bodyExpression = object.getBodyExpression();
            if (bodyExpression != null) {
                DomainUsage domainUsage = this.visit((Element)bodyExpression);
                return domainUsage;
            }
            DomainUsage domainUsage = this.visit((Element)object.getType());
            return domainUsage;
        }
        finally {
            this.popSelfUsage(savedUsage);
        }
    }

    @Nullable
    public DomainUsage visitOperationCallExp(@NonNull OperationCallExp object) {
        DomainUsage savedUsage = this.pushSelfUsage(this.visit((Element)object.getOwnedSource()));
        try {
            Operation operation = (Operation)ClassUtil.nonNullState((Object)object.getReferredOperation());
            DomainUsageAnalysis analysis = this.getRootAnalysis().getAnalysis(operation);
            HashMap<DomainUsage, DomainUsage> referred2specialized = new HashMap<DomainUsage, DomainUsage>();
            List ownedParameters = operation.getOwnedParameters();
            int iMax = Math.min(ownedParameters.size(), object.getOwnedArguments().size());
            int i = 0;
            while (i < iMax) {
                Parameter parameter = (Parameter)ownedParameters.get(i);
                OCLExpression argument = (OCLExpression)object.getOwnedArguments().get(i);
                DomainUsage referredParameterUsage = analysis.getUsage((EObject)parameter);
                if (referredParameterUsage != null) {
                    DomainUsage specializedParameterUsage;
                    if (referredParameterUsage.isConstant()) {
                        specializedParameterUsage = referredParameterUsage;
                    } else {
                        specializedParameterUsage = (DomainUsage)referred2specialized.get(referredParameterUsage);
                        if (specializedParameterUsage == null) {
                            specializedParameterUsage = ((DomainUsage.Internal)referredParameterUsage).cloneVariable();
                            referred2specialized.put(referredParameterUsage, specializedParameterUsage);
                        }
                    }
                    DomainUsage argumentUsage = this.visit((Element)argument);
                    this.intersection(argumentUsage, specializedParameterUsage);
                }
                ++i;
            }
            DomainUsage operationUsage = analysis.getUsage((EObject)operation);
            if (operationUsage != null && !operationUsage.isConstant()) {
                operationUsage = ((DomainUsage.Internal)operationUsage).cloneVariable();
            }
            DomainUsage operationCallUsage = this.visit((Element)object.getType());
            DomainUsage domainUsage = operationUsage != null ? this.intersection(operationUsage, operationCallUsage) : operationCallUsage;
            return domainUsage;
        }
        finally {
            this.popSelfUsage(savedUsage);
        }
    }

    @Nullable
    public DomainUsage visitOppositePropertyCallExp(@NonNull OppositePropertyCallExp object) {
        Property property = object.getReferredProperty();
        Property oppositeProperty = property != null ? property.getOpposite() : null;
        return this.doPropertyCallExp(oppositeProperty, (NavigationCallExp)object);
    }

    @Nullable
    public DomainUsage visitParameter(@NonNull Parameter object) {
        return this.visit((Element)object.getType());
    }

    @Nullable
    public DomainUsage visitPredicate(@NonNull Predicate object) {
        return this.visit((Element)object.getConditionExpression());
    }

    @Nullable
    public DomainUsage visitPrimitiveType(@NonNull PrimitiveType object) {
        return this.getRootAnalysis().getPrimitiveUsage();
    }

    @Override
    @Nullable
    public DomainUsage visitPropertyAssignment(@NonNull PropertyAssignment object) {
        Property property = object.getTargetProperty();
        if ("att2col.type := prim2name".equals(object.toString())) {
            property = object.getTargetProperty();
        }
        return this.doPropertyAssignment(property, object);
    }

    @Nullable
    public DomainUsage visitPropertyCallExp(@NonNull PropertyCallExp object) {
        Property property = object.getReferredProperty();
        return this.doPropertyCallExp(property, (NavigationCallExp)object);
    }

    @Override
    @Nullable
    public DomainUsage visitRealizedVariable(@NonNull RealizedVariable object) {
        return this.getDomainUsage((EObject)object);
    }

    @Nullable
    public DomainUsage visitRule(@NonNull Rule object) {
        for (Domain domain : object.getDomain()) {
            this.visit((Element)domain);
        }
        return this.getRootAnalysis().getNoneUsage();
    }

    @Nullable
    public DomainUsage visitSelfType(@NonNull SelfType object) {
        return this.selfUsage;
    }

    @Nullable
    public DomainUsage visitShadowExp(@NonNull ShadowExp object) {
        DomainUsage usage = this.getRootAnalysis().getAnyUsage();
        for (ShadowPart part : object.getOwnedParts()) {
            usage = this.intersection(usage, this.visit((Element)part));
        }
        return usage;
    }

    @Nullable
    public DomainUsage visitShadowPart(@NonNull ShadowPart object) {
        return this.visit((Element)object.getType());
    }

    @Nullable
    public DomainUsage visitTemplateParameter(@NonNull TemplateParameter object) {
        return this.getRootAnalysis().getAnyUsage();
    }

    @Nullable
    public DomainUsage visitTransformation(@NonNull Transformation object) {
        Variable ownedContext = object.getOwnedContext();
        DomainUsage domainUsage = this.getUsage((EObject)object);
        if (ownedContext != null && domainUsage != null) {
            this.setUsage((Element)ownedContext, domainUsage);
        }
        for (Operation operation : object.getOwnedOperations()) {
            if (operation == null) continue;
            this.getRootAnalysis().analyzeOperation(operation);
        }
        for (Rule rule : object.getRule()) {
            if (rule == null) continue;
            this.setBoundVariablesUsages(rule);
        }
        for (Rule rule : object.getRule()) {
            this.visit((Element)rule);
        }
        return this.getRootAnalysis().getNoneUsage();
    }

    @Nullable
    public DomainUsage visitTupleLiteralExp(@NonNull TupleLiteralExp object) {
        DomainUsage usage = this.getRootAnalysis().getAnyUsage();
        for (TupleLiteralPart part : object.getOwnedParts()) {
            usage = this.intersection(usage, this.visit((Element)part));
        }
        return usage;
    }

    @Nullable
    public DomainUsage visitTupleLiteralPart(@NonNull TupleLiteralPart object) {
        return this.visit((Element)object.getType());
    }

    @Nullable
    public DomainUsage visitTupleType(@NonNull TupleType object) {
        DomainUsage usage = this.getRootAnalysis().getAnyUsage();
        for (Property part : object.getOwnedProperties()) {
            usage = this.intersection(usage, this.visit((Element)part.getType()));
        }
        return usage;
    }

    @Nullable
    public DomainUsage visitType(@NonNull Type object) {
        return this.getRootAnalysis().getPrimitiveUsage();
    }

    @Nullable
    public DomainUsage visitTypeExp(@NonNull TypeExp object) {
        return this.visit((Element)object.getReferredType());
    }

    @Nullable
    public DomainUsage visitTypedModel(@NonNull TypedModel object) {
        return this.element2usage.get(object);
    }

    @Nullable
    public DomainUsage visitVariable(@NonNull Variable object) {
        OCLExpression ownedInit = object.getOwnedInit();
        if (ownedInit != null) {
            return this.visit((Element)ownedInit);
        }
        return this.visit((Element)object.getType());
    }

    @Override
    @Nullable
    public DomainUsage visitVariableAssignment(@NonNull VariableAssignment object) {
        DomainUsage valueUsage = this.visit((Element)object.getValue());
        DomainUsage variableUsage = this.visit((Element)object.getTargetVariable());
        return this.intersection(variableUsage, valueUsage);
    }

    @Nullable
    public DomainUsage visitVariableDeclaration(@NonNull VariableDeclaration object) {
        return this.visit((Element)object.getType());
    }

    @Nullable
    public DomainUsage visitVariableExp(@NonNull VariableExp object) {
        DomainUsage usage = this.element2usage.get(object.getReferredVariable());
        assert (usage != null) : object.getReferredVariable() + " usage not defined";
        return usage;
    }
}

