/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QvtrToQvtcTransformation;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.Rule;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.AbstractRule;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.RelationalTransformationToTracePackage;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.RuleBindings;
import org.eclipse.qvtd.pivot.qvtbase.QVTbaseFactory;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;

public class RelationalTransformationToMappingTransformation
extends AbstractRule {
    @NonNull
    public static final Rule.Factory FACTORY = new Factory();
    @NonNull
    private static final RuleBindings.KeySet RULE_BINDINGS = new RuleBindings.KeySet();
    @NonNull
    public static final RuleBindings.RuleKey<RelationalTransformation> RELATIONS_rt = RULE_BINDINGS.createRoot(null, "rt");
    Transformation mt = null;
    Package p = null;
    TypedModel mmtm = null;
    String rtn;
    @NonNull
    protected final List<SubRecord> subRecords = new ArrayList<SubRecord>();

    public RelationalTransformationToMappingTransformation(@NonNull QvtrToQvtcTransformation transformation, @NonNull RelationalTransformation rt) {
        super(transformation);
        this.ruleBindings.put(RELATIONS_rt, rt);
    }

    @Override
    public void check() {
        RelationalTransformation rt = this.ruleBindings.get(RELATIONS_rt);
        this.rtn = rt.getName();
        assert (rt != null && this.mt == null);
        this.p = this.transformation.getTransformationToPackageTrace(rt);
        assert (this.p != null);
        for (TypedModel rtm : rt.getModelParameter()) {
            EList usedPackage = rtm.getUsedPackage();
            String tmn = rtm.getName();
            assert (tmn != null);
            this.subRecords.add(new SubRecord(rtm, tmn, (List<Package>)usedPackage));
        }
    }

    @Nullable
    public Transformation getCore() {
        return this.mt;
    }

    @Override
    @NonNull
    public RuleBindings.KeySet getRuleBindingsKeys() {
        return RULE_BINDINGS;
    }

    @Override
    public void instantiateOutput() {
        this.mt = QVTbaseFactory.eINSTANCE.createTransformation();
        assert (this.mt != null);
        this.transformation.addOrphan((EObject)this.mt);
        this.mmtm = QVTbaseFactory.eINSTANCE.createTypedModel();
        for (SubRecord subRecord : this.subRecords) {
            TypedModel mtm;
            subRecord.mtm = mtm = QVTbaseFactory.eINSTANCE.createTypedModel();
        }
    }

    @Override
    public void setAttributes() {
        assert (this.mt != null);
        this.mt.setName(this.rtn);
        assert (this.p != null);
        assert (this.mmtm != null);
        this.mmtm.setName("");
        this.mmtm.getUsedPackage().add((Object)this.p);
        this.mt.getModelParameter().add((Object)this.mmtm);
        for (SubRecord subRecord : this.subRecords) {
            TypedModel mtm = subRecord.mtm;
            assert (mtm != null);
            mtm.setName(subRecord.tmn);
            mtm.getUsedPackage().addAll(subRecord.up);
            this.mt.getModelParameter().add((Object)mtm);
        }
    }

    @Override
    public boolean when() {
        RelationalTransformation rt = this.ruleBindings.get(RELATIONS_rt);
        assert (rt != null);
        RelationalTransformationToTracePackage whenRule = new RelationalTransformationToTracePackage(this.transformation, rt);
        RuleBindings whenBindings = whenRule.getRuleBindings();
        RelationalTransformationToTracePackage whenRuleRecord = (RelationalTransformationToTracePackage)this.transformation.getRecord(whenBindings);
        if (whenRuleRecord != null && whenRuleRecord.hasExecuted()) {
            this.p = whenRuleRecord.getCore();
            assert (this.p != null);
            return true;
        }
        return false;
    }

    private static class Factory
    extends AbstractRule.Factory {
        private Factory() {
        }

        @Override
        @Nullable
        public Rule createRule(@NonNull QvtrToQvtcTransformation transformation, @NonNull EObject eo) {
            Rule tracedRule;
            Rule rule = null;
            if (eo instanceof RelationalTransformation && (tracedRule = transformation.getRecord((rule = new RelationalTransformationToMappingTransformation(transformation, (RelationalTransformation)eo)).getRuleBindings())) != null) {
                rule = tracedRule;
            }
            return rule;
        }

        @Override
        @Nullable
        public Rule createRule(@NonNull QvtrToQvtcTransformation transformation, @NonNull List<EObject> eos) {
            return null;
        }
    }

    private class SubRecord {
        @NonNull
        public TypedModel rtm;
        @NonNull
        public String tmn;
        @NonNull
        public List<Package> up;
        @Nullable
        public TypedModel mtm;

        public SubRecord(@NonNull TypedModel rtm, @NonNull String tmn, List<Package> up) {
            this.rtm = rtm;
            this.tmn = tmn;
            this.up = up;
        }
    }
}

