/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Annotation;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Detail;
import org.eclipse.ocl.pivot.EnumLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QvtrToQvtcTransformation;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.OCLExpCopy;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.RelationalTransformationToMappingTransformation;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.RuleBindings;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.CorePattern;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvttemplate.CollectionTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.PropertyTemplateItem;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

public class QVTr2QVTcRelations {
    @NonNull
    private final QvtrToQvtcTransformation transformation;
    @NonNull
    private final String OPPOSITE_UPPER_SOURCE = "http://schema.omg.org/spec/MOF/2.0/emof.xml#Property.oppositeUpper";
    @NonNull
    private final String OPPOSITE_ROLE_NAME_SOURCE = "http://schema.omg.org/spec/MOF/2.0/emof.xml#Property.oppositeRoleName";
    @NonNull
    private final String EMF_ANNOTATION_DETAIL_KEY = "body";
    @NonNull
    private final String OPPOSITE_UPPER_VALUE = "1";
    @NonNull
    private final String OPPOSITE_ROLE_NAME_VALUE = "middle";

    public QVTr2QVTcRelations(@NonNull QvtrToQvtcTransformation transformation) {
        this.transformation = transformation;
    }

    private void addMiddleSynthesisAnnotations(Property p) {
        Annotation oppositeUpper = PivotFactory.eINSTANCE.createAnnotation();
        oppositeUpper.setName("http://schema.omg.org/spec/MOF/2.0/emof.xml#Property.oppositeUpper");
        Detail oppositeUpperDetail = PivotFactory.eINSTANCE.createDetail();
        oppositeUpperDetail.setName("body");
        oppositeUpperDetail.getValues().add("OPPOSITE_UPPER_VALUE");
        oppositeUpper.getOwnedDetails().add(oppositeUpperDetail);
        p.getOwnedAnnotations().add(oppositeUpper);
        Annotation oppositeRoleName = PivotFactory.eINSTANCE.createAnnotation();
        oppositeRoleName.setName("http://schema.omg.org/spec/MOF/2.0/emof.xml#Property.oppositeRoleName");
        Detail oppositeRoleNameDetail = PivotFactory.eINSTANCE.createDetail();
        oppositeRoleNameDetail.setName("body");
        oppositeRoleNameDetail.getValues().add("OPPOSITE_ROLE_NAME_VALUE");
        oppositeRoleName.getOwnedDetails().add(oppositeRoleNameDetail);
        p.getOwnedAnnotations().add(oppositeRoleName);
    }

    public Set<Variable> getSharedDomainVars(Relation r) {
        HashSet<Variable> vars = new HashSet<Variable>();
        for (Domain d : r.getDomain()) {
            if (((RelationDomain)d).getPattern() == null) continue;
            if (vars.isEmpty()) {
                vars.addAll((Collection<Variable>)((DomainPattern)((RelationDomain)d).getPattern().get(0)).getBindsTo());
                continue;
            }
            EList bt = ((DomainPattern)((RelationDomain)d).getPattern().get(0)).getBindsTo();
            vars.retainAll((Collection<?>)bt);
        }
        return vars;
    }

    public Set<Variable> getVarsOfExp(OCLExpression e) {
        HashSet<Variable> vs = new HashSet<Variable>();
        if (e instanceof VariableExp) {
            vs.add((Variable)((VariableExp)e).getReferredVariable());
        } else if (e instanceof OperationCallExp) {
            OperationCallExp oc = (OperationCallExp)e;
            vs.addAll(this.getVarsOfExp(oc.getOwnedSource()));
            for (OCLExpression a : oc.getOwnedArguments()) {
                vs.addAll(this.getVarsOfExp(a));
            }
        } else if (e instanceof PropertyCallExp) {
            vs.addAll(this.getVarsOfExp(((PropertyCallExp)e).getOwnedSource()));
        } else if (e instanceof RelationCallExp) {
            RelationCallExp rc = (RelationCallExp)e;
            for (OCLExpression a : rc.getArgument()) {
                vs.addAll(this.getVarsOfExp(a));
            }
        } else if (!(e instanceof EnumLiteralExp)) {
            if (e instanceof ObjectTemplateExp) {
                ObjectTemplateExp te = (ObjectTemplateExp)e;
                vs.add(te.getBindsTo());
                for (PropertyTemplateItem p : te.getPart()) {
                    vs.addAll(this.getVarsOfExp(p.getValue()));
                }
            } else if (e instanceof CollectionTemplateExp) {
                CollectionTemplateExp cte = (CollectionTemplateExp)e;
                for (OCLExpression m : cte.getMember()) {
                    vs.addAll(this.getVarsOfExp(m));
                }
            } else assert (false) : "getVarsOfExp() missing case for " + e.eClass().getName();
        }
        return vs;
    }

    @NonNull
    public Set<Predicate> filterOutPredicatesThatReferToVars(@NonNull Set<Predicate> rpSet, @NonNull Set<Variable> ownrdVars) {
        HashSet<Predicate> fpSet = new HashSet<Predicate>();
        for (Predicate p : rpSet) {
            Set<Variable> vs = this.getVarsOfExp(p.getConditionExpression());
            vs.retainAll(ownrdVars);
            if (!vs.isEmpty()) continue;
            fpSet.add(p);
        }
        return fpSet;
    }

    private boolean isVarBoundToSomeOtherTemplate(ObjectTemplateExp rootTe, ObjectTemplateExp skipTe, Variable v) {
        if (rootTe == skipTe) {
            return false;
        }
        if (rootTe.getBindsTo().equals(v)) {
            return true;
        }
        boolean exists = false;
        for (PropertyTemplateItem p : rootTe.getPart()) {
            if (!(p.getValue() instanceof ObjectTemplateExp)) continue;
            exists |= this.isVarBoundToSomeOtherTemplate((ObjectTemplateExp)p.getValue(), skipTe, v);
        }
        return exists;
    }

    public void doRDomainToMDBottomForEnforcement(@NonNull Relation r, @NonNull RelationDomain rd, @NonNull ObjectTemplateExp te, @NonNull Set<Predicate> predicatesWithoutVarBindings, @NonNull Set<Variable> unboundDomainVars, @NonNull BottomPattern db) {
        Variable v = te.getBindsTo();
        HashSet<Variable> remainingUnBoundDomainVars = new HashSet<Variable>(unboundDomainVars);
        remainingUnBoundDomainVars.remove(v);
        Set<Predicate> predicatesWithVarBindings = this.filterOutPredicatesThatReferToVars(predicatesWithoutVarBindings, remainingUnBoundDomainVars);
        HashSet<Predicate> remainingPredicatesWithoutVarBindings = new HashSet<Predicate>(predicatesWithoutVarBindings);
        remainingPredicatesWithoutVarBindings.removeAll(predicatesWithVarBindings);
        Area area = db.getArea();
        assert (area instanceof CoreDomain) : "Missing CoreDomain for RDomainToMDBottomForEnforcement";
        CoreDomain cd = (CoreDomain)area;
        Rule rule = cd.getRule();
        assert (rule instanceof Mapping) : "Missing Mapping for RDomainToMDBottomForEnforcement";
        Mapping m = (Mapping)rule;
        BottomPattern mb = m.getBottomPattern();
        assert (mb != null);
        this.doRDomainToMDBottomForEnforcementOfIdentityProp(r, te, db);
        this.doRDomainToMDBottomForEnforcementOfNonIdentityPropPrimitive(r, te, rd, m);
        this.doRDomainVarToMDBottomAssignmnetForEnforcement(r, rd, te, mb);
    }

    public void doRRelImplToMBottomEnforcementOperation(Relation r, RelationDomain rd, BottomPattern mb) {
    }

    public void doRWhenPatternToMGuardPattern(@NonNull Relation r, @NonNull GuardPattern mg) {
        Pattern whenp = r.getWhen();
        if (whenp != null) {
            HashSet whenVars = new HashSet(whenp.getBindsTo());
            Set<Variable> allDomainVars = this.getAllDomainVars(r);
            HashSet unsharedWhenVars = new HashSet(whenVars);
            unsharedWhenVars.removeAll(allDomainVars);
            this.doRWhenRelCallToMGuard(whenp, mg);
            this.doRSimplePatternToMPattern(whenp, (Pattern)mg);
            this.doRVarSetToDGVarSet(new ArrayList<Variable>(unsharedWhenVars), mg);
        }
    }

    private void doRDomainPatternToMDBottomPattern(@NonNull Relation r, @NonNull ObjectTemplateExp te, @NonNull BottomPattern db) {
        CoreDomain cd = (CoreDomain)db.getArea();
        assert (cd != null);
        Mapping m = (Mapping)cd.getRule();
        assert (m != null);
        BottomPattern mb = m.getBottomPattern();
        assert (mb != null);
        this.doRDomainPatternToMDBottomPatternComposite(r, te, db);
        this.doRDomainPatternToMDBottomPatternSimpleNonVarExpr(te, db);
        this.doRDomainPatternToMDBottomPatternSimpleUnSharedVarExpr(r, te, db);
        this.doRDomainPatternToMDBottomPatternSimpleSharedVarExpr(r, te, mb);
    }

    public void doRDomainToMBottomPredicateForEnforcement(@NonNull Relation r, @NonNull RelationDomain rd, @NonNull ObjectTemplateExp te, @NonNull Set<Predicate> predicatesWithoutVarBindings, @NonNull Set<Variable> unboundDomainVars, @NonNull BottomPattern mb) {
        Variable v = te.getBindsTo();
        assert (v != null);
        Predicate pd = this.transformation.createPredicate();
        OperationCallExp ee = this.transformation.createOperationCallExp();
        PropertyCallExp pe = this.transformation.createPropertyCallExp();
        VariableExp pve = this.transformation.createVariableExp();
        VariableExp ave = this.transformation.createVariableExp();
        RealizedVariable tcv = this.doRelationDomainToTraceClassVar(r, rd, (CorePattern)mb);
        Variable mv = this.doRVarToMVar(v);
        HashSet<Variable> remainingUnBoundDomainVars = new HashSet<Variable>(unboundDomainVars);
        remainingUnBoundDomainVars.remove(v);
        Set<Predicate> predicatesWithVarBindings = this.filterOutPredicatesThatReferToVars(predicatesWithoutVarBindings, remainingUnBoundDomainVars);
        this.doRPredicateSetToMBPredicateSet(new ArrayList<Predicate>(predicatesWithVarBindings), mb);
        pve.setReferredVariable((VariableDeclaration)tcv);
        pve.setType(tcv.getType());
        pe.setOwnedSource((OCLExpression)pve);
        Property pep = this.getProperty(v.getName(), tcv.getType());
        assert (pep != null);
        pe.setReferredProperty(pep);
        pe.setType(pep.getType());
        ee.setOwnedSource((OCLExpression)pe);
        ee.setReferredOperation(this.getEqualsOPeration());
        ee.setType((Type)this.transformation.getStandardLibrary().getBooleanType());
        ave.setReferredVariable((VariableDeclaration)mv);
        ave.setType(mv.getType());
        ee.getOwnedArguments().add(ave);
        pd.setConditionExpression((OCLExpression)ee);
        mb.getPredicate().add((Object)pd);
    }

    public void doRDomainToMDBottomForEnforcementOfIdentityProp(@NonNull Relation r, @NonNull ObjectTemplateExp te, @NonNull BottomPattern db) {
        Variable v = te.getBindsTo();
        assert (v != null);
        Type c = v.getType();
        assert (c != null);
        Area area = db.getArea();
        assert (area instanceof CoreDomain) : "Missing CoreDomain for RDomainToMDBottomForEnforcement";
        CoreDomain cd = (CoreDomain)area;
        Rule rule = cd.getRule();
        assert (rule instanceof Mapping) : "Missing Mapping for RDomainToMDBottomForEnforcement";
        Mapping m = (Mapping)rule;
        BottomPattern mb = m.getBottomPattern();
        assert (mb != null);
        for (PropertyTemplateItem pt : te.getPart()) {
            Property pp = pt.getReferredProperty();
            Key key = this.transformation.getKeyforType(c);
            assert (key != null);
            if (!key.getPart().contains((Object)pp)) continue;
            OCLExpression e = pt.getValue();
            assert (pp != null && e != null);
            this.doRDomainPatternExprToMappingDomainAssignment(v, pp, e, db);
            this.doRDomainPatternExprToMappingDomainVarAssignment(r, v, pp, e, db);
            this.doRDomainPatternExprToMappingDomainTemplateVarAssignment(r, v, pp, e, db);
            this.doRDomainPatternExprToMappingBottomVarAssignment(r, v, pp, e, mb);
        }
    }

    public void doRDomainToMDBottomForEnforcementOfNonIdentityPropObject(@NonNull Relation r, @NonNull RelationDomain rd, @NonNull ObjectTemplateExp te, @NonNull Set<Predicate> predicatesWithoutVarBindings, @NonNull Set<Variable> unboundDomainVars, @NonNull Mapping m) {
        RelationalTransformation rt = (RelationalTransformation)r.getTransformation();
        assert (rt != null);
        RelationalTransformationToMappingTransformation whenRule = new RelationalTransformationToMappingTransformation(this.transformation, rt);
        RuleBindings whenBindings = whenRule.getRuleBindings();
        whenRule = (RelationalTransformationToMappingTransformation)this.transformation.getRecord(whenBindings);
        Transformation mt = null;
        if (whenRule != null && whenRule.hasExecuted()) {
            mt = whenRule.getCore();
        }
        assert (mt != null);
    }

    private void doRSimplePatternToMPattern(Pattern rp, Pattern mp) {
        for (Predicate pd : rp.getPredicate()) {
            OCLExpression ce = pd.getConditionExpression();
            assert (ce != null);
            if (ce instanceof RelationCallExp) continue;
            Predicate mpd = this.transformation.createPredicate();
            OCLExpression me = this.doRExpToMExp(ce);
            assert (me != null);
            mpd.setConditionExpression(me);
        }
    }

    public void doRVarSetToMBVarSet(@NonNull ArrayList<Variable> rvSeq, @NonNull BottomPattern mb) {
        if (!rvSeq.isEmpty()) {
            Variable rv = rvSeq.remove(0);
            assert (rv != null);
            Variable mv = this.doRVarToMVar(rv, (CorePattern)mb);
            assert (mv != null);
            this.doRVarSetToMBVarSet(rvSeq, mb);
        }
    }

    public void doRWhenRelCallToMGuard(@NonNull Pattern rp, @NonNull GuardPattern mp) {
        for (Predicate p : rp.getPredicate()) {
            if (!(p.getConditionExpression() instanceof RelationCallExp)) continue;
            RelationCallExp e = (RelationCallExp)p.getConditionExpression();
            Relation r = e.getReferredRelation();
            ArrayList dseq = new ArrayList(r.getDomain());
            StringBuilder s = new StringBuilder();
            for (OCLExpression arg : e.getArgument()) {
                VariableExp a = (VariableExp)arg;
                s.append("_");
                s.append(a.getReferredVariable().getName());
            }
            String vdId = s.toString();
            for (OCLExpression arg : e.getArgument()) {
                VariableExp a = (VariableExp)arg;
                RelationDomain rd = (RelationDomain)dseq.get(e.getArgument().indexOf((Object)a));
                assert (a != null && rd != null && vdId != null);
                this.doRWhenRelCallArgToMGuardPredicate(r, a, rd, mp, vdId);
            }
        }
    }

    public void doRelationToTraceClass(@NonNull Relation r, @NonNull Class rc) {
        this.transformation.putRelationTrace(r, rc);
        String rn = r.getName();
        assert (rn != null);
        rc.setName("T" + rn);
        Set<Variable> sharedDomainVars = this.getSharedDomainVars(r);
        this.doRVarSetToTraceClassProps(new ArrayList<Variable>(sharedDomainVars), rc);
        for (Domain d : r.getDomain()) {
            RelationDomain rd = (RelationDomain)d;
            DomainPattern rdp = (DomainPattern)rd.getPattern().get(0);
            assert (rdp != null);
            TemplateExp t = rdp.getTemplateExpression();
            assert (t != null);
            this.doSubObjectTemplateToTraceClassProps(t, rc);
            this.doSubCollectionTemplateToTraceClassProps(t, rc);
        }
    }

    private void doRVarSetToTraceClassProps(@NonNull ArrayList<Variable> rvSeq, @NonNull Class rc) {
        if (!rvSeq.isEmpty()) {
            Variable rv = rvSeq.remove(0);
            assert (rv != null);
            this.RVarToTraceClassProp(rv, rc);
            this.doRVarSetToTraceClassProps(rvSeq, rc);
        }
    }

    private void RVarToTraceClassProp(@NonNull Variable rv, @NonNull Class rc) {
        Type c = rv.getType();
        assert (c != null);
        String vn = rv.getName();
        assert (vn != null);
        Property a = this.transformation.findProperty(vn, rc);
        this.addMiddleSynthesisAnnotations(a);
        assert (a != null);
        a.setType(c);
    }

    private void doSubObjectTemplateToTraceClassProps(@NonNull TemplateExp t, @NonNull Class rc) {
        if (t instanceof ObjectTemplateExp) {
            this.doObjectTemplateToTraceClassProps((ObjectTemplateExp)t, rc);
        }
    }

    private void doObjectTemplateToTraceClassProps(@NonNull ObjectTemplateExp t, @NonNull Class rc) {
        Variable tv = t.getBindsTo();
        assert (tv != null);
        Type c = tv.getType();
        assert (c != null);
        String vn = tv.getName();
        assert (vn != null);
        Property a = this.transformation.findProperty(vn, rc);
        assert (a != null);
        this.addMiddleSynthesisAnnotations(a);
        for (PropertyTemplateItem pt : t.getPart()) {
            OCLExpression value = pt.getValue();
            assert (value != null);
            if (!(value instanceof TemplateExp)) continue;
            TemplateExp tp = (TemplateExp)value;
            this.doSubObjectTemplateToTraceClassProps(tp, rc);
            this.doSubCollectionTemplateToTraceClassProps(tp, rc);
        }
        a.setType(c);
    }

    private void doSubCollectionTemplateToTraceClassProps(@NonNull TemplateExp t, @NonNull Class rc) {
        if (t instanceof CollectionTemplateExp) {
            this.doCollectionTemplateToTraceClassProps((CollectionTemplateExp)t, rc);
        }
    }

    private void doCollectionTemplateToTraceClassProps(@NonNull CollectionTemplateExp t, @NonNull Class rc) {
        for (OCLExpression m : t.getMember()) {
            if (!(m instanceof TemplateExp)) continue;
            TemplateExp tp = (TemplateExp)m;
            this.doSubObjectTemplateToTraceClassProps(tp, rc);
            this.doSubCollectionTemplateToTraceClassProps(tp, rc);
        }
    }

    public void doTROppositeDomainsToMappingForEnforcement(@NonNull Relation r, @NonNull RelationDomain rd, @NonNull Mapping m) {
        HashSet<RelationDomain> rds = new HashSet<RelationDomain>();
        for (Domain d : r.getDomain()) {
            rds.add((RelationDomain)d);
        }
        rds.remove(rd);
        for (RelationDomain ord : rds) {
            DomainPattern dp = (DomainPattern)ord.getPattern().get(0);
            if (!(dp.getTemplateExpression() instanceof ObjectTemplateExp)) continue;
            String dn = ord.getName();
            assert (dn != null);
            TypedModel dir = ord.getTypedModel();
            String tmn = dir.getName();
            assert (tmn != null);
            RelationalTransformation rt = (RelationalTransformation)dir.getTransformation();
            assert (rt != null);
            EList up = dir.getUsedPackage();
            boolean c = ord.isIsCheckable();
            EList domainVars = dp.getBindsTo();
            ObjectTemplateExp te = (ObjectTemplateExp)dp.getTemplateExpression();
            assert (te != null);
            RelationalTransformationToMappingTransformation whenRule = new RelationalTransformationToMappingTransformation(this.transformation, rt);
            RuleBindings whenBindings = whenRule.getRuleBindings();
            RelationalTransformationToMappingTransformation whenRuleRecord = (RelationalTransformationToMappingTransformation)this.transformation.getRecord(whenBindings);
            Transformation mt = null;
            if (whenRuleRecord != null && whenRuleRecord.hasExecuted()) {
                mt = whenRuleRecord.getCore();
            }
            assert (mt != null);
            CoreDomain cd = this.transformation.findCoreDomain(dn, (Rule)m);
            GuardPattern dg = this.transformation.findGuardPattern((Area)cd);
            BottomPattern db = this.transformation.findBottomPattern((Area)cd);
            BottomPattern mb = this.transformation.findBottomPattern((Area)m);
            HashSet whenVars = new HashSet();
            if (r.getWhen() != null) {
                whenVars.addAll(r.getWhen().getBindsTo());
            }
            HashSet domainTopVars = new HashSet(domainVars);
            domainTopVars.retainAll(whenVars);
            Set<Variable> sharedDomainVars = this.getSharedDomainVars(r);
            HashSet domainBottomUnSharedVars = new HashSet(domainVars);
            domainBottomUnSharedVars.removeAll(whenVars);
            domainBottomUnSharedVars.removeAll(sharedDomainVars);
            HashSet domainBottomSharedVars = new HashSet(domainVars);
            domainBottomSharedVars.removeAll(whenVars);
            domainBottomSharedVars.retainAll(sharedDomainVars);
            this.doRVarSetToDGVarSet(new ArrayList<Variable>(domainTopVars), dg);
            this.doRVarSetToMBVarSet(new ArrayList<Variable>(domainBottomUnSharedVars), db);
            this.doRVarSetToMBVarSet(new ArrayList<Variable>(domainBottomSharedVars), mb);
            this.doRDomainPatternToMDBottomPattern(r, te, db);
            TypedModel mdir = null;
            for (TypedModel tm : mt.getModelParameter()) {
                if (!tm.getName().equals(tmn) || !tm.getUsedPackage().equals((Object)up)) continue;
                mdir = tm;
                break;
            }
            cd.setTypedModel(mdir);
            cd.setIsCheckable(c);
            cd.setIsEnforceable(false);
            cd.setGuardPattern(dg);
            m.setBottomPattern(mb);
        }
    }

    private void doRDomainPatternExprToMappingBottomVarAssignment(@NonNull Relation r, @NonNull Variable v, @NonNull Property pp, @NonNull OCLExpression e, @NonNull BottomPattern mb) {
        Set<Variable> sharedDomainVars = this.getSharedDomainVars(r);
        if (e instanceof VariableExp && sharedDomainVars.contains(((VariableExp)e).getReferredVariable())) {
            String pn = pp.getName();
            Variable rev = (Variable)((VariableExp)e).getReferredVariable();
            assert (rev != null);
            PropertyAssignment a = this.transformation.createPropertyAssignment();
            VariableExp ve = this.transformation.createVariableExp();
            VariableExp me = this.transformation.createVariableExp();
            RealizedVariable mv = this.doRVarToMRealizedVar(v);
            Variable mev = this.doRVarToMVar(rev);
            ve.setReferredVariable((VariableDeclaration)mv);
            ve.setType(mv.getType());
            a.setSlotExpression((OCLExpression)ve);
            Property tp = this.getProperty(pn, mv.getType());
            assert (tp != null);
            a.setTargetProperty(tp);
            me.setReferredVariable((VariableDeclaration)mev);
            me.setType(mev.getType());
            a.setValue((OCLExpression)me);
            mb.getAssignment().add((Object)a);
        }
    }

    private void doRDomainPatternExprToMappingDomainAssignment(@NonNull Variable v, @NonNull Property pp, @NonNull OCLExpression e, @NonNull BottomPattern db) {
        if (!(e instanceof VariableExp) && !(e instanceof ObjectTemplateExp)) {
            String pn = pp.getName();
            PropertyAssignment a = this.transformation.createPropertyAssignment();
            VariableExp ve = this.transformation.createVariableExp();
            Variable mv = this.doRVarToMVar(v);
            assert (mv != null);
            OCLExpression me = this.doRExpToMExp(e);
            assert (me != null);
            a.setSlotExpression((OCLExpression)ve);
            ve.setReferredVariable((VariableDeclaration)mv);
            ve.setType(mv.getType());
            Property tp = this.getProperty(pn, mv.getType());
            a.setTargetProperty(tp);
            a.setValue(me);
            db.getAssignment().add((Object)a);
        }
    }

    private void doRDomainPatternExprToMappingDomainTemplateVarAssignment(@NonNull Relation r, @NonNull Variable v, @NonNull Property pp, @NonNull OCLExpression e, @NonNull BottomPattern db) {
        Set<Variable> sharedDomainVars = this.getSharedDomainVars(r);
        if (e instanceof ObjectTemplateExp) {
            Variable rev = ((ObjectTemplateExp)e).getBindsTo();
            assert (rev != null);
            if (!sharedDomainVars.contains(rev)) {
                String pn = pp.getName();
                PropertyAssignment a = this.transformation.createPropertyAssignment();
                VariableExp ve = this.transformation.createVariableExp();
                VariableExp me = this.transformation.createVariableExp();
                RealizedVariable mv = this.doRVarToMRealizedVar(v);
                Variable mev = this.doRVarToMVar(rev);
                ve.setReferredVariable((VariableDeclaration)mv);
                ve.setType(mv.getType());
                a.setSlotExpression((OCLExpression)ve);
                Property tp = this.getProperty(pn, mv.getType());
                assert (tp != null);
                a.setTargetProperty(tp);
                me.setReferredVariable((VariableDeclaration)mev);
                me.setType(mev.getType());
                a.setValue((OCLExpression)me);
                db.getAssignment().add((Object)a);
            }
        }
    }

    private void doRDomainPatternExprToMappingDomainVarAssignment(@NonNull Relation r, @NonNull Variable v, @NonNull Property pp, @NonNull OCLExpression e, @NonNull BottomPattern db) {
        Set<Variable> sharedDomainVars = this.getSharedDomainVars(r);
        if (e instanceof VariableExp && !sharedDomainVars.contains(((VariableExp)e).getReferredVariable())) {
            String pn = pp.getName();
            Variable rev = (Variable)((VariableExp)e).getReferredVariable();
            assert (rev != null);
            PropertyAssignment a = this.transformation.createPropertyAssignment();
            VariableExp ve = this.transformation.createVariableExp();
            VariableExp me = this.transformation.createVariableExp();
            RealizedVariable mv = this.doRVarToMRealizedVar(v);
            Variable mev = this.doRVarToMVar(rev);
            ve.setReferredVariable((VariableDeclaration)mv);
            ve.setType(mv.getType());
            a.setSlotExpression((OCLExpression)ve);
            Property tp = this.getProperty(pn, mv.getType());
            a.setTargetProperty(tp);
            me.setReferredVariable((VariableDeclaration)mev);
            me.setType(mev.getType());
            a.setValue((OCLExpression)me);
            db.getRealizedVariable().add((Object)mv);
            db.getAssignment().add((Object)a);
        }
    }

    private void doRDomainPatternToMDBottomPatternComposite(@NonNull Relation r, @NonNull ObjectTemplateExp te, @NonNull BottomPattern db) {
        for (PropertyTemplateItem pt : te.getPart()) {
            if (!(pt.getValue() instanceof ObjectTemplateExp)) continue;
            Variable vte = te.getBindsTo();
            assert (vte != null);
            Property pp = pt.getReferredProperty();
            assert (pp != null);
            String pn = pp.getName();
            ObjectTemplateExp pte = (ObjectTemplateExp)pt.getValue();
            Variable vpte = pte.getBindsTo();
            assert (vpte != null);
            PropertyAssignment a = this.transformation.createPropertyAssignment();
            VariableExp ve1 = this.transformation.createVariableExp();
            VariableExp ve2 = this.transformation.createVariableExp();
            Variable mvte = this.doRVarToMVar(vte);
            Variable mvpte = this.doRVarToMVar(vpte);
            this.doRDomainPatternToMDBottomPattern(r, pte, db);
            Property tp = this.getProperty(pn, mvte.getType());
            assert (tp != null);
            ve1.setReferredVariable((VariableDeclaration)mvte);
            ve1.setType(mvte.getType());
            a.setSlotExpression((OCLExpression)ve1);
            a.setTargetProperty(tp);
            ve2.setReferredVariable((VariableDeclaration)mvpte);
            ve2.setType(mvpte.getType());
            a.setValue((OCLExpression)ve2);
            db.getAssignment().add((Object)a);
        }
    }

    private void doRDomainPatternToMDBottomPatternSimpleNonVarExpr(@NonNull ObjectTemplateExp te, @NonNull BottomPattern db) {
        Variable vte = te.getBindsTo();
        assert (vte != null);
        for (PropertyTemplateItem pt : te.getPart()) {
            OCLExpression e = pt.getValue();
            assert (e != null);
            if (e instanceof TemplateExp || e instanceof VariableExp) continue;
            Property pp = pt.getReferredProperty();
            assert (pp != null);
            String pn = pp.getName();
            PropertyAssignment a = this.transformation.createPropertyAssignment();
            VariableExp ve = this.transformation.createVariableExp();
            Variable mvte = this.doRVarToMVar(vte);
            assert (mvte != null);
            OCLExpression me = this.doRExpToMExp(e);
            assert (me != null);
            ve.setReferredVariable((VariableDeclaration)mvte);
            ve.setType(mvte.getType());
            Property tp = this.getProperty(pn, mvte.getType());
            assert (tp != null);
            a.setTargetProperty(tp);
            a.setSlotExpression((OCLExpression)ve);
            a.setValue(me);
            db.getAssignment().add((Object)a);
        }
    }

    private void doRDomainPatternToMDBottomPatternSimpleSharedVarExpr(@NonNull Relation r, @NonNull ObjectTemplateExp te, @NonNull BottomPattern mb) {
        Set<Variable> sharedDomainVars = this.getSharedDomainVars(r);
        Variable vte = te.getBindsTo();
        assert (vte != null);
        for (PropertyTemplateItem pt : te.getPart()) {
            if (!(pt.getValue() instanceof VariableExp)) continue;
            VariableExp e = (VariableExp)pt.getValue();
            Variable vpte = (Variable)e.getReferredVariable();
            assert (vpte != null);
            if (!sharedDomainVars.contains(vpte)) continue;
            String pn = pt.getReferredProperty().getName();
            PropertyAssignment a = this.transformation.createPropertyAssignment();
            VariableExp ve1 = this.transformation.createVariableExp();
            VariableExp ve2 = this.transformation.createVariableExp();
            Variable mvte = this.doRVarToMVar(vte);
            Variable mvpte = this.doRVarToMVar(vpte);
            ve1.setReferredVariable((VariableDeclaration)mvte);
            ve2.setReferredVariable((VariableDeclaration)mvpte);
            Property tp = this.getProperty(pn, mvte.getType());
            assert (tp != null);
            a.setSlotExpression((OCLExpression)ve1);
            a.setTargetProperty(tp);
            a.setValue((OCLExpression)ve2);
            mb.getAssignment().add((Object)a);
        }
    }

    private void doRDomainPatternToMDBottomPatternSimpleUnSharedVarExpr(@NonNull Relation r, @NonNull ObjectTemplateExp te, @NonNull BottomPattern db) {
        Set<Variable> sharedDomainVars = this.getSharedDomainVars(r);
        Variable vte = te.getBindsTo();
        assert (vte != null);
        for (PropertyTemplateItem pt : te.getPart()) {
            if (!(pt.getValue() instanceof VariableExp)) continue;
            VariableExp e = (VariableExp)pt.getValue();
            Variable vpte = (Variable)e.getReferredVariable();
            assert (vpte != null);
            if (sharedDomainVars.contains(vpte)) continue;
            String pn = pt.getReferredProperty().getName();
            PropertyAssignment a = this.transformation.createPropertyAssignment();
            VariableExp ve1 = this.transformation.createVariableExp();
            VariableExp ve2 = this.transformation.createVariableExp();
            Variable mvte = this.doRVarToMVar(vte);
            Variable mvpte = this.doRVarToMVar(vpte);
            ve1.setReferredVariable((VariableDeclaration)mvte);
            ve2.setReferredVariable((VariableDeclaration)mvpte);
            Property tp = this.getProperty(pn, mvte.getType());
            assert (tp != null);
            a.setSlotExpression((OCLExpression)ve1);
            a.setTargetProperty(tp);
            a.setValue((OCLExpression)ve2);
            db.getAssignment().add((Object)a);
        }
    }

    private void doRDomainToMComposedMappingGuard(@NonNull Relation r, @NonNull ObjectTemplateExp te, @NonNull RelationDomain rd, @NonNull OCLExpression e, @NonNull Mapping cm) {
        RelationalTransformation rt = (RelationalTransformation)r.getTransformation();
        assert (rt != null);
        Transformation mt = null;
        RelationalTransformationToMappingTransformation whenRule = new RelationalTransformationToMappingTransformation(this.transformation, rt);
        RuleBindings whenBindings = whenRule.getRuleBindings();
        RelationalTransformationToMappingTransformation whenRuleRecord = (RelationalTransformationToMappingTransformation)this.transformation.getRecord(whenBindings);
        if (whenRuleRecord != null && whenRuleRecord.hasExecuted()) {
            mt = whenRuleRecord.getCore();
        }
        assert (mt != null);
        DomainPattern rdp = (DomainPattern)rd.getPattern().get(0);
        TemplateExp rdt = rdp.getTemplateExpression();
        if (e instanceof VariableExp && rdt instanceof ObjectTemplateExp) {
            Variable v = (Variable)((VariableExp)e).getReferredVariable();
            assert (v != null);
            if (this.isVarBoundToSomeOtherTemplate((ObjectTemplateExp)rdt, te, v)) {
                String dn = rd.getName();
                assert (dn != null);
                TypedModel dir = rd.getTypedModel();
                String tmn = dir.getName();
                assert (tmn != null);
                EList up = dir.getUsedPackage();
                if (rt != dir.getTransformation()) {
                    return;
                }
                GuardPattern mg = this.transformation.findGuardPattern((Area)cm);
                Predicate pd = this.transformation.createPredicate();
                OperationCallExp ee = this.transformation.createOperationCallExp();
                PropertyCallExp pe = this.transformation.createPropertyCallExp();
                VariableExp ve1 = this.transformation.createVariableExp();
                VariableExp ve2 = this.transformation.createVariableExp();
                CoreDomain cd = this.transformation.findCoreDomain(dn, (Rule)cm);
                GuardPattern cmdg = this.transformation.findGuardPattern((Area)cd);
                BottomPattern mb = cm.getBottomPattern();
                assert (mb != null);
                RealizedVariable tcv = this.doRelationDomainToTraceClassVar(r, rd, (CorePattern)mb);
                assert (tcv != null);
                Variable mv = this.doRVarToMVar(v);
                assert (mv != null);
                ve1.setReferredVariable((VariableDeclaration)tcv);
                ve1.setType(tcv.getType());
                Property tp = this.getProperty(mv.getName(), mv.getType());
                pe.setOwnedSource((OCLExpression)ve1);
                pe.setReferredProperty(tp);
                pe.setType(tp.getType());
                ee.setOwnedSource((OCLExpression)pe);
                ee.setReferredOperation(this.getEqualsOPeration());
                ee.setType((Type)this.transformation.getStandardLibrary().getBooleanType());
                ve2.setReferredVariable((VariableDeclaration)mv);
                ve2.setType(mv.getType());
                ee.getOwnedArguments().add(ve2);
                pd.setConditionExpression((OCLExpression)ee);
                mg.getPredicate().add((Object)pd);
                TypedModel mdir = null;
                for (TypedModel tm : mt.getModelParameter()) {
                    if (!tm.getName().equals(tmn) || !tm.getUsedPackage().equals((Object)up)) continue;
                    mdir = tm;
                    break;
                }
                cd.setTypedModel(mdir);
                cmdg.getBindsTo().add((Object)mv);
                cd.setGuardPattern(cmdg);
            }
        }
    }

    public void doRDomainToMDBottomForEnforcementOfNonIdentityPropPrimitive(@NonNull Relation r, @NonNull ObjectTemplateExp te, @NonNull RelationDomain rd, @NonNull Mapping m) {
        RelationalTransformation rt = (RelationalTransformation)r.getTransformation();
        assert (rt != null);
        RelationalTransformationToMappingTransformation whenRule = new RelationalTransformationToMappingTransformation(this.transformation, rt);
        RuleBindings whenBindings = whenRule.getRuleBindings();
        whenRule = (RelationalTransformationToMappingTransformation)this.transformation.getRecord(whenBindings);
        Transformation mt = null;
        if (whenRule != null && whenRule.hasExecuted()) {
            mt = whenRule.getCore();
        }
        assert (mt != null);
        for (PropertyTemplateItem pt : te.getPart()) {
            OCLExpression e = pt.getValue();
            Property pp = pt.getReferredProperty();
            assert (e != null);
            Variable v = te.getBindsTo();
            assert (v != null);
            Type c = v.getType();
            assert (c != null);
            Key key = this.transformation.getKeyforType(c);
            assert (key != null);
            if (key.getPart().contains((Object)pp) || e instanceof TemplateExp) continue;
            String pn = pp.getName();
            Mapping cm = this.transformation.findMapping(String.valueOf(m.getName()) + "_forNonIdentityProp", mt);
            BottomPattern bp = this.transformation.findBottomPattern((Area)cm);
            this.transformation.findGuardPattern((Area)cm);
            PropertyAssignment a = this.transformation.createPropertyAssignment();
            VariableExp ve = this.transformation.createVariableExp();
            Variable mv = this.doRVarToMVar(v);
            OCLExpression me = this.doRExpToMExp(e);
            assert (me != null);
            this.doRDomainToMComposedMappingGuard(r, te, rd, e, cm);
            ve.setReferredVariable((VariableDeclaration)mv);
            ve.setType(mv.getType());
            a.setSlotExpression((OCLExpression)ve);
            Property tp = this.getProperty(pn, mv.getType());
            assert (tp != null);
            a.setTargetProperty(tp);
            a.setValue(me);
            bp.getAssignment().add((Object)a);
            m.getLocal().add((Object)cm);
        }
    }

    public void doRDomainVarToMDBottomAssignmnetForEnforcement(@NonNull Relation r, @NonNull RelationDomain rd, @NonNull ObjectTemplateExp te, @NonNull BottomPattern mb) {
        Variable v = te.getBindsTo();
        assert (v != null);
        PropertyAssignment a = this.transformation.createPropertyAssignment();
        VariableExp ve1 = this.transformation.createVariableExp();
        VariableExp ve2 = this.transformation.createVariableExp();
        RealizedVariable tcv = this.doRelationDomainToTraceClassVar(r, rd, (CorePattern)mb);
        Variable mv = this.doRVarToMVar(v);
        ve1.setReferredVariable((VariableDeclaration)tcv);
        ve1.setType(tcv.getType());
        a.setSlotExpression((OCLExpression)ve1);
        Property tp = this.getProperty(v.getName(), tcv.getType());
        assert (tp != null);
        a.setTargetProperty(tp);
        ve2.setReferredVariable((VariableDeclaration)mv);
        ve2.setType(mv.getType());
        a.setValue((OCLExpression)ve2);
        mb.getAssignment().add((Object)a);
    }

    public void doROppositeDomainVarsToTraceClassProps(@NonNull Relation r, @NonNull RelationDomain rd, @NonNull ObjectTemplateExp te, @NonNull Set<Variable> domainVars, @NonNull BottomPattern mb) {
        for (Variable dv : domainVars) {
            if (this.transformation.getTemplateExpression(dv) == null) continue;
            PropertyAssignment a = this.transformation.createPropertyAssignment();
            VariableExp ve1 = this.transformation.createVariableExp();
            VariableExp ve2 = this.transformation.createVariableExp();
            RealizedVariable tcv = this.doRelationDomainToTraceClassVar(r, rd, (CorePattern)mb);
            assert (dv != null);
            Variable mdv = this.doRVarToMVar(dv);
            ve1.setReferredVariable((VariableDeclaration)tcv);
            ve1.setType(tcv.getType());
            a.setSlotExpression((OCLExpression)ve1);
            Property tp = this.getProperty(dv.getName(), tcv.getType());
            assert (tp != null) : "Property " + dv.getName() + ". not found in trace class " + tcv.getType().getName();
            a.setTargetProperty(tp);
            ve2.setReferredVariable((VariableDeclaration)mdv);
            ve2.setType(mdv.getType());
            a.setValue((OCLExpression)ve2);
            mb.getAssignment().add((Object)a);
        }
    }

    public void doRPredicateSetToMBPredicateSet(@NonNull ArrayList<Predicate> predSeq, @NonNull BottomPattern mb) {
        if (predSeq.isEmpty()) {
            return;
        }
        Predicate rp = predSeq.remove(0);
        OCLExpression re = rp.getConditionExpression();
        assert (re != null);
        Predicate mp = this.transformation.createPredicate();
        OCLExpression me = this.doRExpToMExp(re);
        assert (me != null);
        this.doRPredicateSetToMBPredicateSet(predSeq, mb);
        mp.setConditionExpression(me);
        mb.getPredicate().add((Object)mp);
    }

    public void doRVarSetToDGVarSet(@NonNull ArrayList<Variable> rvSeq, @NonNull GuardPattern dg) {
        if (!rvSeq.isEmpty()) {
            Variable rv = rvSeq.remove(0);
            assert (rv != null);
            Variable mv = this.doRVarToMVar(rv, (CorePattern)dg);
            assert (mv != null);
            this.doRVarSetToDGVarSet(rvSeq, dg);
        }
    }

    private void doRWhenRelCallArgToMGuardPredicate(@NonNull Relation r, @NonNull VariableExp ve, @NonNull RelationDomain d, @NonNull GuardPattern mg, @NonNull String vdId) {
        Class tc = this.transformation.getRelationTrace(r);
        assert (tc != null);
        String dvn = ((Variable)d.getRootVariable().get(0)).getName();
        assert (dvn != null);
        Variable v = (Variable)ve.getReferredVariable();
        assert (v != null);
        Variable vd = this.transformation.findVariable(String.valueOf(tc.getName()) + vdId + "_v", (Type)tc, (CorePattern)mg);
        Predicate mgp = this.transformation.createPredicate();
        OperationCallExp ee = this.transformation.createOperationCallExp();
        PropertyCallExp pe = this.transformation.createPropertyCallExp();
        VariableExp pve = this.transformation.createVariableExp();
        VariableExp ave = this.transformation.createVariableExp();
        Variable mv = this.doRVarToMVar(v);
        mgp.setConditionExpression((OCLExpression)ee);
        ee.setOwnedSource((OCLExpression)pe);
        pe.setOwnedSource((OCLExpression)pve);
        pve.setReferredVariable((VariableDeclaration)vd);
        pve.setType(vd.getType());
        Property pep = this.getProperty(dvn, vd.getType());
        assert (pep != null);
        pe.setReferredProperty(pep);
        pe.setType(pep.getType());
        ee.setReferredOperation(this.getEqualsOPeration());
        ee.setType((Type)this.transformation.getStandardLibrary().getBooleanType());
        ave.setReferredVariable((VariableDeclaration)mv);
        ave.setType(mv.getType());
        ee.getOwnedArguments().add(ave);
        mg.getPredicate().add((Object)mgp);
    }

    @Nullable
    public OCLExpression doRExpToMExp(@NonNull OCLExpression re) {
        OCLExpCopy oCLExpCopy = new OCLExpCopy(this.transformation);
        return (OCLExpression)oCLExpCopy.doSwitch((EObject)re);
    }

    @NonNull
    public RealizedVariable doRVarToMRealizedVar(@NonNull Variable rv, @NonNull CorePattern pattern) {
        RealizedVariable mv = this.transformation.findRealizedVariable(rv, pattern);
        return mv;
    }

    @NonNull
    public RealizedVariable doRVarToMRealizedVar(@NonNull Variable rv) {
        RealizedVariable mv = (RealizedVariable)this.transformation.getVariableTrace(rv);
        assert (mv != null);
        return mv;
    }

    @NonNull
    public Variable doRVarToMVar(@NonNull Variable rv, @NonNull CorePattern pattern) {
        Variable mv = this.transformation.findVariable(rv, pattern);
        return mv;
    }

    @NonNull
    public Variable doRVarToMVar(@NonNull Variable rv) {
        Variable mv = this.transformation.getVariableTrace(rv);
        assert (mv != null) : "No variable trace found for " + rv.getName() + ". Probable cause is a missing where/when statement to bind the variable.";
        return mv;
    }

    @NonNull
    public RealizedVariable doRelationDomainToTraceClassVar(@NonNull Relation r, @NonNull RelationDomain d, @NonNull CorePattern p) {
        String rn = r.getName();
        assert (rn != null);
        String dn = d.getName();
        assert (dn != null);
        Class tc = this.transformation.getRelationTrace(r);
        assert (tc != null);
        RealizedVariable mv = this.transformation.findTraceRealizedVariable(String.valueOf(rn) + "_" + dn + "_v", (Type)tc, p);
        return mv;
    }

    public void doIROppositeDomainsToMappingForEnforcement(@NonNull Relation r, @NonNull Relation ir, @NonNull RelationDomain rd, @NonNull Mapping m) {
        HashSet<RelationDomain> rds = new HashSet<RelationDomain>();
        for (Domain d : r.getDomain()) {
            rds.add((RelationDomain)d);
        }
        rds.remove(rd);
        for (RelationDomain ord : rds) {
            DomainPattern dp = (DomainPattern)ord.getPattern().get(0);
            if (!(dp.getTemplateExpression() instanceof ObjectTemplateExp)) continue;
            String dn = ord.getName();
            assert (dn != null);
            TypedModel dir = ord.getTypedModel();
            String tmn = dir.getName();
            assert (tmn != null);
            RelationalTransformation rt = (RelationalTransformation)dir.getTransformation();
            assert (rt != null);
            EList up = dir.getUsedPackage();
            boolean c = ord.isIsCheckable();
            EList domainVars = dp.getBindsTo();
            ObjectTemplateExp te = (ObjectTemplateExp)dp.getTemplateExpression();
            assert (te != null);
            Variable tev = te.getBindsTo();
            RelationalTransformationToMappingTransformation whenRule = new RelationalTransformationToMappingTransformation(this.transformation, rt);
            RuleBindings whenBindings = whenRule.getRuleBindings();
            RelationalTransformationToMappingTransformation whenRuleRecord = (RelationalTransformationToMappingTransformation)this.transformation.getRecord(whenBindings);
            Transformation mt = null;
            if (whenRuleRecord != null && whenRuleRecord.hasExecuted()) {
                mt = whenRuleRecord.getCore();
            }
            assert (mt != null);
            CoreDomain cd = this.transformation.findCoreDomain(dn, (Rule)m);
            GuardPattern dg = this.transformation.findGuardPattern((Area)cd);
            BottomPattern db = this.transformation.findBottomPattern((Area)cd);
            BottomPattern mb = this.transformation.findBottomPattern((Area)m);
            HashSet whenVars = new HashSet();
            if (r.getWhen() != null) {
                whenVars.addAll(r.getWhen().getBindsTo());
            }
            HashSet<Variable> domainTopVars = new HashSet<Variable>((Collection<Variable>)domainVars);
            domainTopVars.retainAll(whenVars);
            domainTopVars.add(tev);
            Set<Variable> sharedDomainVars = this.getSharedDomainVars(r);
            HashSet domainBottomUnSharedVars = new HashSet(domainVars);
            domainBottomUnSharedVars.removeAll(whenVars);
            domainBottomUnSharedVars.removeAll(sharedDomainVars);
            domainBottomUnSharedVars.remove(tev);
            HashSet domainBottomSharedVars = new HashSet(domainVars);
            domainBottomSharedVars.removeAll(whenVars);
            domainBottomSharedVars.retainAll(sharedDomainVars);
            domainBottomSharedVars.remove(tev);
            this.doRVarSetToDGVarSet(new ArrayList<Variable>(domainTopVars), dg);
            this.doRVarSetToMBVarSet(new ArrayList<Variable>(domainBottomUnSharedVars), db);
            this.doRVarSetToMBVarSet(new ArrayList<Variable>(domainBottomSharedVars), mb);
            this.doRDomainPatternToMDBottomPattern(r, te, db);
            TypedModel mdir = null;
            for (TypedModel tm : mt.getModelParameter()) {
                if (!tm.getName().equals(tmn) || !tm.getUsedPackage().equals((Object)up)) continue;
                mdir = tm;
                break;
            }
            cd.setTypedModel(mdir);
            cd.setIsCheckable(c);
            cd.setIsEnforceable(false);
            cd.setGuardPattern(dg);
            m.setBottomPattern(mb);
        }
    }

    public void doRInvokerToMGuard(@NonNull Relation ir, @NonNull RelationCallExp ri, @NonNull Relation r, @NonNull GuardPattern mg) {
        ArrayList dseq = new ArrayList(r.getDomain());
        for (OCLExpression arg : ri.getArgument()) {
            VariableExp a = (VariableExp)arg;
            RelationDomain rd = (RelationDomain)dseq.get(ri.getArgument().indexOf((Object)a));
            assert (a != null && rd != null);
            this.doRInvokerToMGuardPredicate(ir, a, rd, mg);
        }
    }

    private void doRInvokerToMGuardPredicate(@NonNull Relation ir, @NonNull VariableExp ve, @NonNull RelationDomain rd, @NonNull GuardPattern mg) {
        Class tc = this.transformation.getRelationTrace(ir);
        assert (tc != null);
        Variable v = (Variable)ve.getReferredVariable();
        assert (v != null);
        String vn = v.getName();
        assert (vn != null);
        Variable dv = (Variable)rd.getRootVariable().get(0);
        assert (dv != null);
        Variable vd = this.transformation.findVariable(String.valueOf(tc.getName()) + "_v", (Type)tc, (CorePattern)mg);
        Predicate pd = this.transformation.createPredicate();
        OperationCallExp ee = this.transformation.createOperationCallExp();
        PropertyCallExp pe = this.transformation.createPropertyCallExp();
        VariableExp mve = this.transformation.createVariableExp();
        VariableExp ave = this.transformation.createVariableExp();
        Variable mdv = this.doRVarToMVar(dv);
        pd.setConditionExpression((OCLExpression)ee);
        ee.setOwnedSource((OCLExpression)pe);
        pe.setOwnedSource((OCLExpression)mve);
        mve.setReferredVariable((VariableDeclaration)vd);
        mve.setType(vd.getType());
        Property pep = this.getProperty(vn, vd.getType());
        assert (pep != null);
        pe.setReferredProperty(pep);
        pe.setType(pep.getType());
        ee.setReferredOperation(this.getEqualsOPeration());
        ee.setType((Type)this.transformation.getStandardLibrary().getBooleanType());
        ave.setReferredVariable((VariableDeclaration)mdv);
        ave.setType(mdv.getType());
        ee.getOwnedArguments().add(ave);
        mg.getPredicate().add((Object)pd);
    }

    public Set<Predicate> rejectRelationCallPredicates(@NonNull List<Predicate> predicates) {
        HashSet<Predicate> rpSet = new HashSet<Predicate>(predicates);
        Iterator it = rpSet.iterator();
        while (it.hasNext()) {
            Predicate p = (Predicate)it.next();
            if (!(p.getConditionExpression() instanceof RelationCallExp)) continue;
            it.remove();
        }
        return rpSet;
    }

    public Set<Variable> getAllDomainVars(@NonNull Relation r) {
        HashSet<Variable> allDomainVars = new HashSet<Variable>();
        for (Domain d : r.getDomain()) {
            if (((RelationDomain)d).getPattern() == null) continue;
            allDomainVars.addAll((Collection<Variable>)((DomainPattern)((RelationDomain)d).getPattern().get(0)).getBindsTo());
        }
        return allDomainVars;
    }

    private Operation getEqualsOPeration() {
        Operation referredOperation = null;
        for (Operation o : this.transformation.getStandardLibrary().getOclAnyType().getOwnedOperations()) {
            if (!o.getName().equals("=")) continue;
            referredOperation = o;
            break;
        }
        return referredOperation;
    }

    private Property getProperty(String name, Type owningType) {
        if (owningType instanceof Class) {
            for (Property p : ((Class)owningType).getOwnedProperties()) {
                if (!p.getName().equals(name)) continue;
                return p;
            }
        }
        return null;
    }
}

