/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.utilities;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.Assignment;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcorebase.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.utilities.QVTcoreBasePrettyPrintVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeBottomPattern;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCallBinding;
import org.eclipse.qvtd.pivot.qvtimperative.MappingLoop;
import org.eclipse.qvtd.pivot.qvtimperative.MappingSequence;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.VariablePredicate;
import org.eclipse.qvtd.pivot.qvtimperative.util.QVTimperativeVisitor;

public class QVTimperativePrettyPrintVisitor
extends QVTcoreBasePrettyPrintVisitor
implements QVTimperativeVisitor<Object> {
    public QVTimperativePrettyPrintVisitor(@NonNull PrettyPrinter context) {
        super(context);
    }

    private void doArea(Area pArea) {
        ((PrettyPrinter)this.context).append(" (");
        this.safeVisit((Visitable)pArea.getGuardPattern());
        ((PrettyPrinter)this.context).append(")\n{");
        this.safeVisit((Visitable)pArea.getBottomPattern());
        ((PrettyPrinter)this.context).append("}\n");
    }

    public Object visitBottomPattern(@NonNull BottomPattern pBottomPattern) {
        for (RealizedVariable pRealizedVariable : pBottomPattern.getRealizedVariable()) {
            this.safeVisit((Visitable)pRealizedVariable);
        }
        for (Variable pVariable : pBottomPattern.getVariable()) {
            this.safeVisit((Visitable)pVariable);
        }
        ((PrettyPrinter)this.context).append(" |");
        EList assignments = pBottomPattern.getAssignment();
        if (assignments.size() > 0) {
            ((PrettyPrinter)this.context).append("\n");
            for (Assignment pAssignment : assignments) {
                this.safeVisit((Visitable)pAssignment);
            }
        }
        return null;
    }

    public Object visitGuardPattern(@NonNull GuardPattern pGuardPattern) {
        for (Variable pVariable : pGuardPattern.getVariable()) {
            this.safeVisit((Visitable)pVariable);
        }
        ((PrettyPrinter)this.context).append(" |");
        EList predicates = pGuardPattern.getPredicate();
        if (predicates.size() > 0) {
            ((PrettyPrinter)this.context).append("\n");
            for (Predicate pPredicate : predicates) {
                this.safeVisit((Visitable)pPredicate);
            }
        }
        return null;
    }

    @Override
    public Object visitImperativeBottomPattern(@NonNull ImperativeBottomPattern object) {
        return this.visitBottomPattern(object);
    }

    @Override
    public Object visitImperativeModel(@NonNull ImperativeModel object) {
        return null;
    }

    @Override
    public Object visitMapping(@NonNull Mapping pMapping) {
        ((PrettyPrinter)this.context).append("map ");
        ((PrettyPrinter)this.context).appendName((NamedElement)pMapping);
        ((PrettyPrinter)this.context).append(" in ");
        ((PrettyPrinter)this.context).appendName((NamedElement)pMapping.getTransformation());
        ((PrettyPrinter)this.context).append(" {\n");
        ((PrettyPrinter)this.context).push("", "");
        for (Domain pDomain : pMapping.getDomain()) {
            if (!(pDomain instanceof CoreDomain)) continue;
            ((PrettyPrinter)this.context).appendName((NamedElement)pDomain);
            this.doArea((Area)((CoreDomain)pDomain));
        }
        ((PrettyPrinter)this.context).append("where");
        this.doArea((Area)pMapping);
        this.safeVisit((Visitable)pMapping.getMappingStatement());
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    @Override
    public Object visitMappingCall(@NonNull MappingCall pMappingCall) {
        if (pMappingCall.isIsInfinite()) {
            ((PrettyPrinter)this.context).append("infinite ");
        }
        ((PrettyPrinter)this.context).append("map ");
        ((PrettyPrinter)this.context).appendName((NamedElement)pMappingCall.getReferredMapping());
        ((PrettyPrinter)this.context).append(" {\n");
        ((PrettyPrinter)this.context).push("", "");
        for (MappingCallBinding mappingCallBinding : pMappingCall.getBinding()) {
            this.safeVisit((Visitable)mappingCallBinding);
        }
        ((PrettyPrinter)this.context).append("}");
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    @Override
    public Object visitMappingCallBinding(@NonNull MappingCallBinding pMappingCallBinding) {
        ((PrettyPrinter)this.context).appendName((NamedElement)pMappingCallBinding.getBoundVariable());
        ((PrettyPrinter)this.context).append(pMappingCallBinding.isIsPolled() ? " ?= " : " := ");
        this.safeVisit((Visitable)pMappingCallBinding.getValue());
        ((PrettyPrinter)this.context).append(";\n");
        return null;
    }

    @Override
    public Object visitMappingLoop(@NonNull MappingLoop pMappingLoop) {
        ((PrettyPrinter)this.context).append("for ");
        ((PrettyPrinter)this.context).appendElement((Element)pMappingLoop.getOwnedIterators().get(0));
        ((PrettyPrinter)this.context).append(" in ");
        ((PrettyPrinter)this.context).appendElement((Element)pMappingLoop.getOwnedSource());
        ((PrettyPrinter)this.context).append(" {\n");
        ((PrettyPrinter)this.context).push("", "");
        this.safeVisit((Visitable)pMappingLoop.getOwnedBody());
        ((PrettyPrinter)this.context).append("}");
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    @Override
    public Object visitMappingSequence(@NonNull MappingSequence pMappingSequence) {
        for (MappingStatement pMappingStatement : pMappingSequence.getMappingStatements()) {
            this.safeVisit((Visitable)pMappingStatement);
        }
        return null;
    }

    @Override
    public Object visitMappingStatement(@NonNull MappingStatement object) {
        return this.visiting((Visitable)object);
    }

    public Object visitPredicate(@NonNull Predicate pPredicate) {
        this.safeVisit((Visitable)pPredicate.getConditionExpression());
        return null;
    }

    public Object visitPropertyAssignment(@NonNull PropertyAssignment pPropertyAssignment) {
        this.safeVisit((Visitable)pPropertyAssignment.getSlotExpression());
        ((PrettyPrinter)this.context).append(".");
        ((PrettyPrinter)this.context).appendName((NamedElement)pPropertyAssignment.getTargetProperty());
        ((PrettyPrinter)this.context).append(" := ");
        this.safeVisit((Visitable)pPropertyAssignment.getValue());
        ((PrettyPrinter)this.context).append(";\n");
        return null;
    }

    public Object visitRealizedVariable(@NonNull RealizedVariable pRealizedVariable) {
        ((PrettyPrinter)this.context).append("realize ");
        this.visitVariable((Variable)pRealizedVariable);
        return null;
    }

    public Object visitVariable(@NonNull Variable pVariable) {
        if (pVariable.eContainer() instanceof MappingLoop) {
            ((PrettyPrinter)this.context).appendName((NamedElement)pVariable);
            ((PrettyPrinter)this.context).append(" : ");
            ((PrettyPrinter)this.context).appendElement((Element)pVariable.getType());
        } else {
            super.visitVariable(pVariable);
            ((PrettyPrinter)this.context).append(";\n");
        }
        return null;
    }

    public Object visitVariableAssignment(@NonNull VariableAssignment pVariableAssignment) {
        this.safeVisit((Visitable)pVariableAssignment.getTargetVariable());
        ((PrettyPrinter)this.context).append(" := ");
        this.safeVisit((Visitable)pVariableAssignment.getValue());
        ((PrettyPrinter)this.context).append(";\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitVariablePredicate(@NonNull VariablePredicate object) {
        return null;
    }
}

