/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.codegen.qvti.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.AS2CGVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGFinalVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNamedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.examples.codegen.generator.GenModelException;
import org.eclipse.ocl.examples.codegen.java.JavaLocalContext;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.ids.PrimitiveTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.library.LibraryProperty;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiAnalyzer;
import org.eclipse.qvtd.codegen.qvti.java.QVTiGlobalContext;
import org.eclipse.qvtd.codegen.qvticgmodel.CGEcorePropertyAssignment;
import org.eclipse.qvtd.codegen.qvticgmodel.CGEcoreRealizedVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGFunction;
import org.eclipse.qvtd.codegen.qvticgmodel.CGFunctionCallExp;
import org.eclipse.qvtd.codegen.qvticgmodel.CGFunctionParameter;
import org.eclipse.qvtd.codegen.qvticgmodel.CGGuardVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMapping;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMappingCall;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMappingCallBinding;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMappingExp;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMappingLoop;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMiddlePropertyAssignment;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMiddlePropertyCallExp;
import org.eclipse.qvtd.codegen.qvticgmodel.CGPredicate;
import org.eclipse.qvtd.codegen.qvticgmodel.CGPropertyAssignment;
import org.eclipse.qvtd.codegen.qvticgmodel.CGRealizedVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGSequence;
import org.eclipse.qvtd.codegen.qvticgmodel.CGTransformation;
import org.eclipse.qvtd.codegen.qvticgmodel.CGTypedModel;
import org.eclipse.qvtd.codegen.qvticgmodel.CGVariablePredicate;
import org.eclipse.qvtd.codegen.qvticgmodel.QVTiCGModelFactory;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.FunctionParameter;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.Assignment;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.CorePattern;
import org.eclipse.qvtd.pivot.qvtcorebase.EnforcementOperation;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcorebase.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.utilities.QVTcoreBaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeBottomPattern;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCallBinding;
import org.eclipse.qvtd.pivot.qvtimperative.MappingLoop;
import org.eclipse.qvtd.pivot.qvtimperative.MappingSequence;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.VariablePredicate;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTransformationAnalysis;
import org.eclipse.qvtd.pivot.qvtimperative.util.QVTimperativeVisitor;

public class QVTiAS2CGVisitor
extends AS2CGVisitor
implements QVTimperativeVisitor<CGNamedElement> {
    @NonNull
    protected final QVTiAnalyzer analyzer;
    @NonNull
    protected final QVTiGlobalContext globalContext;

    public QVTiAS2CGVisitor(@NonNull QVTiAnalyzer analyzer, @NonNull QVTiGlobalContext globalContext) {
        super((CodeGenAnalyzer)analyzer);
        this.analyzer = analyzer;
        this.globalContext = globalContext;
    }

    protected void doBottoms(@NonNull Mapping pMapping, @NonNull CGMappingExp cgMappingExp) {
        ArrayList<BottomPattern> pBottomPatterns = new ArrayList<BottomPattern>();
        BottomPattern pBottomPattern = pMapping.getBottomPattern();
        if (pBottomPattern != null) {
            pBottomPatterns.add(pBottomPattern);
        }
        for (Domain pDomain : pMapping.getDomain()) {
            if (!(pDomain instanceof CoreDomain) || (pBottomPattern = ((CoreDomain)pDomain).getBottomPattern()) == null) continue;
            pBottomPatterns.add(pBottomPattern);
        }
        ArrayList pRealizedVariables = new ArrayList();
        for (BottomPattern pBottomPattern2 : pBottomPatterns) {
            pRealizedVariables.addAll(pBottomPattern2.getRealizedVariable());
        }
        Collections.sort(pRealizedVariables, new Comparator<NamedElement>(){

            @Override
            public int compare(NamedElement o1, NamedElement o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        List<CGValuedElement> cgRealizedVariables = cgMappingExp.getRealizedVariables();
        for (RealizedVariable pRealizedVariable : pRealizedVariables) {
            CGRealizedVariable cgVariable = this.getRealizedVariable(pRealizedVariable);
            cgRealizedVariables.add((CGValuedElement)cgVariable);
        }
        List<CGPropertyAssignment> cgAssignments = cgMappingExp.getAssignments();
        for (BottomPattern pBottomPattern3 : pBottomPatterns) {
            for (Assignment pAssignment : pBottomPattern3.getAssignment()) {
                cgAssignments.add((CGPropertyAssignment)this.doVisit(CGPropertyAssignment.class, (Element)pAssignment));
            }
        }
    }

    protected void doGuards(@NonNull Mapping pMapping, @NonNull CGMapping cgMapping, @NonNull CGMappingExp cgMappingExp) {
        ArrayList<GuardPattern> guardPatterns = new ArrayList<GuardPattern>();
        GuardPattern pGuardPattern = pMapping.getGuardPattern();
        if (pGuardPattern != null) {
            guardPatterns.add(pGuardPattern);
        }
        for (Domain pDomain : pMapping.getDomain()) {
            GuardPattern guardPattern;
            if (!(pDomain instanceof CoreDomain) || (guardPattern = ((CoreDomain)pDomain).getGuardPattern()) == null) continue;
            guardPatterns.add(guardPattern);
        }
        HashSet<Variable> predicatedVariables = new HashSet<Variable>();
        for (GuardPattern pGuardPattern2 : guardPatterns) {
            for (Predicate predicate : pGuardPattern2.getPredicate()) {
                if (!(predicate instanceof VariablePredicate)) continue;
                predicatedVariables.add(((VariablePredicate)predicate).getTargetVariable());
            }
        }
        ArrayList<Variable> pGuardVariables = new ArrayList<Variable>();
        for (GuardPattern pGuardPattern3 : guardPatterns) {
            pGuardPattern3.getPredicate();
            for (Variable pGuardVariable : pGuardPattern3.getVariable()) {
                if (predicatedVariables.contains(pGuardVariable)) continue;
                pGuardVariables.add(pGuardVariable);
            }
        }
        Collections.sort(pGuardVariables, new Comparator<NamedElement>(){

            @Override
            public int compare(NamedElement o1, NamedElement o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        ArrayList<CGGuardVariable> cgFreeVariables = new ArrayList<CGGuardVariable>();
        ArrayList<CGFinalVariable> cgBoundVariables = new ArrayList<CGFinalVariable>();
        for (Variable pGuardVariable : pGuardVariables) {
            OCLExpression initExpression = pGuardVariable.getOwnedInit();
            if (initExpression == null) {
                CGGuardVariable cgUnboundVariable = this.getGuardVariable(pGuardVariable);
                cgFreeVariables.add(cgUnboundVariable);
                continue;
            }
            CGFinalVariable cgBoundVariable = (CGFinalVariable)this.getVariable((VariableDeclaration)pGuardVariable);
            CGValuedElement cgInit = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)initExpression);
            cgBoundVariable.setInit(cgInit);
            JavaLocalContext localContext = this.globalContext.getLocalContext((CGElement)cgMapping);
            cgBoundVariables.add(cgBoundVariable);
        }
        Collections.sort(cgFreeVariables, new Comparator<CGGuardVariable>(){

            @Override
            public int compare(CGGuardVariable o1, CGGuardVariable o2) {
                String n1 = o1.getName();
                String n2 = o2.getName();
                return n1.compareTo(n2);
            }
        });
        Collections.sort(cgBoundVariables, new Comparator<CGFinalVariable>(){

            @Override
            public int compare(CGFinalVariable o1, CGFinalVariable o2) {
                String n1 = o1.getName();
                String n2 = o2.getName();
                return n1.compareTo(n2);
            }
        });
        cgMapping.getFreeVariables().addAll(cgFreeVariables);
        List<CGPredicate> cgGuardExpressions = cgMappingExp.getPredicates();
        for (GuardPattern pGuardPattern4 : guardPatterns) {
            for (Predicate asPredicate : pGuardPattern4.getPredicate()) {
                cgGuardExpressions.add((CGPredicate)this.doVisit(CGPredicate.class, (Element)asPredicate));
            }
        }
    }

    @NonNull
    protected CGValuedElement generateOperationCallExp(@Nullable CGValuedElement cgSource, @NonNull OperationCallExp asOperationCallExp) {
        Operation pOperation = asOperationCallExp.getReferredOperation();
        if (pOperation instanceof Function) {
            CGFunctionCallExp cgFunctionCallExp = QVTiCGModelFactory.eINSTANCE.createCGFunctionCallExp();
            cgFunctionCallExp.setReferredOperation(pOperation);
            this.setAst((CGTypedElement)cgFunctionCallExp, (TypedElement)asOperationCallExp);
            cgFunctionCallExp.setRequired(pOperation.isIsRequired());
            for (OCLExpression pArgument : asOperationCallExp.getOwnedArguments()) {
                CGValuedElement cgArgument = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)pArgument);
                cgFunctionCallExp.getArguments().add(cgArgument);
            }
            return cgFunctionCallExp;
        }
        return super.generateOperationCallExp(cgSource, asOperationCallExp);
    }

    @NonNull
    protected CGValuedElement generateOppositePropertyCallExp(@NonNull CGValuedElement cgSource, @NonNull OppositePropertyCallExp asOppositePropertyCallExp) {
        Property asOppositeProperty = (Property)ClassUtil.nonNullModel((Object)asOppositePropertyCallExp.getReferredProperty());
        Property asProperty = (Property)ClassUtil.nonNullModel((Object)asOppositeProperty.getOpposite());
        this.globalContext.addOppositeProperty(asOppositeProperty);
        CGMiddlePropertyCallExp cgPropertyCallExp = QVTiCGModelFactory.eINSTANCE.createCGMiddlePropertyCallExp();
        cgPropertyCallExp.setReferredProperty(asOppositeProperty);
        this.setAst((CGTypedElement)cgPropertyCallExp, (TypedElement)asOppositePropertyCallExp);
        cgPropertyCallExp.setRequired(asProperty.isIsRequired());
        cgPropertyCallExp.setSource(cgSource);
        return cgPropertyCallExp;
    }

    @Nullable
    protected EClassifier getEClassifier(@Nullable Type type) {
        if (type == null) {
            return null;
        }
        CompleteClassInternal completeClass = this.environmentFactory.getCompleteModel().getCompleteClass(type);
        for (Type partialClass : completeClass.getPartialClasses()) {
            EObject esObject = partialClass.getESObject();
            if (!(esObject instanceof EClassifier)) continue;
            return (EClassifier)esObject;
        }
        return null;
    }

    @NonNull
    public CGFunctionParameter getFunctionParameter(@NonNull FunctionParameter asFunctionParameter) {
        CGFunctionParameter cgFunctionParameter = (CGFunctionParameter)this.getVariablesStack().getParameter((Variable)asFunctionParameter);
        if (cgFunctionParameter == null) {
            cgFunctionParameter = QVTiCGModelFactory.eINSTANCE.createCGFunctionParameter();
            ((CodeGenAnalyzer)this.context).setNames((CGValuedElement)cgFunctionParameter, (Object)asFunctionParameter);
            this.setAst((CGTypedElement)cgFunctionParameter, (TypedElement)asFunctionParameter);
            cgFunctionParameter.setTypeId(((CodeGenAnalyzer)this.context).getTypeId(asFunctionParameter.getTypeId()));
            this.addParameter((Variable)asFunctionParameter, cgFunctionParameter);
        }
        return cgFunctionParameter;
    }

    @NonNull
    public CGGuardVariable getGuardVariable(@NonNull Variable asVariable) {
        CGGuardVariable cgGuardVariable = (CGGuardVariable)this.getVariablesStack().getParameter(asVariable);
        cgGuardVariable = QVTiCGModelFactory.eINSTANCE.createCGGuardVariable();
        ((CodeGenAnalyzer)this.context).setNames((CGValuedElement)cgGuardVariable, (Object)asVariable);
        this.setAst((CGTypedElement)cgGuardVariable, (TypedElement)asVariable);
        cgGuardVariable.setTypeId(((CodeGenAnalyzer)this.context).getTypeId(asVariable.getTypeId()));
        cgGuardVariable.setTypedModel(this.getTypedModel(asVariable));
        this.addParameter(asVariable, cgGuardVariable);
        return cgGuardVariable;
    }

    @NonNull
    public CGRealizedVariable getRealizedVariable(@NonNull RealizedVariable pRealizedVariable) {
        AS2CGVisitor.Variables variablesStack = this.getVariablesStack();
        CGRealizedVariable cgVariable = (CGRealizedVariable)variablesStack.getVariable((VariableDeclaration)pRealizedVariable);
        if (cgVariable == null) {
            EClassifier eClassifier = this.getEClassifier(pRealizedVariable.getType());
            if (eClassifier != null) {
                CGEcoreRealizedVariable cgEcoreRealizedVariable = QVTiCGModelFactory.eINSTANCE.createCGEcoreRealizedVariable();
                cgEcoreRealizedVariable.setEClassifier(eClassifier);
                cgVariable = cgEcoreRealizedVariable;
            }
            if (cgVariable == null) {
                cgVariable = QVTiCGModelFactory.eINSTANCE.createCGRealizedVariable();
            }
            this.setAst((CGTypedElement)cgVariable, (TypedElement)pRealizedVariable);
            cgVariable.setTypedModel(this.getTypedModel((Variable)pRealizedVariable));
            variablesStack.putVariable((VariableDeclaration)pRealizedVariable, (CGVariable)cgVariable);
        }
        return cgVariable;
    }

    @NonNull
    protected CGTypedModel getTypedModel(@NonNull Variable pVariable) {
        Area pArea = (Area)ClassUtil.nonNullState((Object)QVTcoreBaseUtil.getContainingArea((EObject)pVariable));
        TypedModel asTypedModel = null;
        if (pArea instanceof Domain) {
            asTypedModel = (TypedModel)ClassUtil.nonNullState((Object)((Domain)pArea).getTypedModel());
        } else {
            Transformation pTransformation = ((Mapping)pArea).getTransformation();
            asTypedModel = (TypedModel)ClassUtil.nonNullState((Object)pTransformation.getModelParameter(null));
        }
        return (CGTypedModel)ClassUtil.nonNullState((Object)this.analyzer.getTypedModel(asTypedModel));
    }

    @Nullable
    public CGNamedElement visitAssignment(@NonNull Assignment object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitBaseModel(@NonNull BaseModel object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitBottomPattern(@NonNull BottomPattern object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitCoreDomain(@NonNull CoreDomain object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitCorePattern(@NonNull CorePattern object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitDomain(@NonNull Domain object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitEnforcementOperation(@NonNull EnforcementOperation object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitFunction(@NonNull Function asFunction) {
        CGFunction cgFunction = QVTiCGModelFactory.eINSTANCE.createCGFunction();
        this.setAst((CGTypedElement)cgFunction, (TypedElement)asFunction);
        cgFunction.setRequired(asFunction.isIsRequired());
        for (Parameter pParameter : asFunction.getOwnedParameters()) {
            cgFunction.getParameters().add((CGParameter)this.doVisit(CGParameter.class, (Element)pParameter));
        }
        LanguageExpression specification = asFunction.getBodyExpression();
        if (specification != null) {
            try {
                ExpressionInOCL query = this.metamodelManager.parseSpecification(specification);
                Variable contextVariable = query.getOwnedContext();
                if (contextVariable != null) {
                    this.getParameter(contextVariable);
                }
                for (Variable parameterVariable : query.getOwnedParameters()) {
                    this.getParameter(parameterVariable);
                }
                cgFunction.setBody((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)query.getOwnedBody()));
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        this.analyzer.addFunction(asFunction, cgFunction);
        return cgFunction;
    }

    @Nullable
    public CGNamedElement visitFunctionParameter(@NonNull FunctionParameter asFunctionParameter) {
        return this.getFunctionParameter(asFunctionParameter);
    }

    @Nullable
    public CGNamedElement visitGuardPattern(@NonNull GuardPattern object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitImperativeBottomPattern(@NonNull ImperativeBottomPattern object) {
        return this.visitBottomPattern((BottomPattern)object);
    }

    @Nullable
    public CGNamedElement visitImperativeModel(@NonNull ImperativeModel object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitMapping(@NonNull Mapping pMapping) {
        CGMapping cgMapping = QVTiCGModelFactory.eINSTANCE.createCGMapping();
        this.setAst(cgMapping, (NamedElement)pMapping);
        this.analyzer.addMapping(pMapping, cgMapping);
        CGMappingExp cgMappingExp = QVTiCGModelFactory.eINSTANCE.createCGMappingExp();
        this.setAst((CGNamedElement)cgMappingExp, (NamedElement)pMapping);
        PrimitiveTypeId pivotTypeId = TypeId.BOOLEAN;
        cgMappingExp.setTypeId(((CodeGenAnalyzer)this.context).getTypeId((TypeId)pivotTypeId));
        cgMapping.setBody(cgMappingExp);
        this.doGuards(pMapping, cgMapping, cgMappingExp);
        this.doBottoms(pMapping, cgMappingExp);
        MappingStatement mappingStatements = pMapping.getMappingStatement();
        if (mappingStatements != null) {
            cgMappingExp.setBody((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)mappingStatements));
        }
        List<CGGuardVariable> cgFreeVariables = cgMapping.getFreeVariables();
        ArrayList<CGGuardVariable> sortedVariables = new ArrayList<CGGuardVariable>(cgFreeVariables);
        Collections.sort(sortedVariables, CGVariableComparator.INSTANCE);
        cgFreeVariables.clear();
        cgFreeVariables.addAll(sortedVariables);
        return cgMapping;
    }

    @Nullable
    public CGNamedElement visitMappingCall(@NonNull MappingCall asMappingCall) {
        CGMappingCall cgMappingCall = QVTiCGModelFactory.eINSTANCE.createCGMappingCall();
        this.setAst((CGTypedElement)cgMappingCall, (TypedElement)asMappingCall);
        ArrayList<CGMappingCallBinding> cgMappingCallBindings = new ArrayList<CGMappingCallBinding>();
        for (MappingCallBinding asMappingCallBinding : asMappingCall.getBinding()) {
            CGMappingCallBinding cgMappingCallBinding = (CGMappingCallBinding)this.doVisit(CGMappingCallBinding.class, (Element)asMappingCallBinding);
            cgMappingCallBindings.add(cgMappingCallBinding);
        }
        Collections.sort(cgMappingCallBindings, CGMappingCallBindingComparator.INSTANCE);
        cgMappingCall.getMappingCallBindings().addAll(cgMappingCallBindings);
        return cgMappingCall;
    }

    @Nullable
    public CGNamedElement visitMappingCallBinding(@NonNull MappingCallBinding asMappingCallBinding) {
        Variable asBoundVariable = asMappingCallBinding.getBoundVariable();
        CGMappingCallBinding cgMappingCallBinding = QVTiCGModelFactory.eINSTANCE.createCGMappingCallBinding();
        cgMappingCallBinding.setName(asBoundVariable.getName());
        cgMappingCallBinding.setAst((Element)asMappingCallBinding);
        cgMappingCallBinding.setRequired(asBoundVariable.isIsRequired());
        cgMappingCallBinding.setValue((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asMappingCallBinding.getValue()));
        cgMappingCallBinding.setTypeId(this.analyzer.getTypeId(asBoundVariable.getTypeId()));
        return cgMappingCallBinding;
    }

    @Nullable
    public CGNamedElement visitMappingLoop(@NonNull MappingLoop asMappingLoop) {
        Variable asIterator;
        CGMappingLoop cgMappingLoop = QVTiCGModelFactory.eINSTANCE.createCGMappingLoop();
        List asIterators = asMappingLoop.getOwnedIterators();
        if (asIterators.size() > 0 && (asIterator = (Variable)asIterators.get(0)) != null) {
            CGIterator cgIterator = this.getIterator((VariableDeclaration)asIterator);
            cgIterator.setTypeId(((CodeGenAnalyzer)this.context).getTypeId(asIterator.getTypeId()));
            cgIterator.setRequired(asIterator.isIsRequired());
            if (asIterator.isIsRequired()) {
                cgIterator.setNonNull();
            }
            cgMappingLoop.getIterators().add(cgIterator);
        }
        cgMappingLoop.setSource((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asMappingLoop.getOwnedSource()));
        cgMappingLoop.setAst((Element)asMappingLoop);
        CollectionType collectionType = this.metamodelManager.getStandardLibrary().getCollectionType();
        Operation forAllIteration = (Operation)NameUtil.getNameable((Iterable)collectionType.getOwnedOperations(), (String)"forAll");
        cgMappingLoop.setReferredIteration((Iteration)forAllIteration);
        cgMappingLoop.setBody((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asMappingLoop.getOwnedBody()));
        return cgMappingLoop;
    }

    @Nullable
    public CGNamedElement visitMappingSequence(@NonNull MappingSequence asMappingSequence) {
        CGSequence cgSequence = QVTiCGModelFactory.eINSTANCE.createCGSequence();
        List<CGValuedElement> cgMappingStatements = cgSequence.getStatements();
        for (MappingStatement asMappingStatement : asMappingSequence.getMappingStatements()) {
            CGValuedElement cgMappingStatement = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asMappingStatement);
            cgMappingStatements.add(cgMappingStatement);
        }
        return cgSequence;
    }

    @Nullable
    public CGNamedElement visitMappingStatement(@NonNull MappingStatement object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitPattern(@NonNull Pattern object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitPredicate(@NonNull Predicate asPredicate) {
        CGPredicate cgPredicate = QVTiCGModelFactory.eINSTANCE.createCGPredicate();
        cgPredicate.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
        cgPredicate.setConditionExpression((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asPredicate.getConditionExpression()));
        return cgPredicate;
    }

    @Nullable
    public CGNamedElement visitPropertyAssignment(@NonNull PropertyAssignment asPropertyAssignment) {
        EStructuralFeature eStructuralFeature;
        Transformation asTransformation = (Transformation)ClassUtil.nonNullModel((Object)QVTbaseUtil.getContainingTransformation((EObject)asPropertyAssignment));
        QVTiTransformationAnalysis transformationAnalysis = this.analyzer.getCodeGenerator().getTransformationAnalysis(asTransformation);
        Integer cacheIndex = transformationAnalysis.getCacheIndex(asPropertyAssignment);
        if (cacheIndex != null) {
            CGMiddlePropertyAssignment cgPropertyAssignment = QVTiCGModelFactory.eINSTANCE.createCGMiddlePropertyAssignment();
            cgPropertyAssignment.setSlotValue((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asPropertyAssignment.getSlotExpression()));
            Property asProperty = asPropertyAssignment.getTargetProperty();
            cgPropertyAssignment.setReferredProperty(asProperty);
            cgPropertyAssignment.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.OCL_VOID));
            cgPropertyAssignment.setInitValue((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asPropertyAssignment.getValue()));
            EStructuralFeature eStructuralFeature2 = (EStructuralFeature)asProperty.getESObject();
            if (eStructuralFeature2 != null) {
                try {
                    this.genModelHelper.getGetAccessor(eStructuralFeature2);
                    cgPropertyAssignment.setEStructuralFeature(eStructuralFeature2);
                }
                catch (GenModelException genModelException) {
                    // empty catch block
                }
            }
            return cgPropertyAssignment;
        }
        Property asTargetProperty = (Property)ClassUtil.nonNullModel((Object)asPropertyAssignment.getTargetProperty());
        LibraryProperty libraryProperty = this.metamodelManager.getImplementation((Element)asPropertyAssignment, null, asTargetProperty);
        CGPropertyAssignment cgPropertyAssignment = null;
        if (this.isEcoreProperty(libraryProperty) && (eStructuralFeature = (EStructuralFeature)asTargetProperty.getESObject()) != null) {
            try {
                this.genModelHelper.getGetAccessor(eStructuralFeature);
                CGEcorePropertyAssignment cgEcorePropertyAssignment = QVTiCGModelFactory.eINSTANCE.createCGEcorePropertyAssignment();
                cgEcorePropertyAssignment.setEStructuralFeature(eStructuralFeature);
                cgPropertyAssignment = cgEcorePropertyAssignment;
            }
            catch (GenModelException genModelException) {
                // empty catch block
            }
        }
        if (cgPropertyAssignment == null) {
            cgPropertyAssignment = QVTiCGModelFactory.eINSTANCE.createCGPropertyAssignment();
        }
        cgPropertyAssignment.setSlotValue((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asPropertyAssignment.getSlotExpression()));
        cgPropertyAssignment.setReferredProperty(asTargetProperty);
        cgPropertyAssignment.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.OCL_VOID));
        cgPropertyAssignment.setInitValue((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asPropertyAssignment.getValue()));
        CGExecutorProperty cgExecutorProperty = ((CodeGenAnalyzer)this.context).createExecutorProperty(asTargetProperty);
        cgPropertyAssignment.setExecutorProperty(cgExecutorProperty);
        return cgPropertyAssignment;
    }

    @Nullable
    public CGNamedElement visitRealizedVariable(@NonNull RealizedVariable object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitRule(@NonNull Rule object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitVariableAssignment(@NonNull VariableAssignment object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitTransformation(@NonNull Transformation asTransformation) {
        CGTransformation cgTransformation = QVTiCGModelFactory.eINSTANCE.createCGTransformation();
        this.setAst((CGNamedElement)cgTransformation, (NamedElement)asTransformation);
        this.pushCurrentClass(cgTransformation);
        List<CGTypedModel> cgTypedModels = cgTransformation.getTypedModels();
        for (TypedModel asTypedModel : asTransformation.getModelParameter()) {
            CGTypedModel cgTypedModel = (CGTypedModel)this.doVisit(CGTypedModel.class, (Element)asTypedModel);
            cgTypedModel.setModelIndex(cgTypedModels.size());
            cgTypedModels.add(cgTypedModel);
        }
        for (Rule asRule : asTransformation.getRule()) {
            CGMapping cgMapping = (CGMapping)this.doVisit(CGMapping.class, (Element)asRule);
            cgTransformation.getMappings().add(cgMapping);
        }
        for (Operation asOperation : asTransformation.getOwnedOperations()) {
            CGOperation cgOperation = (CGOperation)this.doVisit(CGOperation.class, (Element)asOperation);
            cgTransformation.getOperations().add(cgOperation);
        }
        this.popCurrentClass(cgTransformation);
        return cgTransformation;
    }

    @Nullable
    public CGNamedElement visitTypedModel(@NonNull TypedModel asTypedModel) {
        CGTypedModel cgTypedModel = QVTiCGModelFactory.eINSTANCE.createCGTypedModel();
        this.setAst(cgTypedModel, (NamedElement)asTypedModel);
        this.analyzer.addTypedModel(asTypedModel, cgTypedModel);
        return cgTypedModel;
    }

    @Nullable
    public CGNamedElement visitImport(@NonNull Import object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitVariablePredicate(@NonNull VariablePredicate asPredicate) {
        CGVariablePredicate cgPredicate = QVTiCGModelFactory.eINSTANCE.createCGVariablePredicate();
        cgPredicate.setAst((Element)asPredicate);
        Variable targetVariable = asPredicate.getTargetVariable();
        cgPredicate.setName(targetVariable.getName());
        cgPredicate.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
        OCLExpression conditionExpression = asPredicate.getConditionExpression();
        cgPredicate.setConditionExpression((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)conditionExpression));
        CGVariable cgVariable = this.createCGVariable(targetVariable);
        cgPredicate.setPredicateVariable(cgVariable);
        return cgPredicate;
    }

    public static class CGMappingCallBindingComparator
    implements Comparator<CGMappingCallBinding> {
        @NonNull
        public static final CGMappingCallBindingComparator INSTANCE = new CGMappingCallBindingComparator();

        @Override
        public int compare(CGMappingCallBinding o1, CGMappingCallBinding o2) {
            String n2;
            MappingCallBinding b1 = (MappingCallBinding)o1.getAst();
            MappingCallBinding b2 = (MappingCallBinding)o2.getAst();
            Variable v1 = b1 != null ? b1.getBoundVariable() : null;
            Variable v2 = b2 != null ? b2.getBoundVariable() : null;
            String n1 = v1 != null ? v1.getName() : null;
            String string = n2 = v2 != null ? v2.getName() : null;
            if (n1 == null) {
                n1 = "";
            }
            if (n2 == null) {
                n2 = "";
            }
            return n1.compareTo(n2);
        }
    }

    public static class CGVariableComparator
    implements Comparator<CGVariable> {
        @NonNull
        public static final CGVariableComparator INSTANCE = new CGVariableComparator();

        @Override
        public int compare(CGVariable o1, CGVariable o2) {
            String n2;
            Variable v1 = (Variable)o1.getAst();
            Variable v2 = (Variable)o2.getAst();
            String n1 = v1 != null ? v1.getName() : null;
            String string = n2 = v2 != null ? v2.getName() : null;
            if (n1 == null) {
                n1 = "";
            }
            if (n2 == null) {
                n2 = "";
            }
            return n1.compareTo(n2);
        }
    }
}

